/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.huaiRen;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.bizvane.appletservice.interfaces.huaiRen.HuaiRenGetNumService;
import com.bizvane.appletservice.models.vo.HuaiRenIntegralExchangeListVO;
import com.bizvane.appletservice.models.vo.HuaiRenIntegralExchangeShowVO;
import com.bizvane.appletservice.models.vo.HuaiRenIntegralExchangeVO;
import com.bizvane.appletservice.models.vo.HuaiRenRequestVO;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.out.huairen.HuaiRenGetStorageNumRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.OutOfConnectServiceFeign;
import com.bizvane.members.facade.models.bo.MemberIntegralExchangeListResBO;
import com.bizvane.members.facade.models.bo.MemberIntegralExchangeReqBO;
import com.bizvane.members.facade.models.bo.MemberIntegralExchangeResBO;
import com.bizvane.members.facade.service.api.MemberIntegralExchangeApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HuaiRenGetNumServiceImpl
implements HuaiRenGetNumService {
    private static final Logger log = LoggerFactory.getLogger(HuaiRenGetNumServiceImpl.class);
    @Autowired
    OutOfConnectServiceFeign outOfConnectServiceFeign;
    @Autowired
    MemberIntegralExchangeApiService memberIntegralExchangeApiService;
    private static final Logger logger = LoggerFactory.getLogger(HuaiRenGetNumServiceImpl.class);

    public ResponseData<Integer> getStorageNum(HuaiRenRequestVO requestVO) {
        ResponseData responseData = new ResponseData();
        if (null == requestVO) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (null == requestVO.getBrandId()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cID\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)requestVO.getOfflineCardNo())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7ebf\u4e0b\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        HuaiRenGetStorageNumRequestVO huaiRenRequestVO = new HuaiRenGetStorageNumRequestVO();
        huaiRenRequestVO.setBrandId(requestVO.getBrandId());
        huaiRenRequestVO.setOfflineCardNo(requestVO.getOfflineCardNo());
        logger.info("HuaiRenGetNumServiceImpl getStorageNum \u8c03\u8fde\u63a5\u5668\u5668\u67e5\u8be2\u5269\u4f59\u6570\u91cf");
        Result result = this.outOfConnectServiceFeign.getStorageNum(huaiRenRequestVO);
        logger.info("HuaiRenGetNumServiceImpl getStorageNum \u67e5\u8be2\u7ed3\u679c\u4e3a \uff1a param:{}", (Object)JSON.toJSONString((Object)result));
        List data = new ArrayList();
        if (null != result && result.getCode() == 0) {
            data = (List)result.getTData();
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u8fde\u63a5\u5668\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(result.getMessage());
        responseData.setData(data);
        return responseData;
    }

    public ResponseData<HuaiRenIntegralExchangeShowVO> getIntegralExchange(String memberCode, String sysCompanyIdStr, String sysBrandIdStr) {
        Long sysBrandId;
        log.info("HuaiRenGetNumServiceImpl getIntegralExchange method! sysCompanyI:{},brandId:{}", (Object)sysCompanyIdStr, (Object)sysBrandIdStr);
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)memberCode) || StringUtils.isEmpty((CharSequence)sysCompanyIdStr) || StringUtils.isEmpty((CharSequence)sysBrandIdStr)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        Long sysCompanyId = Long.parseLong(sysCompanyIdStr);
        MemberIntegralExchangeResBO integralExchange = this.memberIntegralExchangeApiService.getIntegralExchange(memberCode, sysCompanyId, sysBrandId = Long.valueOf(Long.parseLong(sysBrandIdStr)));
        if (integralExchange != null) {
            HuaiRenIntegralExchangeShowVO vo = new HuaiRenIntegralExchangeShowVO();
            BeanUtils.copyProperties((Object)integralExchange, (Object)vo);
            responseData.setData((Object)vo);
        }
        return responseData;
    }

    public ResponseData integralExchange(HuaiRenIntegralExchangeVO vo) {
        log.info("HuaiRenGetNumServiceImpl integralExchange method!");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)vo.getMemberCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        MemberIntegralExchangeReqBO bo = new MemberIntegralExchangeReqBO();
        bo.setSysCompanyId(vo.getSysCompanyId());
        bo.setBrandId(vo.getBrandId());
        bo.setMemberCode(vo.getMemberCode());
        ArrayList<MemberIntegralExchangeListResBO> listResBos = new ArrayList<MemberIntegralExchangeListResBO>();
        if (CollectionUtils.isNotEmpty((Collection)vo.getExchangeListVoList())) {
            for (HuaiRenIntegralExchangeListVO exchangeListVO : vo.getExchangeListVoList()) {
                MemberIntegralExchangeListResBO resBo = MemberIntegralExchangeListResBO.builder().balance(exchangeListVO.getBalance()).sourceBrandId(exchangeListVO.getSourceBrandId()).sourceBrandName(exchangeListVO.getSourceBrandName()).build();
                listResBos.add(resBo);
            }
        }
        bo.setExchangeListVoList(listResBos);
        responseData = this.memberIntegralExchangeApiService.integralExchange(bo);
        return responseData;
    }
}

