/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.alipay;

import com.bizvane.appletserviceimpl.constant.Constant;
import com.bizvane.centercontrolservice.models.enums.FusionPayChannelEnum;
import com.bizvane.centercontrolservice.models.enums.FusionPayTypeEnum;
import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordAlipayMerchantPo;
import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordAlipayProvidersPo;
import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordWxPayMerchantPo;
import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordWxPayUnionPo;
import com.bizvane.centercontrolservice.models.po.SysFusionPayBusinessPlatformHistoryPo;
import com.bizvane.centercontrolservice.models.vo.BrandBusinessFusionPayMethodVo;
import com.bizvane.centercontrolservice.models.vo.FusionPayBusinessRelationVo;
import com.bizvane.centercontrolservice.models.vo.FusionPayRecordWrapperVo;
import com.bizvane.centercontrolservice.models.vo.SysCompanyFusionPayConfigVo;
import com.bizvane.centercontrolservice.rpc.BrandBusinessFusionPayRpcService;
import com.bizvane.centercontrolservice.rpc.SysCompanyFusionPayRecordServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FusionPayService {
    private static final Logger log = LoggerFactory.getLogger(FusionPayService.class);
    @Autowired
    private BrandBusinessFusionPayRpcService brandBusinessFusionPayRpcService;
    @Autowired
    private SysCompanyFusionPayRecordServiceRpc sysCompanyFusionPayRecordServiceRpc;

    public FusionPayBusinessRelationVo getBrandBusinessFusionPayByBrandId(Long sysBrandId, String businessChannelCode, String platformCode) {
        ResponseData brandBusinessFusionPayMethodVos = this.brandBusinessFusionPayRpcService.getBrandBusinessFusionPayByBrandId(sysBrandId, businessChannelCode);
        if (SysResponseEnum.SUCCESS.getCode() != brandBusinessFusionPayMethodVos.getCode()) {
            log.warn("\u4e1a\u52a1\u6e20\u9053:{}\u83b7\u53d6\u5e73\u53f0:{}\u652f\u4ed8\u914d\u7f6e\u5931\u8d25:{}", new Object[]{businessChannelCode, platformCode, brandBusinessFusionPayMethodVos.getMessage()});
            return null;
        }
        BrandBusinessFusionPayMethodVo brandBusinessFusionPayMethodVo = ((List)brandBusinessFusionPayMethodVos.getData()).stream().filter(e -> e.getBusinessMethodCode().equalsIgnoreCase(platformCode)).findFirst().orElse(BrandBusinessFusionPayMethodVo.builder().build());
        log.info("BrandBusinessFusionPayMethodVo:{}", (Object)JacksonUtil.bean2Json((Object)brandBusinessFusionPayMethodVo));
        FusionPayBusinessRelationVo fusionPayBusinessRelationVo = brandBusinessFusionPayMethodVo.getFusionPayBusinessRelationVo();
        if (fusionPayBusinessRelationVo == null) {
            log.warn("\u4e1a\u52a1\u6e20\u9053:{}\u83b7\u53d6\u5e73\u53f0:{}\u652f\u4ed8\u914d\u7f6e\u5931\u8d25:{}", new Object[]{businessChannelCode, platformCode, "\u6ca1\u6709\u914d\u7f6e\u8be5\u6e20\u9053\u652f\u4ed8\u914d\u7f6e"});
            return null;
        }
        return fusionPayBusinessRelationVo;
    }

    public SysCompanyFusionPayRecordAlipayMerchantPo getAlipayMerchantPo(FusionPayBusinessRelationVo fusionPayBusinessRelationVo, String platformCode) {
        FusionPayRecordWrapperVo fusionPayRecordWrapperVo = this.getFusionPayRecordWrapperVo(fusionPayBusinessRelationVo, platformCode, Boolean.TRUE, FusionPayTypeEnum.ALIPAY, FusionPayChannelEnum.MERCHANTS);
        SysCompanyFusionPayRecordAlipayMerchantPo sysCompanyFusionPayRecordAlipayMerchantPo = fusionPayRecordWrapperVo.getSysCompanyFusionPayRecordAlipayMerchantPo();
        return sysCompanyFusionPayRecordAlipayMerchantPo;
    }

    public SysCompanyFusionPayRecordAlipayProvidersPo getAlipayProvidersPo(FusionPayBusinessRelationVo fusionPayBusinessRelationVo, String platformCode) {
        FusionPayRecordWrapperVo fusionPayRecordWrapperVo = this.getFusionPayRecordWrapperVo(fusionPayBusinessRelationVo, platformCode, Boolean.TRUE, FusionPayTypeEnum.ALIPAY, FusionPayChannelEnum.PROVIDERS);
        SysCompanyFusionPayRecordAlipayProvidersPo sysCompanyFusionPayRecordAlipayProvidersPo = fusionPayRecordWrapperVo.getSysCompanyFusionPayRecordAlipayProvidersPo();
        return sysCompanyFusionPayRecordAlipayProvidersPo;
    }

    public SysCompanyFusionPayRecordWxPayUnionPo getWxPayUnionPo(FusionPayBusinessRelationVo fusionPayBusinessRelationVo, String platformCode) {
        FusionPayRecordWrapperVo fusionPayRecordWrapperVo = this.getFusionPayRecordWrapperVo(fusionPayBusinessRelationVo, platformCode, Boolean.TRUE, FusionPayTypeEnum.WXPAY, FusionPayChannelEnum.UNIONPAY);
        SysCompanyFusionPayRecordWxPayUnionPo sysCompanyFusionPayRecordWxPayUnionPo = fusionPayRecordWrapperVo.getSysCompanyFusionPayRecordWxPayUnionPo();
        return sysCompanyFusionPayRecordWxPayUnionPo;
    }

    public SysCompanyFusionPayRecordWxPayMerchantPo getWxPayMerchantPo(FusionPayBusinessRelationVo fusionPayBusinessRelationVo, String platformCode) {
        FusionPayRecordWrapperVo fusionPayRecordWrapperVo = this.getFusionPayRecordWrapperVo(fusionPayBusinessRelationVo, platformCode, Boolean.TRUE, FusionPayTypeEnum.WXPAY, FusionPayChannelEnum.MERCHANTS);
        SysCompanyFusionPayRecordWxPayMerchantPo sysCompanyFusionPayRecordWxPayMerchantPo = fusionPayRecordWrapperVo.getSysCompanyFusionPayRecordWxPayMerchantPo();
        return sysCompanyFusionPayRecordWxPayMerchantPo;
    }

    public FusionPayRecordWrapperVo getFusionPayRecordWrapperVo(FusionPayBusinessRelationVo fusionPayBusinessRelationVo, String platformCode, Boolean check, FusionPayTypeEnum payMethodCode, FusionPayChannelEnum payChannelCode) {
        Integer fusionPayBusinessPlatformHistoryId = fusionPayBusinessRelationVo.getFusionPayBusinessPlatformHistoryId();
        FusionPayRecordWrapperVo fusionPayRecordWrapperVo = (FusionPayRecordWrapperVo)this.sysCompanyFusionPayRecordServiceRpc.getFusionPayInfoByHistoryId(fusionPayBusinessPlatformHistoryId).getData();
        log.info("sysCompanyFusionPayRecordServiceRpc.getFusionPayInfoByHistoryId:{}", (Object)JacksonUtil.bean2Json((Object)fusionPayRecordWrapperVo));
        SysFusionPayBusinessPlatformHistoryPo fusionPayBusinessPlatformHistoryPo = fusionPayRecordWrapperVo.getFusionPayBusinessPlatformHistoryPo();
        if (fusionPayBusinessPlatformHistoryPo.getSyncStatus() != Constant.FUSION_PAY_BUSINESS_PLATFORM_HISTORY_SYNC_STATUS_SUCCESS) {
            throw new RuntimeException("\u652f\u4ed8\u914d\u7f6e\u672a\u540c\u6b65\u7f51\u5173,\u8bf7\u8054\u7cfb\u5de5\u4f5c\u4eba\u5458!");
        }
        SysCompanyFusionPayConfigVo sysCompanyFusionPayConfigVo = fusionPayRecordWrapperVo.getSysCompanyFusionPayConfigVo();
        String paymentChannelCode = sysCompanyFusionPayConfigVo.getPaymentChannelCode();
        String paymentMethodCode = sysCompanyFusionPayConfigVo.getPaymentMethodCode();
        if (StringUtils.isEmpty((Object)platformCode) || !platformCode.equalsIgnoreCase(paymentMethodCode)) {
            throw new RuntimeException("\u67e5\u8be2\u5e73\u53f0code\u548c\u8fd4\u56de\u5e73\u53f0code\u4e0d\u4e00\u81f4");
        }
        if (!(!check.booleanValue() || payMethodCode.getCode().equalsIgnoreCase(paymentMethodCode) && payChannelCode.getCode().equalsIgnoreCase(paymentChannelCode))) {
            String errorMsg = "\u5f53\u524d\u54c1\u724c\u6ca1\u6709\u914d\u7f6e:" + payMethodCode.getMsg() + "=>" + payChannelCode.getMsg() + "\u4fe1\u606f!";
            throw new RuntimeException(errorMsg);
        }
        return fusionPayRecordWrapperVo;
    }

    public FusionPayRecordWrapperVo getFusionPayRecordWrapperVo(FusionPayBusinessRelationVo fusionPayBusinessRelationVo, String platformCode) {
        return this.getFusionPayRecordWrapperVo(fusionPayBusinessRelationVo, platformCode, Boolean.FALSE, null, null);
    }
}

