/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.PaymentPasswordService;
import com.bizvane.appletservice.models.vo.PaymentPasswordVo;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.PaymentPasswordRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentPasswordServiceImpl
implements PaymentPasswordService {
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData maintainPassword(PaymentPasswordVo paymentPasswordVo, String sysBrandId) {
        ResponseData responseData = new ResponseData();
        if (paymentPasswordVo.getVerificationCode() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            return responseData;
        }
        if (paymentPasswordVo.getSettingPaymentPassword() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u5bc6\u7801");
            return responseData;
        }
        if (paymentPasswordVo.getPhone() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u624b\u673a\u53f7");
            return responseData;
        }
        String sendCode = (String)this.redisTemplateService.stringGetStringByKey((Object)paymentPasswordVo.getPhone().toString());
        if (!paymentPasswordVo.getVerificationCode().equals(sendCode)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return responseData;
        }
        String intCount = (String)this.redisTemplateService.stringGetStringByKey((Object)(String.valueOf(paymentPasswordVo.getPhone()) + "intCount_new" + sysBrandId));
        if (StringUtils.isBlank((CharSequence)intCount)) {
            intCount = "0";
        }
        int count = Integer.valueOf(intCount) + 1;
        intCount = String.valueOf(count);
        logger.info("intCount={}", (Object)intCount);
        if ("5".equals(intCount)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4eca\u65e5\u4fee\u6539\u5bc6\u7801\u5df2\u7ecf\u8fbe\u5230\u9650\u5236");
            return responseData;
        }
        String settingPaymentPassword = (String)this.redisTemplateService.stringGetStringByKey((Object)(String.valueOf(paymentPasswordVo.getPhone()) + "settingPaymentPassword"));
        logger.info("settingPaymentPassword={} settingPaymentPassword_new={}", (Object)settingPaymentPassword, (Object)paymentPasswordVo.getSettingPaymentPassword());
        if (StringUtils.isNotBlank((CharSequence)settingPaymentPassword) && paymentPasswordVo.getSettingPaymentPassword().equals(settingPaymentPassword)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
            return responseData;
        }
        this.redisTemplateService.stringSetString((Object)(String.valueOf(paymentPasswordVo.getPhone()) + "settingPaymentPassword"), (Object)paymentPasswordVo.getSettingPaymentPassword());
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(String.valueOf(paymentPasswordVo.getPhone()) + "intCount_new" + sysBrandId), (Object)intCount, 86400000L);
        String memberCode = paymentPasswordVo.getMemberCode();
        WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
        wxChannelInfoVo.setMemberCode(memberCode);
        wxChannelInfoVo.setAppId(paymentPasswordVo.getAppId());
        ResponseData wxChannelInfoAndMemberInfo = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(wxChannelInfoVo);
        WxChannelAndMemberVo infoData = (WxChannelAndMemberVo)wxChannelInfoAndMemberInfo.getData();
        MemberInfoModel memberInfoModel = infoData.getMemberInfoModel();
        String cardNo = memberInfoModel.getCardNo();
        String erpId = memberInfoModel.getErpId();
        PaymentPasswordRequestVO paymentPasswordRequestVO = new PaymentPasswordRequestVO();
        MemberInfoModel model = new MemberInfoModel();
        model.setBrandId(paymentPasswordVo.getBrandId());
        model.setMemberCode(paymentPasswordVo.getMemberCode());
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.queryBasicMemberInfo(model);
        if (SysResponseEnum.FAILED.getCode() == memberInfoModelResponseData.getCode()) {
            logger.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
        }
        if (memberInfoModelResponseData.getData() != null) {
            paymentPasswordRequestVO.setPetCard(((MemberInfoModel)memberInfoModelResponseData.getData()).getPetCard());
        }
        paymentPasswordRequestVO.setErpId(erpId);
        paymentPasswordRequestVO.setOfflineCardNo(cardNo);
        paymentPasswordRequestVO.setPaymentPassword(paymentPasswordVo.getSettingPaymentPassword());
        paymentPasswordRequestVO.setBrandId(paymentPasswordVo.getBrandId());
        logger.info("paymentPasswordRequestVO={}", (Object)JSON.toJSONString((Object)paymentPasswordRequestVO));
        Result result = this.connectorServiceFeign.modifyPaymentPassword(paymentPasswordRequestVO);
        logger.info("maintainPassword+result={}", (Object)JSON.toJSONString((Object)result));
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData searchPhone(String memberCode) {
        ResponseData responseData = new ResponseData();
        ResponseData memberInfoModelResponseData = this.memberCardProgramApiService.queryMemberIntegral(memberCode);
        String phone = ((MemberInfoModel)memberInfoModelResponseData.getData()).getPhone();
        if (StringUtils.isBlank((CharSequence)phone)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        } else {
            responseData.setData((Object)phone);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        }
        return responseData;
    }

    public ResponseData searchPassword(String phone) {
        ResponseData responseData = new ResponseData();
        String phoneVerificationCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(phone + "verificationCode"));
        if (StringUtils.isNotBlank((CharSequence)phoneVerificationCode)) {
            responseData.setData((Object)phoneVerificationCode);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }
}

