/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.MemberOpenCardStoreService;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.AppletSysStoreBo;
import com.bizvane.appletservice.models.vo.MemberOpenCard2StoreVo;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.appletserviceimpl.mappers.LocalHandwrittenMapper;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.rpc.ActivityPrizeServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MemberOpenCardStoreServiceImpl
implements MemberOpenCardStoreService {
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Resource
    private LocalHandwrittenMapper localHandwrittenMapper;
    @Autowired
    private ActivityPrizeServiceRpc activityPrizeServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    DecimalFormat df = new DecimalFormat("###.#");

    public ResponseData searchStores(MemberOpenCardStoreVo memberOpenCardStoreVo) {
        List storeWhitelist;
        logger.info("\u95e8\u5e97\u5bfc\u822a\u5165\u53c2memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        Long storeId = (Long)this.wxAppletApiService.getServiceStoreId(memberOpenCardStoreVo.getMemberCode()).getData();
        logger.info("MemberOpenCardStoreServiceImpl#searchStores storeId:{}", (Object)storeId);
        if (memberOpenCardStoreVo.getIsWholeStore() == 0) {
            ResponseData store1 = this.storeServiceRpc.getStoreById(storeId);
            SysStorePo data = (SysStorePo)store1.getData();
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            BeanUtils.copyProperties((Object)data, (Object)appletSysStoreBo);
            ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
            appletSysStoreBos.add(appletSysStoreBo);
            AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
            appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBos);
            logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={},{},{},{}", new Object[]{JSON.toJSONString((Object)store1), JSONObject.toJSONString((Object)data), JSONObject.toJSONString((Object)appletSysStoreBo), JSONObject.toJSONString((Object)appletRefreshtoInterfaceBo)});
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)appletRefreshtoInterfaceBo);
            return responseData;
        }
        memberOpenCardStoreVo.setSysStoreId(storeId);
        SysStoreBo vo = new SysStoreBo();
        BeanUtils.copyProperties((Object)memberOpenCardStoreVo, (Object)vo);
        ResponseData brandList = this.brandServiceRpc.getBrandListByCompanyId(memberOpenCardStoreVo.getSysCompanyId());
        logger.info("getBrandListByCompanyId#brandList:{}", JSON.toJSON((Object)brandList));
        List data = (List)brandList.getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            List collect = data.stream().map(SysBrandPo::getSysBrandId).collect(Collectors.toList());
            vo.setBrandIds(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)(storeWhitelist = this.localHandwrittenMapper.queryIntegralMallStore()))) {
            vo.setStoreWhitelist(storeWhitelist);
        }
        ResponseData brandByIdSysStoreListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(vo);
        List sysStoreBoList = ((PageInfo)brandByIdSysStoreListPage.getData()).getList();
        ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        for (SysStoreBo sysStoreBo : sysStoreBoList) {
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            String distance = sysStoreBo.getDistance();
            if (distance == null) {
                sysStoreBo.setDistance(distance);
            } else {
                Double aDouble = Double.valueOf(distance);
                if (aDouble == null) {
                    sysStoreBo.setDistance(distance);
                }
                double lod = aDouble / 1000.0;
                String format = this.df.format(lod);
                sysStoreBo.setDistance(format);
            }
            BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
            if (appletSysStoreBo != null) {
                AppletSysStoreBos.add(appletSysStoreBo);
                continue;
            }
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        if (AppletSysStoreBos != null) {
            for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                if (appletSysStoreBo.getDistance() == null) {
                    sysStoreBos.add(appletSysStoreBo);
                }
                if (appletSysStoreBo.getDistance() == null) continue;
                appletSysStoreBos.add(appletSysStoreBo);
            }
        }
        if (appletSysStoreBos != null) {
            Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
        }
        ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
        appletSysStoreBoList.addAll(appletSysStoreBos);
        appletSysStoreBoList.addAll(sysStoreBos);
        appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
        logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData choosingStore(Long storeId, String memberCode) {
        return this.wxAppletApiService.updateOpenCardStoreIdByMemberCode(storeId, memberCode);
    }

    public ResponseData searchStoresByRecordId(MemberOpenCardStoreVo memberOpenCardStoreVo) {
        logger.info("searchStoresByRecordId memberOpenCardStoreVo:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        MktActivityPrizeRecordPO po = new MktActivityPrizeRecordPO();
        po.setMktActivityPrizeRecordId(memberOpenCardStoreVo.getMktActivityPrizeRecordId());
        po.setMemberCode(memberOpenCardStoreVo.getMemberCode());
        po.setSysBrandId(memberOpenCardStoreVo.getSysBrandId());
        po.setPhysicalExtractionType(memberOpenCardStoreVo.getPhysicalExtractionType());
        ResponseData storeResponseData = this.activityPrizeServiceRpc.selectStoreIds(po);
        if (null != storeResponseData && SysResponseEnum.SUCCESS.getCode() == storeResponseData.getCode()) {
            List storeIds = (List)storeResponseData.getData();
            if (null != storeIds && storeIds.size() > 0) {
                List allBrandIds = this.getAllBrandIdsByStoreId((Long)storeIds.get(0));
                logger.info("allBrandIds:{}", (Object)allBrandIds);
                SysStoreBo vo = new SysStoreBo();
                BeanUtils.copyProperties((Object)memberOpenCardStoreVo, (Object)vo);
                vo.setStoreIdList(storeIds);
                vo.setBrandIds(allBrandIds);
                vo.setDisplay(Boolean.valueOf(true));
                ResponseData brandByIdSysStoreListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(vo);
                List sysStoreBoList = ((PageInfo)brandByIdSysStoreListPage.getData()).getList();
                ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
                for (SysStoreBo sysStoreBo : sysStoreBoList) {
                    AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
                    String distance = sysStoreBo.getDistance();
                    if (distance == null) {
                        sysStoreBo.setDistance(distance);
                    } else {
                        Double aDouble = Double.valueOf(distance);
                        if (aDouble == null) {
                            sysStoreBo.setDistance(distance);
                        }
                        double lod = aDouble / 1000.0;
                        String format = this.df.format(lod);
                        sysStoreBo.setDistance(format);
                    }
                    BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
                    if (appletSysStoreBo != null) {
                        AppletSysStoreBos.add(appletSysStoreBo);
                        continue;
                    }
                    responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
                ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
                ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
                if (AppletSysStoreBos != null) {
                    for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                        if (appletSysStoreBo.getDistance() == null) {
                            sysStoreBos.add(appletSysStoreBo);
                        }
                        if (appletSysStoreBo.getDistance() == null) continue;
                        appletSysStoreBos.add(appletSysStoreBo);
                    }
                }
                if (appletSysStoreBos != null) {
                    Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
                }
                ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
                appletSysStoreBoList.addAll(appletSysStoreBos);
                appletSysStoreBoList.addAll(sysStoreBos);
                appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
                logger.info("searchStoresByRecordId\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
                responseData.setData((Object)appletRefreshtoInterfaceBo);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setMessage("\u53ef\u63d0\u8d27\u95e8\u5e97\u5217\u8868\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setMessage(null != storeResponseData ? storeResponseData.getMessage() : "\u83b7\u53d6\u53ef\u63d0\u8d27\u95e8\u5e97\u5f02\u5e38");
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    public ResponseData searchStoresByRecordIdRpc(MemberOpenCardStoreVo memberOpenCardStoreVo) {
        logger.info("searchStoresByRecordId searchStoresByRecordIdRpc:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        MktActivityPrizeRecordPO po = new MktActivityPrizeRecordPO();
        po.setMktActivityPrizeRecordId(memberOpenCardStoreVo.getMktActivityPrizeRecordId());
        ResponseData storeResponseData = this.activityPrizeServiceRpc.selectStoreIdsByRecordId(po);
        if (null != storeResponseData && SysResponseEnum.SUCCESS.getCode() == storeResponseData.getCode()) {
            List storeIds = (List)storeResponseData.getData();
            if (null != storeIds && storeIds.size() > 0) {
                List allBrandIds = this.getAllBrandIdsByStoreId((Long)storeIds.get(0));
                logger.info("allBrandIds:{}", (Object)allBrandIds);
                SysStoreBo vo = new SysStoreBo();
                BeanUtils.copyProperties((Object)memberOpenCardStoreVo, (Object)vo);
                vo.setStoreIdList(storeIds);
                vo.setBrandIds(allBrandIds);
                vo.setSysBrandId((Long)allBrandIds.get(0));
                vo.setDisplay(Boolean.valueOf(true));
                ResponseData brandByIdSysStoreListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(vo);
                List sysStoreBoList = ((PageInfo)brandByIdSysStoreListPage.getData()).getList();
                ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
                for (SysStoreBo sysStoreBo : sysStoreBoList) {
                    AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
                    String distance = sysStoreBo.getDistance();
                    if (distance == null) {
                        sysStoreBo.setDistance(distance);
                    } else {
                        Double aDouble = Double.valueOf(distance);
                        if (aDouble == null) {
                            sysStoreBo.setDistance(distance);
                        }
                        double lod = aDouble / 1000.0;
                        String format = this.df.format(lod);
                        sysStoreBo.setDistance(format);
                    }
                    BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
                    if (appletSysStoreBo != null) {
                        AppletSysStoreBos.add(appletSysStoreBo);
                        continue;
                    }
                    responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
                ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
                ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
                if (AppletSysStoreBos != null) {
                    for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                        if (appletSysStoreBo.getDistance() == null) {
                            sysStoreBos.add(appletSysStoreBo);
                        }
                        if (appletSysStoreBo.getDistance() == null) continue;
                        appletSysStoreBos.add(appletSysStoreBo);
                    }
                }
                if (appletSysStoreBos != null) {
                    Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
                }
                ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
                appletSysStoreBoList.addAll(appletSysStoreBos);
                appletSysStoreBoList.addAll(sysStoreBos);
                appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
                logger.info("searchStoresByRecordId\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
                responseData.setData((Object)appletRefreshtoInterfaceBo);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setMessage("\u53ef\u63d0\u8d27\u95e8\u5e97\u5217\u8868\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setMessage(null != storeResponseData ? storeResponseData.getMessage() : "\u83b7\u53d6\u53ef\u63d0\u8d27\u95e8\u5e97\u5f02\u5e38");
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    private List<Long> getAllBrandIdsByStoreId(Long storeId) {
        ResponseData storeResponseData = this.storeServiceRpc.getStoreById(storeId);
        Long sysCompanyId = ((SysStorePo)storeResponseData.getData()).getSysCompanyId();
        ResponseData brandListResponseData = this.brandServiceRpc.getBrandListByCompanyId(sysCompanyId);
        if (brandListResponseData.getData() != null) {
            List<Long> brandIds = ((List)brandListResponseData.getData()).stream().map(SysBrandPo::getSysBrandId).collect(Collectors.toList());
            return brandIds;
        }
        return new ArrayList<Long>();
    }

    public ResponseData searchStoresByIds(MemberOpenCard2StoreVo memberOpenCardStoreVo) {
        logger.info("\u95e8\u5e97\u5bfc\u822a\u5165\u53c2memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        Long storeId = (Long)this.wxAppletApiService.getServiceStoreId(memberOpenCardStoreVo.getMemberCode()).getData();
        logger.info("MemberOpenCardStoreServiceImpl#searchStores storeId:{}", (Object)storeId);
        logger.info("MemberOpenCardStoreServiceImpl.searchStoresByIds.Step1:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        if (memberOpenCardStoreVo.getIsWholeStore() == 0) {
            ResponseData store1 = this.storeServiceRpc.getStoreById(storeId);
            SysStorePo data = (SysStorePo)store1.getData();
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            BeanUtils.copyProperties((Object)data, (Object)appletSysStoreBo);
            ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
            appletSysStoreBos.add(appletSysStoreBo);
            AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
            appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBos);
            logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={},{},{},{}", new Object[]{JSON.toJSONString((Object)store1), JSONObject.toJSONString((Object)data), JSONObject.toJSONString((Object)appletSysStoreBo), JSONObject.toJSONString((Object)appletRefreshtoInterfaceBo)});
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)appletRefreshtoInterfaceBo);
            return responseData;
        }
        memberOpenCardStoreVo.setSysStoreId(storeId);
        SysStoreBo vo = new SysStoreBo();
        BeanUtils.copyProperties((Object)memberOpenCardStoreVo, (Object)vo);
        vo.setSearchValue(memberOpenCardStoreVo.getSearchValue());
        vo.setStoreIdList(memberOpenCardStoreVo.getStoreIdList());
        vo.setClubId(memberOpenCardStoreVo.getClubId());
        vo.setSysBrandId(memberOpenCardStoreVo.getSysBrandId());
        logger.info("MemberOpenCardStoreServiceImpl.searchStoresByIds.Step2:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData brandList = this.brandServiceRpc.getBrandListByCompanyId(memberOpenCardStoreVo.getSysCompanyId());
        logger.info("getBrandListByCompanyId#brandList:{}", (Object)JSON.toJSONString((Object)brandList));
        List data = (List)brandList.getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            List collect = data.stream().map(SysBrandPo::getSysBrandId).collect(Collectors.toList());
            vo.setBrandIds(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)memberOpenCardStoreVo.getStoreIdList())) {
            ResponseData idStoreLists = this.storeServiceRpc.getIdStoreLists(memberOpenCardStoreVo.getStoreIdList());
            if (CollectionUtils.isEmpty((Collection)((Collection)idStoreLists.getData()))) {
                logger.info("\u5f53\u524d\u95e8\u5e97\u672a\u627e\u5230,\u95e8\u5e97Id\u4e3a:{}", (Object)JSONObject.toJSONString((Object)memberOpenCardStoreVo.getStoreIdList()));
                throw LogicException.error((Integer)-1, (String)"\u5f53\u524d\u95e8\u5e97\u672a\u627e\u5230\uff01");
            }
            List storeCodeList = ((List)idStoreLists.getData()).stream().map(SysStorePo::getSysStoreOfflineCode).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(storeCodeList)) {
                vo.setStoreWhitelist(storeCodeList);
            }
        }
        vo.setStoreIdList(new ArrayList());
        logger.info("MemberOpenCardStoreServiceImpl.searchStoresByIds.Step3:{}", (Object)JSON.toJSONString((Object)vo));
        ResponseData brandByIdSysStoreListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(vo);
        logger.info("MemberOpenCardStoreServiceImpl.searchStoresByIds.Step4:{}", (Object)JSON.toJSONString((Object)brandByIdSysStoreListPage));
        List sysStoreBoList = ((PageInfo)brandByIdSysStoreListPage.getData()).getList();
        ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        for (SysStoreBo sysStoreBo : sysStoreBoList) {
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            String distance = sysStoreBo.getDistance();
            if (distance == null) {
                sysStoreBo.setDistance(distance);
            } else {
                Double aDouble = Double.valueOf(distance);
                if (aDouble == null) {
                    sysStoreBo.setDistance(distance);
                }
                double lod = aDouble / 1000.0;
                String format = this.df.format(lod);
                sysStoreBo.setDistance(format);
            }
            BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
            if (appletSysStoreBo != null) {
                AppletSysStoreBos.add(appletSysStoreBo);
                continue;
            }
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        if (AppletSysStoreBos != null) {
            for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                if (appletSysStoreBo.getDistance() == null) {
                    sysStoreBos.add(appletSysStoreBo);
                }
                if (appletSysStoreBo.getDistance() == null) continue;
                appletSysStoreBos.add(appletSysStoreBo);
            }
        }
        if (appletSysStoreBos != null) {
            Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
        }
        ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
        appletSysStoreBoList.addAll(appletSysStoreBos);
        appletSysStoreBoList.addAll(sysStoreBos);
        appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
        logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }
}

