/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.hq;

import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.hq.HqCouponTranService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.HqCouponRechargeRequestVO;
import com.bizvane.appletservice.models.vo.HqCouponTranDescResponseVO;
import com.bizvane.connectorservice.entity.hqt.HqCouponTranRequestVO;
import com.bizvane.connectorservice.entity.hqt.HqCouponTranResponseVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"HQ\u5238\u8f6c\u6362"})
@RequestMapping(value={"/hq/couponTran"})
@RestController
public class HqCouponTranController {
    private static final Logger log = LoggerFactory.getLogger(HqCouponTranController.class);
    @Autowired
    private LoginService loginService;
    @Autowired
    private HqCouponTranService hqCouponTranService;

    @PostMapping(value={"/getReminder"})
    public ResponseData<HqCouponTranDescResponseVO> getReminder() {
        log.info("enter HqCouponTranController getReminder");
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        return this.hqCouponTranService.getReminder(memberResourceBO);
    }

    @PostMapping(value={"/couponCardCheck"})
    public ResponseData<HqCouponTranResponseVO> couponCardCheck(@RequestParam(value="cardNum") String cardNum) {
        log.info("enter HqCouponTranController couponCardCheck param:{}", (Object)cardNum);
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        HqCouponTranRequestVO requestVO = new HqCouponTranRequestVO();
        requestVO.setBrandId(memberResourceBO.getBrandId());
        requestVO.setCardNum(cardNum);
        return this.hqCouponTranService.couponCardCheck(requestVO);
    }

    @PostMapping(value={"/couponCardRecharge"})
    public ResponseData couponCardRecharge(@RequestBody HqCouponRechargeRequestVO requestVO, HttpServletRequest request) {
        log.info("enter HqCouponTranController couponCardRecharge param:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        requestVO.setMemberCode(this.loginService.getMemberCode(request));
        return this.hqCouponTranService.couponCardRecharge(requestVO);
    }
}

