/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.activity;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletserviceimpl.common.BaseConstant;
import com.bizvane.appletserviceimpl.impl.activity.ActivityCouponsReponseVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityCouponsRequestVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityGoodsRequestVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityGoodsResponseVO;
import com.bizvane.appletserviceimpl.impl.activity.ActivityRequestVO;
import com.bizvane.appletserviceimpl.impl.activity.IntegralActivityService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.tokens.TokenUtils;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"activity"})
public class ActivityController {
    private static final Logger log = LoggerFactory.getLogger(ActivityController.class);
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    IntegralActivityService integralActivityService;

    @PostMapping(value={"/activity/goodsList"})
    public Result<ActivityGoodsResponseVO> getActivityGoodsList(@RequestBody @Valid ActivityGoodsRequestVO requestVO, HttpServletRequest request) {
        logger.info("ActivityController|getActivityGoodsList|requestVO:{}", (Object)JSONObject.toJSONString((Object)requestVO));
        Result result = this.getMemberCode(request);
        if (result.isSuccess()) {
            requestVO.setMemberCode((String)result.getData());
            return this.integralActivityService.getActivityGoodsList(requestVO);
        }
        return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @PostMapping(value={"/activity/queryActivityCoupons"})
    public Result<ActivityCouponsReponseVO> queryActivityCoupons(@RequestBody @Valid ActivityCouponsRequestVO requestVO, @RequestHeader(value="sysBrandId") Long brandId, @RequestHeader(value="sysCompanyId") Long companyId, HttpServletRequest request) {
        logger.info("ActivityController|queryActivityCoupons|requestVO:{}", (Object)JSONObject.toJSONString((Object)requestVO));
        requestVO.setBrandId(brandId);
        requestVO.setCompanyId(companyId);
        return this.integralActivityService.queryActivityCoupons(requestVO, request);
    }

    @PostMapping(value={"/activity/queryActivityCouponsDetail"})
    public Result<ActivityCouponsReponseVO> queryActivityCouponsDetail(@RequestBody @Valid ActivityCouponsRequestVO requestVO, @RequestHeader(value="sysBrandId") Long brandId, @RequestHeader(value="sysCompanyId") Long companyId, HttpServletRequest request) {
        logger.info("ActivityController|queryActivityCouponsDetail|requestVO:{}", (Object)JSONObject.toJSONString((Object)requestVO));
        requestVO.setBrandId(brandId);
        requestVO.setCompanyId(companyId);
        return this.integralActivityService.queryActivityCouponsDetail(requestVO, request);
    }

    @PostMapping(value={"/activity/goodsDetail"})
    public Result<ActivityGoodsResponseVO> goodsDetail(@RequestBody @Valid ActivityGoodsRequestVO requestVO, HttpServletRequest request) {
        logger.info("ActivityController|goodsDetail|requestVO:{}", (Object)JSONObject.toJSONString((Object)requestVO));
        Result result = this.getMemberCode(request);
        if (result.isSuccess()) {
            requestVO.setMemberCode((String)result.getData());
            return this.integralActivityService.getGoodsDetail(requestVO);
        }
        return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @PostMapping(value={"/activity/checkActivityInfo"})
    public Result<Boolean> checkActivityInfo(@RequestBody ActivityRequestVO activityRequestVO, @RequestHeader(value="sysBrandId") Long brandId, @RequestHeader(value="sysCompanyId") Long companyId, HttpServletRequest request) {
        logger.info("ActivityController|checkActivityInfo|activityRequestVO:{}", (Object)JSONObject.toJSONString((Object)activityRequestVO));
        Result result = this.getMemberCode(request);
        if (result.isSuccess()) {
            activityRequestVO.setMemberCode((String)result.getData());
            activityRequestVO.setBrandId(brandId);
            activityRequestVO.setCompanyId(companyId);
            return this.integralActivityService.checkActivityInfo(activityRequestVO);
        }
        return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    private Result<String> getMemberCode(HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader(BaseConstant.SESSION_ID);
        if (bizvaneSessionId == null) {
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + BaseConstant.MEMBER_CODE));
        if (memberCode == null) {
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return Result.success((Object)memberCode);
    }
}

