/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.ResourcesService;
import com.bizvane.appletservice.models.po.AppletBrandThemePO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources"})
public class ResourcesController {
    @Autowired
    private ResourcesService resourcesService;
    @Autowired
    private HttpServletResponse response;

    @RequestMapping(value={"/getResources"})
    public ResponseData<List<AppletResourcesPO>> getResources(AppletResourcesPO po) {
        return this.resourcesService.getResources(po);
    }

    @RequestMapping(value={"/themeResources"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<String> themeResources(Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        if (sysBrandId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            this.response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return responseData;
        }
        ResponseData themeResources = this.resourcesService.themeResources(sysBrandId);
        for (AppletBrandThemePO appletBrandThemePO : (List)themeResources.getData()) {
            String themeStyle = appletBrandThemePO.getThemeStyle();
            responseData.setData((Object)themeStyle);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        }
        return responseData;
    }
}

