/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.appletservice.models.bo.CouponEntityAndDefinitionBo;
import com.bizvane.appletservice.models.vo.FindStoreVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.appletserviceimpl.impl.vg.VGCommonService;
import com.bizvane.appletserviceimpl.utils.CouponUtils;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponAuthTmallServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponByTransferVO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOnlineUseRequestVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.messagefacade.enums.vg.WechatSUbscribeMenuEnum;
import com.bizvane.mktcenterservice.models.po.MktActivityPO;
import com.bizvane.mktcenterservice.models.vg.VGActivityVo;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.MktRedPortRecordVO;
import com.bizvane.mktcenterservice.rpc.ActivityManualServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityRedPortServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activity"})
public class MenberCenterActivityController {
    @Autowired
    private ActivityManualServiceRpc activityManualServiceRpc;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private ActivityRedPortServiceRpc activityRedPortServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponAuthTmallServiceFeign couponAuthTmallServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private VGLoginService vgLoginService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private VGCommonService vgCommonService;

    @RequestMapping(value={"/getActivityRecordPOList"}, method={RequestMethod.POST})
    public ResponseData<List<VGActivityVo>> getActivityRecordPOList(ActivityManualVO vo, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        if (vo.getActivityCode() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u9886\u52b5\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(vo.getMemberInfoModel().getBrandId());
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        vo.getMemberInfoModel().setMemberCode(memberCode);
        vo.getMemberInfoModel().setSysCompanyId(((SysBrandPo)brandByID.getData()).getSysCompanyId());
        vo.setOpenId(openId);
        logger.info("\u626b\u7801\u9886\u52b5\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData byQrcode = this.activityManualServiceRpc.getActivityByQrcodeVgV2(vo);
        responseData.setData(byQrcode.getData());
        return responseData;
    }

    @RequestMapping(value={"/executeActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityManualVO> executeActivity(ActivityManualVO vo, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (vo == null || vo.getMktActivityId() == null) {
            responseData.setCode(-100);
            responseData.setMessage("\u53c2\u6570\u4e3a\u7a7a");
            return responseData;
        }
        ResponseData mktActivityPOResponseData = this.activityServiceRpc.selectActivityById(vo.getMktActivityId());
        if (mktActivityPOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || mktActivityPOResponseData.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MktActivityPO mktActivityPO = (MktActivityPO)mktActivityPOResponseData.getData();
        MemberInfoModel masterMemberInfo = (MemberInfoModel)singleMemberModel.getData();
        MemberInfoModel clubMemberInfo = this.vgLoginService.simpleJoinClub((HttpServletRequest)request, masterMemberInfo, mktActivityPO.getSysBrandId());
        vo.setMemberInfoModel(clubMemberInfo);
        this.sleep500ms();
        logger.info("\u626b\u7801\u9886\u53d6\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        return this.activityManualServiceRpc.executeActivityScanVG(vo);
    }

    @RequestMapping(value={"/getActivityByMemberInfo"}, method={RequestMethod.POST})
    public ResponseData<List<VGActivityVo>> getActivityByMemberInfo(ActivityManualVO vo, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u9886\u52b5\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        vo.getMemberInfoModel().setMemberCode(memberCode);
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        logger.info("\u9886\u5238\u4e2d\u5fc3\u5217\u8868={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(vo.getMemberInfoModel().getBrandId());
        Long sysCompanyId = ((SysBrandPo)brandByID.getData()).getSysCompanyId();
        vo.setSysCompanyId(sysCompanyId);
        vo.getMemberInfoModel().setSysCompanyId(sysCompanyId);
        String mktActivityId = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + vo.getMemberInfoModel().getBrandId() + 2));
        MktRedPortRecordVO mktRedPortRecordVO = new MktRedPortRecordVO();
        mktRedPortRecordVO.setType(Integer.valueOf(2));
        mktRedPortRecordVO.setMemberCode(memberCode);
        mktRedPortRecordVO.setSysCompanyId(sysCompanyId);
        mktRedPortRecordVO.setSysBrandId(vo.getMemberInfoModel().getBrandId());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)mktActivityId)) {
            mktRedPortRecordVO.setMktActivityId(Long.valueOf(mktActivityId));
        }
        mktRedPortRecordVO.setServiceStoreId(serviceStoreId);
        logger.info("updateRedPort={}", (Object)JSON.toJSONString((Object)mktRedPortRecordVO));
        this.activityRedPortServiceRpc.updateRedPort(mktRedPortRecordVO);
        vo.setOpenId(openId);
        return this.activityManualServiceRpc.getActivityByMemberInfoVgV2(vo);
    }

    @RequestMapping(value={"/onlyexecuteActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityManualVO> onlyexecuteActivity(ActivityManualVO vo, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (vo == null || vo.getMktActivityId() == null) {
            responseData.setCode(-100);
            responseData.setMessage("\u53c2\u6570\u4e3a\u7a7a");
            return responseData;
        }
        ResponseData mktActivityPOResponseData = this.activityServiceRpc.selectActivityById(vo.getMktActivityId());
        if (mktActivityPOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || mktActivityPOResponseData.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MktActivityPO mktActivityPO = (MktActivityPO)mktActivityPOResponseData.getData();
        MemberInfoModel masterMemberInfo = (MemberInfoModel)singleMemberModel.getData();
        MemberInfoModel clubMemberInfo = this.vgLoginService.simpleJoinClub((HttpServletRequest)request, masterMemberInfo, mktActivityPO.getSysBrandId());
        vo.setMemberInfoModel(clubMemberInfo);
        this.sleep500ms();
        return this.activityManualServiceRpc.executeActivityVGV2(vo);
    }

    @RequestMapping(value={"/onlySubscribeActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityManualVO> onlySubscribeActivity(ActivityManualVO vo, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (vo == null || vo.getMktActivityId() == null) {
            responseData.setCode(-100);
            responseData.setMessage("\u53c2\u6570\u4e3a\u7a7a");
            return responseData;
        }
        ResponseData mktActivityPOResponseData = this.activityServiceRpc.selectActivityById(vo.getMktActivityId());
        if (mktActivityPOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || mktActivityPOResponseData.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MktActivityPO mktActivityPO = (MktActivityPO)mktActivityPOResponseData.getData();
        MemberInfoModel masterMemberInfo = (MemberInfoModel)singleMemberModel.getData();
        MemberInfoModel clubMemberInfo = this.vgLoginService.simpleJoinClub((HttpServletRequest)request, masterMemberInfo, mktActivityPO.getSysBrandId());
        vo.setMemberInfoModel(clubMemberInfo);
        this.sleep500ms();
        return this.activityManualServiceRpc.subscribeActivityVG(vo);
    }

    private void sleep500ms() {
        logger.info("\u4f11\u77200.5s\u7b49\u5f85es\u540c\u6b65");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.info("\u4f11\u77200.5s\u7b49\u5f85es\u540c\u6b65error:{}", (Throwable)e);
        }
    }

    @RequestMapping(value={"/getCouponListByCondition"}, method={RequestMethod.POST})
    public ResponseData getCouponListByCondition(CouponListByMemberCodeRequestVO vo, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponStatus() == null) {
            responseData.setMessage("\u52b5\u7c7b\u578b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bizvaneSessionId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)companyId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)brandId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        vo.setMemberCode(memberCode);
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(companyId)));
        vo.setQuerySource(Integer.valueOf(1));
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u67e5\u8be2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData couponListByMemeberCode = this.couponQueryServiceFeign.getCouponListByMemeberCode(vo);
        com.bizvane.utils.responseinfo.PageInfo couponListByMemeberCodeData = (com.bizvane.utils.responseinfo.PageInfo)couponListByMemeberCode.getData();
        couponListByMemeberCode.getData();
        com.bizvane.utils.responseinfo.PageInfo boPageInfo = new com.bizvane.utils.responseinfo.PageInfo();
        BeanUtils.copyProperties((Object)couponListByMemeberCodeData, (Object)boPageInfo);
        ArrayList<CouponEntityAndDefinitionBo> entityAndDefinitionBoList = new ArrayList<CouponEntityAndDefinitionBo>();
        for (CouponEntityAndDefinitionVO couponEntityAndDefinitionVO : couponListByMemeberCodeData.getList()) {
            CouponEntityAndDefinitionBo couponEntityAndDefinitionBo = new CouponEntityAndDefinitionBo();
            VGSubscribeMsgAuthResponseVo vgSubscribeMsgAuthResponseVo = this.vgCommonService.queryCouponDetailBrandWechatAppletSubscribeDataRedis(couponEntityAndDefinitionVO.getSysBrandId(), openId, WechatSUbscribeMenuEnum.FIELD_3, couponEntityAndDefinitionVO.getCouponCode());
            couponEntityAndDefinitionBo.setVgSubscribeMsgAuthResponseVo(vgSubscribeMsgAuthResponseVo);
            BeanUtils.copyProperties((Object)couponEntityAndDefinitionVO, (Object)couponEntityAndDefinitionBo);
            if (couponEntityAndDefinitionVO.getTransfer() == null) {
                couponEntityAndDefinitionBo.setOldMemberCode(null);
            } else if (couponEntityAndDefinitionVO.getTransfer().booleanValue()) {
                couponEntityAndDefinitionBo.setOldMemberCode(memberCode);
            }
            Date currentTime = new Date();
            if (couponEntityAndDefinitionVO.getValidDateStart().compareTo(currentTime) < 0 && couponEntityAndDefinitionVO.getValidDateEnd().compareTo(currentTime) > 0) {
                couponEntityAndDefinitionBo.setCurrentTimeAvailable(Boolean.TRUE);
            } else {
                couponEntityAndDefinitionBo.setCurrentTimeAvailable(Boolean.FALSE);
            }
            entityAndDefinitionBoList.add(couponEntityAndDefinitionBo);
        }
        boPageInfo.setList(entityAndDefinitionBoList);
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)boPageInfo));
        this.redisClient.set("applet:TemplateInfo:coupenRed:status:" + memberCode, (Object)Boolean.FALSE, Long.valueOf(300L));
        responseData.setData((Object)boPageInfo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/getCouponListByTransfer"}, method={RequestMethod.POST})
    public ResponseData getCouponListByTransfer(CouponListByMemberCodeRequestVO vo, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        logger.info("MenberCenterActivityController getCouponListByTransfer start");
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bizvaneSessionId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)companyId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)brandId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(companyId)));
        vo.setSysBrandId(Long.valueOf(Long.parseLong(brandId)));
        logger.info("MenberCenterActivityController getCouponListByTransfer memberCode={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData couponListByTransfer = this.couponQueryServiceFeign.getCouponListByTransfer(vo);
        PageInfo couponListByMemeberCodeData = (PageInfo)couponListByTransfer.getData();
        PageInfo boPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)couponListByMemeberCodeData, (Object)boPageInfo);
        ArrayList<CouponEntityAndDefinitionBo> entityAndDefinitionBoList = new ArrayList<CouponEntityAndDefinitionBo>();
        for (CouponByTransferVO couponByTransferVo : couponListByMemeberCodeData.getList()) {
            CouponEntityAndDefinitionBo couponEntityAndDefinitionBo = new CouponEntityAndDefinitionBo();
            BeanUtils.copyProperties((Object)couponByTransferVo, (Object)couponEntityAndDefinitionBo);
            if (couponByTransferVo.getTransfer() == null) {
                couponEntityAndDefinitionBo.setOldMemberCode(null);
            } else if (couponByTransferVo.getTransfer().booleanValue()) {
                couponEntityAndDefinitionBo.setOldMemberCode(memberCode);
            }
            entityAndDefinitionBoList.add(couponEntityAndDefinitionBo);
        }
        boPageInfo.setList(entityAndDefinitionBoList);
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)boPageInfo));
        responseData.setData((Object)boPageInfo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/findCouponDetailByCouponId"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<CouponDetailResponseVO> findCouponDetailByCouponId(Long couponEntityId) {
        ResponseData responseData = new ResponseData();
        if (couponEntityId == null) {
            responseData.setMessage(" \u672a\u8f93\u5165\u8868 id");
            return responseData;
        }
        logger.info("\u4f18\u60e0\u5238\u8be6\u60c5={}", (Object)couponEntityId);
        ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(couponEntityId);
        Date validDateStart = ((CouponDetailResponseVO)couponDetail.getData()).getCouponEntityPO().getValidDateStart();
        Date validDateEnd = ((CouponDetailResponseVO)couponDetail.getData()).getCouponEntityPO().getValidDateEnd();
        ((CouponDetailResponseVO)couponDetail.getData()).getCouponDefinitionPO().setValidDateStart(validDateStart);
        ((CouponDetailResponseVO)couponDetail.getData()).getCouponDefinitionPO().setValidDateEnd(validDateEnd);
        CouponDetailResponseVO data = (CouponDetailResponseVO)couponDetail.getData();
        CouponDefinitionPO couponDefinitionPo = data.getCouponDefinitionPO();
        if (!StringUtils.isEmpty((Object)couponDefinitionPo)) {
            CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)couponDefinitionPo, (int)2);
        }
        logger.info("\u4f18\u60e0\u5238\u8be6\u60c5\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)couponDetail.getData()));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(couponDetail.getData());
        return responseData;
    }

    @RequestMapping(value={"/findStoreByCoupon"}, method={RequestMethod.POST})
    public ResponseData findStoreByCoupon(FindStoreVo vo) {
        logger.info("\u83b7\u53d6\u5238\u9002\u7528\u95e8\u5e97\u5165\u53c2\uff1a" + com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        try {
            if (vo.getCouponEntityId() == null) {
                responseData.setMessage(" \u52b5id\u4e0d\u80fd\u4e3a\u7a7a");
                return responseData;
            }
            ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(vo.getCouponEntityId());
            if (couponDetail.getCode() != 0) {
                return couponDetail;
            }
            CouponDetailResponseVO cVo = (CouponDetailResponseVO)couponDetail.getData();
            SysStoreVo sysStoreVo = new SysStoreVo();
            if (cVo != null) {
                CouponDefinitionPOWithBLOBs cp = cVo.getCouponDefinitionPOWithBLOBs();
                sysStoreVo.setSysCompanyId(cp.getSysCompanyId());
                sysStoreVo.setSysBrandId(cp.getSysBrandId());
                sysStoreVo.setProvinceName(vo.getProvinceName());
                sysStoreVo.setCityName(vo.getCityName());
                sysStoreVo.setAreaName(vo.getAreaName());
                sysStoreVo.setPageNumber(vo.getPageNum());
                sysStoreVo.setPageSize(vo.getPageSize());
                sysStoreVo.setLng(vo.getLng());
                sysStoreVo.setLat(vo.getLat());
                sysStoreVo.setSearchName(vo.getSearchName());
                if (cp != null && null != cp.getApplianceStoreType() && cp.getApplianceStoreType() == 2) {
                    String[] split;
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreWhitelist())) {
                        split = cp.getStoreWhitelist().split(",");
                        sysStoreVo.setStoreWhitelist(Arrays.asList(split));
                    } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreBlacklist())) {
                        split = cp.getStoreBlacklist().split(",");
                        sysStoreVo.setStoreBlacklist(Arrays.asList(split));
                    }
                }
                ResponseData rs = this.storeServiceRpc.listStoreByCondition(sysStoreVo);
                responseData.setData(rs.getData());
            }
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            logger.info("\u83b7\u53d6\u5238\u9002\u7528\u95e8\u5e97\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return responseData;
    }

    @RequestMapping(value={"/onlineUse"}, method={RequestMethod.POST})
    public ResponseData<Object> findCouponDetailByCouponId(CouponOnlineUseRequestVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.onlineUse(vo);
    }

    @RequestMapping(value={"/lock"}, method={RequestMethod.POST})
    public ResponseData<Object> lock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.lock(vo);
    }

    @RequestMapping(value={"/unlock"}, method={RequestMethod.POST})
    public ResponseData<Object> unlock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.unlock(vo);
    }

    @RequestMapping(value={"/getTaobaoName"}, method={RequestMethod.POST})
    ResponseData<String> getTaobaoName(ActivityManualVO requestVO, org.apache.catalina.servlet4preview.http.HttpServletRequest request) {
        logger.info("enter MenberCenterActivityController getTaobaoName method! ");
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        requestVO.getMemberInfoModel().setMemberCode(memberCode);
        return this.couponAuthTmallServiceFeign.getTaobaoName(requestVO);
    }
}

