/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.members.facade.models.MbrIntegralTransferModel;
import com.bizvane.members.facade.service.api.MemberIntegralTransferService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u5458\u79ef\u5206\u8f6c\u8d60\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/memberIntegralTransfer"})
public class MemberIntegralTransferController {
    private static final Logger log = LoggerFactory.getLogger(MemberIntegralTransferController.class);
    @Autowired
    MemberIntegralTransferService transferService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    @ApiOperation(value="\u63d0\u4ea4\u79ef\u5206\u8f6c\u8d60\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="transferIntegral", dataType="Long", value="\u8f6c\u8d60\u79ef\u5206", paramType="form", required=true), @ApiImplicitParam(name="integralTransferCode", dataType="String", value="\u8f6c\u8d60\u6d41\u6c34\u53f7", paramType="form", required=true)})
    @PostMapping(value={"/addIntegralTransfer"})
    public ResponseData<String> addIntegralTransfer(MbrIntegralTransferModel model, HttpServletRequest request) {
        log.info("MemberIntegralTransferController addIntegralTransfer param: model:{}", (Object)model.toString());
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        model.setTransferMemberCode(memberCode);
        if (StringUtils.isEmpty((CharSequence)model.getTransferMemberCode())) {
            responseData.setMessage("\u8f6c\u8d60\u65b9\u4f1a\u5458code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)model.getIntegralTransferCode())) {
            responseData.setMessage("\u8f6c\u8d60\u6d41\u6c34\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return responseData;
        }
        if (model.getTransferIntegral() == null) {
            responseData.setMessage("\u8f6c\u8d60\u79ef\u5206\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return responseData;
        }
        if (model.getTransferIntegral() <= 0L) {
            responseData.setMessage("\u8f6c\u8d60\u79ef\u5206\u5fc5\u987b\u5927\u4e8e0");
            return responseData;
        }
        return this.transferService.addIntegralTransfer(model);
    }

    @ApiOperation(value="\u79ef\u5206\u9886\u53d6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="integralTransferCode", dataType="String", value="\u4f1a\u5458\u79ef\u5206\u8f6c\u8d60\u6d41\u6c34\u53f7", paramType="form", required=true)})
    @PostMapping(value={"/integralRecipient"})
    public ResponseData<String> integralRecipient(MbrIntegralTransferModel model, HttpServletRequest request) {
        log.info("MemberIntegralTransferController integralRecipient param: model:{}", (Object)model.toString());
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        model.setRecipientMemberCode(memberCode);
        if (StringUtils.isEmpty((CharSequence)model.getRecipientMemberCode())) {
            responseData.setMessage("\u53d7\u8d60\u65b9\u4f1a\u5458code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)model.getIntegralTransferCode())) {
            responseData.setMessage("\u79ef\u5206\u8f6c\u8d60\u6d41\u6c34\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return responseData;
        }
        return this.transferService.integralRecipient(model);
    }
}

