/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.mktp;

import com.bizvane.appletservice.interfaces.mktp.FissionActivityService;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.mktcenterservice.models.vo.mktp.ActivityRuleResponseVO;
import com.bizvane.mktcenterservice.models.vo.mktp.FissionActivityDetailResponseVO;
import com.bizvane.mktcenterservice.models.vo.mktp.FissionActivityInviteRecordVO;
import com.bizvane.mktcenterservice.models.vo.mktp.FissionActivityInviteResponseVO;
import com.bizvane.mktcenterservice.models.vo.mktp.FissionActivityParamsVO;
import com.bizvane.mktcenterservice.models.vo.mktp.FissionActivityStepResponseVO;
import com.bizvane.mktcenterservice.models.vo.mktp.LifeCodeResponseVO;
import com.bizvane.mktcenterservice.models.vo.mktp.ReceiveAwardResponseVO;
import com.bizvane.mktcenterservice.rpc.mktp.FissionActivityServiceRpc;
import com.bizvane.unifiedreg.model.vo.MemberCommonVo;
import com.bizvane.unifiedreg.rpc.AppletServiceFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FissionActivityServiceImpl
implements FissionActivityService {
    private static final Logger log = LoggerFactory.getLogger(FissionActivityServiceImpl.class);
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private FissionActivityServiceRpc fissionActivityServiceRpc;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private AppletServiceFeign appletServiceFeign;

    public ResponseData<FissionActivityDetailResponseVO> selectActivityDetail(FissionActivityParamsVO paramsVO) {
        log.info("selectActivityDetail#paramsVO:{}", (Object)JacksonUtil.bean2Json((Object)paramsVO));
        ResponseData responseData = this.fissionActivityServiceRpc.selectActivityDetail(paramsVO);
        log.info("responseData:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        if (null != responseData && SysResponseEnum.SUCCESS.getCode() == responseData.getCode() && null != responseData.getData()) {
            List memberActivityStepVOList;
            FissionActivityDetailResponseVO detailResponseVO = (FissionActivityDetailResponseVO)responseData.getData();
            if (StringUtils.isNotBlank((String)paramsVO.getMemberCode())) {
                ResponseData memberCommonResp = this.appletServiceFeign.queryMemberIncludeCommon(paramsVO.getSysBrandId(), paramsVO.getMemberCode());
                log.info("memberCommonResp:{}", (Object)JacksonUtil.bean2Json((Object)memberCommonResp));
                if (null != memberCommonResp && SysResponseEnum.SUCCESS.getCode() == memberCommonResp.getCode() && null != memberCommonResp.getData()) {
                    MemberCommonVo memberCommonVo = (MemberCommonVo)memberCommonResp.getData();
                    detailResponseVO.setWxNick(memberCommonVo.getWxNick());
                    detailResponseVO.setWxHeadPortraits(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)memberCommonVo.getWxHeadPortraits()));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(memberActivityStepVOList = ((FissionActivityDetailResponseVO)responseData.getData()).getMemberActivityStepVOList()))) {
                for (FissionActivityStepResponseVO vo : memberActivityStepVOList) {
                    if (!StringUtils.isNotBlank((String)vo.getAwardImageUrl())) continue;
                    vo.setAwardImageUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)vo.getAwardImageUrl()));
                }
            }
        }
        return responseData;
    }

    public ResponseData<FissionActivityInviteResponseVO> inviteNow(FissionActivityParamsVO paramsVO) {
        log.info("inviteNow#paramsVO:{}", (Object)JacksonUtil.bean2Json((Object)paramsVO));
        return this.fissionActivityServiceRpc.inviteNow(paramsVO);
    }

    public ResponseData<FissionActivityInviteResponseVO> customerActivityInviteNow(FissionActivityParamsVO paramsVO) {
        log.info("customerActivityInviteNow#paramsVO:{}", (Object)JacksonUtil.bean2Json((Object)paramsVO));
        return this.fissionActivityServiceRpc.customerActivityInviteNow(paramsVO);
    }

    public ResponseData<ActivityRuleResponseVO> getActivityRuleByCode(FissionActivityParamsVO paramsVO) {
        log.info("getActivityRuleByCode#paramsVO:{}", (Object)JacksonUtil.bean2Json((Object)paramsVO));
        ResponseData responseData = new ResponseData();
        ActivityRuleResponseVO activityRuleResponseVO = new ActivityRuleResponseVO();
        if (StringUtils.isBlank((String)paramsVO.getActivityCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6d3b\u52a8\u7f16\u53f7\u4e3a\u7a7a");
            return responseData;
        }
        String activityRuleKey = "applet:mktp:activityRule:" + paramsVO.getActivityCode();
        Object object = this.redisClient.get(activityRuleKey);
        if (object == null) {
            ResponseData activityRuleResp = this.fissionActivityServiceRpc.getActivityRuleByCode(paramsVO);
            log.info("activityRuleResp:{}", (Object)JacksonUtil.bean2Json((Object)activityRuleResp));
            if (null != activityRuleResp && SysResponseEnum.SUCCESS.getCode() == activityRuleResp.getCode() && null != activityRuleResp.getData()) {
                ActivityRuleResponseVO responseVO = (ActivityRuleResponseVO)activityRuleResp.getData();
                this.redisClient.set(activityRuleKey, (Object)responseVO, Long.valueOf(60L));
            }
            return activityRuleResp;
        }
        log.info("getActivityRuleByCode_getActivityRuleByCode_cache");
        activityRuleResponseVO = (ActivityRuleResponseVO)object;
        responseData.setData((Object)activityRuleResponseVO);
        return responseData;
    }

    public ResponseData<FissionActivityInviteRecordVO> getInvitationRecord(FissionActivityParamsVO paramsVO) {
        log.info("getInvitationRecord#paramsVO:{}", (Object)JacksonUtil.bean2Json((Object)paramsVO));
        return this.fissionActivityServiceRpc.getInvitationRecord(paramsVO);
    }

    public ResponseData<ReceiveAwardResponseVO> receiveAward(FissionActivityParamsVO paramsVO) {
        log.info("receiveAward#paramsVO:{}", (Object)JacksonUtil.bean2Json((Object)paramsVO));
        return this.fissionActivityServiceRpc.receiveAward(paramsVO);
    }

    public ResponseData<LifeCodeResponseVO> getLiveCodeInfoById(Long staffLiveCodeId) {
        log.info("getLifeCodeInfoById#staffLiveCodeId:{}", (Object)staffLiveCodeId);
        return this.fissionActivityServiceRpc.getLiveCodeInfoById(staffLiveCodeId);
    }
}

