/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.integeractivity.nsActivity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.models.bo.IntegralActivityGoodBO;
import com.bizvane.appletservice.models.bo.IntegralNSActivityBO;
import com.bizvane.appletservice.models.vo.integralactivity.IntegralNSActivityFindGoodsRequestVO;
import com.bizvane.appletserviceimpl.common.NoStoreActivityGoodsRangeEnum;
import com.bizvane.appletserviceimpl.impl.integeractivity.nsActivity.IntegrationShopNSActivityRedisServiceImpl;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import tk.mybatis.mapper.util.StringUtil;

@Service
public class IntegrationShopNSActivityServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(IntegrationShopNSActivityServiceImpl.class);
    private static final String GET_NS_ACTIVITY_DETAIL = "api/integral/activity/getNSActivityByIdRpc/";
    private static final String GET_NS_GOODS = "api/integral/activity-wx/NS/getGoods";
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;
    @Autowired
    private IntegrationShopNSActivityRedisServiceImpl integrationShopNSActivityRedisService;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;

    public ResponseData<JSONObject> getNSActivityDetail(Long activityId, Long brandId) {
        ResponseData responseData = new ResponseData();
        JSONObject nsActivity = this.getNsActivity(activityId, brandId);
        log.info("IntegrationShopNSActivityServiceImpl#getNSActivityDetail#nsActivity:{}", (Object)JSON.toJSONString((Object)nsActivity));
        if (!ObjectUtils.isEmpty((Object)nsActivity)) {
            responseData.setData((Object)nsActivity);
            return responseData;
        }
        try {
            String activityDetailStr = HttpUtil.get((String)(this.DOMAINNAME + GET_NS_ACTIVITY_DETAIL + activityId));
            if (StringUtil.isEmpty((String)activityDetailStr)) {
                return ResponseUtils.getFailedData((String)"\u672a\u67e5\u627e\u5230\u6d3b\u52a8");
            }
            JSONObject activityDetail = JSON.parseObject((String)activityDetailStr);
            Long merchantId = activityDetail.getLong("merchantId");
            if (!merchantId.equals(brandId)) {
                return ResponseUtils.getFailedData((String)"\u6d3b\u52a8\u975e\u8be5\u4f01\u4e1a\u6240\u6709");
            }
            this.transList(activityDetail);
            log.info("IntegrationShopNSActivityServiceImpl#getNSActivityDetail#activityDetail:{}", (Object)JSON.toJSONString((Object)activityDetail));
            responseData.setData((Object)activityDetail);
            this.integrationShopNSActivityRedisService.saveNSActivity2Redis(activityDetail, brandId);
            return responseData;
        }
        catch (Exception e) {
            log.info("IntegrationShopActivityServiceImpl#getNSActivityDetail={}", (Object)e.getMessage());
            return ResponseUtils.getFailedData((String)"\u6d3b\u52a8\u67e5\u8be2\u5f02\u5e38");
        }
    }

    private void transList(JSONObject activityDetail) {
        List couponsList;
        List goodsList = JSONArray.parseArray((String)activityDetail.getString("goodsList"), IntegralActivityGoodBO.class);
        if (!CollectionUtils.isEmpty((Collection)goodsList)) {
            ArrayList<String> goodsNoList = new ArrayList<String>();
            for (IntegralActivityGoodBO goodObj : goodsList) {
                goodsNoList.add(goodObj.getGoodUniqueSign());
            }
            activityDetail.put("goodsList", goodsNoList);
        }
        if (!CollectionUtils.isEmpty((Collection)(couponsList = JSONArray.parseArray((String)activityDetail.getString("couponList"), IntegralActivityGoodBO.class)))) {
            ArrayList<String> couponsNoList = new ArrayList<String>();
            for (IntegralActivityGoodBO couponObj : couponsList) {
                couponsNoList.add(couponObj.getGoodUniqueSign());
            }
            activityDetail.put("couponList", couponsNoList);
        }
    }

    public ResponseData deleteNSActivityAll(Long brandId, Long activityId) {
        return this.integrationShopNSActivityRedisService.deleteNSActivityAll(brandId, activityId);
    }

    public JSONObject getNsActivity(Long activityId, Long brandId) {
        JSONObject nsActivity = this.integrationShopNSActivityRedisService.getNSActivity(brandId, activityId);
        if (ObjectUtils.isEmpty((Object)nsActivity)) {
            return null;
        }
        nsActivity.put("goodsList", (Object)this.integrationShopNSActivityRedisService.getNSActivityGoods(activityId));
        nsActivity.put("couponList", (Object)this.integrationShopNSActivityRedisService.getNSActivityCoupons(activityId));
        return nsActivity;
    }

    public ResponseData getNSActivityGoods(IntegralNSActivityFindGoodsRequestVO requestVO) {
        ResponseData responseData = new ResponseData();
        ResponseData nsActivityDetail = this.getNSActivityDetail(requestVO.getActivityId(), requestVO.getBrandId());
        if (ObjectUtils.isEmpty((Object)nsActivityDetail.getData())) {
            responseData.setMessage("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        IntegralNSActivityBO activityBO = (IntegralNSActivityBO)((JSONObject)nsActivityDetail.getData()).toJavaObject(IntegralNSActivityBO.class);
        if (!activityBO.getActivityStatus().booleanValue()) {
            responseData.setMessage("\u6d3b\u52a8\u5173\u95ed\uff0c\u4e0d\u53ef\u67e5\u770b\u5546\u54c1");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (NoStoreActivityGoodsRangeEnum.COUPON.getCode().equals(activityBO.getGoodsType())) {
            responseData.setMessage("\u6d3b\u52a8\u662f\u7eaf\u4f18\u60e0\u5238\u6d3b\u52a8");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        try {
            JSONObject activityGoodRequestVO = new JSONObject();
            activityGoodRequestVO.put("pageSize", (Object)requestVO.getPageSize());
            activityGoodRequestVO.put("pageIndex", (Object)requestVO.getPageIndex());
            activityGoodRequestVO.put("activityId", (Object)requestVO.getActivityId());
            activityGoodRequestVO.put("merchantId", (Object)requestVO.getBrandId());
            activityGoodRequestVO.put("goodsNoList", (Object)activityBO.getGoodsList());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            String activityDetailStr = HttpUtil.post((String)(this.DOMAINNAME + GET_NS_GOODS), (String)activityGoodRequestVO.toJSONString(), map);
            log.info("IntegrationShopNSActivityServiceImpl#getNSActivityGoods#activityDetailStr:{}", (Object)activityDetailStr);
            JSONObject result = JSON.parseObject((String)activityDetailStr);
            responseData.setData((Object)result.getJSONObject("data"));
            return responseData;
        }
        catch (Exception e) {
            log.info("getNSActivityGoods#goodRpcException", (Throwable)e);
            responseData.setMessage("\u79ef\u5206\u5546\u54c1\u8bf7\u6c42\u5f02\u5e38");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    public ResponseData getNSActivityCoupons(CouponRecordVO couponRecordVO, Long activityId) {
        ResponseData responseData = new ResponseData();
        ResponseData nsActivityDetail = this.getNSActivityDetail(activityId, couponRecordVO.getBrandId());
        if (ObjectUtils.isEmpty((Object)nsActivityDetail.getData())) {
            responseData.setMessage("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        IntegralNSActivityBO activityBO = (IntegralNSActivityBO)((JSONObject)nsActivityDetail.getData()).toJavaObject(IntegralNSActivityBO.class);
        if (!activityBO.getActivityStatus().booleanValue()) {
            responseData.setMessage("\u6d3b\u52a8\u5173\u95ed\uff0c\u4e0d\u53ef\u67e5\u770b\u5546\u54c1");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (NoStoreActivityGoodsRangeEnum.GOODS.getCode().equals(activityBO.getGoodsType())) {
            responseData.setMessage("\u6d3b\u52a8\u662f\u7eaf\u5546\u54c1\u6d3b\u52a8");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        couponRecordVO.setExchangeCodes(activityBO.getCouponList());
        couponRecordVO.setActivityType(activityBO.getActivityType());
        log.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO));
        ResponseData convernCouponLists = this.taskServiceForWXRpc.getConvernCouponLists(couponRecordVO);
        log.info("integrationShopGetall convernCouponLists:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
        return convernCouponLists;
    }

    public ResponseData<List<String>> getNSActivityCouponCodes(Long activityId, Long brandId) {
        ResponseData responseData = new ResponseData();
        ResponseData nsActivityDetail = this.getNSActivityDetail(activityId, brandId);
        if (ObjectUtils.isEmpty((Object)nsActivityDetail.getData())) {
            responseData.setMessage("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        IntegralNSActivityBO activityBO = (IntegralNSActivityBO)((JSONObject)nsActivityDetail.getData()).toJavaObject(IntegralNSActivityBO.class);
        if (NoStoreActivityGoodsRangeEnum.GOODS.getCode().equals(activityBO.getGoodsType())) {
            responseData.setMessage("\u6d3b\u52a8\u662f\u7eaf\u5546\u54c1\u6d3b\u52a8");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setData((Object)activityBO.getCouponList());
        return responseData;
    }
}

