/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.hq;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.hq.HqCouponTranService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.HqCouponRechargeRequestVO;
import com.bizvane.appletservice.models.vo.HqCouponTranDescResponseVO;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.models.po.SysConfigsPo;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysConfigsServiceRpc;
import com.bizvane.connectorservice.entity.hqt.HqCouponTranRequestVO;
import com.bizvane.connectorservice.entity.hqt.HqCouponTranResponseVO;
import com.bizvane.customized.facade.interfaces.CusHqCouponTranServiceFeign;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HqCouponTranServiceImpl
implements HqCouponTranService {
    private static final Logger log = LoggerFactory.getLogger(HqCouponTranServiceImpl.class);
    @Autowired
    private SysConfigsServiceRpc sysConfigsServiceRpc;
    @Autowired
    private CusHqCouponTranServiceFeign cusHqCouponTranServiceFeign;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private StaffServiceRpc staffServiceRpc;

    public ResponseData<HqCouponTranDescResponseVO> getReminder(MemberResoucreBO resoucreBO) {
        log.info("enter HqCouponTranServiceImpl getReminder param:{}", (Object)JacksonUtil.bean2Json((Object)resoucreBO));
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        String key = "HQT_REMINDER_MSG_KEY";
        ResponseData configsByBrandAndKey = this.sysConfigsServiceRpc.getConfigsByBrandAndKey(resoucreBO.getBrandId(), key);
        if (configsByBrandAndKey.getCode() == SysResponseEnum.FAILED.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        SysConfigsPo data = (SysConfigsPo)configsByBrandAndKey.getData();
        log.info("sysConfigsServiceRpc getConfigsByBrandAndKey result:{}", (Object)JacksonUtil.bean2Json((Object)data));
        HqCouponTranDescResponseVO responseVO = new HqCouponTranDescResponseVO();
        responseVO.setDesc(data.getConfigDesc());
        responseData.setData((Object)responseVO);
        return responseData;
    }

    public ResponseData<HqCouponTranResponseVO> couponCardCheck(HqCouponTranRequestVO requestVO) {
        log.info("enter HqCouponTranServiceImpl couponCardCheck param:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = this.cusHqCouponTranServiceFeign.couponCardCheck(requestVO);
        log.info("enter HqCouponTranServiceImpl couponCardCheck result:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    public ResponseData couponCardRecharge(HqCouponRechargeRequestVO requestVO) {
        log.info("enter HqCouponTranServiceImpl couponCardRecharge param:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        ResponseData memberInfoModelResponseData = this.memberCardProgramApiService.queryMemberIntegral(requestVO.getMemberCode());
        MemberInfoModel data = (MemberInfoModel)memberInfoModelResponseData.getData();
        MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
        mbrRechargeRecordPo.setSysBrandId(data.getBrandId());
        mbrRechargeRecordPo.setCardNo(data.getCardNo());
        mbrRechargeRecordPo.setName(data.getName());
        mbrRechargeRecordPo.setRechargeMoney(requestVO.getBalance());
        mbrRechargeRecordPo.setState(Long.valueOf(3L));
        mbrRechargeRecordPo.setGiveMoney(Double.valueOf(0.0));
        mbrRechargeRecordPo.setPayVoucherNo(requestVO.getCardNum());
        mbrRechargeRecordPo.setPaymentDate(new Date());
        mbrRechargeRecordPo.setErpId(data.getErpId());
        mbrRechargeRecordPo.setBusinessId("GB");
        mbrRechargeRecordPo.setPaymentCard(requestVO.getCardNum());
        mbrRechargeRecordPo.setRechargeType(Integer.valueOf(2));
        mbrRechargeRecordPo.setMbrPetCardSourceType(Integer.valueOf(1));
        log.info("\u5165\u53c2========mbrRechargeRecordBo========" + JSON.toJSONString((Object)mbrRechargeRecordPo));
        ResponseData responseRechargeData = this.mbrRechargeServiceRpc.addMbrRechargeRecord(mbrRechargeRecordPo);
        log.info("addMbrRechargeRecord={}", (Object)JSON.toJSONString((Object)responseData));
        return responseRechargeData;
    }
}

