/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.WeChatAppletSubscribeMsgService;
import com.bizvane.appletservice.models.bo.AppletBrandFunctionBo;
import com.bizvane.appletservice.models.vo.SubscribeMessageCloseRequestVO;
import com.bizvane.appletservice.models.vo.SubscribeMessageRequestVO;
import com.bizvane.appletservice.models.vo.SubscribeMsgAuthInfoVO;
import com.bizvane.appletservice.models.vo.SubscribeMsgAuthRequestVO;
import com.bizvane.appletservice.models.vo.SubscribeMsgAuthResponseVO;
import com.bizvane.messagebase.model.po.MsgWxMiniProTempPO;
import com.bizvane.messagefacade.enums.WeChatSubscribeMenuEnum;
import com.bizvane.messagefacade.interfaces.WeChatAppletMessageServiceFeign;
import com.bizvane.messagefacade.interfaces.WeChatAppletSubscribeMsgServiceFeign;
import com.bizvane.messagefacade.models.vo.WeChatAppletSubscribeRequestVO;
import com.bizvane.messagefacade.models.vo.WeChatAppletSubscribeResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WeChatAppletSubscribeMsgServiceImpl
implements WeChatAppletSubscribeMsgService {
    private static final Logger log = LoggerFactory.getLogger(WeChatAppletSubscribeMsgServiceImpl.class);
    @Autowired
    private WeChatAppletMessageServiceFeign weChatAppletMessageServiceFeign;
    @Autowired
    private WeChatAppletSubscribeMsgServiceFeign weChatAppletSubscribeMsgServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    private final String BRAND_WECHAT_APPLET_SUBSCRIBE = "BrandWeChatAppletSubscribe";
    private final long DAY_EXPIRE = 86400000L;

    public SubscribeMsgAuthResponseVO queryBrandWeChatAppletSubscribeData(SubscribeMsgAuthRequestVO subscribeMsgAuthRequestVO) {
        log.info("queryBrandWeChatAppletSubscribeData#subscribeMsgAuthRequestVO:{}", (Object)JSON.toJSONString((Object)subscribeMsgAuthRequestVO));
        Long sysBrandId = subscribeMsgAuthRequestVO.getBrandId();
        SubscribeMsgAuthResponseVO subscribeMsgAuthResponseVO = new SubscribeMsgAuthResponseVO();
        SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = this.getAndSetAllowSubscribe(subscribeMsgAuthRequestVO, Boolean.TRUE.booleanValue(), null);
        subscribeMsgAuthResponseVO.setSubscribeInfo(subscribeMsgAuthInfoVO);
        subscribeMsgAuthResponseVO.setByCache(subscribeMsgAuthInfoVO.getByCache());
        if (!subscribeMsgAuthInfoVO.getAllowSubscribe().booleanValue() && !this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_7).booleanValue()) {
            subscribeMsgAuthResponseVO.setAllowSubscribe(subscribeMsgAuthInfoVO.getAllowSubscribe());
            return subscribeMsgAuthResponseVO;
        }
        if (!subscribeMsgAuthInfoVO.getAllowSubscribe().booleanValue()) {
            subscribeMsgAuthResponseVO.setAllowSubscribe(subscribeMsgAuthInfoVO.getAllowSubscribe());
        }
        WeChatAppletSubscribeRequestVO weChatAppletSubscribeRequestVO = new WeChatAppletSubscribeRequestVO();
        weChatAppletSubscribeRequestVO.setBrandId(sysBrandId);
        weChatAppletSubscribeRequestVO.setFirstPageName(subscribeMsgAuthRequestVO.getFirstPageName());
        weChatAppletSubscribeRequestVO.setFunctionPageName(subscribeMsgAuthRequestVO.getFunctionPageName());
        weChatAppletSubscribeRequestVO.setActiveButtonName(subscribeMsgAuthRequestVO.getActiveButtonName());
        ResponseData responseData = this.weChatAppletMessageServiceFeign.queryBrandWeChatAppletSubscribe(weChatAppletSubscribeRequestVO);
        if (responseData == null || responseData.getCode() != SysResponseEnum.SUCCESS.getCode() || responseData.getData() == null) {
            return subscribeMsgAuthResponseVO;
        }
        WeChatAppletSubscribeResponseVO weChatAppletSubscribeResponseVO = (WeChatAppletSubscribeResponseVO)responseData.getData();
        Integer brandSceneId = weChatAppletSubscribeResponseVO.getBrandSceneId();
        if (brandSceneId != null) {
            String redisKey = "BrandWeChatAppletSubscribe:brandSceneId:" + brandSceneId;
            this.redisTemplateService.stringSetString((Object)redisKey, (Object)JSON.toJSONString((Object)weChatAppletSubscribeRequestVO));
        }
        subscribeMsgAuthResponseVO.fillExtendsFiled(weChatAppletSubscribeResponseVO);
        return subscribeMsgAuthResponseVO;
    }

    public ResponseData subscribeMessageRequest(SubscribeMessageRequestVO subscribeMessageRequestVO) {
        log.info("subscribeMessageRequest#subscribeMessageRequestVO:{}", (Object)JSON.toJSONString((Object)subscribeMessageRequestVO));
        Long brandSceneId = subscribeMessageRequestVO.getBrandSceneId();
        String requestJsonString = JSON.toJSONString((Object)subscribeMessageRequestVO);
        JSONObject requestVO = JSONObject.parseObject((String)requestJsonString);
        if (!this.checkActivitySubscribeStatus(requestVO)) {
            return new ResponseData();
        }
        String redisKey = "BrandWeChatAppletSubscribe:brandSceneId:" + brandSceneId;
        String redisValue = (String)this.redisTemplateService.stringGetStringByKey((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)redisValue)) {
            WeChatAppletSubscribeRequestVO weChatAppletSubscribeRequestVO = (WeChatAppletSubscribeRequestVO)JSON.parseObject((String)redisValue, WeChatAppletSubscribeRequestVO.class);
            SubscribeMsgAuthRequestVO subscribeMsgAuthRequestVO = new SubscribeMsgAuthRequestVO();
            subscribeMsgAuthRequestVO.setBrandId(weChatAppletSubscribeRequestVO.getBrandId());
            subscribeMsgAuthRequestVO.setFirstPageName(weChatAppletSubscribeRequestVO.getFirstPageName());
            subscribeMsgAuthRequestVO.setFunctionPageName(weChatAppletSubscribeRequestVO.getFunctionPageName());
            subscribeMsgAuthRequestVO.setActiveButtonName(weChatAppletSubscribeRequestVO.getActiveButtonName());
            subscribeMsgAuthRequestVO.setOpenId(subscribeMessageRequestVO.getOpenId());
            subscribeMsgAuthRequestVO.setBusinessParam(subscribeMessageRequestVO.getBusinessParam());
            this.getAndSetAllowSubscribe(subscribeMsgAuthRequestVO, Boolean.FALSE.booleanValue(), "\u7528\u6237\u8ba2\u9605");
        }
        log.info("subscribeMessageRequest:{}", (Object)requestJsonString);
        return this.weChatAppletSubscribeMsgServiceFeign.subscribeMessageRequest(requestVO);
    }

    private boolean checkActivitySubscribeStatus(JSONObject jsonObject) {
        String businessParam = jsonObject.getString("businessParam");
        String subscribeMessage = jsonObject.getString("subscribeMessage");
        JSONObject businessJson = JSONObject.parseObject((String)businessParam);
        String activityCode = businessJson.getString("activityCode");
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return Boolean.TRUE;
        }
        String tempPOList = jsonObject.getString("tempPOList");
        if (StringUtils.isNotBlank((CharSequence)tempPOList)) {
            JSONObject subscribeJson = JSON.parseObject((String)subscribeMessage);
            subscribeJson.remove((Object)"errMsg");
            List msgWxMiniProTempPOS = JSON.parseArray((String)tempPOList, MsgWxMiniProTempPO.class);
            log.info("checkActivitySubscribeStatus.msgWxMiniProTempPOS:{}", (Object)JSON.toJSONString((Object)msgWxMiniProTempPOS));
            if (CollectionUtils.isEmpty((Collection)msgWxMiniProTempPOS) || msgWxMiniProTempPOS.size() != 1) {
                return Boolean.TRUE;
            }
            MsgWxMiniProTempPO msgWxMiniProTempPO = (MsgWxMiniProTempPO)msgWxMiniProTempPOS.get(0);
            if (!"ACTIVITY_WX_TEMPLATE_SUBSCRIBE_MESSAGE".equals(msgWxMiniProTempPO.getTemplateType())) {
                return Boolean.TRUE;
            }
            if ("accept".equals(subscribeJson.getString(msgWxMiniProTempPO.getWxTempId()))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public ResponseData closeSubscribeMessage(SubscribeMessageCloseRequestVO subscribeMessageCloseRequestVO) {
        log.info("closeSubscribeMessage#subscribeMessageCloseRequestVO:{}", (Object)JSON.toJSONString((Object)subscribeMessageCloseRequestVO));
        ResponseData responseData = new ResponseData();
        SubscribeMsgAuthRequestVO subscribeMsgAuthRequestVO = new SubscribeMsgAuthRequestVO();
        subscribeMsgAuthRequestVO.setBrandId(subscribeMessageCloseRequestVO.getBrandId());
        subscribeMsgAuthRequestVO.setFirstPageName(subscribeMessageCloseRequestVO.getFirstPageName());
        subscribeMsgAuthRequestVO.setFunctionPageName(subscribeMessageCloseRequestVO.getFunctionPageName());
        subscribeMsgAuthRequestVO.setActiveButtonName(subscribeMessageCloseRequestVO.getActiveButtonName());
        subscribeMsgAuthRequestVO.setOpenId(subscribeMessageCloseRequestVO.getOpenId());
        subscribeMsgAuthRequestVO.setBusinessParam(subscribeMessageCloseRequestVO.getBusinessParam());
        this.getAndSetAllowSubscribe(subscribeMsgAuthRequestVO, Boolean.FALSE.booleanValue(), "\u7528\u6237\u5173\u95ed");
        responseData.setMessage("close subscribe success");
        return responseData;
    }

    private SubscribeMsgAuthInfoVO getAndSetAllowSubscribe(SubscribeMsgAuthRequestVO subscribeMsgAuthRequestVO, boolean isGet, String subscribeMsg) {
        String openId = subscribeMsgAuthRequestVO.getOpenId();
        String businessParam = subscribeMsgAuthRequestVO.getBusinessParam();
        Long brandId = subscribeMsgAuthRequestVO.getBrandId();
        if (StringUtils.isBlank((CharSequence)openId)) {
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
            subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
            subscribeMsgAuthInfoVO.setSubscribeMsg("\u65e0openId\uff0c\u4e0d\u5141\u8bb8\u6388\u6743\u5f39\u7a97");
            return subscribeMsgAuthInfoVO;
        }
        String dateFormat = DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.PURE_DATE_FORMAT);
        String dateTimeFormat = DateUtil.format((Date)new Date(), (DatePrinter)DatePattern.NORM_DATETIME_FORMAT);
        StringBuilder redisKey = new StringBuilder();
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_1).booleanValue()) {
            if (StringUtils.isBlank((CharSequence)businessParam)) {
                SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
                subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
                subscribeMsgAuthInfoVO.setSubscribeMsg("\u4e1a\u52a1\u53c2\u6570:couponCode\u672a\u586b\u5199");
                return subscribeMsgAuthInfoVO;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)businessParam);
            String couponCode = jsonObject.getString("couponCode");
            if (StringUtils.isBlank((CharSequence)couponCode)) {
                SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
                subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
                subscribeMsgAuthInfoVO.setSubscribeMsg("\u4e1a\u52a1\u53c2\u6570:couponCode\u4e3a\u7a7a");
                return subscribeMsgAuthInfoVO;
            }
            String dataRedisKey = redisKey.append("BrandWeChatAppletSubscribe").append(":openId:").append(openId).append(":brandId:").append(brandId).append(":FIELD_1").append(":couponCode:").append(couponCode).toString();
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = null;
            subscribeMsgAuthInfoVO = isGet ? this.getSubscribeMsgAuthInfoByRedis(dataRedisKey, new SubscribeMsgAuthInfoVO()) : this.getAndSetSubscribeMsgAuthInfoToRedis(subscribeMsg, dateTimeFormat, dataRedisKey, null);
            return subscribeMsgAuthInfoVO;
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_2).booleanValue()) {
            return new SubscribeMsgAuthInfoVO();
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_3).booleanValue()) {
            return new SubscribeMsgAuthInfoVO();
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_4).booleanValue()) {
            String dataRedisKey = redisKey.append("BrandWeChatAppletSubscribe").append(":openId:").append(openId).append(":brandId:").append(brandId).append(":FIELD_4").append(":dateFormat:").append(dateFormat).toString();
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = null;
            subscribeMsgAuthInfoVO = isGet ? this.getSubscribeMsgAuthInfoByRedis(dataRedisKey, new SubscribeMsgAuthInfoVO()) : this.getAndSetSubscribeMsgAuthInfoToRedis(subscribeMsg, dateTimeFormat, dataRedisKey, Long.valueOf(86400000L));
            return subscribeMsgAuthInfoVO;
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_5).booleanValue()) {
            String dataRedisKey = redisKey.append("BrandWeChatAppletSubscribe").append(":openId:").append(openId).append(":FIELD_5").toString();
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
            if (isGet) {
                String dataRedisValue = (String)this.redisTemplateService.stringGetStringByKey((Object)dataRedisKey);
                if (StringUtils.isNotBlank((CharSequence)dataRedisValue)) {
                    return (SubscribeMsgAuthInfoVO)JSONObject.parseObject((String)dataRedisValue, SubscribeMsgAuthInfoVO.class);
                }
                if (StringUtils.isNotBlank((CharSequence)subscribeMsgAuthRequestVO.getMemberCode())) {
                    AppletBrandFunctionBo appletBrandFunctionBoParam = new AppletBrandFunctionBo();
                    appletBrandFunctionBoParam.setBrandId(subscribeMsgAuthRequestVO.getBrandId());
                    appletBrandFunctionBoParam.setOderMemberCode(subscribeMsgAuthRequestVO.getMemberCode());
                    subscribeMsgAuthInfoVO = this.getAndSetSubscribeMsgAuthInfoToRedis("\u5df2\u5b8c\u6210\u5b8c\u5584\u8d44\u6599\u4efb\u52a1", dateTimeFormat, dataRedisKey, Long.valueOf(86400000L));
                }
            }
            return subscribeMsgAuthInfoVO;
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_6).booleanValue()) {
            return new SubscribeMsgAuthInfoVO();
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_7).booleanValue()) {
            if (StringUtils.isBlank((CharSequence)businessParam)) {
                SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
                subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
                subscribeMsgAuthInfoVO.setSubscribeMsg("\u4e1a\u52a1\u53c2\u6570:activityCode\u672a\u586b\u5199");
                return subscribeMsgAuthInfoVO;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)businessParam);
            String activityCode = jsonObject.getString("activityCode");
            if (StringUtils.isBlank((CharSequence)activityCode)) {
                SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
                subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
                subscribeMsgAuthInfoVO.setSubscribeMsg("\u4e1a\u52a1\u53c2\u6570:activityCode\u4e3a\u7a7a");
                return subscribeMsgAuthInfoVO;
            }
            String dataRedisKey = redisKey.append("BrandWeChatAppletSubscribe").append(":openId:").append(openId).append(":brandId:").append(brandId).append(":FIELD_7").append(":activityCode:").append(activityCode).toString();
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = null;
            subscribeMsgAuthInfoVO = isGet ? this.getSubscribeMsgAuthInfoByRedis(dataRedisKey, new SubscribeMsgAuthInfoVO()) : this.getAndSetSubscribeMsgAuthInfoToRedis(subscribeMsg, dateTimeFormat, dataRedisKey, null);
            return subscribeMsgAuthInfoVO;
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_8).booleanValue()) {
            if (StringUtils.isBlank((CharSequence)businessParam)) {
                SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
                subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
                subscribeMsgAuthInfoVO.setSubscribeMsg("\u4e1a\u52a1\u53c2\u6570:taskCode\u672a\u586b\u5199");
                return subscribeMsgAuthInfoVO;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)businessParam);
            String taskCode = jsonObject.getString("taskCode");
            if (StringUtils.isBlank((CharSequence)taskCode)) {
                SubscribeMsgAuthInfoVO vgSubscribeMsgAuthInfoVo = new SubscribeMsgAuthInfoVO();
                vgSubscribeMsgAuthInfoVo.setAllowSubscribe(Boolean.FALSE);
                vgSubscribeMsgAuthInfoVo.setSubscribeMsg("\u4e1a\u52a1\u53c2\u6570:taskCode\u4e3a\u7a7a");
                return vgSubscribeMsgAuthInfoVo;
            }
            String dataRedisKey = redisKey.append("BrandWeChatAppletSubscribe").append(":openId:").append(openId).append(":brandId:").append(brandId).append(":FIELD_20").append(":taskCode:").append(taskCode).toString();
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = null;
            subscribeMsgAuthInfoVO = isGet ? this.getSubscribeMsgAuthInfoByRedis(dataRedisKey, new SubscribeMsgAuthInfoVO()) : this.getAndSetSubscribeMsgAuthInfoToRedis(subscribeMsg, dateTimeFormat, dataRedisKey, null);
            return subscribeMsgAuthInfoVO;
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_9).booleanValue()) {
            String dataRedisKey = redisKey.append("BrandWeChatAppletSubscribe").append(":openId:").append(openId).append(":brandId:").append(brandId).append(":FIELD_9").append(":dateFormat:").append(dateFormat).toString();
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = null;
            subscribeMsgAuthInfoVO = isGet ? this.getSubscribeMsgAuthInfoByRedis(dataRedisKey, new SubscribeMsgAuthInfoVO()) : this.getAndSetSubscribeMsgAuthInfoToRedis(subscribeMsg, dateTimeFormat, dataRedisKey, Long.valueOf(86400000L));
            return subscribeMsgAuthInfoVO;
        }
        if (this.isWeChatSubscribeMenuEnum(subscribeMsgAuthRequestVO, WeChatSubscribeMenuEnum.FIELD_10).booleanValue()) {
            return new SubscribeMsgAuthInfoVO();
        }
        SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
        subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
        subscribeMsgAuthInfoVO.setSubscribeMsg("\u975e\u4e1a\u52a1\u573a\u666f\uff0c\u4e0d\u5141\u8bb8\u6388\u6743\u5f39\u7a97");
        return subscribeMsgAuthInfoVO;
    }

    private Boolean isWeChatSubscribeMenuEnum(SubscribeMsgAuthRequestVO subscribeMsgAuthRequestVo, WeChatSubscribeMenuEnum weChatSubscribeMenuEnum) {
        boolean activeButtonName = weChatSubscribeMenuEnum.getActiveButtonName().equals(subscribeMsgAuthRequestVo.getActiveButtonName());
        boolean firstPageName = weChatSubscribeMenuEnum.getFirstPageName().equals(subscribeMsgAuthRequestVo.getFirstPageName());
        boolean functionPageName = weChatSubscribeMenuEnum.getFunctionPageName().equals(subscribeMsgAuthRequestVo.getFunctionPageName());
        return activeButtonName && firstPageName && functionPageName;
    }

    private SubscribeMsgAuthInfoVO getAndSetSubscribeMsgAuthInfoToRedis(String subscribeMsg, String dateTimeFormat, String dataRedisKey, Long expireTime) {
        SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = new SubscribeMsgAuthInfoVO();
        subscribeMsgAuthInfoVO.setAllowSubscribe(Boolean.FALSE);
        subscribeMsgAuthInfoVO.setLastSubscribeTime(dateTimeFormat);
        subscribeMsgAuthInfoVO.setSubscribeMsg(subscribeMsg);
        if (expireTime == null) {
            this.redisTemplateService.stringSetString((Object)dataRedisKey, (Object)JSONObject.toJSONString((Object)subscribeMsgAuthInfoVO));
        } else {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)dataRedisKey, (Object)JSONObject.toJSONString((Object)subscribeMsgAuthInfoVO), 86400000L);
        }
        return subscribeMsgAuthInfoVO;
    }

    private SubscribeMsgAuthInfoVO getSubscribeMsgAuthInfoByRedis(String dataRedisKey, SubscribeMsgAuthInfoVO defaultSubscribeMsgAuthInfoVO) {
        String dataRedisValue = (String)this.redisTemplateService.stringGetStringByKey((Object)dataRedisKey);
        if (StringUtils.isNotBlank((CharSequence)dataRedisValue)) {
            SubscribeMsgAuthInfoVO subscribeMsgAuthInfoVO = (SubscribeMsgAuthInfoVO)JSONObject.parseObject((String)dataRedisValue, SubscribeMsgAuthInfoVO.class);
            subscribeMsgAuthInfoVO.setByCache(Boolean.TRUE);
            return subscribeMsgAuthInfoVO;
        }
        return defaultSubscribeMsgAuthInfoVO;
    }
}

