/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.UnionPayService;
import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoExample;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoWithBLOBs;
import com.bizvane.appletservice.models.vo.CreateGitfCardOrderVo;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletservice.models.vo.UnionPay2MQVo;
import com.bizvane.appletservice.models.vo.UnionPayCallBackVO;
import com.bizvane.appletserviceimpl.common.PayOrderStatusEnum;
import com.bizvane.appletserviceimpl.common.RechargeTypeEnum;
import com.bizvane.appletserviceimpl.enums.OrderNoGeneratePrefixEnum;
import com.bizvane.appletserviceimpl.impl.yw.YwHelper;
import com.bizvane.appletserviceimpl.mappers.SysRechargeOrderPoMapper;
import com.bizvane.appletserviceimpl.utils.MD5Utils;
import com.bizvane.appletserviceimpl.utils.WxConfig;
import com.bizvane.base.common.bean.PayBusinessTypeEnum;
import com.bizvane.base.common.bean.PayPackageResult;
import com.bizvane.base.common.bean.PayStrategyEnum;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.service.IRemoteBusinessPayService;
import com.bizvane.base.remote.service.IRemotePayService;
import com.bizvane.centercontrolservice.models.enums.FusionPayBusinessChannelEnum;
import com.bizvane.centercontrolservice.models.enums.FusionPayBusinessTypeEnum;
import com.bizvane.centercontrolservice.models.enums.FusionPayTypeChannelRelEnum;
import com.bizvane.centercontrolservice.models.po.SysFusionPayBusinessPlatformHistoryPo;
import com.bizvane.centercontrolservice.models.vo.BrandBusinessFusionPayAppletRequestVo;
import com.bizvane.centercontrolservice.models.vo.BrandBusinessFusionPayAppletVo;
import com.bizvane.centercontrolservice.rpc.BrandBusinessFusionPayRpcService;
import com.bizvane.centercontrolservice.rpc.SysCompanyFusionPayRecordServiceRpc;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.customized.facade.interfaces.RechargeCardServiceFeign;
import com.bizvane.customized.facade.models.vo.UrRechargeCardVo;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.members.facade.models.MbrRechargeCardVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MbrRechargeCardRpcService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelRechargeApiService;
import com.bizvane.members.facade.vo.LevelRechargeCallBackRequestVO;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.serviceCard.interfaces.GiftCardStandardServiceFeign;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardInfoDTO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.common.DateUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UnionPayServiceImpl
implements UnionPayService {
    private static final Logger log = LoggerFactory.getLogger(UnionPayServiceImpl.class);
    @Autowired
    private WxConfig wxConfig;
    @Autowired
    private SysRechargeOrderPoMapper sysRechargeOrderPoMapper;
    @Autowired
    IRemotePayService iRemotePayService;
    @Autowired
    IRemoteBusinessPayService iRemoteBusinessPayService;
    @Autowired
    BrandServiceRpc brandServiceRpc;
    @Autowired
    MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    MemberInfoApiService memberInfoApiService;
    @Autowired
    ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private GiftCardStandardServiceFeign giftCardStandardServiceFeign;
    @Autowired
    private BrandBusinessFusionPayRpcService brandBusinessFusionPayRpcService;
    @Autowired
    private MbrRechargeCardRpcService mbrRechargeCardRpcService;
    @Autowired
    private SysCompanyFusionPayRecordServiceRpc sysCompanyFusionPayRecordServiceRpc;
    @Autowired
    private MemberLevelRechargeApiService memberLevelRechargeApiService;
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private RechargeCardServiceFeign rechargeCardServiceFeign;
    @Value(value="${yiWen.brandId}")
    private Long yiWenBrandId;
    @Value(value="#{'${ur.brandId}'.split(',')}")
    private List<Long> urBrandIds;
    @Autowired
    private YwHelper ywHelper;
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;
    private static final String PRIVATE_PURCHASE = "\u79c1\u4eba\u8d2d\u4e70";
    private static final String PAY_TYPE = "UNION_TYPE";
    private static final String CALLBACK_SUCCESS = "SUCCESS";
    private static final String CALLBACK_FAIL = "FAIL";
    private static final String TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    private static final String WX_TIME_FORMATTER = "yyyyMMddHHmmss";
    private static final String WX_CALL_BACK = "api/notifyCallBackUnion/payGateway";

    public ResponseData<Map<String, String>> createRechargeOrder(CreateRechargeVO vo, SysBrandPo brandPo, MemberInfoModel model, String appId) {
        String salt = "";
        String bizvaneMid = "";
        String payType = "";
        if (brandPo.getNewPayConfigSwitch().booleanValue()) {
            log.info("\u8fdb\u5165\u65b0\u652f\u4ed8\u914d\u7f6e,\u54c1\u724c\u540d\u79f0:{}", (Object)brandPo.getBrandName());
            BrandBusinessFusionPayAppletRequestVo brandBusinessFusionPayAppletRequestVo = new BrandBusinessFusionPayAppletRequestVo();
            if (brandPo.getOrganizationWithdrawSwitch().booleanValue() && Integer.valueOf(2).equals(brandPo.getOrganizationWithdrawType())) {
                brandBusinessFusionPayAppletRequestVo.setSourceType(vo.getPetCardSourceType());
                brandBusinessFusionPayAppletRequestVo.setOrganizationCode(vo.getPetCardOrgCode());
            } else {
                brandBusinessFusionPayAppletRequestVo.setSourceType(Integer.valueOf(1));
                brandBusinessFusionPayAppletRequestVo.setOrganizationCode(null);
            }
            brandBusinessFusionPayAppletRequestVo.setSysBrandId(brandPo.getSysBrandId());
            brandBusinessFusionPayAppletRequestVo.setBusinessChannelCode(FusionPayBusinessChannelEnum.CRM_PAY.getCode());
            brandBusinessFusionPayAppletRequestVo.setBusinessMethodCode(FusionPayBusinessTypeEnum.WXPAY.getCode());
            ResponseData brandBusinessFusionPayAppletVoRes = this.brandBusinessFusionPayRpcService.getBrandBusinessFusionPayAppletVo(brandBusinessFusionPayAppletRequestVo);
            log.info("brandBusinessFusionPayAppletVoRes:{}", (Object)JacksonUtil.bean2Json((Object)brandBusinessFusionPayAppletVoRes));
            if (SysResponseEnum.SUCCESS.getCode() != brandBusinessFusionPayAppletVoRes.getCode()) {
                return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u652f\u4ed8\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            if (brandBusinessFusionPayAppletVoRes.getData() == null) {
                return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u5145\u503c\u652f\u4ed8\u8fd8\u6ca1\u6709\u542f\u7528,\u65e0\u6cd5\u5145\u503c");
            }
            BrandBusinessFusionPayAppletVo businessFusionPayAppletVo = (BrandBusinessFusionPayAppletVo)brandBusinessFusionPayAppletVoRes.getData();
            salt = businessFusionPayAppletVo.getBizvaneSecretKey();
            bizvaneMid = businessFusionPayAppletVo.getBizvaneMerchantId();
            payType = businessFusionPayAppletVo.getPlatformPayTypeCode();
        } else {
            salt = brandPo.getBizvaneSecretKey();
            bizvaneMid = brandPo.getBizvaneMid();
            payType = "UNION_TYPE";
        }
        if (StringUtils.isBlank((CharSequence)vo.getPetCardNo()) && vo.getPetCardSourceType() == null) {
            ResponseData mbrRechargeCardVoResponseData = this.mbrRechargeCardRpcService.queryMbrRechargeCardByOrg(brandPo.getSysCompanyId(), brandPo.getSysBrandId(), model.getMemberCode(), Integer.valueOf(1), null);
            if (SysResponseEnum.SUCCESS.getCode() != mbrRechargeCardVoResponseData.getCode()) {
                return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u4f1a\u5458\u50a8\u503c\u5361\u4fe1\u606f\u67e5\u8be2\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            MbrRechargeCardVo mbrRechargeCardVo = (MbrRechargeCardVo)mbrRechargeCardVoResponseData.getData();
            if (mbrRechargeCardVo != null) {
                vo.setPetCardNo(mbrRechargeCardVo.getPetCardNo());
                vo.setPetCardSourceType(mbrRechargeCardVo.getCardSourceType());
            }
        }
        if (payType.equals(PayStrategyEnum.WEIXIN_PAY_STRATEGY.getPayType())) {
            return this.wxPayRecharge(vo, model, bizvaneMid, payType, salt);
        }
        return this.unionPayRecharge(vo, model, bizvaneMid, payType, salt, appId);
    }

    private ResponseData<Map<String, String>> unionPayRecharge(CreateRechargeVO vo, MemberInfoModel model, String bizvaneMid, String payType, String salt, String appId) {
        ResponseData responseData = new ResponseData();
        String serialNumber = UnionPayServiceImpl.getSerialNumber((OrderNoGeneratePrefixEnum)OrderNoGeneratePrefixEnum.CHUZHI_CARD_ONLINE_NEW);
        Integer totalFee = this.getCentAmount(vo.getMoney(), appId);
        String attach = this.getAttach(vo, model);
        String cryptData = MD5Utils.encode((String)(bizvaneMid + payType), (String)salt).toUpperCase();
        log.info("createRechargeOrder cryptData:{},totalFee:{},attach:{}", new Object[]{cryptData, totalFee, attach});
        ResultBean preOrderResult = this.iRemoteBusinessPayService.createPreOrder(bizvaneMid, serialNumber, "", model.getName(), "\u79c1\u4eba\u8d2d\u4e70", vo.getOpenid(), "", totalFee, "", "", payType, attach, cryptData, PayBusinessTypeEnum.MBR_CENTER_RECHARGE_CARD.getType());
        log.info("createRechargeOrder resp:{}", (Object)JSONObject.toJSONString((Object)preOrderResult));
        if (Boolean.FALSE.equals(preOrderResult.getSuccess()) || Boolean.TRUE.equals(preOrderResult.getSuccess()) && "FAIL".equals(((PayPackageResult)preOrderResult.getResult()).getResultCode())) {
            responseData.setMessage("\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        PayPackageResult result = (PayPackageResult)preOrderResult.getResult();
        this.insertRechargeOrder(vo, model, serialNumber, totalFee, result, attach, bizvaneMid, payType);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", result.getAppid());
        map.put("timeStamp", result.getTimeStamp());
        map.put("nonceStr", result.getNonceStr());
        map.put("package", result.getPrepayId());
        map.put("signType", "RSA");
        map.put("paySign", result.getSign());
        map.put("billNumber", serialNumber);
        responseData.setData(map);
        return responseData;
    }

    private ResponseData<Map<String, String>> wxPayRecharge(CreateRechargeVO vo, MemberInfoModel model, String bizvaneMid, String payType, String salt) {
        String serialNumber = UnionPayServiceImpl.getSerialNumber((OrderNoGeneratePrefixEnum)OrderNoGeneratePrefixEnum.CHUZHI_CARD_ONLINE_NEW);
        Integer totalFee = this.getCentAmount(vo.getMoney(), vo.getAppId());
        String attach = this.getAttach(vo, model);
        String cryptData = MD5Utils.encode((String)(bizvaneMid + payType), (String)salt).toUpperCase();
        String body = StringUtils.isBlank((CharSequence)vo.getRemake()) ? "\u5145\u503c" : vo.getRemake();
        String spbillCreateIp = this.wxConfig.getServiceUrl();
        log.info("createRechargeOrder cryptData:{},totalFee:{},attach:{}", new Object[]{cryptData, totalFee, attach});
        ResultBean preOrderResult = this.iRemoteBusinessPayService.createPreOrder(bizvaneMid, serialNumber, body, model.getName(), "\u79c1\u4eba\u8d2d\u4e70", vo.getOpenid(), "", totalFee, spbillCreateIp, "", payType, attach, cryptData, PayBusinessTypeEnum.MBR_CENTER_RECHARGE_CARD.getType());
        log.info("createRechargeOrder resp:{}", (Object)JSONObject.toJSONString((Object)preOrderResult));
        if (Boolean.FALSE.equals(preOrderResult.getSuccess()) || Boolean.TRUE.equals(preOrderResult.getSuccess()) && "FAIL".equals(((PayPackageResult)preOrderResult.getResult()).getResultCode())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        PayPackageResult result = (PayPackageResult)preOrderResult.getResult();
        this.insertRechargeOrder(vo, model, serialNumber, totalFee, result, attach, bizvaneMid, payType);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", result.getAppid());
        map.put("nonceStr", result.getNonceStr());
        map.put("package", "prepay_id=" + result.getPrepayId());
        map.put("signType", "MD5");
        map.put("timeStamp", result.getTimeStamp());
        map.put("paySign", result.getSign());
        map.put("billNumber", serialNumber);
        return new ResponseData(map);
    }

    public ResponseData transit(CreateRechargeVO vo, HttpServletRequest request) {
        log.info("UnionPayServiceImpl transit param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u65e0bizvaneSessionId");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getMoney()) || new BigDecimal(vo.getMoney()).compareTo(new BigDecimal("0")) <= 0) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(Long.valueOf(sysBrandId));
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        if (!brandPo.getNewPayConfigSwitch().booleanValue() && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{brandPo.getBizvaneMid(), brandPo.getBizvaneSecretKey()})) {
            responseData.setMessage("\u5546\u6237\u94f6\u8054\u652f\u4ed8\u4fe1\u606f\u672a\u914d\u7f6e");
            responseData.setCode(-100);
            return responseData;
        }
        return this.createRechargeOrder(vo, brandPo, model, appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ResponseData<String> unionRechargeCallBack(UnionPayCallBackVO vo) throws Exception {
        ResponseData responseData = new ResponseData();
        if (PayBusinessTypeEnum.MBR_CENTER_INTEGRAL_MALL.getType().equals(vo.getPayBusinessType())) {
            return this.getBizvaneMallCallBack(vo);
        }
        JSONObject attachObj = JSONObject.parseObject((String)vo.getAttach());
        Long sysBrandId = PayBusinessTypeEnum.MBR_CENTER_PAY_LEVEL.getType().equals(vo.getPayBusinessType()) ? attachObj.getLong("b") : attachObj.getLong("bid");
        try {
            List<String> ids;
            SysFusionPayBusinessPlatformHistoryPo sysFusionPayBusinessPlatformHistoryPo;
            ResponseData brandResp = this.brandServiceRpc.getBrandByID(sysBrandId);
            if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
                log.info("unionRechargeCallBack \u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u9519\u8bef");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData2 = responseData;
                return responseData2;
            }
            SysBrandPo brandInfo = (SysBrandPo)brandResp.getData();
            String bizvaneSecretKey = "";
            if (brandInfo.getNewPayConfigSwitch().booleanValue()) {
                log.info("\u65b0\u652f\u4ed8\u914d\u7f6e\u56de\u8c03,\u54c1\u724c\u540d\u79f0:{}", (Object)brandInfo.getBrandName());
                ResponseData sysFusionPayBusinessPlatformHistoryPoRes = this.sysCompanyFusionPayRecordServiceRpc.getFusionPayHistoryByMerchantIdAndPayType(vo.getBizvaneMid(), vo.getPayType());
                if (sysFusionPayBusinessPlatformHistoryPoRes.getCode() != SysResponseEnum.SUCCESS.getCode() || sysFusionPayBusinessPlatformHistoryPoRes.getData() == null) {
                    log.info("unionRechargeCallBack \u67e5\u8be2\u652f\u4ed8\u7f51\u5173\u914d\u7f6e\u5931\u8d25!sysFusionPayBusinessPlatformHistoryPoRes:{}", (Object)JacksonUtil.bean2Json((Object)sysFusionPayBusinessPlatformHistoryPoRes));
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                    responseData.setData((Object)"FAIL");
                    ResponseData responseData3 = responseData;
                    return responseData3;
                }
                sysFusionPayBusinessPlatformHistoryPo = (SysFusionPayBusinessPlatformHistoryPo)sysFusionPayBusinessPlatformHistoryPoRes.getData();
                bizvaneSecretKey = sysFusionPayBusinessPlatformHistoryPo.getBizvaneSecretKey();
            } else {
                bizvaneSecretKey = brandInfo.getBizvaneSecretKey();
            }
            String sign = MD5Utils.encode((String)(vo.getBizvaneMid() + vo.getPayType()), (String)bizvaneSecretKey).toUpperCase();
            if (!vo.getCryptData().equals(sign)) {
                log.info("unionRechargeCallBack \u9a8c\u7b7e\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                sysFusionPayBusinessPlatformHistoryPo = responseData;
                return sysFusionPayBusinessPlatformHistoryPo;
            }
            log.info("\u8ba2\u5355\u53f7\u662f:{}", (Object)vo.getOutTradeNo());
            if (brandInfo.getNewPayConfigSwitch().booleanValue() && PayBusinessTypeEnum.MBR_CENTER_GIFT_CARD.getType().equals(vo.getPayBusinessType())) {
                sysFusionPayBusinessPlatformHistoryPo = this.execGitfCardService(vo.getOutTradeNo(), vo.getTotalFee(), vo.getTransactionid(), vo.getAttach());
                return sysFusionPayBusinessPlatformHistoryPo;
            }
            if (UnionPayServiceImpl.isGitfCard((String)vo.getOutTradeNo())) {
                sysFusionPayBusinessPlatformHistoryPo = this.execGitfCardService(vo.getOutTradeNo(), vo.getTotalFee(), vo.getTransactionid(), vo.getAttach());
                return sysFusionPayBusinessPlatformHistoryPo;
            }
            if (PayBusinessTypeEnum.MBR_CENTER_PAY_LEVEL.getType().equals(vo.getPayBusinessType())) {
                sysFusionPayBusinessPlatformHistoryPo = this.execPayLevelService(vo);
                return sysFusionPayBusinessPlatformHistoryPo;
            }
            if (this.urBrandIds.contains(sysBrandId)) {
                log.info("\u54c1\u724cid\u662fur\u4f01\u4e1a");
                sysFusionPayBusinessPlatformHistoryPo = this.urAddMbrRechargeRecord(vo);
                return sysFusionPayBusinessPlatformHistoryPo;
            }
            this.redissonTemplate.getRLock(sysBrandId + vo.getTransactionid(), 90L, TimeUnit.SECONDS);
            SysRechargeOrderPoExample example = new SysRechargeOrderPoExample();
            example.createCriteria().andBizvaneTradeNoEqualTo(vo.getBizvaneTradeNo()).andOutTradeNoEqualTo(vo.getOutTradeNo()).andSysBrandIdEqualTo(sysBrandId);
            List poWithBLOBs = this.sysRechargeOrderPoMapper.selectByExampleWithBLOBs(example);
            if (CollectionUtils.isEmpty((Collection)poWithBLOBs)) {
                log.info("unionRechargeCallBack \u67e5\u8be2\u9884\u5145\u503c\u5355\u6d41\u6c34\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData4 = responseData;
                return responseData4;
            }
            SysRechargeOrderPoWithBLOBs po = (SysRechargeOrderPoWithBLOBs)poWithBLOBs.get(0);
            if (!PayOrderStatusEnum.WAIT_PAY.getCode().equals(po.getStatus())) {
                log.info("unionRechargeCallBack \u5df2\u652f\u4ed8 \u652f\u4ed8\u670d\u52a1\u91cd\u590d\u8c03\u7528");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData5 = responseData;
                return responseData5;
            }
            Double money = Double.parseDouble(vo.getTotalFee()) / (double)this.wxConfig.getMoneyCode().intValue();
            String testBrand = this.wxConfig.getTestBrand();
            if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(po.getAppId())) {
                money = money * 100.0;
            }
            String memberCode = String.valueOf(attachObj.get((Object)"mC"));
            MemberInfoModel member = this.getMemberInfoModel(brandInfo, memberCode);
            Integer status = null;
            for (PayOrderStatusEnum value : PayOrderStatusEnum.values()) {
                if (!value.getMessage().equals(vo.getPayStatus())) continue;
                status = value.getCode();
            }
            Object mbrRechargeExplainIdObj = attachObj.get((Object)"mbrRechargeExplainId");
            Long mbrRechargeExplainId = null;
            if (mbrRechargeExplainIdObj != null && StringUtils.isNotBlank((CharSequence)mbrRechargeExplainIdObj.toString()) && !"null".equals(mbrRechargeExplainIdObj.toString())) {
                mbrRechargeExplainId = Long.valueOf(attachObj.get((Object)"mbrRechargeExplainId").toString());
            }
            po.setPlatSerialNum(vo.getTransactionid());
            po.setStatus(status);
            po.setModifiedDate(new Date());
            po.setPayServiceStatus(vo.getPayStatus());
            int count = this.sysRechargeOrderPoMapper.updateByPrimaryKeySelective(po);
            if (count == 0) {
                PayOrderStatusEnum value;
                log.info("unionRechargeCallBack \u66f4\u65b0\u5145\u503c\u6d41\u6c34\u72b6\u6001\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                value = responseData;
                return value;
            }
            if (PayOrderStatusEnum.PAY_SUCCESS.getMessage().equals(vo.getPayStatus())) {
                Date payDate = new Date();
                if (FusionPayTypeChannelRelEnum.WXPAY_MERCHANTS.getPlatformPayTypeCode().equals(vo.getPayType())) {
                    payDate = DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyyMMddHHmmss");
                } else if (PayOrderStatusEnum.PAY_SUCCESS.getMessage().equals(vo.getPayStatus())) {
                    payDate = DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss");
                }
                String activityId = String.valueOf(attachObj.get((Object)"aid"));
                UnionPay2MQVo mqMessage = UnionPay2MQVo.builder().cardNo(member.getCardNo()).createDate(payDate).erpId(member.getErpId()).giveMoney((Double)ObjectUtils.defaultIfNull((Object)po.getGiveMoney().doubleValue(), (Object)0.0)).rechargeMoney(money).levelId(member.getLevelId()).memberCode(member.getMemberCode()).paymentDate(payDate).name(member.getName()).payId(StringUtils.isBlank((CharSequence)activityId) || "null".equals(activityId) ? null : Integer.valueOf(activityId)).state(Long.valueOf(0L)).sysBrandId(sysBrandId).payVoucherNo(vo.getTransactionid()).bizvaneMerchantId(po.getBizvaneMerchantId()).mbrPetCardSourceType(po.getMbrPetCardSourceType()).mbrPetCardNo(po.getMbrPetCardNo()).mbrPetCardOrgCode(po.getMbrPetCardOrgCode()).rechargeType(po.getPayType()).outTradeNo(vo.getOutTradeNo()).mbrRechargeExplainId(mbrRechargeExplainId).build();
                SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("public_union_pay_recharge_record").build(), (Object)JSON.toJSONString((Object)mqMessage));
                log.info("unionRechargeCallBack sendResult:{}", (Object)JSONObject.toJSONString((Object)sendResult));
            }
        }
        finally {
            this.redissonTemplate.getRUnLook(sysBrandId + vo.getTransactionid());
        }
        responseData.setData((Object)"SUCCESS");
        return responseData;
    }

    private ResponseData<String> urAddMbrRechargeRecord(UnionPayCallBackVO vo) {
        JSONObject attach = JSONObject.parseObject((String)vo.getAttach());
        Long sysCompanyId = attach.getLong("cid");
        Long brandId = attach.getLong("bid");
        String memberCode = attach.getString("mC");
        double totalFee = Double.parseDouble(vo.getTotalFee()) / (double)this.wxConfig.getMoneyCode().intValue();
        double giveMoney = attach.getDoubleValue("m");
        Long sysStoreId = this.wxPayService.getSysStoreId(memberCode);
        Date payDate = new Date();
        if (FusionPayTypeChannelRelEnum.WXPAY_MERCHANTS.getPlatformPayTypeCode().equals(vo.getPayType())) {
            payDate = DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyyMMddHHmmss");
        } else if (PayOrderStatusEnum.PAY_SUCCESS.getMessage().equals(vo.getPayStatus())) {
            payDate = DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        UrRechargeCardVo urRechargeCardVo = new UrRechargeCardVo();
        urRechargeCardVo.setSysCompanyId(sysCompanyId);
        urRechargeCardVo.setSysBrandId(brandId);
        urRechargeCardVo.setMemberCode(memberCode);
        urRechargeCardVo.setAmount(BigDecimal.valueOf(totalFee));
        urRechargeCardVo.setGiveAmount(BigDecimal.valueOf(giveMoney));
        urRechargeCardVo.setCreateDate(payDate);
        urRechargeCardVo.setMerchantNo(vo.getTransactionid());
        urRechargeCardVo.setSysStoreId(sysStoreId);
        urRechargeCardVo.setBizTradeNo(vo.getOutTradeNo());
        String nameAndCardStyleCode = attach.getString("p");
        if (StringUtils.isNotBlank((CharSequence)nameAndCardStyleCode)) {
            String params = String.valueOf(attach.get((Object)"p"));
            String[] split = params.split(",");
            if (split.length > 1) {
                urRechargeCardVo.setName(split[0]);
                urRechargeCardVo.setCardStyleCode(split[1]);
            } else {
                urRechargeCardVo.setName(split[0]);
            }
        }
        log.info("urAddMbrRechargeRecord method urRechargeCardVo={}", (Object)JacksonUtil.bean2Json((Object)urRechargeCardVo));
        ResponseData responseData = this.rechargeCardServiceFeign.addDebitCardRechargeRecord(urRechargeCardVo);
        log.info("urAddMbrRechargeRecord method responseData={}", (Object)JacksonUtil.bean2Json((Object)urRechargeCardVo));
        return responseData;
    }

    private ResponseData<String> execPayLevelService(UnionPayCallBackVO vo) {
        String inviterTaskData;
        log.info("\u6267\u884c\u4ed8\u8d39\u7b49\u7ea7\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1");
        JSONObject attach = JSONObject.parseObject((String)vo.getAttach());
        String memberCode = String.valueOf(attach.get((Object)"m"));
        Long sysBrandId = Long.valueOf(String.valueOf(attach.get((Object)"b")));
        Long sysCompanyId = Long.valueOf(String.valueOf(attach.get((Object)"c")));
        Long levelId = Long.valueOf(String.valueOf(attach.get((Object)"l")));
        boolean upgrade = attach.get((Object)"up") != null && String.valueOf(attach.get((Object)"up")).equals("1");
        LevelRechargeCallBackRequestVO callBackRequestVO = new LevelRechargeCallBackRequestVO();
        callBackRequestVO.setSysCompanyId(sysCompanyId);
        callBackRequestVO.setBrandId(sysBrandId);
        callBackRequestVO.setMemberCode(memberCode);
        callBackRequestVO.setMbrLevelId(levelId);
        callBackRequestVO.setMemberCode(memberCode);
        callBackRequestVO.setUpgrade(Boolean.valueOf(upgrade));
        callBackRequestVO.setOutTradeNo(vo.getOutTradeNo());
        callBackRequestVO.setTransactionId(vo.getTransactionid());
        callBackRequestVO.setTotalFee(new BigDecimal(Double.parseDouble(vo.getTotalFee()) / (double)this.wxConfig.getMoneyCode().intValue()));
        callBackRequestVO.setBizvaneMerchantId(vo.getBizvaneMid());
        Date payDate = new Date();
        if (FusionPayTypeChannelRelEnum.WXPAY_MERCHANTS.getPlatformPayTypeCode().equals(vo.getPayType())) {
            payDate = DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyyMMddHHmmss");
        } else if (PayOrderStatusEnum.PAY_SUCCESS.getMessage().equals(vo.getPayStatus())) {
            payDate = DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        callBackRequestVO.setPayTime(payDate);
        if (this.yiWenBrandId != null && this.yiWenBrandId.equals(callBackRequestVO.getBrandId())) {
            String ywShareGuideCode = this.ywHelper.getYwShareGuideCode(callBackRequestVO.getMemberCode(), null);
            callBackRequestVO.setYwShareGuideCode(ywShareGuideCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)(inviterTaskData = (String)this.redisTemplateService.stringGetStringByKey((Object)String.format("payLevelInviterTask:%s", memberCode))))) {
            com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)inviterTaskData);
            String orderMemberCode = jsonObject.getString("orderMemberCode");
            Long mktTaskId = jsonObject.getLong("mktTaskId");
            callBackRequestVO.setOrderMemberCode(orderMemberCode);
            callBackRequestVO.setMktTaskId(mktTaskId);
            callBackRequestVO.setTaskType(Integer.valueOf(7));
            log.info("\u8bbe\u7f6e\u5f53\u524d\u7528\u6237{},\u5bf9\u5e94orderMemberCode\u4e3a:{},mktTaskId\u4e3a:{}", new Object[]{memberCode, orderMemberCode, mktTaskId});
        }
        ResponseData levelRechargeCallBackRes = this.memberLevelRechargeApiService.levelRechargeCallBack(callBackRequestVO);
        log.info("\u4ed8\u8d39\u5361\u4e1a\u52a1\u5904\u7406\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)levelRechargeCallBackRes));
        if (levelRechargeCallBackRes.getCode() != 0) {
            log.info("\u4ed8\u8d39\u5361\u4e1a\u52a1\u5904\u7406\u5931\u8d25:{}", (Object)levelRechargeCallBackRes.getMessage());
            return new ResponseData(levelRechargeCallBackRes.getCode(), levelRechargeCallBackRes.getMessage(), (Object)"FAIL");
        }
        return new ResponseData((Object)"SUCCESS");
    }

    private ResponseData<String> getBizvaneMallCallBack(UnionPayCallBackVO vo) {
        log.info("\u8c03\u7528\u5fae\u5546\u57ce\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u63a5\u53e3");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=UTF-8");
        try {
            String resultStr = HttpUtil.post((String)(this.DOMAINNAME + "api/notifyCallBackUnion/payGateway"), (String)JacksonUtil.bean2Json((Object)vo), headerMap);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                log.info("\u8c03\u7528\u5fae\u5546\u57ce\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u8fd4\u56de\u4e3anull");
                return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), (Object)"FAIL");
            }
            log.info("\u8c03\u7528\u5fae\u5546\u57ce\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u8fd4\u56de\u4e3a:{}", (Object)resultStr);
            JSONObject resultJson = JSONObject.parseObject((String)resultStr);
            return new ResponseData(resultJson.getInteger("code").intValue(), resultJson.getString("message"), (Object)resultJson.getString("data"));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u5546\u57ce\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), (Object)"FAIL");
        }
    }

    public ResponseData<String> execGitfCardService(String out_trade_no, String total_fee, String transaction_id, String attachStr) {
        ResponseData responseData = new ResponseData();
        com.alibaba.fastjson.JSONObject attach = JSON.parseObject((String)attachStr);
        String serviceDefinitionId = attach.getString("did");
        String cardNo = attach.getString("Co");
        String sysBrandId = attach.getString("bid");
        String sysCompanyId = attach.getString("cid");
        String memberCode = attach.getString("mC");
        ReqGiftCardInfoDTO dto = new ReqGiftCardInfoDTO();
        dto.setSysCompanyId(Long.valueOf(Long.parseLong(sysCompanyId)));
        dto.setSysBrandId(Long.valueOf(Long.parseLong(sysBrandId)));
        dto.setMemberCode(memberCode);
        dto.setCardGiftDefinitionId(Long.valueOf(Long.parseLong(serviceDefinitionId)));
        dto.setGiftCardNo(cardNo);
        dto.setGiftCardId(attach.getLong("gfcid"));
        log.info("\u8bf7\u6c42service-card\u66f4\u65b0\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)dto));
        ResponseData paied = this.giftCardStandardServiceFeign.paied(dto);
        if (paied.getCode() != 0) {
            log.info("\u4fee\u6539service-card \u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u4ed8\u6b3e \u5931\u8d25:{}", (Object)paied.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData((Object)"FAIL");
            return responseData;
        }
        responseData.setData((Object)"SUCCESS");
        return responseData;
    }

    private static boolean isGitfCard(String outTradeNo) {
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            String sufixValue = outTradeNo.substring(0, 2);
            return sufixValue.equals(OrderNoGeneratePrefixEnum.SERVICE_GIFT.getSufixValue());
        }
        throw new RuntimeException("\u8ba2\u5355\u53f7\u662f\u7a7a\u7684");
    }

    private MemberInfoModel getMemberInfoModel(SysBrandPo brandInfo, String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setSysCompanyId(brandInfo.getSysCompanyId());
        memberInfoModel.setBrandId(brandInfo.getSysBrandId());
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        return (MemberInfoModel)memberInfoModelResponseData.getData();
    }

    private ResponseData addRechargeRecord(String transactionid, String timeEnd, SysRechargeOrderPoWithBLOBs po, Double money, MemberInfoModel member) {
        MbrRechargeRecordPo recordPo = new MbrRechargeRecordPo();
        recordPo.setErpId(member.getErpId());
        recordPo.setName(member.getName());
        recordPo.setCardNo(member.getCardNo());
        recordPo.setSysBrandId(member.getBrandId());
        recordPo.setRechargeMoney(money);
        recordPo.setGiveMoney((Double)ObjectUtils.defaultIfNull((Object)po.getGiveMoney().doubleValue(), (Object)0.0));
        recordPo.setPayVoucherNo(transactionid);
        recordPo.setState(Long.valueOf(0L));
        recordPo.setCreateDate(DateUtil.parse((String)timeEnd, (String)"yyyy-MM-dd HH:mm:ss"));
        recordPo.setPaymentDate(DateUtil.parse((String)timeEnd, (String)"yyyy-MM-dd HH:mm:ss"));
        log.info("UnionPayServiceImpl addRechargeRecord params:{}", (Object)JSONObject.toJSONString((Object)recordPo));
        return this.mbrRechargeServiceRpc.addMbrRechargeRecord(recordPo);
    }

    private void insertRechargeOrder(CreateRechargeVO vo, MemberInfoModel model, String serialNumber, Integer totalFee, PayPackageResult result, String attach, String bizvaneMid, String payChannelCode) {
        SysRechargeOrderPoWithBLOBs preOrder = new SysRechargeOrderPoWithBLOBs();
        preOrder.setBizvaneTradeNo(result.getBizvaneTradeNo());
        preOrder.setCreateDate(new Date());
        preOrder.setGiveMoney(new BigDecimal(vo.getGiveMoney()));
        preOrder.setOutTradeNo(serialNumber);
        preOrder.setMemberCode(model.getMemberCode());
        preOrder.setOpenId(vo.getOpenid());
        preOrder.setRechargeMoney(new BigDecimal(vo.getMoney()));
        preOrder.setStatus(PayOrderStatusEnum.WAIT_PAY.getCode());
        preOrder.setSysCompanyId(model.getSysCompanyId());
        preOrder.setSysBrandId(model.getBrandId());
        preOrder.setAttach(attach);
        preOrder.setTotalFee(totalFee);
        preOrder.setAppId(result.getAppid());
        preOrder.setBizvaneMerchantId(bizvaneMid);
        preOrder.setMbrPetCardNo(vo.getPetCardNo());
        preOrder.setMbrPetCardSourceType(vo.getPetCardSourceType());
        preOrder.setMbrPetCardOrgCode(vo.getPetCardOrgCode());
        RechargeTypeEnum rechargeTypeEnum = RechargeTypeEnum.getRechargeTypeEnumByPayChannelCode((String)payChannelCode);
        if (rechargeTypeEnum != null) {
            log.info("\u652f\u4ed8\u7c7b\u578b\u679a\u4e3e:{}", (Object)rechargeTypeEnum.toString());
            preOrder.setPayType(rechargeTypeEnum.getCode());
        }
        this.sysRechargeOrderPoMapper.insertSelective(preOrder);
    }

    private String getAttach(CreateRechargeVO vo, MemberInfoModel model) {
        HashMap<String, String> attachMap = new HashMap<String, String>();
        attachMap.put("m", vo.getGiveMoney());
        attachMap.put("mC", model.getMemberCode());
        attachMap.put("aid", vo.getActivityId());
        attachMap.put("bid", model.getBrandId().toString());
        attachMap.put("cid", model.getSysCompanyId().toString());
        if (vo.getMbrRechargeExplainId() != null) {
            attachMap.put("mbrRechargeExplainId", vo.getMbrRechargeExplainId().toString());
        }
        return JSONObject.toJSONString(attachMap);
    }

    private String getAttach(CreateGitfCardOrderVo vo, MemberInfoModel model) {
        HashMap<String, String> attachMap = new HashMap<String, String>();
        attachMap.put("Co", vo.getCardNo());
        attachMap.put("mC", model.getMemberCode());
        attachMap.put("did", vo.getServiceCardDefinitionId());
        attachMap.put("bid", model.getBrandId().toString());
        attachMap.put("cid", model.getSysCompanyId().toString());
        return JSONObject.toJSONString(attachMap);
    }

    private static String getSerialNumber(OrderNoGeneratePrefixEnum enu) {
        String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        return enu.getSufixValue() + format + UUIDUtil.getUUID().substring(0, 4);
    }

    private Integer getCentAmount(String amount, String appId) {
        Integer value = null;
        String testBrand = this.wxConfig.getTestBrand();
        if (StringUtils.isNotEmpty((CharSequence)testBrand)) {
            List<String> ids = Arrays.asList(testBrand.split(","));
            if (ids.contains(appId)) {
                value = Integer.parseInt(amount);
            } else {
                Integer integer = Integer.valueOf(amount);
                value = integer * this.wxConfig.getMoneyCode();
            }
        }
        return value;
    }
}

