/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson2.JSON;
import com.bizvane.appletservice.interfaces.MktPopupService;
import com.bizvane.appletservice.models.vo.MktPopupAdvertisementInfoVO;
import com.bizvane.appletservice.models.vo.SysConfigsInfoVO;
import com.bizvane.centerstageservice.models.po.SysConfigsPo;
import com.bizvane.centerstageservice.rpc.SysConfigsServiceRpc;
import com.bizvane.mktcenterservice.models.vo.MktPopupAdvertisementRequestVO;
import com.bizvane.mktcenterservice.rpc.MktPopupAdvertisementServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MktPopupServiceImpl
implements MktPopupService {
    private static final Logger log = LoggerFactory.getLogger(MktPopupServiceImpl.class);
    @Autowired
    private SysConfigsServiceRpc sysConfigsServiceRpc;
    @Autowired
    private MktPopupAdvertisementServiceRpc mktPopupAdvertisementServiceRpc;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public ResponseData<MktPopupAdvertisementInfoVO> getPopupAdvertisementList(Long sysBrandId, String memberCode, Integer channelType) {
        log.info("getPopupAdvertisementList#sysBrandId:{},memberCode:{},channelType:{}", new Object[]{sysBrandId, memberCode, channelType});
        ResponseData responseData = new ResponseData();
        ResponseData respData = this.sysConfigsServiceRpc.getConfigsByBrandAndKeyWithoutRedis(sysBrandId, "POPUP_SETTING_KEY");
        log.info("getPopupAdvertisementList#respData:{}", (Object)JSON.toJSONString((Object)respData));
        if (null == respData || respData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u83b7\u53d6\u54c1\u724c\u5f39\u7a97\u5e7f\u544a\u914d\u7f6e\u5931\u8d25");
            return responseData;
        }
        MktPopupAdvertisementInfoVO mktPopupAdvertisementInfoVO = new MktPopupAdvertisementInfoVO();
        SysConfigsPo sysConfigsPo = (SysConfigsPo)respData.getData();
        SysConfigsInfoVO sysConfigsInfoVO = new SysConfigsInfoVO();
        if (null != sysConfigsPo) {
            sysConfigsInfoVO.setConfigKey(sysConfigsPo.getConfigKey());
            sysConfigsInfoVO.setConfigValue(sysConfigsPo.getConfigValue());
        }
        mktPopupAdvertisementInfoVO.setSysConfigsVO(sysConfigsInfoVO);
        ResponseData mktPopupRespData = this.mktPopupAdvertisementServiceRpc.selectPopupAdvertisement(sysBrandId, memberCode, channelType);
        log.info("getPopupAdvertisementList#mktPopupRespData:{}", (Object)JSON.toJSONString((Object)mktPopupRespData));
        if (null == mktPopupRespData || respData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u83b7\u53d6\u4f1a\u5458\u5f39\u7a97\u5e7f\u544a\u5217\u8868\u5931\u8d25");
            return responseData;
        }
        mktPopupAdvertisementInfoVO.setMktPopupInfoVOList((List)mktPopupRespData.getData());
        responseData.setData((Object)mktPopupAdvertisementInfoVO);
        return responseData;
    }

    public ResponseData<String> mktPopupScanDataCollect(MktPopupAdvertisementRequestVO mktPopupAdvertisementRequestVO) {
        log.info("mktPopupScanDataCollect#mktPopupAdvertisementRequestVO:{}", (Object)JSON.toJSONString((Object)mktPopupAdvertisementRequestVO));
        ResponseData responseData = new ResponseData();
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("mkt_popup_topic").tag("advertisement_collect_tag").build(), (Object)mktPopupAdvertisementRequestVO);
        log.info("mktPopupScanDataCollect#sendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
        responseData.setData((Object)sendResult.getMsgId());
        return responseData;
    }
}

