/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.bizvane.appletservice.interfaces.MembershipCardService;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipCartPOExample;
import com.bizvane.appletservice.models.vo.MbrCarBarCodeVO;
import com.bizvane.appletserviceimpl.impl.HemsCommon;
import com.bizvane.appletserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.appletserviceimpl.utils.QRCodeUtil;
import com.bizvane.appletserviceimpl.vo.HemsCardNoE3VO;
import com.bizvane.centerstageservice.models.vo.SysBrandGrowthConfigVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.code.BarcodeUtils;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.AesUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MembershipCardServiceImpl
implements MembershipCardService {
    private static final Logger log = LoggerFactory.getLogger(MembershipCardServiceImpl.class);
    @Autowired
    private AppletVipCartPOMapper appletVipCartPoMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private HemsCommon hemsCommon;

    public ResponseData<List<AppletVipCartPO>> selectByPrimaryKey(Long appletVipCardId) {
        ResponseData responseData = new ResponseData();
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGradeIdEqualTo(appletVipCardId);
        List appletVipCartPO = this.appletVipCartPoMapper.selectByExample(appletVipCartPOExample);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)appletVipCartPO);
        return responseData;
    }

    public MbrCarBarCodeVO getMbrCarBarCode1VO(Long sysCompanyId, Long sysBrandId, String code) {
        SysBrandGrowthConfigVo configVo = (SysBrandGrowthConfigVo)this.brandServiceRpc.queryGrowthConfigRoleSwitch(sysCompanyId, sysBrandId).getData();
        Boolean switchBoolean = configVo.getMbrCardCodeValiditySwitch();
        if (switchBoolean.booleanValue()) {
            code = code + "_" + DateUtils.getStringNoDate((Date)new Date());
            try {
                code = AesUtils.encryptAES((String)configVo.getMbrCardCodeValidityKey(), (String)configVo.getMbrCardCodeValidityKey(), (String)code);
            }
            catch (Exception e) {
                log.error("\u52a0\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
                throw new BizException(-1, "\u52a0\u5bc6\u5931\u8d25");
            }
        }
        String barCodeData = BarcodeUtils.generateBarCode((String)code);
        return new MbrCarBarCodeVO(switchBoolean, barCodeData, configVo.getMbrCardCodeValidityTime());
    }

    public MbrCarBarCodeVO getMbrCarBarCode2VO(Long sysCompanyId, Long sysBrandId, String code) {
        HemsCardNoE3VO e3VO;
        SysBrandGrowthConfigVo configVo = (SysBrandGrowthConfigVo)this.brandServiceRpc.queryGrowthConfigRoleSwitch(sysCompanyId, sysBrandId).getData();
        Boolean switchBoolean = configVo.getMbrCardCodeValiditySwitch();
        if (switchBoolean.booleanValue()) {
            code = code + "_" + DateUtils.getStringNoDate((Date)new Date());
            try {
                code = AesUtils.encryptAES((String)configVo.getMbrCardCodeValidityKey(), (String)configVo.getMbrCardCodeValidityKey(), (String)code);
            }
            catch (Exception e) {
                log.error("\u52a0\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
                throw new BizException(-1, "\u52a0\u5bc6\u5931\u8d25");
            }
        }
        if (sysCompanyId.equals(this.hemsCommon.getHemsSysCompanyId()) && (e3VO = this.hemsCommon.getHemsCardNo(code)) != null && StringUtils.isNotBlank((CharSequence)e3VO.getDynamicNo())) {
            code = e3VO.getDynamicNo();
        }
        String barCodeData = null;
        try {
            barCodeData = QRCodeUtil.crateQRCode((String)code, (int)200, (int)200);
        }
        catch (IOException e) {
            log.error("\u4e8c\u7ef4\u7801\u751f\u6210\u5f02\u5e38:", (Throwable)e);
            throw new BizException(-1, "\u4e8c\u7ef4\u7801\u751f\u6210\u5f02\u5e38");
        }
        return new MbrCarBarCodeVO(switchBoolean, barCodeData, configVo.getMbrCardCodeValidityTime());
    }
}

