/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberPrizeService;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.AppletSysStoreBo;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeResVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeStoreReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeStoreResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeAddressReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeReqVO;
import com.bizvane.mktcenterservice.rpc.TaskPrizeServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberPrizeServiceImpl
implements MemberPrizeService {
    private static final Logger log = LoggerFactory.getLogger(MemberPrizeServiceImpl.class);
    @Autowired
    private TaskPrizeServiceRpc taskPrizeServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;

    public ResponseData<List<MemberTaskPrizeResVO>> taskPrizeRecord(MemberTaskPrizeReqVO reqVO) {
        return this.taskPrizeServiceRpc.getTaskPrizeRecord(reqVO);
    }

    public ResponseData addPrizeAddressNew(TaskPrizeAddressReqVO reqVO) {
        return this.taskPrizeServiceRpc.addPrizeAddressNew(reqVO);
    }

    public ResponseData<TaskPrizeExchangeDetailResVO> getPrizeExchangeDetail(TaskPrizeExchangeDetailReqVO reqVO) {
        return this.taskPrizeServiceRpc.getPrizeExchangeDetail(reqVO);
    }

    public ResponseData receivePrize(TaskPrizeExchangeReqVO reqVO) {
        return this.taskPrizeServiceRpc.receivePrize(reqVO);
    }

    public ResponseData searchStoresByRecordId(MemberOpenCardStoreVo memberOpenCardStoreVo) {
        log.info("searchStoresByRecordId memberOpenCardStoreVo:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        MemberTaskPrizeStoreReqVO paramsVO = new MemberTaskPrizeStoreReqVO();
        paramsVO.setId(memberOpenCardStoreVo.getMktActivityPrizeRecordId());
        paramsVO.setMemberCode(memberOpenCardStoreVo.getMemberCode());
        ResponseData storeResponseData = this.taskPrizeServiceRpc.selectStoreIds(paramsVO);
        log.info("searchStoresByRecordId#storeResponseData:{}", (Object)JacksonUtil.bean2Json((Object)storeResponseData));
        if (null == storeResponseData || SysResponseEnum.SUCCESS.getCode() != storeResponseData.getCode()) {
            responseData.setMessage("\u53ef\u63d0\u8d27\u95e8\u5e97\u5217\u8868\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        MemberTaskPrizeStoreResVO prizeStoreResVO = (MemberTaskPrizeStoreResVO)storeResponseData.getData();
        if (prizeStoreResVO == null) {
            responseData.setMessage("\u53ef\u63d0\u8d27\u95e8\u5e97\u5217\u8868\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        SysStoreBo vo = new SysStoreBo();
        BeanUtils.copyProperties((Object)memberOpenCardStoreVo, (Object)vo);
        if (!prizeStoreResVO.getStoreScopeType().equals(0)) {
            if (null == prizeStoreResVO.getStoreIdList() || prizeStoreResVO.getStoreIdList().size() == 0) {
                responseData.setMessage("\u53ef\u63d0\u8d27\u95e8\u5e97\u5217\u8868\u4e3a\u7a7a");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            vo.setStoreIdList(prizeStoreResVO.getStoreIdList());
        }
        return this.searchStore(vo);
    }

    public ResponseData searchStore(SysStoreBo vo) {
        ResponseData responseData = new ResponseData();
        ResponseData brandByIdSysStoreListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(vo);
        List sysStoreBoList = ((PageInfo)brandByIdSysStoreListPage.getData()).getList();
        ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        for (SysStoreBo sysStoreBo : sysStoreBoList) {
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            String distance = sysStoreBo.getDistance();
            if (distance == null) {
                sysStoreBo.setDistance(distance);
            } else {
                Double aDouble = Double.valueOf(distance);
                if (aDouble == null) {
                    sysStoreBo.setDistance(distance);
                }
                double lod = aDouble / 1000.0;
                String format = new DecimalFormat("###.#").format(lod);
                sysStoreBo.setDistance(format);
            }
            BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
            if (appletSysStoreBo != null) {
                AppletSysStoreBos.add(appletSysStoreBo);
                continue;
            }
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        if (AppletSysStoreBos != null) {
            for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                if (appletSysStoreBo.getDistance() == null) {
                    sysStoreBos.add(appletSysStoreBo);
                }
                if (appletSysStoreBo.getDistance() == null) continue;
                appletSysStoreBos.add(appletSysStoreBo);
            }
        }
        if (appletSysStoreBos != null) {
            Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
        }
        ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
        appletSysStoreBoList.addAll(appletSysStoreBos);
        appletSysStoreBoList.addAll(sysStoreBos);
        appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
        log.info("searchStoresByRecordId\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }
}

