/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.CreateMembersCardService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletByCodeBo;
import com.bizvane.appletservice.models.bo.AppletLoginBo;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.ParamProcessingVo;
import com.bizvane.appletservice.models.vo.WxMbrRegisteRequestVo;
import com.bizvane.appletserviceimpl.impl.yw.YwHelper;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.SystemServiceRpc;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.members.facade.constants.SysResponseEnum;
import com.bizvane.members.facade.enums.MemberCardStatusModifySourceEnum;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberElectCardApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MiniProgramOpenCardService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.members.facade.service.electcard.MbrElectCardOpenErrorRpcService;
import com.bizvane.members.facade.service.electcard.MemberElectCardOpenCardApiService;
import com.bizvane.members.facade.vo.MbrElectCardOpenErrorVo;
import com.bizvane.members.facade.vo.MemberCardStatusLogOutVo;
import com.bizvane.members.facade.vo.MemberElectCardRequestVo;
import com.bizvane.members.facade.vo.MemberElectCardResVo;
import com.bizvane.members.facade.vo.MemberElectCardResponseVo;
import com.bizvane.members.facade.vo.MemberElectCardSearchVo;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.interfaces.SendCommonMessageFeign;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.unifiedreg.rpc.AppletServiceFeign;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.UserAuthorizationFeign;
import com.bizvane.wechatfacade.interfaces.WxMiniprgmServiceFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberResponseVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoResponseVO;
import com.bizvane.wechatfacade.models.vo.WxCodeResolveVo;
import com.google.gson.Gson;
import feign.FeignException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private SendCommonMessageFeign sendCommonMessageFeign;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private AppletServiceFeign appletServiceFeign;
    @Autowired
    private MiniProgramOpenCardService miniProgramOpenCardService;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private UserAuthorizationFeign userAuthorizationFeign;
    @Autowired
    private WxMiniprgmServiceFeign wxMiniprgmServiceFeign;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private CreateMembersCardService createMembersCardService;
    @Autowired
    private MemberElectCardOpenCardApiService memberElectCardOpenCardApiService;
    @Autowired
    private MemberElectCardApiService memberElectCardApiService;
    @Autowired
    private MbrElectCardOpenErrorRpcService mbrElectCardOpenErrorRpcService;
    @Autowired
    private SystemServiceRpc systemServiceRpc;
    private static final String MEMEBER_ACTIVITY = "api/marketActivity/newMemberByActivity";
    @Autowired
    private YwHelper ywHelper;
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private StaffServiceRpc staffServiceRpc;

    public String getMemberCode(HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            throw LogicException.error((Integer)-100, (String)"\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            throw LogicException.error((Integer)-100, (String)"\u4f1a\u5458\u4e3a\u7a7a");
        }
        return memberCode;
    }

    public String getMemberCode() {
        return this.getMemberCode(this.request);
    }

    public MemberResoucreBO getMemberResourceBO() {
        String sysCompanyId = this.request.getHeader("sysCompanyId");
        String sysBrandId = this.request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysCompanyId) || StringUtils.isBlank((CharSequence)sysBrandId)) {
            throw LogicException.error((Integer)-100, (String)"\u672a\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        return MemberResoucreBO.builder().memberCode(this.getMemberCode()).sysCompanyId(Long.valueOf(Long.parseLong(sysCompanyId))).brandId(Long.valueOf(Long.parseLong(sysBrandId))).build();
    }

    public MemberResoucreBO getLoginResourceBO() {
        String sysCompanyId = this.request.getHeader("sysCompanyId");
        String sysBrandId = this.request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysCompanyId) || StringUtils.isBlank((CharSequence)sysBrandId)) {
            throw LogicException.error((Integer)-100, (String)"\u672a\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        String bizvaneSessionId = this.request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            throw LogicException.error((Integer)-100, (String)"\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        return MemberResoucreBO.builder().memberCode(memberCode).sysCompanyId(Long.valueOf(Long.parseLong(sysCompanyId))).brandId(Long.valueOf(Long.parseLong(sysBrandId))).build();
    }

    public ResponseData<Map<String, Object>> login(AppletLoginBo bo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode());
        if (StringUtils.isBlank((CharSequence)bo.getPhone())) {
            responseData.setMessage("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)bo.getVerificationCode())) {
            responseData.setMessage("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        String redisVerificationCode = (String)this.redisTemplateService.stringGetStringByKey((Object)bo.getPhone());
        System.out.println("redisVerificationCode:" + redisVerificationCode);
        if (!bo.getVerificationCode().equals(redisVerificationCode)) {
            responseData.setMessage("\u9a8c\u8bc1\u7801\u9519\u8bef!");
            return responseData;
        }
        String memberCode = "2";
        ResponseData memberCardLevelModelData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel memberCardLevelModel = (MemberCardLevelModel)memberCardLevelModelData.getData();
        String token = JWTUtil.sign((Object)memberCardLevelModel, (long)JWTUtil.TTLMILLIS.intValue());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("token", token);
        map.put("memberCardLevelModel", (String)memberCardLevelModel);
        responseData.setData(map);
        responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<Integer> sendVerificationCode(String sign, String usign, String phone, String sysBrandId, String areaCode) {
        int count;
        ResponseData responseData = new ResponseData();
        logger.info("phone=========={},{}", (Object)phone, (Object)areaCode);
        if (StringUtils.isEmpty((CharSequence)sign)) {
            responseData.setCode(101);
            responseData.setMessage("sign\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String uid = (String)this.redisTemplateService.stringGetStringByKey((Object)sign.toUpperCase());
        logger.info("\u83b7\u53d6\u7684sign={}  redis\u4e2d\u62ff\u5230\u7684uid={}", (Object)sign, (Object)uid);
        if (!usign.equals(uid)) {
            responseData.setCode(101);
            responseData.setMessage("\u7b7e\u540d\u5f02\u5e38");
            return responseData;
        }
        this.redisTemplateService.deleteFromRedis((Object)sign.toUpperCase());
        SysSmsConfigVO sysSmsConfigVO = new SysSmsConfigVO();
        sysSmsConfigVO.setChannelName("moments3.4");
        sysSmsConfigVO.setChannelAccount("JJ0253");
        sysSmsConfigVO.setChannelPassword("513678");
        sysSmsConfigVO.setChannelService("http://TSN19.800CT.COM:8901/MWGate/wmgw.asmx/MongateSendSubmit");
        sysSmsConfigVO.setPhone(phone);
        if (StringUtils.isNotBlank((CharSequence)sysBrandId)) {
            sysSmsConfigVO.setSysBrandId(Long.valueOf(sysBrandId));
        }
        String redisVerificationCode = (String)this.redisTemplateService.stringGetStringByKey((Object)("limitTime" + phone));
        String authcode = "";
        if (!StringUtils.isBlank((CharSequence)redisVerificationCode)) {
            responseData.setData((Object)"-1");
            responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("60\u79d2\u5185\u65e0\u6cd5\u518d\u6b21\u53d1\u9001");
            return responseData;
        }
        Random r = new Random();
        Double d = r.nextDouble();
        authcode = d.toString().substring(3, 9);
        String text = "\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a\uff1a";
        text = text + authcode + "\u3002\u9a8c\u8bc1\u78015\u5206\u949f\u5185\u6709\u6548";
        sysSmsConfigVO.setMsgContent(text);
        String intCount = (String)this.redisTemplateService.stringGetStringByKey((Object)("intCount" + phone));
        if (StringUtils.isBlank((CharSequence)intCount)) {
            intCount = "0";
        }
        if ("50".equals(intCount = String.valueOf(count = Integer.valueOf(intCount) + 1))) {
            responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4eca\u65e5\u9a8c\u8bc1\u7801\u53d1\u9001\u6b21\u6570\u5df2\u8d85\u9650\u5236");
            return responseData;
        }
        logger.info("sysSmsConfigVO={}", (Object)JSON.toJSONString((Object)sysSmsConfigVO));
        ResponseData result = this.sendCommonMessageFeign.sendSmg(sysSmsConfigVO);
        Integer i = result.getCode();
        logger.info("i========" + i);
        if (i == 0) {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)phone, (Object)authcode, 300000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("limitTime" + phone), (Object)"1", 60000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("intCount" + phone), (Object)intCount, 86400000L);
            logger.info("\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a========" + authcode);
            responseData.setData((Object)0);
            responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u53d1\u9001\u6210\u529f!");
        } else {
            responseData.setData((Object)"-1");
            responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(result.getMessage());
        }
        return responseData;
    }

    public ResponseData<Integer> loginToken(String token) {
        ResponseData responseData = new ResponseData();
        if (token == null) {
            responseData.setMessage("token \u4e3a\u7a7a");
            responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        Gson gson = new Gson();
        Claims claims = JWTUtil.parseJWT((String)token);
        String subject = claims.getSubject();
        MemberCardLevelModel memberCardLevelModel = (MemberCardLevelModel)gson.fromJson(subject, MemberCardLevelModel.class);
        if (memberCardLevelModel == null) {
            responseData.setMessage("token \u9a8c\u8bc1\u5931\u8d25");
            responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u9a8c\u8bc1\u6210\u529f");
        responseData.setData((Object)memberCardLevelModel);
        return responseData;
    }

    public ResponseData<AppletRefreshtoInterfaceBo> refreshtoInterface(String appId) {
        ResponseData responseData = new ResponseData();
        ResponseData otherMiniprgm = this.wxMiniprgmServiceFeign.getJumpMiniprgm(appId);
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        String personalAppId = ((WxPublicPO)otherMiniprgm.getData()).getAppid();
        logger.info("\u8fd4\u56de\u5fae\u5546\u57ceappid={}", (Object)personalAppId);
        String url = "/pages/entry/main";
        appletRefreshtoInterfaceBo.setAppId(personalAppId);
        appletRefreshtoInterfaceBo.setUrl(url);
        if (appletRefreshtoInterfaceBo == null) {
            responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        responseData.setCode(com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        return responseData;
    }

    public ResponseData<AppletBrandMenberBo> getUserInfobyCode(String code, String appid) {
        logger.info("getUserInfobyCode\u63a5\u53e3\u5165\u53c2,code={} , appid={}", (Object)code, (Object)appid);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)code), (String)"code\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)appid), (String)"appid\u4e3a\u7a7a");
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        WxCodeResolveVo wxCodeResolveVo = this.getWxCodeResolveVo(code, appid);
        String bizvaneSessionId = wxCodeResolveVo.getBizvaneSessionId();
        logger.info("bizvaneSessionId\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvaneSessionId, (Object)bizvaneSessionId, 7776000000L);
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(appid);
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sysBrandPo.getBrandLogo()));
        }
        logger.info("\u7f13\u5b58\u6240\u9700\u5fae\u4fe1\u5173\u952e\u4fe1\u606f\u5230Redis,openId={},unionid={}, appid={},sysBrandId={}", new Object[]{wxCodeResolveVo.getOpenid(), wxCodeResolveVo.getUnionid(), appid, sysBrandPo.getSysBrandId()});
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getOpenId" + bizvaneSessionId), (Object)wxCodeResolveVo.getOpenid(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + bizvaneSessionId), (Object)wxCodeResolveVo.getUnionid(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getAppId" + bizvaneSessionId), (Object)appid, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(sysBrandPo.getSysBrandId()), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(sysBrandPo.getSysBrandId()), 7776000000L);
        AppletBrandMenberBo appletBrandMenberBo = this.getMbrOpenCardFlag(wxCodeResolveVo, sysBrandPo.getSysBrandId(), appid);
        appletBrandMenberBo.setAppletByCodeBo(appletByCodeBo);
        appletBrandMenberBo.setSysCompanyId(sysBrandPo.getSysCompanyId());
        appletBrandMenberBo.setSysBrandId(sysBrandPo.getSysBrandId());
        appletBrandMenberBo.setOpenId(wxCodeResolveVo.getOpenid());
        appletBrandMenberBo.setUnionId(wxCodeResolveVo.getUnionid());
        logger.info("\u7528\u6237\u57fa\u672c\u4fe1\u606f\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        logger.info("getUserInfobyCode\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)appletBrandMenberBo));
        return new ResponseData((Object)appletBrandMenberBo);
    }

    public ResponseData<AppletBrandMenberBo> getUserInfoByUnionId(String unionId, Long sysBrandId) {
        logger.info("getUserInfoByUnionId\u63a5\u53e3\u5165\u53c2,unionId={}, sysBrandId={}", (Object)unionId, (Object)sysBrandId);
        MemberInfoModel memberInfoModelParam = new MemberInfoModel();
        memberInfoModelParam.setBrandId(sysBrandId);
        memberInfoModelParam.setWxUnionId(unionId);
        MemberInfoModel memberInfoModel = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModelParam).getData();
        if (memberInfoModel == null) {
            return new ResponseData(-1, "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        String bizvaneSessionId = DigestUtils.md5Hex((String)UUID.randomUUID().toString());
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvaneSessionId, (Object)bizvaneSessionId, 7776000000L);
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(sysBrandId).getData();
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sysBrandPo.getBrandLogo()));
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + bizvaneSessionId), (Object)unionId, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(sysBrandPo.getSysBrandId()), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(sysBrandPo.getSysBrandId()), 7776000000L);
        AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
        appletBrandMenberBo.setOpenCard(true);
        appletBrandMenberBo.setMemberCode(memberInfoModel.getMemberCode());
        appletBrandMenberBo.setUnionId(unionId);
        appletBrandMenberBo.setCardUseStatus(Integer.valueOf(1));
        logger.info("2\u5b58\u50a8\u4f1a\u5458\u4fe1\u606f\u5230Redis memberCode={}  bizvaneSessionId={}   phone={}", new Object[]{memberInfoModel.getMemberCode(), bizvaneSessionId, memberInfoModel.getPhone()});
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + bizvaneSessionId), (Object)unionId, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + memberInfoModel.getMemberCode()), (Object)memberInfoModel.getPhone(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberInfoModel.getMemberCode(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberInfoModel.getMemberCode() + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
        logger.info("2UnionId={}", this.redisTemplateService.stringGetStringByKey((Object)("getUnionId" + bizvaneSessionId)));
        appletBrandMenberBo.setAppletByCodeBo(appletByCodeBo);
        appletBrandMenberBo.setSysCompanyId(sysBrandPo.getSysCompanyId());
        appletBrandMenberBo.setSysBrandId(sysBrandPo.getSysBrandId());
        appletBrandMenberBo.setUnionId(unionId);
        logger.info("2\u7528\u6237\u57fa\u672c\u4fe1\u606f\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        logger.info("2getUserInfobyCode\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)appletBrandMenberBo));
        return new ResponseData((Object)appletBrandMenberBo);
    }

    public ResponseData<AppletBrandMenberBo> getMbrAndOpenCard(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        logger.info("\u66f4\u65b0\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u53ca\u6ce8\u518c\u5f00\u5361\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)wxMbrRegisteRequestVo));
        this.checkWxMbrRegisterRequestVoParam(wxMbrRegisteRequestVo);
        this.checkVerifCode(wxMbrRegisteRequestVo);
        ResponseData userInfoResData = this.userAuthorizationFeign.getUserInfoByCode(wxMbrRegisteRequestVo.getCode(), wxMbrRegisteRequestVo.getAppid());
        logger.info("\u6388\u6743\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8fd4\u56de\u7684\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)userInfoResData));
        if (userInfoResData == null || userInfoResData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || userInfoResData.getData() == null || ((UserAuthorizationGetUserInfoResponseVO)userInfoResData.getData()).getSysBrandId() == null) {
            return new ResponseData(100, "\u6388\u6743\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
        }
        UserAuthorizationGetUserInfoResponseVO userInfoRes = (UserAuthorizationGetUserInfoResponseVO)userInfoResData.getData();
        String bizvaneSessionId = userInfoRes.getBizvaneSessionId();
        logger.info("bizvaneSessionId\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvaneSessionId, (Object)bizvaneSessionId, 7776000000L);
        this.cacheWxInfoToRedis(wxMbrRegisteRequestVo, bizvaneSessionId, userInfoRes);
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(wxMbrRegisteRequestVo.getAppid());
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sysBrandPo.getBrandLogo()));
        }
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        menberBoRes.setAppletByCodeBo(appletByCodeBo);
        menberBoRes.setUnionId(userInfoRes.getUnionId());
        menberBoRes.setOpenId(userInfoRes.getOpenId());
        menberBoRes.setSysBrandId(sysBrandPo.getSysBrandId());
        menberBoRes.setSysCompanyId(sysBrandPo.getSysCompanyId());
        if (StringUtils.isNotBlank((CharSequence)userInfoRes.getMemberCode())) {
            return this.getMbrInfoByWx(bizvaneSessionId, menberBoRes, userInfoRes);
        }
        this.insertTraceRecord(wxMbrRegisteRequestVo, userInfoRes, menberBoRes);
        return this.MbrOpenCardByWx(request, wxMbrRegisteRequestVo, bizvaneSessionId, menberBoRes, userInfoRes);
    }

    public ResponseData<AppletBrandMenberBo> getMbrNoOpenCardByUnionId(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        logger.info("unionId\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u81ea\u52a8\u767b\u5f55\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)wxMbrRegisteRequestVo));
        this.checkWxMbrRegisterByUnionIdRequestVoParam(wxMbrRegisteRequestVo);
        this.checkVerifCode(wxMbrRegisteRequestVo);
        return this.noAuthGetMbrByUnionId(wxMbrRegisteRequestVo);
    }

    private SysStaffPo transformStaffToRedis(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, SysBrandPo sysBrandPo) {
        SysStaffPo sysStaffPo;
        int code;
        Long sysCompanyId = sysBrandPo.getSysCompanyId();
        SysStaffPo crmSysStaffPo = null;
        String staffCode = wxMbrRegisteRequestVo.getStaffCode();
        String staffPhone = wxMbrRegisteRequestVo.getStaffPhone();
        if (StringUtils.isEmpty((CharSequence)staffCode) && StringUtils.isEmpty((CharSequence)staffPhone)) {
            logger.info("\u4f9d\u6587\u514d\u767b\u5f55staffCode\u548cstaffPhone\u90fd\u4e3a\u7a7a");
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)staffCode) && crmSysStaffPo == null) {
            ResponseData staffInfoByCode = this.staffServiceRpc.getStaffInfoByCode(staffCode, sysCompanyId);
            logger.info("staffServiceRpc.getStaffInfoByCode:{}", (Object)JSON.toJSONString((Object)staffInfoByCode));
            code = staffInfoByCode.getCode();
            sysStaffPo = (SysStaffPo)staffInfoByCode.getData();
            if (code == com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() && sysStaffPo != null) {
                crmSysStaffPo = sysStaffPo;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)staffPhone) && crmSysStaffPo == null) {
            ResponseData staffByPhone = this.staffServiceRpc.getStaffByPhone(sysCompanyId, staffPhone);
            logger.info("staffServiceRpc.getStaffByPhone:{}", (Object)JSON.toJSONString((Object)staffByPhone));
            code = staffByPhone.getCode();
            sysStaffPo = (SysStaffPo)staffByPhone.getData();
            if (code == com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() && staffByPhone != null) {
                crmSysStaffPo = sysStaffPo;
            }
        }
        logger.info("crmSysStaffPo:{}", (Object)JSON.toJSONString(crmSysStaffPo));
        return crmSysStaffPo;
    }

    private ResponseData authGetMbrByUnionId(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId) {
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((CharSequence)memberCode)) {
            return new ResponseData(100, "\u4f1a\u5458\u4e3a\u7a7a!");
        }
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(wxMbrRegisteRequestVo.getAppid());
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sysBrandPo.getBrandLogo()));
        }
        String redisUnionId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getUnionId" + bizvaneSessionId));
        String redisPhone = (String)this.redisTemplateService.stringGetStringByKey((Object)("Phone:" + memberCode));
        if (wxMbrRegisteRequestVo.getUnionId().equals(redisUnionId) && wxMbrRegisteRequestVo.getPhone().equals(redisPhone)) {
            AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
            menberBoRes.setMemberCode(memberCode);
            menberBoRes.setOpenCard(true);
            menberBoRes.setSysBrandId(sysBrandPo.getSysBrandId());
            menberBoRes.setSysCompanyId(sysBrandPo.getSysCompanyId());
            menberBoRes.setAppletByCodeBo(appletByCodeBo);
            menberBoRes.setUnionId(redisUnionId);
            return new ResponseData((Object)menberBoRes);
        }
        MemberInfoModel memberInfoModelSearchByPhone = new MemberInfoModel();
        memberInfoModelSearchByPhone.setBrandId(sysBrandPo.getSysBrandId());
        memberInfoModelSearchByPhone.setPhone(wxMbrRegisteRequestVo.getPhone());
        memberInfoModelSearchByPhone.setWxUnionId(wxMbrRegisteRequestVo.getUnionId());
        ResponseData singleMemberModelPhone = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearchByPhone);
        MemberInfoModel memberModelPhoneData = (MemberInfoModel)singleMemberModelPhone.getData();
        if (memberModelPhoneData == null) {
            return new ResponseData(100, "\u4f20\u53c2\u624b\u673a\u53f7\u548cunionId\u53c2\u6570\u4e0d\u4e00\u81f4");
        }
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        menberBoRes.setMemberCode(memberModelPhoneData.getMemberCode());
        menberBoRes.setOpenCard(true);
        menberBoRes.setSysBrandId(sysBrandPo.getSysBrandId());
        menberBoRes.setSysCompanyId(sysBrandPo.getSysCompanyId());
        menberBoRes.setAppletByCodeBo(appletByCodeBo);
        menberBoRes.setUnionId(memberModelPhoneData.getWxUnionId());
        menberBoRes.setOpenId(memberModelPhoneData.getWxOpenId());
        return new ResponseData((Object)menberBoRes);
    }

    private ResponseData noAuthGetMbrByUnionId(WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        ResponseData stringResponseData = this.userAuthorizationFeign.byCode(wxMbrRegisteRequestVo.getCode(), wxMbrRegisteRequestVo.getAppid());
        if (stringResponseData.getData() == null || stringResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || StringUtils.isBlank((CharSequence)((CharSequence)stringResponseData.getData()))) {
            logger.info("bizvanekey\u672a\u83b7\u53d6");
            return new ResponseData(100, "bizvanekey\u672a\u83b7\u53d6");
        }
        String bizvaneSessionId = (String)stringResponseData.getData();
        logger.info("bizvaneSessionId\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvaneSessionId, (Object)bizvaneSessionId, 7776000000L);
        ResponseData userInfoResData = this.getUserAuthorizationInfoYw(wxMbrRegisteRequestVo, bizvaneSessionId);
        logger.info("\u6388\u6743\u8fd4\u56de\u7684\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)userInfoResData));
        if (userInfoResData == null || userInfoResData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || userInfoResData.getData() == null || ((UserAuthorizationGetUserInfoResponseVO)userInfoResData.getData()).getSysBrandId() == null) {
            return new ResponseData(100, "\u6388\u6743\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
        }
        UserAuthorizationGetUserInfoResponseVO userInfoRes = (UserAuthorizationGetUserInfoResponseVO)userInfoResData.getData();
        if (!userInfoRes.getUnionId().equals(wxMbrRegisteRequestVo.getUnionId())) {
            return new ResponseData(100, "\u4f20\u53c2unionId\u548cCRM\u5c0f\u7a0b\u5e8funionId\u4e0d\u4e00\u81f4");
        }
        this.cacheWxInfoToRedis(wxMbrRegisteRequestVo, bizvaneSessionId, userInfoRes);
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(wxMbrRegisteRequestVo.getAppid());
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sysBrandPo.getBrandLogo()));
        }
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        menberBoRes.setAppletByCodeBo(appletByCodeBo);
        menberBoRes.setUnionId(userInfoRes.getUnionId());
        menberBoRes.setOpenId(userInfoRes.getOpenId());
        menberBoRes.setSysBrandId(sysBrandPo.getSysBrandId());
        menberBoRes.setSysCompanyId(sysBrandPo.getSysCompanyId());
        SysStaffPo sysStaffPo = this.transformStaffToRedis(wxMbrRegisteRequestVo, sysBrandPo);
        if (sysStaffPo != null) {
            this.ywHelper.setYwShareGuideCode(sysStaffPo.getStaffCode(), null, bizvaneSessionId);
        }
        MemberInfoModel memberInfoModelSearchByPhone = new MemberInfoModel();
        memberInfoModelSearchByPhone.setBrandId(menberBoRes.getSysBrandId());
        memberInfoModelSearchByPhone.setPhone(wxMbrRegisteRequestVo.getPhone());
        ResponseData singleMemberModelPhone = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearchByPhone);
        MemberInfoModel memberModelPhoneData = (MemberInfoModel)singleMemberModelPhone.getData();
        if (memberModelPhoneData == null) {
            return new ResponseData(100, "\u901a\u8fc7\u624b\u673a\u53f7,\u5728DB\u4e2d\u67e5\u4e0d\u5230\u4f1a\u5458");
        }
        MemberInfoModel memberInfoModelSearchByUnionId = new MemberInfoModel();
        memberInfoModelSearchByUnionId.setBrandId(menberBoRes.getSysBrandId());
        memberInfoModelSearchByUnionId.setWxUnionId(wxMbrRegisteRequestVo.getUnionId());
        ResponseData singleMemberModelUnionId = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearchByPhone);
        MemberInfoModel memberModelUnionIdData = (MemberInfoModel)singleMemberModelUnionId.getData();
        if (memberModelUnionIdData == null) {
            return new ResponseData(100, "\u901a\u8fc7unionId,\u5728DB\u4e2d\u67e5\u4e0d\u5230\u4f1a\u5458");
        }
        if (!wxMbrRegisteRequestVo.getPhone().equals(memberModelUnionIdData.getPhone())) {
            return new ResponseData(100, "unionId\u5728DB\u4e2d\u5df2\u7ed1\u5b9a\u5176\u4ed6\u624b\u673a\u53f7\uff08\u975e\u4f20\u53c2\u7684\u624b\u673a\u53f7\uff09");
        }
        if (!wxMbrRegisteRequestVo.getUnionId().equals(memberModelPhoneData.getWxUnionId())) {
            return new ResponseData(100, "\u4f20\u53c2\u7684unionId\u4e0e\u901a\u8fc7\u624b\u673a\u53f7\u5728DB\u4e2d\u62ff\u5230\u7684unionId\u4e0d\u7b49");
        }
        this.fillMemberCodeByUnionId(userInfoRes);
        return this.getMbrInfoByWx(bizvaneSessionId, menberBoRes, userInfoRes);
    }

    private void fillMemberCodeByUnionId(UserAuthorizationGetUserInfoResponseVO userInfoRes) {
        if (StringUtils.isEmpty((CharSequence)userInfoRes.getMemberCode()) && StringUtils.isNotEmpty((CharSequence)userInfoRes.getUnionId())) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setSysCompanyId(userInfoRes.getSysCompanyId());
            memberInfoModel.setBrandId(userInfoRes.getSysBrandId());
            memberInfoModel.setWxUnionId(userInfoRes.getUnionId());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (singleMemberModel.getCode() == com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                String memberCode = ((MemberInfoModel)singleMemberModel.getData()).getMemberCode();
                userInfoRes.setMemberCode(memberCode);
            }
        }
    }

    private void checkVerifCode(WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        if (Boolean.TRUE.equals(wxMbrRegisteRequestVo.getCustomPhoneAuth())) {
            SysAccountVo param = new SysAccountVo();
            param.setVerifCode(wxMbrRegisteRequestVo.getVerifCode());
            param.setAreaCode(wxMbrRegisteRequestVo.getAreaCode());
            param.setAccountCode(wxMbrRegisteRequestVo.getPhone());
            ResponseData checkResult = this.systemServiceRpc.checkVerifCode(param);
            if (com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() != checkResult.getCode()) {
                throw new BizException(checkResult.getCode(), checkResult.getMessage());
            }
        }
    }

    private void cacheWxInfoToRedis(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId, UserAuthorizationGetUserInfoResponseVO userInfoRes) {
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getOpenId" + bizvaneSessionId), (Object)userInfoRes.getOpenId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + bizvaneSessionId), (Object)userInfoRes.getUnionId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getAppId" + bizvaneSessionId), (Object)wxMbrRegisteRequestVo.getAppid(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(userInfoRes.getSysBrandId()), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(userInfoRes.getSysBrandId()), 7776000000L);
        logger.info("UnionId={}", this.redisTemplateService.stringGetStringByKey((Object)("getUnionId" + bizvaneSessionId)));
    }

    private void checkWxMbrRegisterRequestVoParam(WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        Assert.isTrue((wxMbrRegisteRequestVo != null ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getAppid()), (String)"\u8bf7\u6c42\u53c2\u6570appid\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getCode()), (String)"\u8bf7\u6c42\u53c2\u6570code\u4e3a\u7a7a");
    }

    private void checkWxMbrRegisterByUnionIdRequestVoParam(WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        Assert.isTrue((wxMbrRegisteRequestVo != null ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getAppid()), (String)"\u8bf7\u6c42\u53c2\u6570appid\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getUnionId()), (String)"\u8bf7\u6c42\u53c2\u6570unionId\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getPhone()), (String)"\u8bf7\u6c42\u53c2\u6570phone\u4e3a\u7a7a");
    }

    public ResponseData<AppletBrandMenberBo> resolveAndRecord(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        logger.info("\u89e3\u6790\u6388\u6743\u4fe1\u606f\u4ee5\u53ca\u8bb0\u5f55\u94fe\u8def:{}", (Object)JSONObject.toJSONString((Object)wxMbrRegisteRequestVo));
        this.checkWxMbrRegisterRequestVoParam(wxMbrRegisteRequestVo);
        ResponseData userInfoResData = this.userAuthorizationFeign.getUserInfoByCode(wxMbrRegisteRequestVo.getCode(), wxMbrRegisteRequestVo.getAppid());
        logger.info("\u6388\u6743\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8fd4\u56de\u7684\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)userInfoResData));
        if (userInfoResData == null || userInfoResData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || userInfoResData.getData() == null || ((UserAuthorizationGetUserInfoResponseVO)userInfoResData.getData()).getSysBrandId() == null) {
            return new ResponseData(100, "\u6388\u6743\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
        }
        UserAuthorizationGetUserInfoResponseVO userInfoRes = (UserAuthorizationGetUserInfoResponseVO)userInfoResData.getData();
        String bizvaneSessionId = userInfoRes.getBizvaneSessionId();
        logger.info("bizvaneSessionId\u5b58\u50a8\u5230Redis,bizvaneSessionId={}", (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvaneSessionId, (Object)bizvaneSessionId, 7776000000L);
        this.cacheWxInfoToRedis(wxMbrRegisteRequestVo, bizvaneSessionId, userInfoRes);
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(wxMbrRegisteRequestVo.getAppid());
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sysBrandPo.getBrandLogo()));
        }
        menberBoRes.setAppletByCodeBo(appletByCodeBo);
        menberBoRes.setUnionId(userInfoRes.getUnionId());
        menberBoRes.setOpenId(userInfoRes.getOpenId());
        menberBoRes.setSysBrandId(sysBrandPo.getSysBrandId());
        menberBoRes.setSysCompanyId(sysBrandPo.getSysCompanyId());
        if (StringUtils.isNotBlank((CharSequence)userInfoRes.getMemberCode())) {
            return this.getMbrInfoByWx(bizvaneSessionId, menberBoRes, userInfoRes);
        }
        return this.mbrElectCardOpenFlag(request, userInfoRes, menberBoRes, wxMbrRegisteRequestVo);
    }

    private ResponseData<AppletBrandMenberBo> mbrElectCardOpenFlag(HttpServletRequest request, UserAuthorizationGetUserInfoResponseVO userInfoRes, AppletBrandMenberBo menberBoRes, WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo = null;
        if (wxMbrRegisteRequestVo.isOpenWxElectCard()) {
            Assert.isTrue((StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getPhone()) && !"null".equalsIgnoreCase(wxMbrRegisteRequestVo.getPhone()) || StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getPhoneCode()) ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u672a\u6388\u6743");
        } else {
            MbrElectCardOpenErrorVo mbrElectCardOpenErrorVoSearch = new MbrElectCardOpenErrorVo();
            mbrElectCardOpenErrorVoSearch.setSysCompanyId(menberBoRes.getSysCompanyId());
            mbrElectCardOpenErrorVoSearch.setSysBrandId(menberBoRes.getSysBrandId());
            mbrElectCardOpenErrorVoSearch.setUnionId(menberBoRes.getUnionId());
            mbrElectCardOpenErrorVoSearch.setOpenId(menberBoRes.getOpenId());
            ResponseData cardOpenErrorVoResponseData = this.mbrElectCardOpenErrorRpcService.getByVo(mbrElectCardOpenErrorVoSearch);
            logger.info("mbrElectCardOpenErrorRpcService#getByVo(),res:{}", (Object)JSONObject.toJSONString((Object)cardOpenErrorVoResponseData));
            if (cardOpenErrorVoResponseData == null || com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() != cardOpenErrorVoResponseData.getCode()) {
                return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), String.format("%s%s", "\u4f1a\u5458\u7535\u5b50\u5361", com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getMessage()));
            }
            mbrElectCardOpenErrorVo = (MbrElectCardOpenErrorVo)cardOpenErrorVoResponseData.getData();
        }
        if (mbrElectCardOpenErrorVo != null && mbrElectCardOpenErrorVo.getElectCardOpenErrorId() != null) {
            logger.info("\u7535\u5b50\u4f1a\u5458\u5361\u5df2\u5f00\u5361,\u65e0\u9700\u518d\u6b21\u5f00\u901a\u7535\u5b50\u4f1a\u5458\u5361");
            wxMbrRegisteRequestVo.setBizvaneSessionId(menberBoRes.getAppletByCodeBo().getBizvanekey());
            wxMbrRegisteRequestVo.setSysCompanyId(menberBoRes.getSysCompanyId());
            wxMbrRegisteRequestVo.setSysBrandId(menberBoRes.getSysBrandId());
            wxMbrRegisteRequestVo.setUnionId(menberBoRes.getUnionId());
            wxMbrRegisteRequestVo.setOpenId(menberBoRes.getOpenId());
            wxMbrRegisteRequestVo.setCardId(mbrElectCardOpenErrorVo.getCardId());
            wxMbrRegisteRequestVo.setActivateTicket(mbrElectCardOpenErrorVo.getActivateTicket());
            wxMbrRegisteRequestVo.setElectCode(mbrElectCardOpenErrorVo.getElectCode());
            wxMbrRegisteRequestVo.setWxElectCardInfo(mbrElectCardOpenErrorVo.getElectCardInfo());
            return this.businessAfterOpenCard(request, wxMbrRegisteRequestVo);
        }
        if (wxMbrRegisteRequestVo.isOpenWxElectCard()) {
            logger.info("\u7535\u5b50\u4f1a\u5458\u5361\u7ed1\u5361");
            UserAuthorizationGetPhoneNumberResponseVO phoneNumberRes = this.getPhone(wxMbrRegisteRequestVo, menberBoRes.getAppletByCodeBo().getBizvanekey(), userInfoRes.getAppid());
            wxMbrRegisteRequestVo.setBizvaneSessionId(menberBoRes.getAppletByCodeBo().getBizvanekey());
            wxMbrRegisteRequestVo.setSysCompanyId(menberBoRes.getSysCompanyId());
            wxMbrRegisteRequestVo.setSysBrandId(menberBoRes.getSysBrandId());
            wxMbrRegisteRequestVo.setUnionId(menberBoRes.getUnionId());
            wxMbrRegisteRequestVo.setOpenId(menberBoRes.getOpenId());
            wxMbrRegisteRequestVo.setPhone(phoneNumberRes.getPurePhoneNumber());
            return this.businessAfterOpenCard(request, wxMbrRegisteRequestVo);
        }
        logger.info("\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u524d,\u8bb0\u5f55\u94fe\u8def");
        this.insertTraceRecord(wxMbrRegisteRequestVo, userInfoRes, menberBoRes);
        menberBoRes.setOpenCard(false);
        menberBoRes.setOpenWxElectCard(false);
        return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode(), com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getMessage(), (Object)menberBoRes);
    }

    public ResponseData<AppletBrandMenberBo> businessAfterOpenCard(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        ResponseData memberInfoModelRes;
        logger.info("\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u5b8c\u6210,\u5269\u4f59\u4e1a\u52a1\u5904\u7406:{}", (Object)JSONObject.toJSONString((Object)wxMbrRegisteRequestVo));
        Assert.isTrue((wxMbrRegisteRequestVo != null ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getAppid()), (String)"\u8bf7\u6c42\u53c2\u6570appid\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getUnionId()), (String)"\u8bf7\u6c42\u53c2\u6570unionId\u4e3a\u7a7a");
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        Assert.isTrue((StringUtils.isNotBlank((CharSequence)bizvaneSessionId) || StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getBizvaneSessionId()) ? 1 : 0) != 0, (String)"bizvaneSessionId\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getBizvaneSessionId())) {
            bizvaneSessionId = wxMbrRegisteRequestVo.getBizvaneSessionId();
        }
        String key = "loginBusinessAfterOpenCard:" + wxMbrRegisteRequestVo.getAppid() + ":" + wxMbrRegisteRequestVo.getUnionId();
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + bizvaneSessionId), (Object)wxMbrRegisteRequestVo.getUnionId(), 7776000000L);
        ResponseData wxPublicPOResponseData = this.wxPublicServiceFeign.getWxPublicPOByAppId(wxMbrRegisteRequestVo.getAppid());
        logger.info("wxPublicServiceFeign#getWxPublicPOByAppId#res:{}", (Object)JSONObject.toJSONString((Object)wxPublicPOResponseData));
        if (wxPublicPOResponseData == null || com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() != wxPublicPOResponseData.getCode() || wxPublicPOResponseData.getData() == null) {
            return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), String.format("%s%s", "appId", com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage()));
        }
        WxPublicPO wxPublicPO = (WxPublicPO)wxPublicPOResponseData.getData();
        if (Integer.valueOf(1).equals(wxMbrRegisteRequestVo.getElectCardFromWx())) {
            wxMbrRegisteRequestVo.setSysCompanyId(wxPublicPO.getSysCompanyId());
            wxMbrRegisteRequestVo.setSysBrandId(wxPublicPO.getSysBrandId());
            ResponseData mbrElectCardOpenErrorResponseData = this.saveMbrElectCardErroInfo(wxMbrRegisteRequestVo);
            logger.info("mbrElectCardOpenErrorRpcService#saveByVo,res:{}", (Object)JSONObject.toJSONString((Object)mbrElectCardOpenErrorResponseData));
            if (mbrElectCardOpenErrorResponseData == null || com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() != mbrElectCardOpenErrorResponseData.getCode() || mbrElectCardOpenErrorResponseData.getData() == null) {
                return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_ADD_ERROR.getCode(), String.format("%s%s", "\u7535\u5b50\u4f1a\u5458\u5361\u4fe1\u606f", com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_ADD_ERROR.getMessage()));
            }
            wxMbrRegisteRequestVo.setElectCardOpenErrorId((Long)mbrElectCardOpenErrorResponseData.getData());
        }
        if ((memberInfoModelRes = this.openElectCard(wxMbrRegisteRequestVo, wxPublicPO)) != null && SysResponseEnum.USER_APPLET_BINDING_CARD_FAIL_WINDOW.getCode() == memberInfoModelRes.getCode()) {
            return new ResponseData(SysResponseEnum.USER_APPLET_BINDING_CARD_FAIL_WINDOW.getCode(), memberInfoModelRes.getMessage());
        }
        if (memberInfoModelRes == null || memberInfoModelRes.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode(), memberInfoModelRes != null ? memberInfoModelRes.getMessage() : "\u5f00\u5361\u5931\u8d25,\u8bf7\u5220\u9664\u5c0f\u7a0b\u5e8f\u540e\u91cd\u65b0\u8fdb\u5165,\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        MemberInfoModel memberInfoModel = (MemberInfoModel)memberInfoModelRes.getData();
        String uuid = request.getHeader("UUID");
        logger.info("UUID\u5f00\u5361={}", (Object)uuid);
        String uuidJONString = null;
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            uuidJONString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            logger.info("uuidJONString={}", (Object)uuidJONString);
        }
        if (StringUtils.isNotBlank(uuidJONString)) {
            JSONObject JSONobjectUUID = JSONObject.parseObject(uuidJONString);
            String mktActivityId = JSONobjectUUID.getString("mktActivityId");
            ProbabilityVO vo = new ProbabilityVO();
            vo.setMktActivityId(Long.valueOf(mktActivityId));
            ResponseData mktActivityPOWithBLOBs = this.activityEGServiceRpc.getMktActivityPOWithBLOBs(vo);
            Integer activityType = ((MktActivityDetailAndPicture)mktActivityPOWithBLOBs.getData()).getActivityType();
            logger.info("activityType={}, mktActivityId={}", (Object)activityType, (Object)mktActivityId);
            MemberInfoModel memberInfoModelUpdate = MemberInfoModel.builder().sysCompanyId(memberInfoModel.getSysCompanyId()).brandId(memberInfoModel.getBrandId()).memberCode(memberInfoModel.getMemberCode()).activityId(Long.valueOf(mktActivityId)).activityType(activityType).build();
            ResponseData responseData = this.memberInfoApiService.updateMbrInfoByActivityRegister(memberInfoModelUpdate);
            logger.info("memberInfoApiService#updateMemberInfo#res:{}", (Object)JSONObject.toJSONString((Object)responseData));
            if (responseData == null || com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() != responseData.getCode()) {
                return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getCode(), String.format("%s%s", "\u4f1a\u5458", com.bizvane.utils.enumutils.SysResponseEnum.OPERATE_FAILED_UPDATE_ERROR.getMessage()));
            }
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + memberInfoModel.getMemberCode()), (Object)memberInfoModel.getPhone(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberInfoModel.getMemberCode(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberInfoModel.getMemberCode() + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
        this.activityService.executeActivity(memberInfoModel.getBrandId(), memberInfoModel.getMemberCode(), memberInfoModel.getCardStatus());
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getOderMemberCode())) {
            this.activityService.inviteOpenCoder(memberInfoModel.getMemberCode(), wxMbrRegisteRequestVo.getOderMemberCode(), wxMbrRegisteRequestVo.getMktTaskId());
        }
        WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
        wxChannelInfoVo.setMemberCode(memberInfoModel.getMemberCode());
        wxChannelInfoVo.setMiniProgram(Integer.valueOf(1));
        ResponseData wxChannelInfoAndMemberInfo = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(wxChannelInfoVo);
        String wxOpenId = ((WxChannelAndMemberVo)wxChannelInfoAndMemberInfo.getData()).getWxChannelInfoVo().getWxOpenId();
        String wxAppId = ((WxChannelAndMemberVo)wxChannelInfoAndMemberInfo.getData()).getWxChannelInfoVo().getAppId();
        if (StringUtils.isNotBlank((CharSequence)wxOpenId) && StringUtils.isNotBlank((CharSequence)wxAppId) && StringUtils.isNotBlank((CharSequence)memberInfoModel.getMemberCode())) {
            this.activityService.changeFansToMember(wxOpenId, wxAppId, memberInfoModel.getMemberCode(), memberInfoModel.getSysCompanyId(), memberInfoModel.getBrandId());
        }
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getActivityNo()) && StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getActivityOrdersNo())) {
            String userNo = memberInfoModel.getMemberCode();
            String url = this.DOMAINNAME + MEMEBER_ACTIVITY + "?activityNo" + wxMbrRegisteRequestVo.getActivityNo() + "&activityOrdersNo=" + wxMbrRegisteRequestVo.getActivityOrdersNo() + "&userNo" + userNo;
            logger.info("\u5f00\u5361\u8c03\u7528\u5fae\u5546\u57ceURL={}", (Object)url);
            String result = null;
            try {
                result = HttpUtil.get((String)url);
            }
            catch (IOException e) {
                logger.info("\u5f00\u5361\u8c03\u7528\u5fae\u5546\u57ce\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            logger.info("\u5fae\u5546\u57ce\u8fd4\u56de\u6570\u636e={}", (Object)result);
        }
        SysBrandVo sysBrandVo = new SysBrandVo();
        sysBrandVo.setSysBrandId(memberInfoModel.getBrandId());
        ResponseData skipByBrandId = this.brandServiceRpc.getSkipByBrandId(sysBrandVo);
        AppletBrandMenberBo menberBoRes = this.getAppletBrandMenberBoRes(wxMbrRegisteRequestVo, bizvaneSessionId, memberInfoModel);
        menberBoRes.setSkipByBrandId((String)skipByBrandId.getData());
        logger.info("\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u5b8c\u6210,\u5269\u4f59\u4e1a\u52a1\u5904\u7406\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)menberBoRes));
        if (wxMbrRegisteRequestVo.getElectCardOpenErrorId() != null) {
            MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo = new MbrElectCardOpenErrorVo();
            mbrElectCardOpenErrorVo.setElectCardOpenErrorId(wxMbrRegisteRequestVo.getElectCardOpenErrorId());
            this.mbrElectCardOpenErrorRpcService.deleteByVo(mbrElectCardOpenErrorVo);
        }
        menberBoRes.setOpenWxElectCard(true);
        return new ResponseData((Object)menberBoRes);
    }

    public ResponseData standardMemberCardStatusModify(HttpServletRequest request) {
        String memberCode = this.getMemberCode(request);
        String sysCompanyId = request.getHeader("sysCompanyId");
        String sysBrandId = request.getHeader("sysBrandId");
        MemberCardStatusLogOutVo memberCardStatusLogOutVo = new MemberCardStatusLogOutVo();
        memberCardStatusLogOutVo.setMemberCode(memberCode);
        memberCardStatusLogOutVo.setSysCompanyId(Long.valueOf(sysCompanyId));
        memberCardStatusLogOutVo.setSysBrandId(Long.valueOf(sysBrandId));
        memberCardStatusLogOutVo.setActionFromType(MemberCardStatusModifySourceEnum.FROM_APPLET.getCode());
        logger.info("\u4f1a\u5458\u6ce8\u9500\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)memberCardStatusLogOutVo));
        return this.memberInfoApiService.standardMemberCardStatusModify(memberCardStatusLogOutVo);
    }

    public ResponseData paramProcessingAfterOpenCard(HttpServletRequest request, ParamProcessingVo paramProcessingVo) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (StringUtils.isBlank((CharSequence)bizvaneSessionId)) {
            logger.info("bizvaneSessionId is Blank");
            responseData.setMessage("bizvaneSessionId \u65e0\u6548");
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)("sysBrandId" + bizvaneSessionId));
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            logger.info("bizvaneSessionId \u672a\u67e5\u8be2\u5230sysBrandId");
            responseData.setMessage("bizvaneSessionId \u65e0\u6548");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            logger.info("bizvaneSessionId \u672a\u67e5\u8be2\u5230memberCode");
            responseData.setMessage("bizvaneSessionId \u65e0\u6548");
            return responseData;
        }
        logger.info("paramProcessingAfterOpenCard memberCode:{},bizvaneSessionId:{}", (Object)memberCode, (Object)bizvaneSessionId);
        if (StringUtils.isBlank((CharSequence)paramProcessingVo.getYwStaffCode())) {
            logger.info("ywStaffCode is Blank");
            responseData.setMessage("ywStaffCode \u65e0\u6548");
            return responseData;
        }
        ResponseData sysBrandPoResponseData = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
        if (sysBrandPoResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || sysBrandPoResponseData.getData() == null) {
            logger.info("brandServiceRpc#getBrandByID\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25,{}", (Object)JSONObject.toJSONString((Object)sysBrandPoResponseData));
            responseData.setMessage("bizvaneSessionId \u67e5\u8be2sysBrandId \u5931\u8d25");
            return responseData;
        }
        WxMbrRegisteRequestVo wxMbrRegisteRequestVo = new WxMbrRegisteRequestVo();
        wxMbrRegisteRequestVo.setStaffCode(paramProcessingVo.getYwStaffCode());
        SysStaffPo sysStaffPo = this.transformStaffToRedis(wxMbrRegisteRequestVo, (SysBrandPo)sysBrandPoResponseData.getData());
        if (sysStaffPo != null) {
            this.ywHelper.setYwShareGuideCode(sysStaffPo.getStaffCode(), memberCode, bizvaneSessionId);
        }
        responseData.setMessage("\u4f9d\u6587\u81ea\u52a8\u767b\u5f55\u53c2\u6570\u4fdd\u5b58\u64cd\u4f5c\u7ed3\u675f");
        return responseData;
    }

    private ResponseData<Long> saveMbrElectCardErroInfo(WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo = new MbrElectCardOpenErrorVo();
        mbrElectCardOpenErrorVo.setSysCompanyId(wxMbrRegisteRequestVo.getSysCompanyId());
        mbrElectCardOpenErrorVo.setSysBrandId(wxMbrRegisteRequestVo.getSysBrandId());
        mbrElectCardOpenErrorVo.setAppid(wxMbrRegisteRequestVo.getAppid());
        mbrElectCardOpenErrorVo.setUnionId(wxMbrRegisteRequestVo.getUnionId());
        mbrElectCardOpenErrorVo.setOpenId(wxMbrRegisteRequestVo.getOpenId());
        mbrElectCardOpenErrorVo.setCardId(wxMbrRegisteRequestVo.getCardId());
        mbrElectCardOpenErrorVo.setActivateTicket(wxMbrRegisteRequestVo.getActivateTicket());
        mbrElectCardOpenErrorVo.setElectCode(wxMbrRegisteRequestVo.getElectCode());
        mbrElectCardOpenErrorVo.setValid(Boolean.TRUE);
        return this.mbrElectCardOpenErrorRpcService.saveByVo(mbrElectCardOpenErrorVo);
    }

    private AppletBrandMenberBo getAppletBrandMenberBoRes(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId, MemberInfoModel memberInfoModel) {
        AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
        appletByCodeBo.setBizvanekey(bizvaneSessionId);
        appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
        SysBrandPo sysBrandPo = this.getBrandInfo(wxMbrRegisteRequestVo.getAppid());
        if (StringUtils.isNotBlank((CharSequence)sysBrandPo.getBrandLogo())) {
            appletByCodeBo.setBrandLogo(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sysBrandPo.getBrandLogo()));
        }
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        menberBoRes.setAppletByCodeBo(appletByCodeBo);
        menberBoRes.setUnionId(memberInfoModel.getWxUnionId());
        menberBoRes.setOpenId(memberInfoModel.getWxOpenId());
        menberBoRes.setSysBrandId(sysBrandPo.getSysBrandId());
        menberBoRes.setSysCompanyId(sysBrandPo.getSysCompanyId());
        menberBoRes.setPhone(memberInfoModel.getPhone());
        menberBoRes.setMemberCode(memberInfoModel.getMemberCode());
        menberBoRes.setOpenCard(true);
        menberBoRes.setCardUseStatus(memberInfoModel.getCardUseStatus());
        return menberBoRes;
    }

    private ResponseData<UserAuthorizationGetUserInfoResponseVO> getUserAuthorizationInfo(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId) {
        UserAuthorizationGetUserInfoRequestVO userAuthorizationGetUserInfoRequestVo = new UserAuthorizationGetUserInfoRequestVO();
        userAuthorizationGetUserInfoRequestVo.setAppid(wxMbrRegisteRequestVo.getAppid());
        userAuthorizationGetUserInfoRequestVo.setBizvaneSessionId(bizvaneSessionId);
        userAuthorizationGetUserInfoRequestVo.setUserInfoData(wxMbrRegisteRequestVo.getUserInfoData());
        return this.userAuthorizationFeign.getUserInfo(userAuthorizationGetUserInfoRequestVo);
    }

    private ResponseData<UserAuthorizationGetUserInfoResponseVO> getUserAuthorizationInfoYw(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId) {
        UserAuthorizationGetUserInfoRequestVO userAuthorizationGetUserInfoRequestVo = new UserAuthorizationGetUserInfoRequestVO();
        userAuthorizationGetUserInfoRequestVo.setAppid(wxMbrRegisteRequestVo.getAppid());
        userAuthorizationGetUserInfoRequestVo.setBizvaneSessionId(bizvaneSessionId);
        return this.userAuthorizationFeign.getUserInfoYw(userAuthorizationGetUserInfoRequestVo);
    }

    private void handleOderTraceRecord(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, UserAuthorizationGetUserInfoResponseVO userInfoRes, AppletBrandMenberBo appletBrandMenberBo) {
        logger.info("handleOderTraceRecord begin");
        MemberInfoModel memberInfoModelSearch = MemberInfoModel.builder().brandId(appletBrandMenberBo.getSysBrandId()).memberCode(wxMbrRegisteRequestVo.getOderMemberCode()).build();
        ResponseData singleMemberModelRes = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearch);
        if (singleMemberModelRes == null || singleMemberModelRes.getData() == null) {
            logger.info("\u5206\u4eab\u4f1a\u5458\u4e0d\u5b58\u5728:{}", (Object)JacksonUtil.bean2Json((Object)singleMemberModelRes));
            return;
        }
        MemberInfoModel oderMemberInfo = (MemberInfoModel)singleMemberModelRes.getData();
        TracePO tracePO = new TracePO();
        tracePO.setSysCompanyId(appletBrandMenberBo.getSysCompanyId());
        tracePO.setBrandId(appletBrandMenberBo.getSysBrandId());
        JSONObject json = new JSONObject();
        json.put("source_way", (Object)"wxShare");
        json.put("storeId", (Object)oderMemberInfo.getServiceStoreId());
        json.put("guideId", (Object)oderMemberInfo.getServiceGuideId());
        json.put("memberCode", (Object)wxMbrRegisteRequestVo.getOderMemberCode());
        tracePO.setTraceValue(json.toJSONString());
        logger.info("\u624b\u52a8\u63d2\u5165trace\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)tracePO));
        ResponseData responseData = this.coreTraceFeign.insertTrace(tracePO);
        logger.info("\u624b\u52a8\u63d2\u5165trace\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)responseData));
        if (null != responseData && com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() == responseData.getCode() && null != responseData.getData()) {
            try {
                wxMbrRegisteRequestVo.setTraceId(((Long)responseData.getData()).toString());
            }
            catch (Exception e) {
                logger.info("\u624b\u52a8\u63d2\u5165trace\u8bb0\u5f55\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private void insertTraceRecord(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, UserAuthorizationGetUserInfoResponseVO userInfoRes, AppletBrandMenberBo menberBoRes) {
        TraceRecordVo traceRecordVo = new TraceRecordVo();
        traceRecordVo.setOpenId(userInfoRes.getOpenId());
        traceRecordVo.setSysCompanyId(menberBoRes.getSysCompanyId());
        traceRecordVo.setBrandId(menberBoRes.getSysBrandId());
        traceRecordVo.setUnionId(userInfoRes.getUnionId());
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceRecordVo.setTraceId(Long.valueOf(wxMbrRegisteRequestVo.getTraceId()));
            this.coreTraceFeign.saveTraceRecord(traceRecordVo);
        }
        logger.info("\u4f1a\u5458\u5f00\u5361,traceRecord,\u5185\u5bb9:{},appid={}", (Object)JSONObject.toJSONString((Object)traceRecordVo), (Object)wxMbrRegisteRequestVo.getAppid());
    }

    private ResponseData<AppletBrandMenberBo> MbrOpenCardByWx(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId, AppletBrandMenberBo menberBoRes, UserAuthorizationGetUserInfoResponseVO userInfoRes) {
        String mktTaskId = wxMbrRegisteRequestVo.getMktTaskId();
        Assert.isTrue((StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getPhone()) || StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getPhoneCode()) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u6536\u5230\u624b\u673a\u53f7");
        UserAuthorizationGetPhoneNumberResponseVO phoneNumberRes = this.getPhone(wxMbrRegisteRequestVo, bizvaneSessionId, userInfoRes.getAppid());
        RequestOpenCardModel requestOpenCardModel = new RequestOpenCardModel();
        requestOpenCardModel.setPhone(wxMbrRegisteRequestVo.getPhone());
        requestOpenCardModel.setOpenId(userInfoRes.getOpenId());
        requestOpenCardModel.setUnionId(userInfoRes.getUnionId());
        requestOpenCardModel.setAppId(userInfoRes.getAppid());
        requestOpenCardModel.setPhone(phoneNumberRes.getPurePhoneNumber());
        requestOpenCardModel.setRecommendMemberCode(wxMbrRegisteRequestVo.getOderMemberCode());
        requestOpenCardModel.setShareMemberCode(wxMbrRegisteRequestVo.getShareMemberCode());
        String uuid = request.getHeader("UUID");
        logger.info("UUID\u5f00\u5361={}", (Object)uuid);
        String uuidJONString = null;
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            uuidJONString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            logger.info("uuidJONString={}", (Object)uuidJONString);
        }
        if (StringUtils.isNotBlank(uuidJONString)) {
            JSONObject JSONobjectUUID = JSONObject.parseObject(uuidJONString);
            String mktActivityId = JSONobjectUUID.getString("mktActivityId");
            ProbabilityVO vo = new ProbabilityVO();
            vo.setMktActivityId(Long.valueOf(mktActivityId));
            ResponseData mktActivityPOWithBLOBs = this.activityEGServiceRpc.getMktActivityPOWithBLOBs(vo);
            Integer activityType = ((MktActivityDetailAndPicture)mktActivityPOWithBLOBs.getData()).getActivityType();
            logger.info("activityType={}, mktActivityId={}", (Object)activityType, (Object)mktActivityId);
            requestOpenCardModel.setActivityId(Long.valueOf(mktActivityId));
            requestOpenCardModel.setActivityType(activityType);
        }
        ResponseData responseOpenCardModelResponseData = null;
        try {
            responseOpenCardModelResponseData = this.miniProgramOpenCardService.openCardV(requestOpenCardModel);
        }
        catch (FeignException e1) {
            logger.info("openCardMenbr:{}", (Object)e1.getMessage());
            ResponseData responseData = new ResponseData();
            String errorMsg = e1.getMessage();
            int indexOf = errorMsg.indexOf("content:");
            if (indexOf >= 0) {
                String errorResponseData = errorMsg.substring(indexOf + 9);
                responseData = (ResponseData)JacksonUtil.json2Obj((String)errorResponseData, ResponseData.class);
            } else {
                responseData.setCode(-1);
                responseData.setMessage(errorMsg);
            }
            return responseData;
        }
        logger.info("\u5f00\u5361\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)responseOpenCardModelResponseData));
        if (responseOpenCardModelResponseData != null && SysResponseEnum.USER_APPLET_BINDING_CARD_FAIL_WINDOW.getCode() == responseOpenCardModelResponseData.getCode()) {
            return new ResponseData(SysResponseEnum.USER_APPLET_BINDING_CARD_FAIL_WINDOW.getCode(), responseOpenCardModelResponseData.getMessage());
        }
        if (responseOpenCardModelResponseData == null || responseOpenCardModelResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode(), responseOpenCardModelResponseData != null ? responseOpenCardModelResponseData.getMessage() : "\u5f00\u5361\u5931\u8d25,\u8bf7\u5220\u9664\u5c0f\u7a0b\u5e8f\u540e\u91cd\u65b0\u8fdb\u5165,\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ResponseOpenCardModel responseOpenCardModel = (ResponseOpenCardModel)responseOpenCardModelResponseData.getData();
        if (Integer.valueOf(9000).equals(responseOpenCardModel.getCode())) {
            return new ResponseData(100, responseOpenCardModel.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)responseOpenCardModel.getMemberCode())) {
            return new ResponseData(100, "\u5f00\u5361\u5931\u8d25,\u672a\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f");
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + responseOpenCardModel.getMemberCode()), (Object)phoneNumberRes.getPurePhoneNumber(), 7776000000L);
        Integer operateType = responseOpenCardModel.getOperateType();
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)responseOpenCardModel.getMemberCode(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(responseOpenCardModel.getMemberCode() + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
        Long sysBrandId = userInfoRes.getSysBrandId();
        Long sysCompanyId = userInfoRes.getSysCompanyId();
        this.activityService.executeActivity(sysBrandId, responseOpenCardModel.getMemberCode(), operateType);
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getOderMemberCode())) {
            this.activityService.inviteOpenCoder(responseOpenCardModel.getMemberCode(), wxMbrRegisteRequestVo.getOderMemberCode(), mktTaskId);
        }
        WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
        wxChannelInfoVo.setMemberCode(responseOpenCardModel.getMemberCode());
        wxChannelInfoVo.setMiniProgram(Integer.valueOf(1));
        ResponseData wxChannelInfoAndMemberInfo = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(wxChannelInfoVo);
        String wxOpenId = ((WxChannelAndMemberVo)wxChannelInfoAndMemberInfo.getData()).getWxChannelInfoVo().getWxOpenId();
        String wxAppId = ((WxChannelAndMemberVo)wxChannelInfoAndMemberInfo.getData()).getWxChannelInfoVo().getAppId();
        if (StringUtils.isNotBlank((CharSequence)wxOpenId) && StringUtils.isNotBlank((CharSequence)wxAppId) && StringUtils.isNotBlank((CharSequence)responseOpenCardModel.getMemberCode())) {
            this.activityService.changeFansToMember(wxOpenId, wxAppId, responseOpenCardModel.getMemberCode(), sysCompanyId, sysBrandId);
        }
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getActivityNo()) && StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getActivityOrdersNo())) {
            String userNo = responseOpenCardModel.getMemberCode();
            String url = this.DOMAINNAME + MEMEBER_ACTIVITY + "?activityNo" + wxMbrRegisteRequestVo.getActivityNo() + "&activityOrdersNo=" + wxMbrRegisteRequestVo.getActivityOrdersNo() + "&userNo" + userNo;
            logger.info("\u5f00\u5361\u8c03\u7528\u5fae\u5546\u57ceURL={}", (Object)url);
            String result = null;
            try {
                result = HttpUtil.get((String)url);
            }
            catch (IOException e) {
                logger.info("\u5f00\u5361\u8c03\u7528\u5fae\u5546\u57ce\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            logger.info("\u5fae\u5546\u57ce\u8fd4\u56de\u6570\u636e={}", (Object)result);
        }
        SysBrandVo sysBrandVo = new SysBrandVo();
        sysBrandVo.setSysBrandId(sysBrandId);
        ResponseData skipByBrandId = this.brandServiceRpc.getSkipByBrandId(sysBrandVo);
        String skipByBrandIdData = (String)skipByBrandId.getData();
        menberBoRes.setSkipByBrandId(skipByBrandIdData);
        menberBoRes.setPhone(responseOpenCardModel.getPhone());
        logger.info("operateType={} , mktTaskId={} , sysBrandId={} , \u4f1a\u5458\u4fe1\u606f\u5b58\u50a8={}", new Object[]{operateType, mktTaskId, sysBrandId, this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"))});
        menberBoRes.setMemberCode(responseOpenCardModel.getMemberCode());
        menberBoRes.setOpenCard(true);
        menberBoRes.setCardUseStatus(responseOpenCardModel.getCardUseStatus());
        return new ResponseData((Object)menberBoRes);
    }

    private UserAuthorizationGetPhoneNumberResponseVO getPhone(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, String bizvaneSessionId, String appid) {
        if (Boolean.TRUE.equals(wxMbrRegisteRequestVo.getCustomPhoneAuth())) {
            UserAuthorizationGetPhoneNumberResponseVO vo = new UserAuthorizationGetPhoneNumberResponseVO();
            vo.setCountryCode(wxMbrRegisteRequestVo.getAreaCode());
            vo.setPurePhoneNumber(wxMbrRegisteRequestVo.getPhone());
            return vo;
        }
        UserAuthorizationGetPhoneNumberRequestVO userAuthorizationGetPhoneNumberRequestVO = new UserAuthorizationGetPhoneNumberRequestVO();
        userAuthorizationGetPhoneNumberRequestVO.setAppid(appid);
        userAuthorizationGetPhoneNumberRequestVO.setBizvaneSessionId(bizvaneSessionId);
        userAuthorizationGetPhoneNumberRequestVO.setPhoneNumberData(wxMbrRegisteRequestVo.getPhone());
        userAuthorizationGetPhoneNumberRequestVO.setPhoneCode(wxMbrRegisteRequestVo.getPhoneCode());
        logger.info("UserAuthorizationGetPhoneNumberResponseVO phoneNumberResData : {}", (Object)JSONObject.toJSONString((Object)userAuthorizationGetPhoneNumberRequestVO));
        ResponseData phoneNumberResData = new ResponseData();
        phoneNumberResData = StringUtils.isNotBlank((CharSequence)userAuthorizationGetPhoneNumberRequestVO.getPhoneCode()) ? this.userAuthorizationFeign.getPhoneNumberNew(userAuthorizationGetPhoneNumberRequestVO) : this.userAuthorizationFeign.getPhoneNumber(userAuthorizationGetPhoneNumberRequestVO);
        logger.info("\u6ce8\u518c\u5f00\u5361\u65f6\u89e3\u5bc6\u624b\u673a\u53f7\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)phoneNumberResData));
        if (phoneNumberResData.getData() == null || phoneNumberResData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || StringUtils.isBlank((CharSequence)((UserAuthorizationGetPhoneNumberResponseVO)phoneNumberResData.getData()).getPurePhoneNumber())) {
            throw new BizException(100, "\u89e3\u5bc6\u624b\u673a\u53f7\u5931\u8d25");
        }
        return (UserAuthorizationGetPhoneNumberResponseVO)phoneNumberResData.getData();
    }

    private ResponseData<AppletBrandMenberBo> getMbrInfoByWx(String bizvaneSessionId, AppletBrandMenberBo menberBoRes, UserAuthorizationGetUserInfoResponseVO userInfoRes) {
        String memberCode = userInfoRes.getMemberCode();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData model = this.appletServiceFeign.getSingleMemberModel(memberInfoModel);
        if (model.getData() != null) {
            String phone = ((MemberInfoModel)model.getData()).getPhone();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + memberCode), (Object)phone, 7776000000L);
            menberBoRes.setCardUseStatus(((MemberInfoModel)model.getData()).getCardUseStatus());
        }
        logger.info("getUserInfo memberCode={}  bizvaneSessionId={}", (Object)memberCode, (Object)bizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
        logger.info("memberCode\u6388\u6743\u5df2\u5f00\u5361={}", this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode")));
        menberBoRes.setMemberCode(memberCode);
        menberBoRes.setOpenCard(true);
        menberBoRes.setSysBrandId(userInfoRes.getSysBrandId());
        menberBoRes.setSysCompanyId(userInfoRes.getSysCompanyId());
        logger.info("openCard={}", (Object)JSON.toJSONString((Object)menberBoRes));
        return new ResponseData((Object)menberBoRes);
    }

    private WxCodeResolveVo getWxCodeResolveVo(String code, String appid) {
        ResponseData wxCodeResolveVoResponseData = this.userAuthorizationFeign.wxCodeResolve(code, appid);
        if (wxCodeResolveVoResponseData == null || wxCodeResolveVoResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || wxCodeResolveVoResponseData.getData() == null || StringUtils.isBlank((CharSequence)((WxCodeResolveVo)wxCodeResolveVoResponseData.getData()).getBizvaneSessionId()) || StringUtils.isBlank((CharSequence)((WxCodeResolveVo)wxCodeResolveVoResponseData.getData()).getOpenid())) {
            logger.info("userAuthorizationFeign#wxCodeResolve\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25,{}", (Object)JSONObject.toJSONString((Object)wxCodeResolveVoResponseData));
            throw new RuntimeException("bizvanekey\u672a\u83b7\u53d6");
        }
        return (WxCodeResolveVo)wxCodeResolveVoResponseData.getData();
    }

    private SysBrandPo getBrandInfo(String appid) {
        ResponseData wxPublicPOResponseData = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
        if (wxPublicPOResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || wxPublicPOResponseData.getData() == null) {
            logger.info("wxPublicServiceFeign#getWxPublicPOByAppId\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25,{}", (Object)JSONObject.toJSONString((Object)wxPublicPOResponseData));
            throw new RuntimeException("\u5c0f\u7a0b\u5e8f\u8d26\u53f7\u4e3b\u4f53\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        Long sysBrandId = ((WxPublicPO)wxPublicPOResponseData.getData()).getSysBrandId();
        logger.info("\u5c0f\u7a0b\u5e8f\u8d26\u53f7\u4e3b\u4f53\u4fe1\u606f sysBrandId={}", (Object)sysBrandId);
        ResponseData sysBrandPoResponseData = this.brandServiceRpc.getBrandByID(sysBrandId);
        if (sysBrandPoResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode() || sysBrandPoResponseData.getData() == null) {
            logger.info("brandServiceRpc#getBrandByID\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25,{}", (Object)JSONObject.toJSONString((Object)sysBrandPoResponseData));
            throw new RuntimeException("\u5c0f\u7a0b\u5e8f\u8d26\u53f7\u4e3b\u4f53\u54c1\u724c\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return (SysBrandPo)sysBrandPoResponseData.getData();
    }

    private AppletBrandMenberBo getMbrOpenCardFlag(WxCodeResolveVo wxCodeResolveVo, Long sysBrandId, String appid) {
        WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
        wxChannelInfoVo.setAppId(appid);
        wxChannelInfoVo.setBrandId(sysBrandId);
        wxChannelInfoVo.setWxOpenId(wxCodeResolveVo.getOpenid());
        wxChannelInfoVo.setWxUnionId(wxCodeResolveVo.getUnionid());
        wxChannelInfoVo.setMiniProgram(Integer.valueOf(2));
        ResponseData wxChannelInfoResData = this.wxChannelInfoApiService.getWxChannelInfoByWX(wxChannelInfoVo);
        logger.info("wxChannelInfoApiService#getWxChannelInfoByWX\u8bf7\u6c42\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)wxChannelInfoResData));
        AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
        if (wxChannelInfoResData == null || wxChannelInfoResData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode()) {
            throw new RuntimeException("\u6388\u6743\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
        }
        if (wxChannelInfoResData.getData() == null || StringUtils.isBlank((CharSequence)((WxChannelInfoVo)wxChannelInfoResData.getData()).getMemberCode())) {
            appletBrandMenberBo.setOpenCard(false);
            logger.info("\u672a\u5f00\u5361,openid={}", (Object)wxCodeResolveVo.getOpenid());
            MemberElectCardSearchVo memberElectCardSearchVo = new MemberElectCardSearchVo();
            memberElectCardSearchVo.setBrandId(sysBrandId);
            memberElectCardSearchVo.setUnionId(wxCodeResolveVo.getUnionid());
            ResponseData memberElectCardByWxRes = this.memberElectCardApiService.getMemberElectCardByWx(memberElectCardSearchVo);
            if (memberElectCardByWxRes != null && memberElectCardByWxRes.getData() != null && StringUtils.isNotBlank((CharSequence)((MemberElectCardResVo)memberElectCardByWxRes.getData()).getWechatElectronicCardCode())) {
                logger.info("\u9886\u53d6\u8fc7\u7535\u5b50\u4f1a\u5458\u5361,openid={}", (Object)wxCodeResolveVo.getOpenid());
                appletBrandMenberBo.setOpenWxElectCard(true);
            }
            return appletBrandMenberBo;
        }
        WxChannelInfoVo wxChannelInfoRes = (WxChannelInfoVo)wxChannelInfoResData.getData();
        appletBrandMenberBo.setOpenCard(true);
        appletBrandMenberBo.setMemberCode(wxChannelInfoRes.getMemberCode());
        appletBrandMenberBo.setUnionId(wxChannelInfoRes.getWxUnionId());
        appletBrandMenberBo.setCardUseStatus(wxChannelInfoRes.getCardUseStatus());
        logger.info("\u5b58\u50a8\u4f1a\u5458\u4fe1\u606f\u5230Redis memberCode={}  bizvaneSessionId={}   phone={}", new Object[]{wxChannelInfoRes.getMemberCode(), wxCodeResolveVo.getBizvaneSessionId(), wxChannelInfoRes.getPhone()});
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + wxCodeResolveVo.getBizvaneSessionId()), (Object)wxChannelInfoRes.getWxUnionId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + wxChannelInfoRes.getMemberCode()), (Object)wxChannelInfoRes.getPhone(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(wxCodeResolveVo.getBizvaneSessionId() + "memberCode"), (Object)wxChannelInfoRes.getMemberCode(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(wxChannelInfoRes.getMemberCode() + "bizvaneSessionId"), (Object)wxCodeResolveVo.getBizvaneSessionId(), 7776000000L);
        logger.info("UnionId={}", this.redisTemplateService.stringGetStringByKey((Object)("getUnionId" + wxCodeResolveVo.getBizvaneSessionId())));
        return appletBrandMenberBo;
    }

    public ResponseData<MemberInfoModel> openElectCard(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, WxPublicPO wxPublicPO) {
        MemberElectCardRequestVo memberElectCardRequestVo = new MemberElectCardRequestVo();
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getWxElectCardInfo())) {
            memberElectCardRequestVo.setCardId(wxMbrRegisteRequestVo.getCardId());
            memberElectCardRequestVo.setCode(wxMbrRegisteRequestVo.getElectCode());
            memberElectCardRequestVo.setWxOpenId(wxMbrRegisteRequestVo.getOpenId());
            memberElectCardRequestVo.setWxUnionId(wxMbrRegisteRequestVo.getUnionId());
            String wxElectCardInfo = wxMbrRegisteRequestVo.getWxElectCardInfo();
            MemberElectCardRequestVo memberElectCardRequestVoParseRes = (MemberElectCardRequestVo)JSONObject.parseObject((String)wxElectCardInfo, MemberElectCardRequestVo.class);
            memberElectCardRequestVo.setElectCardMobile(memberElectCardRequestVoParseRes.getElectCardMobile());
            memberElectCardRequestVo.setElectCardName(memberElectCardRequestVoParseRes.getElectCardName());
            memberElectCardRequestVo.setElectCardAddress(memberElectCardRequestVoParseRes.getElectCardName());
            memberElectCardRequestVo.setElectCardBirthday(memberElectCardRequestVoParseRes.getElectCardBirthday());
            memberElectCardRequestVo.setElectCardEmail(memberElectCardRequestVoParseRes.getElectCardName());
            memberElectCardRequestVo.setElectCardSex(memberElectCardRequestVoParseRes.getElectCardSex());
        } else if (wxMbrRegisteRequestVo.isOpenWxElectCard()) {
            memberElectCardRequestVo.setCardId(wxMbrRegisteRequestVo.getCardId());
            memberElectCardRequestVo.setWxOpenId(wxMbrRegisteRequestVo.getOpenId());
            memberElectCardRequestVo.setWxUnionId(wxMbrRegisteRequestVo.getUnionId());
            memberElectCardRequestVo.setElectCardMobile(wxMbrRegisteRequestVo.getPhone());
        } else {
            ResponseData wxPublicPOResponseData = this.wxPublicServiceFeign.getWxPublicInfo(wxPublicPO.getSysCompanyId(), wxPublicPO.getSysBrandId(), "1", "00");
            if (wxPublicPOResponseData == null || wxPublicPOResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode()) {
                return null;
            }
            logger.info("wxPublicPOResponseData:{}", (Object)JacksonUtil.bean2Json((Object)wxPublicPOResponseData));
            ResponseData responseData = this.createMembersCardService.getActivateTempInfo(((WxPublicPO)wxPublicPOResponseData.getData()).getAuthorizerAccessToken(), wxMbrRegisteRequestVo.getActivateTicket());
            logger.info("responseData:{}", (Object)JSONObject.toJSONString((Object)responseData));
            if ((responseData == null || responseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode()) && StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getCardId()) && StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getElectCode())) {
                responseData = this.createMembersCardService.getElectMemberCardInfo(wxPublicPO.getSysBrandId(), wxMbrRegisteRequestVo.getCardId(), wxMbrRegisteRequestVo.getElectCode());
                logger.info("getElectMemberCardInfo method :{}", (Object)JSONObject.toJSONString((Object)responseData));
            }
            if (responseData == null || responseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode()) {
                return null;
            }
            memberElectCardRequestVo = this.jointOpenCardParam(wxMbrRegisteRequestVo, responseData);
        }
        logger.info("memberElectCardRequestVo:{}", (Object)JacksonUtil.bean2Json((Object)memberElectCardRequestVo));
        ResponseData memberElectCardResponseVoResponseData = this.memberElectCardOpenCardApiService.openCard(memberElectCardRequestVo);
        logger.info("memberElectCardResponseVoResponseData:{}", (Object)JacksonUtil.bean2Json((Object)memberElectCardResponseVoResponseData));
        if (memberElectCardResponseVoResponseData != null && SysResponseEnum.USER_APPLET_BINDING_CARD_FAIL_WINDOW.getCode() == memberElectCardResponseVoResponseData.getCode()) {
            return new ResponseData(SysResponseEnum.USER_APPLET_BINDING_CARD_FAIL_WINDOW.getCode(), memberElectCardResponseVoResponseData.getMessage());
        }
        if (memberElectCardResponseVoResponseData == null || memberElectCardResponseVoResponseData.getCode() != com.bizvane.utils.enumutils.SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(com.bizvane.utils.enumutils.SysResponseEnum.FAILED.getCode(), memberElectCardResponseVoResponseData != null ? memberElectCardResponseVoResponseData.getMessage() : "\u5f00\u5361\u5931\u8d25");
        }
        MemberElectCardResponseVo memberElectCardResponseVo = (MemberElectCardResponseVo)memberElectCardResponseVoResponseData.getData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        BeanUtils.copyProperties((Object)memberElectCardResponseVo, (Object)memberInfoModel);
        logger.info("memberInfoModel:{}", (Object)JacksonUtil.bean2Json((Object)memberInfoModel));
        return new ResponseData((Object)memberInfoModel);
    }

    private MemberElectCardRequestVo jointOpenCardParam(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, ResponseData<List<Map<String, String>>> responseData) {
        MemberElectCardRequestVo memberElectCardRequestVo = new MemberElectCardRequestVo();
        memberElectCardRequestVo.setCardId(wxMbrRegisteRequestVo.getCardId());
        memberElectCardRequestVo.setCode(wxMbrRegisteRequestVo.getElectCode());
        memberElectCardRequestVo.setWxOpenId(wxMbrRegisteRequestVo.getOpenId());
        memberElectCardRequestVo.setWxUnionId(wxMbrRegisteRequestVo.getUnionId());
        List mapList = (List)responseData.getData();
        for (Map map : mapList) {
            String name = (String)map.get("name");
            String value = (String)map.get("value");
            switch (name) {
                case "USER_FORM_INFO_FLAG_MOBILE": {
                    memberElectCardRequestVo.setElectCardMobile(value);
                    break;
                }
                case "USER_FORM_INFO_FLAG_NAME": {
                    memberElectCardRequestVo.setElectCardName(value);
                    break;
                }
                case "USER_FORM_INFO_FLAG_LOCATION": {
                    memberElectCardRequestVo.setElectCardAddress(value);
                    break;
                }
                case "USER_FORM_INFO_FLAG_BIRTHDAY": {
                    try {
                        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                        memberElectCardRequestVo.setElectCardBirthday(sd.parse(value));
                    }
                    catch (Exception e) {
                        logger.error("convert birthday error", (Throwable)e);
                    }
                    break;
                }
                case "USER_FORM_INFO_FLAG_EMAIL": {
                    memberElectCardRequestVo.setElectCardEmail(value);
                    break;
                }
                case "USER_FORM_INFO_FLAG_SEX": {
                    memberElectCardRequestVo.setElectCardSex(this.convertSex(value));
                }
            }
        }
        return memberElectCardRequestVo;
    }

    private Integer convertSex(String sex) {
        if (StringUtils.isBlank((CharSequence)sex)) {
            return 3;
        }
        switch (sex) {
            case "\u7537": {
                return 2;
            }
            case "\u5973": {
                return 1;
            }
        }
        return 3;
    }
}

