/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.GraphicTemplateService;
import com.bizvane.appletservice.models.bo.ObtainGraphicBo;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GraphicTemplateServiceRpcImpl
implements GraphicTemplateService {
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    private static final String WXOBTAIN_FRAPHIC = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=";
    private static final String WXOBTAIN_FRAPHIC_CONT = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=";
    private static final String GROUP_SENDING = "https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=";
    private static final String GROUP_SENDING_DOING = "https://api.weixin.qq.com/cgi-bin/message/mass/get?access_token=";
    private static final String GROUP_SENDING_DELETE = "https://api.weixin.qq.com/cgi-bin/message/mass/delete?access_token=";
    private static final String WXOBTAIN_DRAFT = "https://api.weixin.qq.com/cgi-bin/draft/batchget?access_token=";
    private static final String WXOBTAIN_DRAFT_CONT = "https://api.weixin.qq.com/cgi-bin/draft/count?access_token=";
    private static final String WXOBTAIN_DRAFT_MP = "https://api.weixin.qq.com/cgi-bin/draft/switch?access_token=";
    private static final String CONSTANT_0_STR = "0";
    private static final String CONSTANT_1_STR = "1";

    public ResponseData<ObtainGraphicBo> obtainGraphicTemplate(ObtainGraphicBo obtainGraphicBo) {
        ResponseData responseData = new ResponseData();
        ResponseData wxPublicBySysBrandId = this.wxPublicServiceFeign.getWxPublicBySysBrandId(obtainGraphicBo.getBrandId());
        WxPublicPO bySysBrandIdData = (WxPublicPO)wxPublicBySysBrandId.getData();
        if (bySysBrandIdData != null) {
            String appid = bySysBrandIdData.getAppid();
            ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(appid);
            String token = (String)accessTokenByAppId.getData();
            try {
                JSONObject jsonObjectPage;
                String countStr;
                if (this.getWxDraftMPSwitch(token)) {
                    countStr = HttpUtil.get((String)(WXOBTAIN_DRAFT_CONT + token));
                    logger.info("\u83b7\u53d6\u8349\u7a3f\u7bb1\u603b\u6570={}", (Object)countStr);
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("offset", obtainGraphicBo.getOffset());
                    paramMap.put("count", obtainGraphicBo.getCount());
                    String paramMapJsonStr = JacksonUtil.bean2Json(paramMap);
                    logger.info("\u83b7\u53d6\u8349\u7a3f\u7bb1\u5217\u8868\u5165\u53c2={}", (Object)paramMapJsonStr);
                    String draftPageStr = HttpUtil.post((String)(WXOBTAIN_DRAFT + token), (String)paramMapJsonStr);
                    jsonObjectPage = JSONObject.parseObject((String)draftPageStr);
                } else {
                    countStr = HttpUtil.get((String)(WXOBTAIN_FRAPHIC_CONT + token));
                    logger.info("\u83b7\u53d6\u56fe\u6587\u6a21\u677f\u603b\u6570={}", (Object)JSON.toJSONString((Object)countStr));
                    HashMap<String, String> stringMap = new HashMap<String, String>();
                    stringMap.put("type", obtainGraphicBo.getType());
                    stringMap.put("offset", obtainGraphicBo.getOffset());
                    stringMap.put("count", obtainGraphicBo.getCount());
                    logger.info("\u83b7\u53d6\u56fe\u6587\u6a21\u677f\u5217\u8868\u5165\u53c2={}", (Object)JSON.toJSONString(stringMap));
                    String obtainGraphicString = HttpUtil.post((String)(WXOBTAIN_FRAPHIC + token), (String)JSON.toJSONString(stringMap));
                    logger.info("\u83b7\u53d6\u56fe\u6587\u6a21\u677f\u5217\u8868={}", (Object)JSON.toJSONString((Object)obtainGraphicString));
                    jsonObjectPage = JSONObject.parseObject((String)obtainGraphicString);
                }
                JSONObject obtainGraphicJson = new JSONObject();
                String item = jsonObjectPage.getString("item");
                String Total_Count = jsonObjectPage.getString("total_count");
                String Item_Count = jsonObjectPage.getString("item_count");
                JSONArray jsonArray = JSONArray.parseArray((String)item);
                JSONArray arrayToo = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject object = jsonArray.getJSONObject(i);
                    JSONObject jobck = new JSONObject();
                    String content = object.getString("content");
                    String stringTime = object.getString("update_time");
                    String Media_Id = object.getString("media_id");
                    JSONObject jsonContent = JSONObject.parseObject((String)content);
                    JSONObject jsoncontents = new JSONObject();
                    String News_Item = jsonContent.getString("news_item");
                    String Create_Time = jsonContent.getString("create_time");
                    String Update_Time = jsonContent.getString("update_time");
                    JSONArray jsonNewsItem = JSONArray.parseArray((String)News_Item);
                    JSONArray jsonArray1 = new JSONArray();
                    for (int n = 0; n < jsonNewsItem.size(); ++n) {
                        JSONObject JsonNewsItemJsonObject = jsonNewsItem.getJSONObject(n);
                        JSONObject jsonObject1 = new JSONObject();
                        String thumbUrl = JsonNewsItemJsonObject.getString("thumb_url");
                        String title = JsonNewsItemJsonObject.getString("title");
                        String author = JsonNewsItemJsonObject.getString("author");
                        String digest = JsonNewsItemJsonObject.getString("digest");
                        String content1 = JsonNewsItemJsonObject.getString("content");
                        String Content_Source_Url = JsonNewsItemJsonObject.getString("content_source_url");
                        String url = JsonNewsItemJsonObject.getString("url");
                        String Need_Open_Comment = JsonNewsItemJsonObject.getString("need_open_comment");
                        String Only_Fans_Can_Comment = JsonNewsItemJsonObject.getString("only_fans_can_comment");
                        String uploadUrl = QiNiuUtil.uploadUrl((String)thumbUrl, null);
                        logger.info("uploadUrl={}", (Object)uploadUrl);
                        jsonObject1.put("title", (Object)title);
                        jsonObject1.put("content", (Object)content1);
                        jsonObject1.put("author", (Object)author);
                        jsonObject1.put("digest", (Object)digest);
                        jsonObject1.put("content_source_url", (Object)Content_Source_Url);
                        jsonObject1.put("url", (Object)url);
                        jsonObject1.put("thumb_url", (Object)uploadUrl);
                        jsonObject1.put("need_open_comment", (Object)Need_Open_Comment);
                        jsonObject1.put("only_fans_can_comment", (Object)Only_Fans_Can_Comment);
                        jsonArray1.set(n, (Object)jsonObject1);
                    }
                    jsoncontents.put("news_item", (Object)jsonArray1);
                    jsoncontents.put("update_time", (Object)Update_Time);
                    jsoncontents.put("create_time", (Object)Create_Time);
                    jobck.put("content", (Object)jsoncontents);
                    jobck.put("update_time", (Object)stringTime);
                    jobck.put("media_id", (Object)Media_Id);
                    arrayToo.set(i, (Object)jobck);
                }
                obtainGraphicJson.put("item", (Object)arrayToo);
                obtainGraphicJson.put("total_count", (Object)Total_Count);
                obtainGraphicJson.put("item_count", (Object)Item_Count);
                String obtainGraphic = obtainGraphicJson.toJSONString();
                ObtainGraphicBo graphicBo = new ObtainGraphicBo();
                graphicBo.setCounts(countStr);
                graphicBo.setObtainGraphic(obtainGraphic);
                logger.info("\u6a21\u677f\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)graphicBo));
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setData((Object)graphicBo);
                return responseData;
            }
            catch (IOException e) {
                logger.info("GraphicTemplateServiceRpcImpl obtainGraphicTemplate Exception : {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("bySysBrandIdData\u4e3a\u7a7a");
        return responseData;
    }

    private boolean getWxDraftMPSwitch(String token) {
        try {
            String switchFlagRes = HttpUtil.post((String)(WXOBTAIN_DRAFT_MP + token + "&checkonly=1"), null);
            logger.info("\u8349\u7a3f\u7bb1MP\u7aef\u5f00\u5173={}", (Object)switchFlagRes);
            JSONObject switchFlagResJson = JSONObject.parseObject((String)switchFlagRes);
            if (switchFlagResJson == null) {
                return true;
            }
            String errcode = switchFlagResJson.getString("errcode");
            String is_open = switchFlagResJson.getString("is_open");
            if (CONSTANT_0_STR.equals(errcode) && CONSTANT_0_STR.equals(is_open)) {
                return false;
            }
            if (CONSTANT_0_STR.equals(errcode) && CONSTANT_1_STR.equals(is_open)) {
                return true;
            }
            return true;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return true;
        }
    }

    public ResponseData groupSending(ObtainGraphicBo obtainGraphicBo) {
        logger.info("GraphicTemplateServiceRpcImpl groupSending\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)obtainGraphicBo));
        ResponseData responseData = new ResponseData();
        try {
            ResponseData wxPublicBySysBrandId = this.wxPublicServiceFeign.getWxPublicBySysBrandId(obtainGraphicBo.getBrandId());
            WxPublicPO bySysBrandIdData = (WxPublicPO)wxPublicBySysBrandId.getData();
            if (bySysBrandIdData != null) {
                String appid = bySysBrandIdData.getAppid();
                ResponseData wxPublicPoByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
                WxPublicPO data = (WxPublicPO)wxPublicPoByAppId.getData();
                String dataAppid = data.getAppid();
                ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(dataAppid);
                String token = (String)accessTokenByAppId.getData();
                List openId = obtainGraphicBo.getOpenId();
                JSONArray array = new JSONArray();
                array.addAll((Collection)openId);
                String mediaId = obtainGraphicBo.getMediaId();
                JSONObject objectBig = new JSONObject();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("media_id", (Object)mediaId);
                String msgType = obtainGraphicBo.getMsgType();
                String sendIgnoreReprint = obtainGraphicBo.getSendIgnoreReprint();
                objectBig.put("touser", (Object)array);
                objectBig.put("mpnews", (Object)jsonObject);
                objectBig.put("msgtype", (Object)msgType);
                objectBig.put("send_ignore_reprint", (Object)CONSTANT_1_STR);
                logger.info("token={}", (Object)token);
                logger.info("stringMap={}", (Object)JSON.toJSONString((Object)objectBig));
                String post = HttpUtil.post((String)(GROUP_SENDING + token), (String)objectBig.toString());
                logger.info("\u7fa4\u53d1\u56de\u6267={}", (Object)JSON.toJSONString((Object)post));
                JSONObject parseObject = JSONObject.parseObject((String)post);
                String errcode = parseObject.getString("errcode");
                String errmsg = parseObject.getString("errmsg");
                String Msg_Id = parseObject.getString("msg_id");
                String Msg_Data_Id = parseObject.getString("msg_data_id");
                Integer integer = Integer.valueOf(errcode);
                responseData.setCode(integer.intValue());
                responseData.setMessage(errmsg);
                responseData.setData((Object)Msg_Id);
                return responseData;
            }
        }
        catch (IOException e) {
            logger.info("GraphicTemplateServiceRpcImpl groupSending Exception : {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        responseData.setCode(100);
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        return responseData;
    }

    public ResponseData groupSendingDoing(String msgId, Long brandId) {
        ResponseData responseData = new ResponseData();
        try {
            ResponseData wxPublicBySysBrandId = this.wxPublicServiceFeign.getWxPublicBySysBrandId(brandId);
            WxPublicPO bySysBrandIdData = (WxPublicPO)wxPublicBySysBrandId.getData();
            if (bySysBrandIdData != null) {
                String appid = bySysBrandIdData.getAppid();
                ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(appid);
                String token = (String)accessTokenByAppId.getData();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("msg_id", (Object)msgId);
                String post = HttpUtil.post((String)(GROUP_SENDING_DOING + token), (String)jsonObject.toJSONString());
                JSONObject parseObject = JSONObject.parseObject((String)post);
                String Msg_Id = parseObject.getString("msg_id");
                String Msg_Status = parseObject.getString("msg_status");
                logger.info("msg_status={}", (Object)Msg_Status);
                if ("SEND_SUCCESS".equals(Msg_Status)) {
                    responseData.setCode(0);
                    responseData.setMessage("\u6d88\u606f\u6210\u529f\u53d1\u9001");
                    return responseData;
                }
                if ("SENDING".equals(Msg_Status)) {
                    responseData.setCode(50);
                    responseData.setMessage("\u6d88\u606f\u53d1\u9001\u4e2d");
                    return responseData;
                }
                if ("SEND_FAIL".equals(Msg_Status)) {
                    responseData.setCode(100);
                    responseData.setMessage("\u6d88\u606f\u53d1\u9001\u5931\u8d25");
                    return responseData;
                }
                if ("DELETE".equals(Msg_Status)) {
                    responseData.setCode(200);
                    responseData.setMessage("\u6d88\u606f\u5df2\u7ecf\u5220\u9664");
                    return responseData;
                }
            }
        }
        catch (IOException e) {
            logger.info("GraphicTemplateServiceRpcImpl groupSendingDoing Exception : {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return responseData;
    }

    public ResponseData groupSendDelete(String msgId, Long brandId) {
        logger.info("GraphicTemplateServiceRpcImpl#groupSendDelete,msgId={},brandId={}", (Object)msgId, (Object)brandId);
        ResponseData wxPublicBySysBrandId = this.wxPublicServiceFeign.getWxPublicBySysBrandId(brandId);
        if (wxPublicBySysBrandId == null || wxPublicBySysBrandId.getData() == null) {
            logger.info("wxPublicServiceFeign#getWxPublicBySysBrandId,res:{}", (Object)JSONObject.toJSONString((Object)wxPublicBySysBrandId));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u6839\u636e\u54c1\u724c\u83b7\u53d6\u516c\u4f17\u53f7\u4fe1\u606f\u5931\u8d25");
        }
        ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(((WxPublicPO)wxPublicBySysBrandId.getData()).getAppid());
        if (accessTokenByAppId == null || StringUtils.isBlank((CharSequence)((CharSequence)accessTokenByAppId.getData()))) {
            logger.info("wxPublicServiceFeign#getAccessTokenByAppId,res:{}", (Object)JSONObject.toJSONString((Object)accessTokenByAppId));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u6839\u636eappid\u67e5\u627etoken\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg_id", (Object)msgId);
        String postRes = null;
        try {
            postRes = HttpUtil.post((String)(GROUP_SENDING_DELETE + (String)accessTokenByAppId.getData()), (String)jsonObject.toJSONString());
        }
        catch (IOException e) {
            logger.info("\u5220\u9664\u5fae\u4fe1\u7fa4\u53d1\u56fe\u6587\u6d88\u606f\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u5220\u9664\u5fae\u4fe1\u7fa4\u53d1\u56fe\u6587\u6d88\u606f\u5f02\u5e38," + e.getMessage());
        }
        JSONObject resJson = JSONObject.parseObject((String)postRes);
        logger.info("\u5220\u9664\u5fae\u4fe1\u7fa4\u53d1\u56fe\u6587\u6d88\u606f\u7ed3\u679c:{}", (Object)resJson);
        return new ResponseData(Integer.valueOf(resJson.get((Object)"errcode").toString()).intValue(), resJson.get((Object)"errmsg").toString());
    }
}

