/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.bizvane.appletservice.interfaces.ActivityRegistrationService;
import com.bizvane.appletservice.models.po.Members;
import com.bizvane.appletservice.models.po.MembersExample;
import com.bizvane.appletservice.models.vo.ActivityRegistrationVO;
import com.bizvane.appletserviceimpl.impl.teddy.util.CheckResultUtil;
import com.bizvane.appletserviceimpl.mappers.MembersMapper;
import com.bizvane.appletserviceimpl.mappers.TMktActivityRegistrationMapper;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.enums.BusinessTypeEnum;
import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.members.facade.service.api.IntegralChangeApiService;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.mktcenterservice.models.bo.ActivityRegistrationBO;
import com.bizvane.mktcenterservice.models.bo.TMktActivitySignup;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.mktcenterservice.models.vo.SignupHistory;
import com.bizvane.mktcenterservice.rpc.ActivityRegistrationServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityRegistrationServiceImpl
implements ActivityRegistrationService {
    private static final Logger log = LoggerFactory.getLogger(ActivityRegistrationServiceImpl.class);
    @Autowired
    private TMktActivityRegistrationMapper registrationMapper;
    @Autowired
    private MembersMapper membersMapper;
    @Autowired
    private ActivityRegistrationServiceRpc registrationServiceRpc;
    @Autowired
    private IntegralChangeApiService integralChangeApiService;
    private static final Pattern PATTERN = Pattern.compile("1[3-9]\\d{9}");

    public ResponseData<ActivityRegistrationVO> getActivityRegistrationDetail(String activityCode, String memberCode) {
        ResponseData registrationDetail = this.registrationServiceRpc.getActivityRegistrationDetail(activityCode);
        if (registrationDetail.getData() == null) {
            return ResponseUtils.getFailedData((String)registrationDetail.getMessage());
        }
        ActivityVO activityVO = ((ActivityRegistrationBO)registrationDetail.getData()).getActivityVO();
        if (activityVO == null) {
            return ResponseUtils.getFailedData((String)"\u67e5\u8be2\u4e0d\u5230\u6b64\u6d3b\u52a8");
        }
        if (!Objects.equals(activityVO.getActivityStatus(), 2)) {
            String errMsg = "";
            switch (activityVO.getActivityStatus()) {
                case 1: {
                    errMsg = "\u6d3b\u52a8\u672a\u5f00\u59cb";
                    break;
                }
                case 3: {
                    errMsg = "\u6d3b\u52a8\u5df2\u7ed3\u675f";
                    break;
                }
                case 4: {
                    errMsg = "\u6d3b\u52a8\u5df2\u7981\u7528";
                    break;
                }
                default: {
                    errMsg = "\u8be5\u6d3b\u52a8\u672a\u542f\u7528";
                }
            }
            return ResponseUtils.getFailedData((String)errMsg);
        }
        ActivityRegistrationVO detail = new ActivityRegistrationVO();
        BeanUtils.copyProperties((Object)activityVO, (Object)detail);
        BeanUtils.copyProperties((Object)((ActivityRegistrationBO)registrationDetail.getData()).getActivity(), (Object)detail);
        detail.setActivityType(activityVO.getActivityType());
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            ResponseData signed = this.registrationServiceRpc.signuped(activityCode, memberCode);
            detail.setSignUp(Boolean.TRUE.equals(signed.getData()));
        }
        return new ResponseData((Object)detail);
    }

    public ResponseData<PageInfo<ActivityRegistrationVO>> getActivityRegistrationList(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        this.registrationMapper.getActivityRegistrationList();
        return new ResponseData((Object)page.toPageInfo());
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> signup(String activityCode, Map<String, String> customProperties, String memberCode) {
        List members;
        MembersExample example;
        ActivityRegistrationVO detail;
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            ResponseData activityRegistrationVOResponseData = this.getActivityRegistrationDetail(activityCode, memberCode);
            detail = (ActivityRegistrationVO)CheckResultUtil.checkResponseData((ResponseData)activityRegistrationVOResponseData, (String)"\u67e5\u8be2\u4e0d\u5230\u6b64\u6d3b\u52a8");
        } else {
            detail = this.registrationMapper.getActivityRegistrationDetail(activityCode);
        }
        if (detail == null) {
            throw LogicException.error((Integer)-1, (String)"\u67e5\u8be2\u4e0d\u5230\u6b64\u6d3b\u52a8");
        }
        String name = customProperties.get("\u59d3\u540d");
        String phone = customProperties.get("\u624b\u673a\u53f7");
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            if (detail.isSignUp()) {
                throw LogicException.error((Integer)-1, (String)"\u60a8\u5df2\u7ecf\u62a5\u8fc7\u540d\u5566\uff0c\u4e0d\u7528\u91cd\u590d\u62a5\u540d");
            }
        } else {
            boolean signuped = this.registrationMapper.isSignupedByPhone(activityCode, phone);
            if (signuped) {
                throw LogicException.error((Integer)-1, (String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ecf\u62a5\u540d");
            }
        }
        List properties = detail.getCustomProperties();
        for (ExtendPropertyModel property : properties) {
            String title = property.getPropertyName();
            String value = customProperties.get(title);
            if (!StringUtils.isBlank((CharSequence)value) || !property.getRequired().equals("2")) continue;
            throw LogicException.error((Integer)-1, (String)String.format("\u60a8\u7684\u3010%s\u3011\u4fe1\u606f\u5fd8\u8bb0\u586b\u5566", title));
        }
        TMktActivitySignup activitySignup = new TMktActivitySignup();
        activitySignup.setSignupUserName(name);
        activitySignup.setSignupUserPhone(phone);
        activitySignup.setCreateDate(new Date());
        Members member = null;
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            example = new MembersExample();
            example.createCriteria().andMemberCodeEqualTo(memberCode).andValidEqualTo(Boolean.TRUE);
            members = this.membersMapper.selectByExample(example);
            if (members.size() > 0) {
                member = (Members)members.get(0);
                activitySignup.setCreateUserId(member.getMbrMemberId());
            }
        } else {
            example = new MembersExample();
            example.createCriteria().andNameEqualTo(name).andPhoneEqualTo(phone).andValidEqualTo(Boolean.TRUE);
            members = this.membersMapper.selectByExample(example);
            if (members.size() > 0) {
                member = (Members)members.get(0);
            }
        }
        IntegralChangeRequestModel integralChangeRequestModel = null;
        activitySignup.setMember(Boolean.valueOf(member != null));
        if (!detail.getIsSignupNoMember().booleanValue()) {
            if (member == null) {
                throw LogicException.error((Integer)-1, (String)"\u975e\u4f1a\u5458\u4e0d\u80fd\u53c2\u52a0\u6d3b\u52a8");
            }
            if (detail.getRegistrationFee() > 0) {
                Integer integral = member.getCountIntegral();
                if (integral < detail.getRegistrationFee()) {
                    throw LogicException.error((Integer)-1, (String)("\u672c\u6b21\u6d3b\u52a8\u9700\u8981" + detail.getRegistrationFee() + "\u79ef\u5206, \u60a8\u7684\u79ef\u5206\u8fd8\u4e0d\u591f\u5662"));
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyymmddHHmmssSSS");
                integralChangeRequestModel = new IntegralChangeRequestModel();
                integralChangeRequestModel.setSysCompanyId(member.getSysCompanyId());
                integralChangeRequestModel.setBrandId(member.getBrandId());
                integralChangeRequestModel.setMemberCode(member.getMemberCode());
                integralChangeRequestModel.setChangeBills(sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0));
                integralChangeRequestModel.setChangeIntegral(Integer.valueOf(detail.getRegistrationFee()));
                integralChangeRequestModel.setChangeDate(new Date());
                integralChangeRequestModel.setChangeType("1");
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.ACTIVITY_TYPE_ORDER.getCode());
                integralChangeRequestModel.setChangeDetails("\u6d3b\u52a8\u62a5\u540d\u652f\u51fa");
                integralChangeRequestModel.setOperateUserId(member.getMbrMemberId());
                integralChangeRequestModel.setOperateUserName(member.getName());
            }
        }
        activitySignup.setCreateUserName(name);
        activitySignup.setCustomProperties(JacksonUtil.bean2Json(customProperties));
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            activitySignup.setMbrMemberCode(memberCode);
        } else if (member != null) {
            activitySignup.setMbrMemberCode(member.getMemberCode());
        }
        activitySignup.setMktActivityCode(activityCode);
        activitySignup.setSignUpSource(Byte.valueOf((byte)0));
        activitySignup.setSysCompanyId(detail.getSysCompanyId());
        activitySignup.setSysBrandId(detail.getSysBrandId());
        activitySignup.setValid(Boolean.valueOf(true));
        ResponseData resultResponseData = this.registrationServiceRpc.signup(activitySignup);
        if (resultResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            if (integralChangeRequestModel != null) {
                IntegralChangeResponseModel integralChangeResponseModel = this.integralChangeApiService.integralChangeOperate(integralChangeRequestModel);
            }
        } else {
            throw LogicException.error((Integer)resultResponseData.getCode(), (String)resultResponseData.getMessage());
        }
        return resultResponseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> signup4others(String activityCode, Map<String, String> customProperties, String memberCode) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        ActivityRegistrationVO detail = this.registrationMapper.getActivityRegistrationDetail(activityCode);
        if (detail == null) {
            throw LogicException.error((Integer)-1, (String)"\u67e5\u8be2\u4e0d\u5230\u6b64\u6d3b\u52a8");
        }
        String name = customProperties.get("\u59d3\u540d");
        String phone = customProperties.get("\u624b\u673a\u53f7");
        MembersExample example = new MembersExample();
        example.createCriteria().andNameEqualTo(name).andPhoneEqualTo(phone).andValidEqualTo(Boolean.TRUE);
        List membersList = this.membersMapper.selectByExample(example);
        String signuperCode = null;
        for (Object e : membersList) {
            signuperCode = e.getMemberCode();
        }
        if (!detail.getIsSignupNoMember().booleanValue() && membersList.size() <= 0) {
            throw LogicException.error((Integer)-1, (String)"\u975e\u4f1a\u5458\u4e0d\u80fd\u53c2\u52a0\u6d3b\u52a8");
        }
        if (signuperCode != null && Objects.equals(memberCode, signuperCode)) {
            throw LogicException.error((Integer)-1, (String)"\u4e0d\u53ef\u4ee5\u4e3a\u81ea\u5df1\u62a5\u540d");
        }
        List properties = detail.getCustomProperties();
        for (ExtendPropertyModel property : properties) {
            String title = property.getPropertyName();
            String value = customProperties.get(title);
            if (!StringUtils.isBlank((CharSequence)value) || !property.getRequired().equals("2")) continue;
            throw LogicException.error((Integer)-1, (String)String.format("\u60a8\u6709\u3010%s\u3011\u4fe1\u606f\u5fd8\u8bb0\u586b\u5566", title));
        }
        boolean signuped = this.registrationMapper.isSignupedByPhone(activityCode, phone);
        if (signuped) {
            throw LogicException.error((Integer)-1, (String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ecf\u62a5\u540d");
        }
        TMktActivitySignup activitySignup = new TMktActivitySignup();
        activitySignup.setSignupUserName(name);
        activitySignup.setSignupUserPhone(phone);
        activitySignup.setCreateDate(new Date());
        activitySignup.setMember(Boolean.valueOf(membersList.size() > 0));
        IntegralChangeRequestModel integralChangeRequestModel = null;
        if (!detail.getIsSignupNoMember().booleanValue() && StringUtils.isBlank((CharSequence)memberCode)) {
            throw LogicException.error((Integer)-1, (String)"\u975e\u4f1a\u5458\u4e0d\u80fd\u53c2\u52a0\u6d3b\u52a8");
        }
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            example.clear();
            example.createCriteria().andMemberCodeEqualTo(memberCode).andValidEqualTo(Boolean.TRUE);
            List members = this.membersMapper.selectByExample(example);
            if (members.size() == 0) {
                throw LogicException.error((Integer)-1, (String)"\u975e\u4f1a\u5458\u4e0d\u80fd\u53c2\u52a0\u6d3b\u52a8");
            }
            Members member = (Members)members.get(0);
            if (detail.getRegistrationFee() > 0) {
                Integer integral = member.getCountIntegral();
                if (integral < detail.getRegistrationFee()) {
                    throw LogicException.error((Integer)-1, (String)("\u672c\u6b21\u6d3b\u52a8\u9700\u8981" + detail.getRegistrationFee() + "\u79ef\u5206, \u60a8\u7684\u79ef\u5206\u8fd8\u4e0d\u591f\u5662"));
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyymmddHHmmssSSS");
                integralChangeRequestModel = new IntegralChangeRequestModel();
                integralChangeRequestModel.setSysCompanyId(member.getSysCompanyId());
                integralChangeRequestModel.setBrandId(member.getBrandId());
                integralChangeRequestModel.setMemberCode(member.getMemberCode());
                integralChangeRequestModel.setChangeBills(sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0));
                integralChangeRequestModel.setChangeIntegral(Integer.valueOf(detail.getRegistrationFee()));
                integralChangeRequestModel.setChangeDate(new Date());
                integralChangeRequestModel.setChangeType("1");
                integralChangeRequestModel.setBusinessType(BusinessTypeEnum.ACTIVITY_TYPE_ORDER.getCode());
                integralChangeRequestModel.setChangeDetails("\u6d3b\u52a8\u62a5\u540d\u652f\u51fa");
                integralChangeRequestModel.setOperateUserId(member.getMbrMemberId());
                integralChangeRequestModel.setOperateUserName(member.getName());
            }
            activitySignup.setCreateUserId(member.getMbrMemberId());
            activitySignup.setCreateUserName(member.getName());
        }
        activitySignup.setCustomProperties(JacksonUtil.bean2Json(customProperties));
        activitySignup.setMbrMemberCode(signuperCode);
        activitySignup.setMktActivityCode(activityCode);
        activitySignup.setSignUpSource(Byte.valueOf((byte)0));
        activitySignup.setSysCompanyId(detail.getSysCompanyId());
        activitySignup.setSysBrandId(detail.getSysBrandId());
        activitySignup.setValid(Boolean.valueOf(true));
        ResponseData resultResponseData = this.registrationServiceRpc.signup(activitySignup);
        if (resultResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            if (integralChangeRequestModel != null) {
                IntegralChangeResponseModel integralChangeResponseModel = this.integralChangeApiService.integralChangeOperate(integralChangeRequestModel);
            }
        } else {
            throw LogicException.error((Integer)resultResponseData.getCode(), (String)resultResponseData.getMessage());
        }
        return resultResponseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> signin(String activityCode, String phone) {
        return this.registrationServiceRpc.signin(activityCode, phone);
    }

    public ResponseData<List<SignupHistory>> signupHistory(String memberCode) {
        return this.registrationServiceRpc.signupHistory(memberCode);
    }

    public String selectMemberCodeByOpenId(String openid) {
        return this.membersMapper.selectMemberCodeByOpenId(openid);
    }

    public Members getMemberByOpenid(String openid) {
        return this.membersMapper.selectByOpenid(openid);
    }
}

