/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.filter;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletserviceimpl.filter.HttpUtil;
import com.bizvane.appletserviceimpl.filter.ParamAuthProperties;
import com.bizvane.appletserviceimpl.filter.ParamAuthUtil;
import com.bizvane.appletserviceimpl.filter.RequestWrapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ParamAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ParamAuthFilter.class);
    private static final String authorizationSign = "authorizationSign";
    private static final String authorizationSignPass = "authorizationSignPass";
    private static final String contentTypeForm = "application/x-www-form-urlencoded";
    @Autowired
    private ParamAuthProperties paramAuthProperties;

    public void init(FilterConfig filterConfig) {
        log.info("ParamSignAuthFilter#init");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String sign;
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        RequestWrapper requestWrapper = new RequestWrapper(httpRequest);
        log.info("ParamSignAuthFilter#doFilter#httpRequest.getRequestURI():{}", (Object)httpRequest.getRequestURI());
        if (authorizationSignPass.equals(requestWrapper.getHeader(authorizationSignPass))) {
            log.info("ParamSignAuthFilter#doFilter gateway request");
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)this.paramAuthProperties.getIgnoreSignUri())) {
            String uri;
            HashSet uriSet = new HashSet(this.paramAuthProperties.getIgnoreSignUri());
            String requestUri = httpRequest.getRequestURI();
            boolean isMatch = false;
            Object object = uriSet.iterator();
            while (object.hasNext() && !(isMatch = requestUri.contains(uri = (String)object.next()))) {
            }
            log.info("ParamSignAuthFilter#doFilter getRequestURI:{},isMatch:{}", (Object)requestUri, (Object)isMatch);
            if (isMatch) {
                requestWrapper.putHeader(authorizationSignPass, authorizationSignPass);
                filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
                return;
            }
        }
        if (StringUtils.isEmpty((Object)(sign = requestWrapper.getHeader(authorizationSign))) || !StringUtils.isEmpty((Object)this.paramAuthProperties.getIgnoreSign()) && this.paramAuthProperties.getIgnoreSign().equals(sign)) {
            requestWrapper.putHeader(authorizationSignPass, authorizationSignPass);
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
            return;
        }
        boolean accept = true;
        switch (requestWrapper.getMethod()) {
            case "GET": {
                LinkedHashMap paramMap = HttpUtil.getUrlParams((HttpServletRequest)requestWrapper);
                accept = ParamAuthUtil.verifySign((LinkedHashMap)paramMap, (String)this.paramAuthProperties.getSecretKey(), (String)sign);
                break;
            }
            case "POST": 
            case "PUT": 
            case "DELETE": {
                LinkedHashMap paramMap = contentTypeForm.equals(requestWrapper.getContentType()) ? HttpUtil.getFormParams((HttpServletRequest)requestWrapper) : HttpUtil.getBodyParams((HttpServletRequest)requestWrapper);
                accept = ParamAuthUtil.verifySign((LinkedHashMap)paramMap, (String)this.paramAuthProperties.getSecretKey(), (String)sign);
                break;
            }
        }
        if (accept) {
            requestWrapper.putHeader(authorizationSignPass, authorizationSignPass);
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
        } else {
            this.returnFail("\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (HttpServletResponse)servletResponse);
        }
    }

    public void destroy() {
    }

    private void returnFail(String msg, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        PrintWriter out = response.getWriter();
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(msg);
        String result = JSONObject.toJSONString((Object)responseData);
        out.println(result);
        out.flush();
        out.close();
    }
}

