/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.wechatmall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.vo.IntegralOrderSendVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.messagefacade.interfaces.WeChatAppletSubscribeMessageServiceFeign;
import com.bizvane.messagefacade.interfaces.WechatOrderServiceFeign;
import com.bizvane.messagefacade.models.vo.OrderMessageVO;
import com.bizvane.messagefacade.models.vo.SubscribeMessageVO;
import com.bizvane.messagefacade.models.vo.subscribe.IntegralOrderSendMessageVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/IntegralMallOrderPush"}, method={RequestMethod.POST})
public class IntegralMallOrderPushService {
    private static final Logger log = LoggerFactory.getLogger(IntegralMallOrderPushService.class);
    @Autowired
    private WechatOrderServiceFeign wechatOrderServiceFeign;
    @Autowired
    private WeChatAppletSubscribeMessageServiceFeign weChatAppletSubscribeMessageServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @PostMapping
    public ResponseData sendOrderMessage(@RequestBody IntegralOrderSendVO integralOrderSendVO) {
        log.info("IntegralMallOrderPushService#integralOrderSendVO:{}", (Object)JSON.toJSONString((Object)integralOrderSendVO));
        OrderMessageVO orderMessageVO = new OrderMessageVO();
        BeanUtils.copyProperties((Object)integralOrderSendVO, (Object)orderMessageVO);
        log.info("IntegralMallOrderPushService#orderMessageVO:{}", (Object)JSON.toJSONString((Object)orderMessageVO));
        ResponseData stringResponseData = this.wechatOrderServiceFeign.integralOrderShip(orderMessageVO);
        log.info("\u63a8\u9001\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)stringResponseData));
        this.fillIntegralOrderSendParamAndSend(integralOrderSendVO);
        return stringResponseData;
    }

    private void fillIntegralOrderSendParamAndSend(IntegralOrderSendVO integralOrderSendVO) {
        String memberCode = integralOrderSendVO.getMemberCode();
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("memberCode is blank");
            return;
        }
        try {
            IntegralOrderSendMessageVO pushMessageRequestVO = new IntegralOrderSendMessageVO();
            BeanUtils.copyProperties((Object)integralOrderSendVO, (Object)pushMessageRequestVO);
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            log.info("fillIntegralOrderSendParamAndSend#singleMemberModel:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
            MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
            pushMessageRequestVO.setFIELD_MEMBER_CARD_NO(memberModelData.getCardNo());
            pushMessageRequestVO.setFIELD_GOOD_NAME(integralOrderSendVO.getIntegralGoodName());
            pushMessageRequestVO.setFIELD_ORDER_NO(integralOrderSendVO.getOrderNo());
            pushMessageRequestVO.setFIELD_LOGISTICS_COMPANY(integralOrderSendVO.getLogisticsCompanyName());
            pushMessageRequestVO.setFIELD_LOGISTICS_NO(integralOrderSendVO.getLogisticsNo());
            pushMessageRequestVO.setFIELD_TEXT(integralOrderSendVO.getFieldText());
            log.info("weChatAppletSubscribeMessageServiceFeign#integralOrderSendMessage#param:{}", (Object)JSONObject.toJSONString((Object)pushMessageRequestVO));
            SubscribeMessageVO integralOrderSendMessageVOSubscribeMessageVO = new SubscribeMessageVO();
            integralOrderSendMessageVOSubscribeMessageVO.setMessageInfo((Object)pushMessageRequestVO);
            integralOrderSendMessageVOSubscribeMessageVO.setLinkUrl(integralOrderSendVO.getLinkUrl());
            ResponseData responseData = this.weChatAppletSubscribeMessageServiceFeign.integralOrderSendMessage(integralOrderSendMessageVOSubscribeMessageVO);
            log.info("weChatAppletSubscribeMessageServiceFeign#integralOrderSendMessage#result:{}", (Object)JSONObject.toJSONString((Object)responseData));
        }
        catch (Exception e) {
            log.info("fillIntegralOrderSendParamAndSend#error:{}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }
}

