/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.questionnaire;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.alipayfacade.interfaces.AlipayPublicServiceFeign;
import com.bizvane.alipayfacade.models.po.AlipayPublicPo;
import com.bizvane.appletservice.models.vo.questionnaire.QuestionnaireEvaluateRequestVO;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.customized.facade.interfaces.EvaluationQuestionnaireFeign;
import com.bizvane.customized.facade.models.vo.questionnaire.EnterQuestionnaireVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireTempRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireTempVO;
import com.bizvane.customized.facade.models.vo.questionnaire.SaveQuestionnaireRequestVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberOrderApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/questionnaire"})
public class QuestionnaireController {
    private static final Logger log = LoggerFactory.getLogger(QuestionnaireController.class);
    @Autowired
    private MemberOrderApiService memberOrderApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private AlipayPublicServiceFeign alipayPublicServiceFeign;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private EvaluationQuestionnaireFeign evaluationQuestionnaireFeign;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    RocketMQTemplate rocketMQTemplate;

    @PostMapping(value={"/enterQuestionnaire"})
    public ResponseData<Boolean> enterQuestionnaire(String templateCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            responseData.setMessage("\u6a21\u677f\u7f16\u53f7\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        EnterQuestionnaireVO enterQuestionnaireVO = new EnterQuestionnaireVO();
        enterQuestionnaireVO.setSysCompanyId(Long.valueOf(request.getHeader("sysCompanyId")));
        enterQuestionnaireVO.setSysBrandId(Long.valueOf(request.getHeader("sysBrandId")));
        enterQuestionnaireVO.setMemberCode(memberCode);
        enterQuestionnaireVO.setTemplateCode(templateCode);
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("ENTER_QUESTIONNAIRE").build(), (Object)JSON.toJSONString((Object)enterQuestionnaireVO));
        log.info("enterQuestionnaire#sendResult:{}", (Object)JSONObject.toJSONString((Object)sendResult));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)Boolean.TRUE);
        return responseData;
    }

    @PostMapping(value={"/checkQuestionnaireTempValid"})
    public ResponseData<Integer> checkQuestionnaireTempValid(String templateCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            responseData.setMessage("\u6a21\u677f\u7f16\u53f7\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        QuestionnaireTempRequestVO requestVO = new QuestionnaireTempRequestVO();
        requestVO.setSysCompanyId(Long.valueOf(request.getHeader("sysCompanyId")));
        requestVO.setSysBrandId(Long.valueOf(request.getHeader("sysBrandId")));
        requestVO.setTemplateCode(templateCode);
        return this.evaluationQuestionnaireFeign.checkQuestionnaireTempValid(requestVO);
    }

    @PostMapping(value={"/getQuestionTemplateByCode"})
    public ResponseData<QuestionnaireTempVO> getQuestionTemplateByCode(String templateCode, Integer questionnaireType, String orderNo, Long mktTaskId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            responseData.setMessage("\u6a21\u677f\u7f16\u53f7\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        QuestionnaireTempRequestVO requestVO = new QuestionnaireTempRequestVO();
        requestVO.setSysCompanyId(Long.valueOf(request.getHeader("sysCompanyId")));
        requestVO.setSysBrandId(Long.valueOf(request.getHeader("sysBrandId")));
        requestVO.setTemplateCode(templateCode);
        requestVO.setMemberCode(memberCode);
        requestVO.setQuestionnaireType(questionnaireType);
        requestVO.setOrderNo(orderNo);
        requestVO.setMktTaskId(mktTaskId);
        return this.evaluationQuestionnaireFeign.queryQuestionnaireTemp(requestVO);
    }

    @PostMapping(value={"/addOrderEvaluate"})
    public ResponseData<String> addOrderEvaluate(@RequestBody QuestionnaireEvaluateRequestVO requestVO, HttpServletRequest request) {
        log.info("addOrderEvaluate#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)requestVO.getOrderNo())) {
            responseData.setMessage("\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (requestVO.getQuestionnaireType() != 1) {
            responseData.setMessage("\u975e\u8ba2\u5355\u95ee\u5377\u8bc4\u4ef7");
            responseData.setCode(-100);
            return responseData;
        }
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        Long sysBrandId = null;
        Long sysCompanyId = null;
        if (null != requestVO.getSourceType() && requestVO.getSourceType() == 2) {
            ResponseData aliPayResp = this.alipayPublicServiceFeign.getAlipayPublicByAppid(appid);
            log.info("addOrderEvaluate#aliPayResp:{}", (Object)JSON.toJSONString((Object)aliPayResp));
            sysBrandId = ((AlipayPublicPo)aliPayResp.getData()).getSysBrandId();
            sysCompanyId = ((AlipayPublicPo)aliPayResp.getData()).getSysCompanyId();
        } else {
            ResponseData wxPublicPo = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
            log.info("addOrderEvaluate#wxPublicPo:{}", (Object)JSON.toJSONString((Object)wxPublicPo));
            sysBrandId = ((WxPublicPO)wxPublicPo.getData()).getSysBrandId();
            sysCompanyId = ((WxPublicPO)wxPublicPo.getData()).getSysCompanyId();
        }
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724c\u7f16\u53f7\u672a\u83b7\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (sysCompanyId == null) {
            responseData.setMessage("\u4f01\u4e1a\u7f16\u53f7\u7f16\u53f7\u672a\u83b7\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        OrderModel orderModel = new OrderModel();
        orderModel.setBrandId(sysBrandId);
        orderModel.setMemberCode(memberCode);
        orderModel.setOrderNo(requestVO.getOrderNo());
        ResponseData orderResponseData = this.memberOrderApiService.queryOrderInfo(orderModel);
        if (orderResponseData.getCode() == 0 && ((OrderModel)orderResponseData.getData()).getEvaluateStatus() == 2) {
            responseData.setMessage("\u5df2\u6210\u529f\u8bc4\u4ef7\u8fc7\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        SaveQuestionnaireRequestVO saveQuestionnaireRequestVO = new SaveQuestionnaireRequestVO();
        saveQuestionnaireRequestVO.setSysCompanyId(sysCompanyId);
        saveQuestionnaireRequestVO.setSysBrandId(sysBrandId);
        saveQuestionnaireRequestVO.setOrderNo(requestVO.getOrderNo());
        saveQuestionnaireRequestVO.setTemplateCode(requestVO.getTemplateCode());
        ResponseData guideResp = this.staffServiceRpc.getStaffById(Long.valueOf(requestVO.getGuideId().intValue()));
        log.info("addOrderEvaluate#guideResp:{}", (Object)JacksonUtil.bean2Json((Object)guideResp));
        if (guideResp.getData() != null) {
            saveQuestionnaireRequestVO.setShopGuideCode(((SysStaffPo)guideResp.getData()).getStaffCode());
            saveQuestionnaireRequestVO.setShopGuideName(((SysStaffPo)guideResp.getData()).getStaffName());
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("addOrderEvaluate#singleMemberModel:{}", (Object)JacksonUtil.bean2Json((Object)singleMemberModel));
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        saveQuestionnaireRequestVO.setMemberCode(memberCode);
        saveQuestionnaireRequestVO.setMemberCardNo(member.getCardNo());
        saveQuestionnaireRequestVO.setMemberName(member.getName());
        saveQuestionnaireRequestVO.setMemberPhone(member.getPhone());
        saveQuestionnaireRequestVO.setStoreName(requestVO.getStoreName());
        saveQuestionnaireRequestVO.setSurveyQuestionnaireVO(requestVO.getSurveyQuestionnaireVO());
        ResponseData saveOrderQuestionnaireResp = this.evaluationQuestionnaireFeign.saveOrderQuestionnaire(saveQuestionnaireRequestVO);
        log.info("addOrderEvaluate#saveOrderQuestionnaireResp:{}", (Object)JacksonUtil.bean2Json((Object)saveOrderQuestionnaireResp));
        if (null == saveOrderQuestionnaireResp || SysResponseEnum.SUCCESS.getCode() != saveOrderQuestionnaireResp.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(null != saveOrderQuestionnaireResp ? saveOrderQuestionnaireResp.getMessage() : "\u4fdd\u5b58\u8ba2\u5355\u95ee\u5377\u8bc4\u4ef7\u9519\u8bef");
            return responseData;
        }
        MemberInfoModel executeActivityMemberInfo = new MemberInfoModel();
        executeActivityMemberInfo.setMemberCode(memberCode);
        executeActivityMemberInfo.setBrandId(sysBrandId);
        executeActivityMemberInfo.setDistributionCreateName("0");
        log.info("distributionCreateName:{}", (Object)executeActivityMemberInfo.getDistributionCreateName());
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        log.info("serviceStoreId:{},openCardStoreId:{}", (Object)serviceStoreId, (Object)openCardStoreId);
        executeActivityMemberInfo.setServiceStoreId(serviceStoreId);
        executeActivityMemberInfo.setOpenCardStoreId(openCardStoreId);
        executeActivityMemberInfo.setCreateDate(requestVO.getOrderTime());
        ResponseData executeActivityResp = this.activityServiceRpc.executeActivityEvaluation(executeActivityMemberInfo);
        log.info("addOrderEvaluate#executeActivityResp:{}", (Object)JacksonUtil.bean2Json((Object)executeActivityResp));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(saveOrderQuestionnaireResp.getData());
        return responseData;
    }

    @PostMapping(value={"/addTaskQuestionnaire"})
    public ResponseData<String> addTaskQuestionnaire(@RequestBody QuestionnaireEvaluateRequestVO requestVO, HttpServletRequest request) {
        log.info("addTaskQuestionnaire#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (null == requestVO.getMktTaskId()) {
            responseData.setMessage("\u4efb\u52a1ID\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (requestVO.getQuestionnaireType() != 2) {
            responseData.setMessage("\u975e\u8c03\u67e5\u95ee\u5377\u4efb\u52a1");
            responseData.setCode(-100);
            return responseData;
        }
        SaveQuestionnaireRequestVO saveQuestionnaireRequestVO = new SaveQuestionnaireRequestVO();
        saveQuestionnaireRequestVO.setSysCompanyId(Long.valueOf(request.getHeader("sysCompanyId")));
        saveQuestionnaireRequestVO.setSysBrandId(Long.valueOf(request.getHeader("sysBrandId")));
        saveQuestionnaireRequestVO.setTemplateCode(requestVO.getTemplateCode());
        saveQuestionnaireRequestVO.setMktTaskId(requestVO.getMktTaskId());
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("addTaskQuestionnaire#singleMemberModel:{}", (Object)JacksonUtil.bean2Json((Object)singleMemberModel));
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        saveQuestionnaireRequestVO.setMemberCode(memberCode);
        saveQuestionnaireRequestVO.setMemberCardNo(member.getCardNo());
        saveQuestionnaireRequestVO.setMemberName(member.getName());
        saveQuestionnaireRequestVO.setMemberPhone(member.getPhone());
        saveQuestionnaireRequestVO.setShopGuideCode(member.getServiceGuideCode());
        saveQuestionnaireRequestVO.setShopGuideName(member.getServiceGuideName());
        ResponseData storeVoResponseData = this.storeServiceRpc.getSysStoreById(member.getServiceStoreId());
        if (storeVoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            SysStoreVo sysStoreVo = (SysStoreVo)storeVoResponseData.getData();
            saveQuestionnaireRequestVO.setStoreName(sysStoreVo != null ? sysStoreVo.getStoreName() : "");
        }
        saveQuestionnaireRequestVO.setSurveyQuestionnaireVO(requestVO.getSurveyQuestionnaireVO());
        return this.evaluationQuestionnaireFeign.saveTaskQuestionnaire(saveQuestionnaireRequestVO);
    }

    @PostMapping(value={"/addCommonQuestionnaire"})
    public ResponseData<String> addCommonQuestionnaire(@RequestBody QuestionnaireEvaluateRequestVO requestVO, HttpServletRequest request) {
        log.info("addCommonQuestionnaire#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (requestVO.getQuestionnaireType() != 3) {
            responseData.setMessage("\u975e\u8c03\u67e5\u95ee\u5377\u6a21\u677f");
            responseData.setCode(-100);
            return responseData;
        }
        SaveQuestionnaireRequestVO saveQuestionnaireRequestVO = new SaveQuestionnaireRequestVO();
        saveQuestionnaireRequestVO.setSysCompanyId(Long.valueOf(request.getHeader("sysCompanyId")));
        saveQuestionnaireRequestVO.setSysBrandId(Long.valueOf(request.getHeader("sysBrandId")));
        saveQuestionnaireRequestVO.setTemplateCode(requestVO.getTemplateCode());
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("addCommonQuestionnaire#singleMemberModel:{}", (Object)JacksonUtil.bean2Json((Object)singleMemberModel));
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        saveQuestionnaireRequestVO.setMemberCode(memberCode);
        saveQuestionnaireRequestVO.setMemberCardNo(member.getCardNo());
        saveQuestionnaireRequestVO.setMemberName(member.getName());
        saveQuestionnaireRequestVO.setMemberPhone(member.getPhone());
        saveQuestionnaireRequestVO.setShopGuideCode(member.getServiceGuideCode());
        saveQuestionnaireRequestVO.setShopGuideName(member.getServiceGuideName());
        ResponseData storeVoResponseData = this.storeServiceRpc.getSysStoreById(member.getServiceStoreId());
        if (storeVoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            SysStoreVo sysStoreVo = (SysStoreVo)storeVoResponseData.getData();
            saveQuestionnaireRequestVO.setStoreName(sysStoreVo != null ? sysStoreVo.getStoreName() : "");
        }
        saveQuestionnaireRequestVO.setSurveyQuestionnaireVO(requestVO.getSurveyQuestionnaireVO());
        return this.evaluationQuestionnaireFeign.saveCommonQuestionnaire(saveQuestionnaireRequestVO);
    }
}

