/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.mj;

import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.baisonBase.facade.models.mj.QueryGiftRecordsResponseVo;
import com.bizvane.customized.facade.interfaces.CurMjGiftCardServiceFegin;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardConfigVo;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardRecordRequestVo;
import com.bizvane.customized.facade.models.vo.mj.CusMjGiftCardRequestVo;
import com.bizvane.fitmentservice.models.Rpc.AppletBrandFitmentRpc;
import com.bizvane.fitmentservice.models.vo.AppletBrandFitmentReqVo;
import com.bizvane.fitmentservice.models.vo.AppletBrandFitmentVo;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u68a6\u6d01\u793c\u54c1\u5361"})
@RestController
@RequestMapping(value={"mjGiftCard"})
public class MjGiftCardController {
    private static final Logger log = LoggerFactory.getLogger(MjGiftCardController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private CurMjGiftCardServiceFegin curMjGiftCardServiceFegin;
    @Autowired
    private AppletBrandFitmentRpc appletBrandFitmentRpc;

    @RequestMapping(value={"bindGiftCard"}, method={RequestMethod.POST})
    public ResponseData<String> bindGiftCard(@RequestBody CusMjGiftCardRequestVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.curMjGiftCardServiceFegin.bindGiftCard(vo);
        return responseData;
    }

    @RequestMapping(value={"getGiftCardConfig"}, method={RequestMethod.POST})
    public ResponseData<CurMjGiftCardConfigVo> getGiftCardConfig(@RequestBody CurMjGiftCardConfigVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.curMjGiftCardServiceFegin.getGiftCardConfig(vo);
        return responseData;
    }

    @RequestMapping(value={"getGiftCardFitment"}, method={RequestMethod.POST})
    public ResponseData<List<AppletBrandFitmentVo>> getGiftCardFitment(@RequestParam(value="moduleType", required=false, defaultValue="4") Integer moduleType, @RequestParam(value="navigationType", required=true) Integer navigationType, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        AppletBrandFitmentReqVo vo = new AppletBrandFitmentReqVo();
        vo.setSysCompanyId(sysCompanyId);
        vo.setSysBrandId(sysBrandId);
        vo.setNavigationType(navigationType);
        ArrayList<Integer> moduleTypeList = new ArrayList<Integer>();
        moduleTypeList.add(moduleType);
        vo.setModuleTypeList(moduleTypeList);
        responseData = this.appletBrandFitmentRpc.getAppletFitmentByVo(vo);
        return responseData;
    }

    @RequestMapping(value={"selectPage"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<QueryGiftRecordsResponseVo>> selectPage(@RequestBody CurMjGiftCardRecordRequestVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.curMjGiftCardServiceFegin.selectPage(vo);
        return responseData;
    }
}

