/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.alipay;

import com.bizvane.alipayfacade.interfaces.AlipayPublicServiceFeign;
import com.bizvane.alipayfacade.models.po.AlipayPublicPo;
import com.bizvane.appletservice.interfaces.alipay.AlipayLoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.vo.AlipayMbrRegisterRequestVo;
import com.bizvane.appletservice.models.vo.ElectCardConfigVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u767b\u5f55\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/alipayUser"})
public class AlipayLoginController {
    @Autowired
    private AlipayLoginService alipayLoginService;
    @Autowired
    private AlipayPublicServiceFeign alipayPublicServiceFeign;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getBrandIdByAppId"})
    public ResponseData<Long> getBrandIdByAppId(String appId) {
        logger.info("getBrandIdByAppId appid:{}", (Object)appId);
        ResponseData responseData = new ResponseData();
        ResponseData alipayPublicByAppid = this.alipayPublicServiceFeign.getAlipayPublicByAppid(appId);
        if (alipayPublicByAppid.getData() != null) {
            Long sysBrandId = ((AlipayPublicPo)alipayPublicByAppid.getData()).getSysBrandId();
            logger.info("getBrandIdByAppId sysBrandId={}", (Object)sysBrandId);
            responseData.setData((Object)sysBrandId);
        }
        return responseData;
    }

    @ApiOperation(value="byCodeNew\u65b0\u63a5\u53e3", notes="byCodeNew\u65b0\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="code", required=true), @ApiImplicitParam(name="appid", value="appid", required=true)})
    @GetMapping(value={"/getUserInfobyCode"})
    public ResponseData<AppletBrandMenberBo> getUserInfobyCode(@RequestParam(value="code") String code, @RequestParam(value="appid") String appid) {
        try {
            return this.alipayLoginService.getUserInfobyCode(code, appid);
        }
        catch (Exception exception) {
            return new ResponseData(100, exception.getMessage());
        }
    }

    @ApiOperation(value="byCodeNew\u65b0\u63a5\u53e3", notes="byCodeNew\u65b0\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appid", value="appid", required=true), @ApiImplicitParam(name="code", value="code", required=true), @ApiImplicitParam(name="phone", value="phone", required=true), @ApiImplicitParam(name="avatar", value="userInfoData", required=true), @ApiImplicitParam(name="gender", value="userInfoData", required=true), @ApiImplicitParam(name="nickName", value="userInfoData", required=true), @ApiImplicitParam(name="oderMemberCode", value="oderMemberCode", example="\u6ce8\u518c\u65f6\u6709\u63a8\u8350\u4eba\u65f6\u4f20\u5165"), @ApiImplicitParam(name="activityNo", value="activityNo", example="\u6d3b\u52a8\u5f00\u5361\u65f6\u4f20\u5165"), @ApiImplicitParam(name="mktTaskId", value="mktTaskId", example="\u9080\u8bf7\u5f00\u5361\u65f6\u4f20\u5165")})
    @PostMapping(value={"/getMbrAndOpenCard"})
    public ResponseData<AppletBrandMenberBo> getMbrAndOpenCard(HttpServletRequest request, AlipayMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        try {
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getOderMemberCode())) {
                wxMbrRegisteRequestVo.setOderMemberCode(null);
            }
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getMktTaskId())) {
                wxMbrRegisteRequestVo.setMktTaskId(null);
            }
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getActivityNo())) {
                wxMbrRegisteRequestVo.setActivityNo(null);
            }
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getActivityOrdersNo())) {
                wxMbrRegisteRequestVo.setActivityOrdersNo(null);
            }
            return this.alipayLoginService.getMbrAndOpenCard(request, wxMbrRegisteRequestVo);
        }
        catch (Exception exception) {
            return new ResponseData(100, exception.getMessage());
        }
    }

    @RequestMapping(value={"/getElectCardConfig"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<ElectCardConfigVo> getElectCardConfig(String appId) {
        ResponseData electCardConfig = this.alipayLoginService.getElectCardConfig(appId);
        return electCardConfig;
    }

    @ApiOperation(value="\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u5b8c\u6210,\u5269\u4f59\u4e1a\u52a1\u5904\u7406", notes="\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u5b8c\u6210,\u5269\u4f59\u4e1a\u52a1\u5904\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appid", value="appid", required=true), @ApiImplicitParam(name="unionId", value="unionId", required=true)})
    @PostMapping(value={"/businessAfterOpenCard"})
    public ResponseData<AppletBrandMenberBo> businessAfterOpenCard(HttpServletRequest request, @RequestBody AlipayMbrRegisterRequestVo alipayMbrRegisterRequestVo) {
        try {
            return this.alipayLoginService.businessAfterOpenCard(request, alipayMbrRegisterRequestVo);
        }
        catch (Exception exception) {
            logger.info("alipayLoginService#businessAfterOpenCard,\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            return new ResponseData(100, exception.getMessage());
        }
    }
}

