/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.AppletResponseStatusEnum;
import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.bo.WxPayLevelBO;
import com.bizvane.appletservice.models.vo.UpgradeAmountVO;
import com.bizvane.appletservice.models.vo.WxPayLevelCardRechargeRequestVO;
import com.bizvane.appletservice.utils.MathUtils;
import com.bizvane.appletserviceimpl.handler.AppletBizvaneException;
import com.bizvane.appletserviceimpl.impl.yw.YwHelper;
import com.bizvane.appletserviceimpl.utils.WxConfig;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.MemberLevelRechargeApiService;
import com.bizvane.members.facade.vo.MemberRechargeLevelRespVo;
import com.bizvane.members.facade.vo.PayLevelCardRequestVO;
import com.bizvane.members.facade.vo.PayLevelCardResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.jsonwebtoken.lang.Collections;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payLevelCard"})
public class WxPayLevelCardController {
    private static final Logger log = LoggerFactory.getLogger(WxPayLevelCardController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private MemberLevelRechargeApiService memberLevelRechargeApiService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private WxConfig wxConfig;
    @Autowired
    private WxPayService wxPayService;
    @Value(value="${yiWen.brandId}")
    private Long yiWenBrandId;
    @Autowired
    private YwHelper ywHelper;

    @PostMapping(value={"/createPayLevelRecharge"})
    public ResponseData<Map<String, String>> createPayLevelRecharge(@RequestBody @Valid WxPayLevelCardRechargeRequestVO rechargeRequestVO, HttpServletRequest request) {
        String key;
        log.info("enter createPayLevelRecharge rechargeRequestVO:{}", (Object)JacksonUtil.bean2Json((Object)rechargeRequestVO));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        Long sysBrandId = null;
        Long sysCompanyId = null;
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)memberCode)) {
            sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
            sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        }
        ResponseData mapResponseData = new ResponseData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bizvaneSessionId) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)memberCode) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)openId) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appId) || sysBrandId == null || sysCompanyId == null) {
            log.info("enter#createPayLevelRecharge,\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7,bizvaneSessionId={},memberCode={},openId={},appId={},sysBrandId={},sysCompanyId={}", new Object[]{bizvaneSessionId, memberCode, openId, appId, sysBrandId, sysCompanyId});
            mapResponseData.setCode(SysResponseEnum.FAILED.getCode());
            mapResponseData.setMessage("\u5fc5\u4f20\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
            return mapResponseData;
        }
        if (this.yiWenBrandId != null && this.yiWenBrandId.equals(sysBrandId)) {
            if (!Integer.valueOf(1).equals(rechargeRequestVO.getSkipVerifyYwShareGuideCodeType()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rechargeRequestVO.getYwShareGuideCode()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.ywHelper.getYwShareGuideCode(memberCode, null))) {
                log.info("\u4ed8\u8d39\u5361\u7b49\u7ea7\u8d2d\u4e70,\u6821\u9a8c\u4f9d\u6587\u5206\u4eab\u5bfc\u8d2d,\u524d\u7aef\u8bf7\u6c42\u6ca1\u6709\u6307\u5b9a\u8df3\u8fc7\u6821\u9a8c,\u4e14\u4f20\u8fc7\u6765\u624b\u8f93\u5bfc\u8d2d\u503c\u4e3a\u7a7a,\u4e14\u67e5\u7f13\u5b58\u5bfc\u8d2d\u4e3a\u7a7a,\u5219\u8fd4\u56de\u63d0\u793a,\u4f1a\u5458:{}", (Object)memberCode);
                mapResponseData.setCode(AppletResponseStatusEnum.PAY_LEVEL_VERIFY_YW_STAFF_CODE_CONFIRM.getCode());
                mapResponseData.setMessage(AppletResponseStatusEnum.PAY_LEVEL_VERIFY_YW_STAFF_CODE_CONFIRM.getMessage());
                return mapResponseData;
            }
            if (!Integer.valueOf(1).equals(rechargeRequestVO.getSkipVerifyYwShareGuideCodeType()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rechargeRequestVO.getYwShareGuideCode())) {
                ResponseData sysStaffPoRes = this.staffServiceRpc.getStaffInfoByCode(rechargeRequestVO.getYwShareGuideCode(), sysCompanyId);
                if (sysStaffPoRes != null && sysStaffPoRes.getData() != null) {
                    log.info("\u4ed8\u8d39\u5361\u7b49\u7ea7\u8d2d\u4e70,\u6821\u9a8c\u4f9d\u6587\u5206\u4eab\u5bfc\u8d2d,\u5bfc\u8d2d\u67e5\u8be2\u83b7\u53d6\u6210\u529f,\u4fdd\u5b58\u5206\u4eab\u5173\u7cfb,\u4f1a\u5458:{}", (Object)memberCode);
                    this.ywHelper.setYwShareGuideCode(rechargeRequestVO.getYwShareGuideCode(), memberCode, bizvaneSessionId);
                } else {
                    log.info("\u4ed8\u8d39\u5361\u7b49\u7ea7\u8d2d\u4e70,\u6821\u9a8c\u4f9d\u6587\u5206\u4eab\u5bfc\u8d2d,\u67e5\u8be2\u51fa\u6765\u5bfc\u8d2d\u4e0d\u5b58\u5728,\u5219\u8fd4\u56de\u63d0\u793a,\u4f1a\u5458:{}", (Object)memberCode);
                    mapResponseData.setCode(AppletResponseStatusEnum.PAY_LEVEL_VERIFY_YW_STAFF_CODE_CONFIRM.getCode());
                    mapResponseData.setMessage(AppletResponseStatusEnum.PAY_LEVEL_VERIFY_YW_STAFF_CODE_CONFIRM.getMessage());
                    return mapResponseData;
                }
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)rechargeRequestVO.getOrderMemberCode()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)rechargeRequestVO.getMktTaskId())) {
            String redisKey = String.format("payLevelInviterTask:%s", memberCode);
            String redisJson = String.format("{\"orderMemberCode\":\"%s\",\"mktTaskId\":\"%s\"}", rechargeRequestVO.getOrderMemberCode(), rechargeRequestVO.getMktTaskId());
            this.redisTemplateService.stringSetValueAndExpireTime((Object)redisKey, (Object)redisJson, 86400000L);
            log.info("\u8bbe\u7f6e\u5f53\u524d\u7528\u6237{},\u5bf9\u5e94orderMemberCode\u4e3a:{},mktTaskIde\u4e3a:{}", new Object[]{memberCode, rechargeRequestVO.getOrderMemberCode(), rechargeRequestVO.getMktTaskId()});
        }
        if (!this.redisTemplateService.setIfAbsent((Object)(key = "createPayLevelRecharge:" + appId + ":" + memberCode), (Object)"1")) {
            log.info("\u4ed8\u8d39\u4f1a\u5458\u5361\u5f00\u5361\u88ab\u9632\u91cd,key : {}", (Object)key);
            mapResponseData.setCode(SysResponseEnum.FAILED.getCode());
            mapResponseData.setMessage("\u5df2\u8bf7\u6c42,\u8bf7\u7a0d\u7b49");
            return mapResponseData;
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)key, (Object)"1", 5000L);
        MemberInfoModel singleMember = this.queryMemberInfo(memberCode);
        Map levelMap = this.getlevelMap(sysBrandId);
        this.validateStatus(rechargeRequestVO, singleMember, levelMap);
        log.info("singleMemberInfo:{}", (Object)JacksonUtil.bean2Json((Object)singleMember));
        MbrLevelModel levelModel = this.queryMbrLevelModel(rechargeRequestVO, levelMap, singleMember);
        WxPayLevelBO wxPayLevelBO = WxPayLevelBO.builder().appId(appId).sysCompanyId(sysCompanyId).sysBrandId(sysBrandId).memberCode(memberCode).memberName(singleMember.getName()).openId(openId).upgradeType(Boolean.valueOf(rechargeRequestVO.getStatus() != null && rechargeRequestVO.getStatus().equals(2))).build();
        if (wxPayLevelBO.getUpgradeType().booleanValue()) {
            log.info("\u5347\u7ea7\u4f1a\u5458\u5361\u7b49\u7ea7\uff0c\u8ba1\u7b97\u5347\u7ea7\u6240\u9700\u652f\u4ed8\u7684\u91d1\u989d");
            ResponseData memberRechargeLevelRes = this.memberLevelRechargeApiService.getMemberRechargeLevel(sysBrandId, memberCode, singleMember.getLevelId());
            log.info("\u5f53\u524d\u5361\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)memberRechargeLevelRes.getData()));
            UpgradeAmountVO upgradeAmountVO = MathUtils.calculateUpgradeAmount((MbrLevelModel)((MbrLevelModel)levelMap.get(singleMember.getLevelId())), (MbrLevelModel)levelModel, (Date)((MemberRechargeLevelRespVo)memberRechargeLevelRes.getData()).getEffectiveDate());
            wxPayLevelBO.setUpgradeAmount(upgradeAmountVO.getUpgradeAmount());
        }
        ResponseData mapRes = this.wxPayService.createPayLevelRecharge(levelModel, wxPayLevelBO);
        log.info("createPayLevelRecharge map:{}", (Object)JacksonUtil.bean2Json((Object)mapRes));
        mapResponseData.setCode(mapRes.getCode());
        mapResponseData.setMessage(mapRes.getMessage());
        mapResponseData.setData(mapRes.getData());
        return mapResponseData;
    }

    private Map<Long, MbrLevelModel> getlevelMap(Long sysBrandId) {
        ResponseData levelModelResponseData = this.memberLevelApiService.queryAllLevelList(sysBrandId);
        if (levelModelResponseData == null || SysResponseEnum.SUCCESS.getCode() != levelModelResponseData.getCode()) {
            throw new AppletBizvaneException("\u67e5\u8be2\u4ed8\u8d39\u5361\u4fe1\u606f\u5931\u8d25");
        }
        Map<Long, MbrLevelModel> levelMap = ((List)levelModelResponseData.getData()).stream().collect(Collectors.toMap(MbrLevelModel::getMbrLevelId, Function.identity()));
        if (Collections.isEmpty(levelMap)) {
            throw new AppletBizvaneException("\u8bf7\u914d\u7f6e\u4ed8\u8d39\u5361\u63cf\u8ff0\u4fe1\u606f");
        }
        return levelMap;
    }

    private void validateStatus(@RequestBody @Valid WxPayLevelCardRechargeRequestVO rechargeRequestVO, MemberInfoModel singleMember, Map<Long, MbrLevelModel> levelMap) {
        if (rechargeRequestVO.getStatus() != null) {
            MbrLevelModel memberLevel = levelMap.get(singleMember.getLevelId());
            MbrLevelModel payChangeLevel = levelMap.get(rechargeRequestVO.getMbrLevelId());
            if (rechargeRequestVO.getStatus().equals(0) && levelMap.containsKey(singleMember.getLevelId()) && levelMap.get(singleMember.getLevelId()).getPayFlag().equals(1)) {
                throw new AppletBizvaneException("\u5f53\u524d\u4f1a\u5458\u5df2\u7ecf\u662f\u4ed8\u8d39\u4f1a\u5458\u5361\u7b49\u7ea7");
            }
            if (rechargeRequestVO.getStatus().equals(1) && !rechargeRequestVO.getMbrLevelId().equals(singleMember.getLevelId())) {
                throw new AppletBizvaneException("\u7eed\u8d39\u4f1a\u5458\u5361\u7b49\u7ea7\u9a8c\u8bc1\u5931\u8d25");
            }
            if (rechargeRequestVO.getStatus().equals(2)) {
                if (memberLevel.getPayMoney().compareTo(payChangeLevel.getPayMoney()) >= 0) {
                    throw new AppletBizvaneException("\u5347\u7ea7\u4f1a\u5458\u5361\u7b49\u7ea7\u9a8c\u8bc1\u5931\u8d25");
                }
            } else if (this.yiWenBrandId != null && this.yiWenBrandId.equals(singleMember.getBrandId()) && Integer.valueOf(1).equals(rechargeRequestVO.getStatus()) && levelMap.get(singleMember.getLevelId()) != null && Integer.valueOf(1).equals(levelMap.get(singleMember.getLevelId()).getPayFlag())) {
                throw new AppletBizvaneException("\u60a8\u5f53\u524d\u5df2\u7ecf\u662f\u5c0a\u4eab\u4f1a\u5458\uff0c\u4e0d\u80fd\u91cd\u590d\u8d2d\u4e70\uff01");
            }
        }
    }

    private ResponseData<PayLevelCardResponseVO> queryPayLevelCardInfo(Long sysBrandId, Long sysCompanyId) {
        PayLevelCardRequestVO payLevelCardRequestVO = new PayLevelCardRequestVO();
        payLevelCardRequestVO.setSysCompanyId(sysCompanyId);
        payLevelCardRequestVO.setBrandId(sysBrandId);
        return this.memberLevelApiService.queryPayLevelCard(payLevelCardRequestVO);
    }

    private MbrLevelModel queryMbrLimitLevelModel(Long payBuyLimitLevel) {
        ResponseData levelModelResponseData = this.memberLevelApiService.queryLevelModel(payBuyLimitLevel);
        if (levelModelResponseData == null || levelModelResponseData.getData() == null) {
            return null;
        }
        if (SysResponseEnum.SUCCESS.getCode() != levelModelResponseData.getCode()) {
            throw new AppletBizvaneException("\u67e5\u8be2\u4ed8\u8d39\u5361\u4fe1\u606f\u5931\u8d25");
        }
        return (MbrLevelModel)levelModelResponseData.getData();
    }

    private MbrLevelModel queryMbrLevelModel(@RequestBody @Valid WxPayLevelCardRechargeRequestVO rechargeRequestVO, Map<Long, MbrLevelModel> levelMap, MemberInfoModel singleMember) {
        MbrLevelModel levelModel = levelMap.get(rechargeRequestVO.getMbrLevelId());
        if (levelModel.getPayFlag() == null || levelModel.getPayFlag() == 0) {
            throw new AppletBizvaneException("\u8be5\u7b49\u7ea7\u4e0d\u662f\u4ed8\u8d39\u5361\u7b49\u7ea7");
        }
        if (levelModel.getPayMoney() == null || levelModel.getPayMoney().compareTo(new BigDecimal(0)) <= 0) {
            throw new AppletBizvaneException("\u4ed8\u8d39\u5361\u7b49\u7ea7\u914d\u7f6e\u65e0\u6548");
        }
        if (levelModel.getEffectiveYear() == null || levelModel.getEffectiveYear() <= 0) {
            throw new AppletBizvaneException("\u4ed8\u8d39\u5361\u7b49\u7ea7\u6709\u6548\u671f\u65e0\u6548");
        }
        if (levelModel.getLevelChangeType() == null) {
            throw new AppletBizvaneException("\u4ed8\u8d39\u5361\u7b49\u7ea7\u5230\u671f\u540e\u5982\u4f55\u5904\u7406\u65e0\u6548");
        }
        if (levelModel.getPayBuyLimitEnable() == null || !levelModel.getPayBuyLimitEnable().equals(1)) {
            return levelModel;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)levelModel.getPayBuyLimitLevel())) {
            throw new AppletBizvaneException("\u5f53\u524d\u5361\u7b49\u7ea7\u6682\u4e0d\u53ef\u8d2d\u4e70");
        }
        String[] payBuyLimitLevel = StringUtils.commaDelimitedListToStringArray((String)levelModel.getPayBuyLimitLevel());
        List<String> payBuyLevelList = Arrays.asList(payBuyLimitLevel);
        if (!payBuyLevelList.contains(singleMember.getLevelId().toString())) {
            throw new AppletBizvaneException("\u5f53\u524d\u5361\u7b49\u7ea7\u6682\u4e0d\u53ef\u8d2d\u4e70");
        }
        return levelModel;
    }

    private MemberInfoModel queryMemberInfo(String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberRes = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberRes == null || singleMemberRes.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberRes.getData() == null) {
            throw new AppletBizvaneException("\u4f1a\u5458\u4fe1\u606f\u65e0\u6548");
        }
        return (MemberInfoModel)singleMemberRes.getData();
    }

    @PostMapping(value={"/payLevelCallBack"})
    public String payLevelCallBack(HttpServletRequest req, HttpServletResponse res) {
        return this.wxPayService.payLevelCallBack(req, res);
    }
}

