/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.AppletResponseStatusEnum;
import com.bizvane.appletservice.interfaces.UnionPayService;
import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.vo.CreateGitfCardOrderVo;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.centerstageservice.consts.ExplainConditionTypeEnum;
import com.bizvane.centerstageservice.models.po.MbrRechargeExplainPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.centerstageservice.models.vo.HqtCheckRechargeTimesRequestVO;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.customized.facade.interfaces.RechargeCardServiceFeign;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardPO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardRechargeVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeGiveVO;
import com.bizvane.customized.facade.models.vo.ur.StatisticsMbrRechargeCardRecordReqVo;
import com.bizvane.customized.facade.models.vo.ur.StatisticsMbrRechargeCardRecordVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.serviceCard.interfaces.GiftCardStandardServiceFeign;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardInfoDTO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5145\u503c", tags={"\u5fae\u4fe1\u5145\u503c"})
@RestController
@RequestMapping(value={"/wxPay"})
public class WxPayController {
    private static final Logger log = LoggerFactory.getLogger(WxPayController.class);
    private static final Logger logger = LoggerFactory.getLogger(WxPayController.class);
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RechargeCardServiceFeign rechargeCardServiceFeign;
    @Value(value="#{'${ur.brandId}'.split(',')}")
    private List<Long> brandId;
    @Value(value="#{'${hqt.specialRuleBrandIds}'.split(',')}")
    private List<Long> specialRuleBrandIds;
    @Value(value="${unionPay.brands}")
    private String unionPayBrands;
    @Value(value="${pay.salt}")
    private String paySalt;
    @Autowired
    private UnionPayService unionPayService;
    @Autowired
    private GiftCardStandardServiceFeign giftCardStandardServiceFeign;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    @ApiOperation(value="\u521b\u5efa\u5145\u503c\u5355", notes="\u521b\u5efa\u5145\u503c\u5355")
    @PostMapping(value={"/createRecharge"})
    public ResponseData createRecharge(CreateRechargeVO vo, HttpServletRequest request) {
        logger.info("createRecharge pararm:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData responseData = new ResponseData();
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if ("0".equals(vo.getMoney()) || StringUtils.isBlank((CharSequence)vo.getMoney())) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        String[] brands = this.unionPayBrands.split(",");
        if (Arrays.asList(brands).contains(String.valueOf(model.getBrandId()))) {
            return this.unionPayService.transit(vo, request);
        }
        ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        WxPayConfigPo wxConfig = (WxPayConfigPo)data.getData();
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        if (this.brandId.contains(wxConfig.getSysBrandId())) {
            CusUrRechargeCardPO cardPO;
            CusUrRechargeCardPO rechargeCardPO = CusUrRechargeCardPO.builder().sysBrandId(wxConfig.getSysBrandId()).sysCompanyId(wxConfig.getSysCompanyId()).memberCode(memberCode).build();
            ResponseData debitCardInfo = this.rechargeCardServiceFeign.queryDebitCardInfo(rechargeCardPO);
            if (CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData())) && (cardPO = (CusUrRechargeCardPO)((List)debitCardInfo.getData()).get(0)).getCardStatus() == 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u60a8\u6709\u4e00\u7b14\u9000\u6b3e\u6d41\u7a0b\u6b63\u5728\u5ba1\u6838\u4e2d");
                return responseData;
            }
            ResponseData rechargeConfig = this.rechargeCardServiceFeign.getRechargeConfig(wxConfig.getSysCompanyId(), wxConfig.getSysBrandId());
            if (rechargeConfig.getData() == null || rechargeConfig.getCode() == SysResponseEnum.FAILED.getCode()) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u914d\u7f6e\u5f02\u5e38");
                return responseData;
            }
            CusUrRechargeConfigVO configData = (CusUrRechargeConfigVO)rechargeConfig.getData();
            if (StringUtils.isNotBlank((CharSequence)configData.getRechargeJson())) {
                String rechargeJson = configData.getRechargeJson();
                List giveList = JSONObject.parseArray((String)rechargeJson, CusUrRechargeGiveVO.class);
                giveList.forEach(rechargeInfo -> {
                    if (rechargeInfo.getAmount().equals(Long.valueOf(vo.getMoney()))) {
                        vo.setGiveMoney(String.valueOf(rechargeInfo.getGiveAmount()));
                    }
                });
            }
            logger.info("ur vo:{}", JSON.toJSON((Object)vo));
            BigDecimal money = new BigDecimal(vo.getMoney());
            BigDecimal giveMoney = new BigDecimal(vo.getGiveMoney());
            BigDecimal giveLimitAmount = configData.getGiveLimitAmount().multiply(new BigDecimal("10000"));
            if (configData.getGiveAmount().add(giveMoney).compareTo(giveLimitAmount) > 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5f53\u524d\u5145\u503c\u989d\u5ea6\u5df2\u8d85\u9650\u989d\uff0c\u6682\u4e0d\u652f\u6301\u5145\u503c\u3002\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d4006-513-512");
                return responseData;
            }
            if (configData.getEveryDayLimit() == 1 && CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData()))) {
                if (debitCardInfo.getCode() == SysResponseEnum.FAILED.getCode()) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u5361\u5f02\u5e38");
                    return responseData;
                }
                List cardInfoList = (List)debitCardInfo.getData();
                CusUrRechargeCardPO cardInfo = (CusUrRechargeCardPO)cardInfoList.get(0);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                if (cardInfo.getLateRechargeDate() != null) {
                    if (!fmt.format(cardInfo.getLateRechargeDate()).equals(fmt.format(new Date()))) {
                        cardInfo.setOnDayRechargeAmount(new BigDecimal("0"));
                    }
                    if (cardInfo.getOnDayRechargeAmount().add(money).compareTo(configData.getEveryDayLimitAmount()) > 0) {
                        responseData.setCode(SysResponseEnum.FAILED.getCode());
                        responseData.setMessage("\u4e3a\u4e86\u60a8\u7684\u8d44\u91d1\u5b89\u5168\uff0c\u6bcf\u4eba\u6bcf\u5929\u9650\u5145\u503c" + configData.getEveryDayLimitAmount() + "\uff0c\u8c22\u8c22");
                        return responseData;
                    }
                }
            }
        }
        if (this.specialRuleBrandIds.contains(wxConfig.getSysBrandId())) {
            log.info("\u6821\u9a8c\u7ea2\u873b\u8713\u5145\u503c\u89c4\u5219\u5f00\u59cb");
            ResponseData checkResp = this.checkHqtSpecialRechargeTimes(vo, memberCode, wxConfig.getSysBrandId());
            log.info("checkHqtSpecialRechargeTimes#checkResp:{}", (Object)JacksonUtil.bean2Json((Object)checkResp));
            if (SysResponseEnum.SUCCESS.getCode() != checkResp.getCode() || BooleanUtils.isNotTrue((Boolean)((Boolean)checkResp.getData()))) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(checkResp.getMessage());
                return responseData;
            }
        }
        logger.info("\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), openId, appId});
        Map map = this.wxPayService.createRecharge(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    @ApiOperation(value="\u521b\u5efa\u5145\u503c\u5355 --\u65b0", notes="\u521b\u5efa\u5145\u503c\u5355")
    @PostMapping(value={"/createRechargeNew"})
    public ResponseData createRechargeNew(CreateRechargeVO vo, HttpServletRequest request) {
        logger.info("createRecharge pararm:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        String sign = vo.getSign();
        vo.setSign(null);
        String params = JSONObject.toJSONString((Object)vo);
        logger.info("createRechargeNew params:{}", (Object)(params + this.paySalt));
        String check = MD5Util.md5((String)(params + this.paySalt)).toUpperCase();
        logger.info("createRechargeNew check:{}", (Object)check);
        if (!sign.equals(check)) {
            responseData.setMessage("\u6076\u610f\u8bbf\u95ee");
            responseData.setCode(100);
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if ("0".equals(vo.getMoney()) || StringUtils.isBlank((CharSequence)vo.getMoney())) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String[] brands = this.unionPayBrands.split(",");
        if (Arrays.asList(brands).contains(String.valueOf(model.getBrandId()))) {
            return this.unionPayService.transit(vo, request);
        }
        if (StringUtils.isBlank((CharSequence)vo.getAppId()) || "null".equals(vo.getAppId())) {
            String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
            vo.setAppId(appId);
        }
        if (StringUtils.isBlank((CharSequence)vo.getOpenid()) || "null".equals(vo.getOpenid())) {
            String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
            vo.setOpenid(openId);
        }
        vo.setMemberCode(memberCode);
        if (this.brandId.contains(model.getBrandId())) {
            ResponseData checkUrEveryMonthRechargeLimitRes;
            CusUrRechargeCardPO cardPO;
            CusUrRechargeCardPO rechargeCardPO = CusUrRechargeCardPO.builder().sysBrandId(model.getBrandId()).sysCompanyId(model.getSysCompanyId()).memberCode(memberCode).build();
            ResponseData debitCardInfo = this.rechargeCardServiceFeign.queryDebitCardInfo(rechargeCardPO);
            if (CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData())) && (cardPO = (CusUrRechargeCardPO)((List)debitCardInfo.getData()).get(0)).getCardStatus() == 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u60a8\u6709\u4e00\u7b14\u9000\u6b3e\u6d41\u7a0b\u6b63\u5728\u5ba1\u6838\u4e2d");
                return responseData;
            }
            ResponseData rechargeConfig = this.rechargeCardServiceFeign.getRechargeConfig(model.getSysCompanyId(), model.getBrandId());
            if (rechargeConfig.getData() == null || rechargeConfig.getCode() == SysResponseEnum.FAILED.getCode()) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u914d\u7f6e\u5f02\u5e38");
                return responseData;
            }
            CusUrRechargeConfigVO configData = (CusUrRechargeConfigVO)rechargeConfig.getData();
            if (StringUtils.isNotBlank((CharSequence)configData.getRechargeJson())) {
                String rechargeJson = configData.getRechargeJson();
                List giveList = JSONObject.parseArray((String)rechargeJson, CusUrRechargeGiveVO.class);
                giveList.forEach(rechargeInfo -> {
                    if (rechargeInfo.getAmount().equals(Long.valueOf(vo.getMoney()))) {
                        vo.setGiveMoney(String.valueOf(rechargeInfo.getGiveAmount()));
                    }
                });
            }
            logger.info("ur vo:{}", JSON.toJSON((Object)vo));
            BigDecimal money = new BigDecimal(vo.getMoney());
            BigDecimal giveMoney = new BigDecimal(vo.getGiveMoney());
            BigDecimal giveLimitAmount = configData.getGiveLimitAmount().multiply(new BigDecimal("10000"));
            if (configData.getGiveAmount().add(giveMoney).compareTo(giveLimitAmount) > 0) {
                responseData.setCode(AppletResponseStatusEnum.RECHARGE_VERIFY_LIMIT.getCode());
                responseData.setMessage("\u5f53\u524d\u5145\u503c\u989d\u5ea6\u5df2\u8d85\u9650\u989d\uff0c\u6682\u4e0d\u652f\u6301\u5145\u503c\u3002\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d4006-513-512");
                return responseData;
            }
            if (configData.getEveryDayLimit() == 1 && CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData()))) {
                if (debitCardInfo.getCode() == SysResponseEnum.FAILED.getCode()) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u5361\u5f02\u5e38");
                    return responseData;
                }
                List cardInfoList = (List)debitCardInfo.getData();
                CusUrRechargeCardPO cardInfo = (CusUrRechargeCardPO)cardInfoList.get(0);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                if (cardInfo.getLateRechargeDate() != null) {
                    if (!fmt.format(cardInfo.getLateRechargeDate()).equals(fmt.format(new Date()))) {
                        cardInfo.setOnDayRechargeAmount(new BigDecimal("0"));
                    }
                    if (cardInfo.getOnDayRechargeAmount().add(money).compareTo(configData.getEveryDayLimitAmount()) > 0) {
                        responseData.setCode(AppletResponseStatusEnum.RECHARGE_VERIFY_LIMIT.getCode());
                        responseData.setMessage("\u4e3a\u4e86\u60a8\u7684\u8d44\u91d1\u5b89\u5168\uff0c\u6bcf\u4eba\u6bcf\u5929\u9650\u5145\u503c" + configData.getEveryDayLimitAmount() + "\uff0c\u8c22\u8c22");
                        return responseData;
                    }
                }
            }
            if ((checkUrEveryMonthRechargeLimitRes = this.checkUrEveryMonthRechargeLimit(vo, model, (List)debitCardInfo.getData(), configData)).getCode() != SysResponseEnum.SUCCESS.getCode()) {
                responseData.setCode(checkUrEveryMonthRechargeLimitRes.getCode());
                responseData.setMessage(checkUrEveryMonthRechargeLimitRes.getMessage());
                return responseData;
            }
        }
        if (this.specialRuleBrandIds.contains(model.getBrandId())) {
            log.info("\u6821\u9a8c\u7ea2\u873b\u8713\u5145\u503c\u89c4\u5219\u5f00\u59cb");
            ResponseData checkResp = this.checkHqtSpecialRechargeTimes(vo, memberCode, model.getBrandId());
            log.info("checkHqtSpecialRechargeTimes#checkResp:{}", (Object)JacksonUtil.bean2Json((Object)checkResp));
            if (SysResponseEnum.SUCCESS.getCode() != checkResp.getCode() || BooleanUtils.isNotTrue((Boolean)((Boolean)checkResp.getData()))) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(checkResp.getMessage());
                return responseData;
            }
        }
        logger.info("\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), vo.getOpenid(), vo.getAppId()});
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(model.getBrandId());
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        String giveMoneyString = vo.getGiveMoney();
        if (this.brandId.contains(brandPo.getSysBrandId()) && StringUtils.isNotEmpty((CharSequence)giveMoneyString) && !"0".equals(giveMoneyString)) {
            logger.info("UR\uff0c\u6821\u9a8c\u65b0\u652f\u4ed8\u914d\u7f6e\uff0c\u9632\u6b62\u8d60\u9001\u91d1\u989d\u6f0f\u6d1e");
            CusUrRechargeCardVO cardParam = new CusUrRechargeCardVO();
            cardParam.setSysCompanyId(model.getSysCompanyId());
            cardParam.setSysBrandId(model.getBrandId());
            cardParam.setMemberCode(memberCode);
            List rechargeGiveList = ((CusUrRechargeCardRechargeVO)this.rechargeCardServiceFeign.getRechargeCardRecharge(cardParam).getData()).getRechargeGiveList();
            boolean checkGive = false;
            if (CollectionUtils.isNotEmpty((Collection)rechargeGiveList)) {
                for (CusUrRechargeGiveVO giveVo : rechargeGiveList) {
                    if (!Long.valueOf(vo.getMoney()).equals(giveVo.getAmount())) continue;
                    vo.setGiveMoney(String.valueOf(giveVo.getGiveAmount()));
                    checkGive = true;
                }
            }
            logger.info("\u6821\u9a8c\u65b0\u652f\u4ed8\u914d\u7f6e\uff0c\u9632\u6b62\u8d60\u9001\u91d1\u989d\u6f0f\u6d1e:{}", (Object)JacksonUtil.bean2Json((Object)vo));
            if (!checkGive) {
                responseData.setMessage("\u8d60\u9001\u914d\u7f6e\u4e0d\u5b58\u5728");
                responseData.setCode(-1);
                return responseData;
            }
        }
        if (brandPo.getNewPayConfigSwitch().booleanValue()) {
            return this.wxPayService.createRechargeOrder(vo, brandPo, model);
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        WxPayConfigPo wxConfig = (WxPayConfigPo)data.getData();
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        Map map = this.wxPayService.createRecharge(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    private ResponseData checkUrEveryMonthRechargeLimit(CreateRechargeVO vo, MemberInfoModel model, List<CusUrRechargeCardPO> cusUrRechargeCardPOList, CusUrRechargeConfigVO configData) {
        log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{}", (Object)model.getMemberCode());
        if (configData.getEveryMonthLimitType() == null) {
            log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236\u4e3a\u7a7a", (Object)model.getMemberCode());
            return new ResponseData();
        }
        if (Integer.valueOf(0).equals(configData.getEveryMonthLimitType())) {
            log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236\u7c7b\u578b:{},\u4e3a\u4e0d\u9650", (Object)model.getMemberCode(), (Object)configData.getEveryMonthLimitType());
            return new ResponseData();
        }
        if (CollectionUtils.isEmpty(cusUrRechargeCardPOList)) {
            log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u4f1a\u5458\u65e0\u50a8\u503c\u5361\u53f7,\u5c5e\u9996\u6b21\u8d2d\u4e70,\u4e0d\u9650\u5236", (Object)model.getMemberCode());
            return new ResponseData();
        }
        BigDecimal rechargeMoney = new BigDecimal(vo.getMoney());
        if (Integer.valueOf(1).equals(configData.getEveryMonthLimitType()) && configData.getEveryMonthLimitAmount() != null && configData.getEveryMonthLimitAmount().compareTo(new BigDecimal(0)) > 0 && configData.getEveryMonthLimitCount() != null && configData.getEveryMonthLimitCount() > 0) {
            log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u5145\u503c\u91d1\u989d\u548c\u5145\u503c\u6b21\u6570\u9650\u5236\u7c7b\u578b,\u6bcf\u6708\u9650\u5236\u91d1\u989d:{},\u6bcf\u6708\u9650\u5236\u6b21\u6570:{}", new Object[]{model.getMemberCode(), configData.getEveryMonthLimitAmount(), configData.getEveryMonthLimitCount()});
            StatisticsMbrRechargeCardRecordReqVo statisticsMbrRechargeCardRecordReqVo = new StatisticsMbrRechargeCardRecordReqVo();
            statisticsMbrRechargeCardRecordReqVo.setSysCompanyId(model.getSysCompanyId());
            statisticsMbrRechargeCardRecordReqVo.setSysBrandId(model.getBrandId());
            statisticsMbrRechargeCardRecordReqVo.setMemberCode(model.getMemberCode());
            DateTime beginOfMonth = DateUtil.beginOfMonth((Date)new Date());
            statisticsMbrRechargeCardRecordReqVo.setSearchBeginTime((Date)(beginOfMonth != null ? beginOfMonth : new Date()));
            ResponseData statisticsMbrRechargeCardRecordVoRes = this.rechargeCardServiceFeign.statisticsUrMemberRecharge(statisticsMbrRechargeCardRecordReqVo);
            log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u5145\u503c\u91d1\u989d\u548c\u5145\u503c\u6b21\u6570\u9650\u5236\u7c7b\u578b,\u4f1a\u5458\u5386\u53f2\u7edf\u8ba1\u8d2d\u4e70\u91d1\u989d,\u8d2d\u4e70\u6b21\u6570\u7ed3\u679c:{}", (Object)model.getMemberCode(), (Object)JacksonUtil.bean2Json((Object)statisticsMbrRechargeCardRecordVoRes));
            Integer statisticRrechargeCount = 0;
            BigDecimal statisticRechargeAmount = new BigDecimal(0);
            if (statisticsMbrRechargeCardRecordVoRes != null && statisticsMbrRechargeCardRecordVoRes.getData() != null) {
                StatisticsMbrRechargeCardRecordVo statisticsMbrRechargeCardRecordVo = (StatisticsMbrRechargeCardRecordVo)statisticsMbrRechargeCardRecordVoRes.getData();
                statisticRrechargeCount = statisticsMbrRechargeCardRecordVo.getRechargeCount();
                statisticRechargeAmount = statisticsMbrRechargeCardRecordVo.getRechargeAmount();
            }
            if (configData.getEveryMonthLimitAmount() != null && configData.getEveryMonthLimitAmount().compareTo(new BigDecimal(0)) > 0 && statisticRechargeAmount.add(rechargeMoney).compareTo(configData.getEveryMonthLimitAmount()) > 0 && configData.getEveryMonthLimitCount() != null && configData.getEveryMonthLimitCount() > 0 && statisticRrechargeCount + 1 > configData.getEveryMonthLimitCount()) {
                log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u5145\u503c\u91d1\u989d\u548c\u5145\u503c\u6b21\u6570\u9650\u5236\u7c7b\u578b,\u6bcf\u6708\u9650\u5236\u91d1\u989d:{},\u6bcf\u6708\u9650\u5236\u6b21\u6570:{},(\u4f1a\u5458\u5386\u53f2\u7d2f\u8ba1+\u672c\u6b21\u8d2d\u4e70)\u7d2f\u8ba1\u91d1\u989d:{},(\u4f1a\u5458\u5386\u53f2\u7d2f\u8ba1+\u672c\u6b21\u8d2d\u4e70)\u6b21\u6570:{},\u8d85\u8fc7\u9650\u5236\u6761\u4ef6,\u4e0d\u5141\u8bb8\u8d2d\u4e70", new Object[]{model.getMemberCode(), configData.getEveryMonthLimitAmount(), configData.getEveryMonthLimitCount(), statisticRechargeAmount.add(rechargeMoney), statisticRrechargeCount + 1});
                return new ResponseData(AppletResponseStatusEnum.RECHARGE_VERIFY_LIMIT.getCode(), "\u6839\u636e\u5546\u52a1\u5c40\u5907\u6848\u7ba1\u7406\uff0c\u4f1a\u5458\u50a8\u503c\u5361\u81ea2023\u5e746\u67081\u65e5\u8d77\uff0c\u6bcf\u4e2a\u4f1a\u5458\u8d26\u6237\u6bcf\u6708\u9650\u5145\u503c" + configData.getEveryMonthLimitAmount() + "\u5143\uff0c\u9650\u5145\u503c" + configData.getEveryMonthLimitCount() + "\u6b21");
            }
        } else if (Integer.valueOf(2).equals(configData.getEveryMonthLimitType()) && (configData.getEveryMonthLimitAmount() != null && configData.getEveryMonthLimitAmount().compareTo(new BigDecimal(0)) > 0 || configData.getEveryMonthLimitCount() != null && configData.getEveryMonthLimitCount() > 0)) {
            log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u5145\u503c\u91d1\u989d\u6216\u5145\u503c\u6b21\u6570\u9650\u5236\u7c7b\u578b,\u6bcf\u6708\u9650\u5236\u91d1\u989d:{},\u6bcf\u6708\u9650\u5236\u6b21\u6570:{}", new Object[]{model.getMemberCode(), configData.getEveryMonthLimitAmount(), configData.getEveryMonthLimitCount()});
            StatisticsMbrRechargeCardRecordReqVo statisticsMbrRechargeCardRecordReqVo = new StatisticsMbrRechargeCardRecordReqVo();
            statisticsMbrRechargeCardRecordReqVo.setSysCompanyId(model.getSysCompanyId());
            statisticsMbrRechargeCardRecordReqVo.setSysBrandId(model.getBrandId());
            statisticsMbrRechargeCardRecordReqVo.setMemberCode(model.getMemberCode());
            DateTime beginOfMonth = DateUtil.beginOfMonth((Date)new Date());
            statisticsMbrRechargeCardRecordReqVo.setSearchBeginTime((Date)(beginOfMonth != null ? beginOfMonth : new Date()));
            ResponseData statisticsMbrRechargeCardRecordVoRes = this.rechargeCardServiceFeign.statisticsUrMemberRecharge(statisticsMbrRechargeCardRecordReqVo);
            log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u5145\u503c\u91d1\u989d\u6216\u5145\u503c\u6b21\u6570\u9650\u5236\u7c7b\u578b,\u4f1a\u5458\u5386\u53f2\u7edf\u8ba1\u8d2d\u4e70\u91d1\u989d,\u8d2d\u4e70\u6b21\u6570\u7ed3\u679c:{}", (Object)model.getMemberCode(), (Object)JacksonUtil.bean2Json((Object)statisticsMbrRechargeCardRecordVoRes));
            Integer statisticRrechargeCount = 0;
            BigDecimal statisticRechargeAmount = new BigDecimal(0);
            if (statisticsMbrRechargeCardRecordVoRes != null && statisticsMbrRechargeCardRecordVoRes.getData() != null) {
                StatisticsMbrRechargeCardRecordVo statisticsMbrRechargeCardRecordVo = (StatisticsMbrRechargeCardRecordVo)statisticsMbrRechargeCardRecordVoRes.getData();
                statisticRrechargeCount = statisticsMbrRechargeCardRecordVo.getRechargeCount();
                statisticRechargeAmount = statisticsMbrRechargeCardRecordVo.getRechargeAmount();
            }
            if (configData.getEveryMonthLimitAmount() != null && configData.getEveryMonthLimitAmount().compareTo(new BigDecimal(0)) > 0 && statisticRechargeAmount.add(rechargeMoney).compareTo(configData.getEveryMonthLimitAmount()) > 0) {
                log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u5145\u503c\u91d1\u989d\u6216\u5145\u503c\u6b21\u6570\u9650\u5236\u7c7b\u578b,\u6bcf\u6708\u9650\u5236\u91d1\u989d:{},(\u4f1a\u5458\u5386\u53f2\u7d2f\u8ba1+\u672c\u6b21\u8d2d\u4e70)\u603b\u91d1\u989d:{},\u8d85\u8fc7\u9650\u5236\u6761\u4ef6,\u4e0d\u5141\u8bb8\u8d2d\u4e70", new Object[]{model.getMemberCode(), configData.getEveryMonthLimitAmount(), statisticRechargeAmount.add(rechargeMoney)});
                return new ResponseData(AppletResponseStatusEnum.RECHARGE_VERIFY_LIMIT.getCode(), "\u6839\u636e\u5546\u52a1\u5c40\u5907\u6848\u7ba1\u7406\uff0c\u4f1a\u5458\u50a8\u503c\u5361\u81ea2023\u5e746\u67081\u65e5\u8d77\uff0c\u6bcf\u4e2a\u4f1a\u5458\u8d26\u6237\u6bcf\u6708\u9650\u5145\u503c" + configData.getEveryMonthLimitAmount() + "\u5143");
            }
            if (configData.getEveryMonthLimitCount() != null && configData.getEveryMonthLimitCount() > 0 && statisticRrechargeCount + 1 > configData.getEveryMonthLimitCount()) {
                log.info("\u6821\u9a8cUR\u6bcf\u4eba\u6bcf\u6708\u50a8\u503c\u9650\u5236,\u4f1a\u5458memberCode:{},\u5145\u503c\u91d1\u989d\u6216\u5145\u503c\u6b21\u6570\u9650\u5236\u7c7b\u578b,\u6bcf\u6708\u9650\u5236\u6b21\u6570:{},(\u4f1a\u5458\u5386\u53f2\u7d2f\u8ba1+\u672c\u6b21\u8d2d\u4e70)\u603b\u6b21\u6570:{},\u8d85\u8fc7\u9650\u5236\u6761\u4ef6,\u4e0d\u5141\u8bb8\u8d2d\u4e70", new Object[]{model.getMemberCode(), configData.getEveryMonthLimitCount(), statisticRrechargeCount + 1});
                return new ResponseData(AppletResponseStatusEnum.RECHARGE_VERIFY_LIMIT.getCode(), "\u6839\u636e\u5546\u52a1\u5c40\u5907\u6848\u7ba1\u7406\uff0c\u4f1a\u5458\u50a8\u503c\u5361\u81ea2023\u5e746\u67081\u65e5\u8d77\uff0c\u6bcf\u4e2a\u4f1a\u5458\u8d26\u6237\u6bcf\u6708\u9650\u5145\u503c" + configData.getEveryMonthLimitCount() + "\u6b21");
            }
        }
        return new ResponseData();
    }

    @ApiOperation(value="\u521b\u5efa\u793c\u54c1\u5361\u8ba2\u5355", notes="\u521b\u5efa\u793c\u54c1\u5361\u8ba2\u5355")
    @PostMapping(value={"/createGiftCardOrder"})
    public ResponseData createGiftCardOrder(@RequestBody CreateGitfCardOrderVo vo, HttpServletRequest request) {
        logger.info("createGiftCardOrder pararm:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)request.getHeader("authorizationSign"))) {
            responseData.setMessage("\u975e\u6cd5\u8bf7\u6c42");
            responseData.setCode(-100);
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        logger.info("\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), openId, appId});
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(model.getBrandId());
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        if (brandPo.getNewPayConfigSwitch().booleanValue()) {
            return this.wxPayService.createGiftCardOrderNew(vo, brandPo, model);
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        WxPayConfigPo wxConfig = (WxPayConfigPo)data.getData();
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        ReqGiftCardInfoDTO dto = new ReqGiftCardInfoDTO();
        dto.setCardGiftDefinitionId(Long.valueOf(Long.parseLong(vo.getServiceCardDefinitionId())));
        dto.setMemberCode(vo.getMemberCode());
        dto.setSysBrandId(vo.getSysBrandId());
        dto.setSysCompanyId(vo.getSysCompanyId());
        dto.setMemberName(model.getName());
        dto.setMomberPhone(model.getPhone());
        ResponseData gitfRes = this.giftCardStandardServiceFeign.saveCreateOrder(dto);
        log.info("\u8bf7\u6c42service-card\u521b\u5efa\u8ba2\u5355res:{}", (Object)JSON.toJSONString((Object)gitfRes));
        if (gitfRes.getCode() != 0 || StringUtils.isEmpty((CharSequence)((CharSequence)gitfRes.getData()))) {
            responseData.setCode(-1);
            responseData.setMessage("\u793c\u54c1\u5361\u670d\u52a1\u5f02\u5e38");
            return responseData;
        }
        JSONObject jsonObject = JSON.parseObject((String)((String)gitfRes.getData()));
        Long giftCardId = jsonObject.getLong("giftCardId");
        vo.setGiftCardId(giftCardId);
        vo.setSellPrice(jsonObject.getInteger("totalFee"));
        Map map = this.wxPayService.createGiftCardOrder(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    @PostMapping(value={"/callback"})
    public String callback(HttpServletRequest req, HttpServletResponse res) {
        return this.wxPayService.callback(req, res);
    }

    public static void main(String[] args) {
        String s = "{\"appId\":\"wxdbcca5299c27edff\",\"memberCode\":\"f5baf6778a534fad\",\"openid\":\"o19L94yo8F965Yn7okjtsKzYLXPI\",\"serviceCardDefinitionId\":\"240\",\"sysBrandId\":96,\"sysCompanyId\":3841}";
        String check = MD5Util.md5((String)(s + "1qaz2wsx3edc")).toUpperCase();
        System.out.println(check);
    }

    private ResponseData<Boolean> checkHqtSpecialRechargeTimes(CreateRechargeVO vo, String memberCode, Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        if (null == vo.getMbrRechargeExplainId() || StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("mbrRechargeExplainId or memberCode is empty, return true");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)Boolean.TRUE);
            return responseData;
        }
        if (null != vo.getMbrRechargeExplainId()) {
            MbrRechargeExplainPo mbrRechargeExplainPo;
            ResponseData explainResp = this.mbrRechargeServiceRpc.selectMbrRechargeExplainPOById(vo.getMbrRechargeExplainId());
            log.info("checkHqtSpecialRechargeTimes#explainResp:{}", (Object)JacksonUtil.bean2Json((Object)explainResp));
            if (null != explainResp && SysResponseEnum.SUCCESS.getCode() == explainResp.getCode() && null != explainResp.getData() && StringUtils.isNotBlank((CharSequence)(mbrRechargeExplainPo = (MbrRechargeExplainPo)explainResp.getData()).getErpActivityCode()) && ExplainConditionTypeEnum.SPECIAL_RULE.getType() == mbrRechargeExplainPo.getExplainConditionType().intValue()) {
                log.info("\u7279\u6b8a\u89c4\u5219\uff0c\u4f1a\u5458\u5145\u503c\u6b21\u6570\u6821\u9a8cid:{},erpActivityCode:{},memberCode:{}", new Object[]{mbrRechargeExplainPo.getMbrRechargeExplainId(), mbrRechargeExplainPo.getErpActivityCode(), memberCode});
                String explainRedisKey = "hqt_recharge_" + mbrRechargeExplainPo.getMbrRechargeExplainId() + "erpCode_" + mbrRechargeExplainPo.getErpActivityCode() + "_memberCode_" + memberCode;
                if (!this.redisTemplateService.setIfAbsent((Object)explainRedisKey, (Object)DateUtil.date().toDateStr())) {
                    log.info("\u63a5\u53e3\u5e76\u53d1\u5904\u7406,\u64cd\u4f5c\u7e41\u5fd9,\u4f1a\u5458memberCode:{}", (Object)memberCode);
                    responseData.setCode(203);
                    responseData.setMessage("\u64cd\u4f5c\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e!");
                    return responseData;
                }
                this.redisTemplateService.stringSetValueAndExpireTime((Object)explainRedisKey, (Object)"executing", 2000L);
                log.info("\u63a5\u53e3\u5e76\u53d1\u5904\u7406,\u8bbe\u7f6eredis\u8fc7\u671f\u65f6\u95f42s");
                HqtCheckRechargeTimesRequestVO hqtCheckRechargeTimesRequestVO = new HqtCheckRechargeTimesRequestVO();
                hqtCheckRechargeTimesRequestVO.setSysBrandId(sysBrandId);
                hqtCheckRechargeTimesRequestVO.setMemberCode(memberCode);
                hqtCheckRechargeTimesRequestVO.setStoreId(vo.getSysStoreId());
                hqtCheckRechargeTimesRequestVO.setMbrRechargeExplainId(mbrRechargeExplainPo.getMbrRechargeExplainId());
                hqtCheckRechargeTimesRequestVO.setErpActivityCode(mbrRechargeExplainPo.getErpActivityCode());
                hqtCheckRechargeTimesRequestVO.setOrganizationCode(mbrRechargeExplainPo.getOrganizationCode());
                ResponseData checkRechargeResp = this.mbrRechargeServiceRpc.checkHqtMemberRechargeTimes(hqtCheckRechargeTimesRequestVO);
                log.info("checkRechargeResp:{}", (Object)JacksonUtil.bean2Json((Object)checkRechargeResp));
                if (null == checkRechargeResp || SysResponseEnum.SUCCESS.getCode() != checkRechargeResp.getCode() || BooleanUtils.isNotTrue((Boolean)((Boolean)checkRechargeResp.getData()))) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u4e0d\u6ee1\u8db3\u5c0f\u989d\u50a8\u503c\u6761\u4ef6");
                    return responseData;
                }
            }
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)Boolean.TRUE);
        return responseData;
    }
}

