/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import cn.hutool.core.date.DateUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.UnionPayService;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletservice.models.vo.UnionPayCallBackVO;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.centerstageservice.consts.ExplainConditionTypeEnum;
import com.bizvane.centerstageservice.models.po.MbrRechargeExplainPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.HqtCheckRechargeTimesRequestVO;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay"})
public class PayController {
    private static final Logger log = LoggerFactory.getLogger(PayController.class);
    @Autowired
    private UnionPayService unionPayService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    BrandServiceRpc brandServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Value(value="${unionPay.brands}")
    private String unionPayBrands;
    @Value(value="${pay.salt}")
    private String paySalt;
    @Value(value="#{'${hqt.specialRuleBrandIds}'.split(',')}")
    private List<Long> specialRuleBrandIds;

    @PostMapping(value={"/createRechargeOrder"})
    public ResponseData createRechargeOrder(@RequestBody CreateRechargeVO vo, HttpServletRequest request) {
        log.info("PayController-createRechargeOrder-info,requestVO:{}", JSONObject.toJSON((Object)vo));
        ResponseData responseData = new ResponseData();
        String sign = vo.getSign();
        vo.setSign(null);
        String params = com.alibaba.fastjson.JSONObject.toJSONString((Object)vo);
        log.info("PayController-createRechargeOrder-info,params:{}", (Object)(params + this.paySalt));
        String check = MD5Util.md5((String)(params + this.paySalt)).toUpperCase();
        log.info("PayController-createRechargeOrder-info,check:{}", (Object)check);
        if (!sign.equals(check)) {
            responseData.setMessage("\u6076\u610f\u8bbf\u95ee");
            responseData.setCode(100);
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u65e0bizvaneSessionId");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getMoney()) || new BigDecimal(vo.getMoney()).compareTo(new BigDecimal("0")) <= 0) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(Long.valueOf(sysBrandId));
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        if (!brandPo.getNewPayConfigSwitch().booleanValue() && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{brandPo.getBizvaneMid(), brandPo.getBizvaneSecretKey()})) {
            responseData.setMessage("\u5546\u6237\u94f6\u8054\u652f\u4ed8\u4fe1\u606f\u672a\u914d\u7f6e");
            responseData.setCode(-100);
            return responseData;
        }
        if (this.specialRuleBrandIds.contains(Long.valueOf(sysBrandId))) {
            ResponseData storePORes;
            ResponseData checkResp = this.checkHqtSpecialRechargeTimes(vo, memberCode, Long.valueOf(sysBrandId));
            log.info("PayController-createRechargeOrder-info,unionPay\u6821\u9a8c\u7ea2\u873b\u8713\u5145\u503c\u89c4\u5219,checkResp:{}", (Object)JacksonUtil.bean2Json((Object)checkResp));
            if (SysResponseEnum.SUCCESS.getCode() != checkResp.getCode() || BooleanUtils.isNotTrue((Boolean)((Boolean)checkResp.getData()))) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(checkResp.getMessage());
                return responseData;
            }
            if (vo.getSysStoreId() != null && (storePORes = this.storeServiceRpc.getStoreById(vo.getSysStoreId())) != null && storePORes.getCode() == SysResponseEnum.SUCCESS.getCode() && storePORes.getData() != null && !Objects.equals(((SysStorePo)storePORes.getData()).getStatus(), true)) {
                log.info("PayController-createRechargeOrder-info,\u5145\u503c\u5e97\u94fa\u4fe1\u606f:{}", (Object)JacksonUtil.bean2Json((Object)storePORes));
                responseData.setMessage("\u5f53\u524d\u5145\u503c\u7801\u5df2\u5931\u6548");
                responseData.setCode(100);
                return responseData;
            }
        }
        return this.unionPayService.createRechargeOrder(vo, brandPo, model, appId);
    }

    @PostMapping(value={"/unionRechargeCallBack"})
    public ResponseData<String> unionRechargeCallBack(@RequestBody UnionPayCallBackVO params) {
        log.info("PayController-unionRechargeCallBack-info,params:{}", (Object)JSONObject.toJSONString((Object)params));
        ResponseData stringResponseData = new ResponseData();
        try {
            stringResponseData = this.unionPayService.unionRechargeCallBack(params);
        }
        catch (Exception e) {
            log.error("PayController-unionRechargeCallBack-info,exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            stringResponseData.setCode(SysResponseEnum.FAILED.getCode());
            stringResponseData.setMessage(SysResponseEnum.FAILED.getMessage());
            stringResponseData.setData((Object)"FAIL");
        }
        return stringResponseData;
    }

    private ResponseData<Boolean> checkHqtSpecialRechargeTimes(CreateRechargeVO vo, String memberCode, Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        if (null == vo.getMbrRechargeExplainId() || StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("unionPay mbrRechargeExplainId or memberCode is empty, return true");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)Boolean.TRUE);
            return responseData;
        }
        if (null != vo.getMbrRechargeExplainId()) {
            MbrRechargeExplainPo mbrRechargeExplainPo;
            ResponseData explainResp = this.mbrRechargeServiceRpc.selectMbrRechargeExplainPOById(vo.getMbrRechargeExplainId());
            log.info("unionPay#checkHqtSpecialRechargeTimes#explainResp:{}", (Object)JacksonUtil.bean2Json((Object)explainResp));
            if (null != explainResp && SysResponseEnum.SUCCESS.getCode() == explainResp.getCode() && null != explainResp.getData() && StringUtils.isNotBlank((CharSequence)(mbrRechargeExplainPo = (MbrRechargeExplainPo)explainResp.getData()).getErpActivityCode()) && ExplainConditionTypeEnum.SPECIAL_RULE.getType() == mbrRechargeExplainPo.getExplainConditionType().intValue()) {
                log.info("unionPay\u7279\u6b8a\u89c4\u5219\uff0c\u4f1a\u5458\u5145\u503c\u6b21\u6570\u6821\u9a8cid:{},erpActivityCode:{},memberCode:{}", new Object[]{mbrRechargeExplainPo.getMbrRechargeExplainId(), mbrRechargeExplainPo.getErpActivityCode(), memberCode});
                String explainRedisKey = "hqt_recharge_" + mbrRechargeExplainPo.getMbrRechargeExplainId() + "erpCode_" + mbrRechargeExplainPo.getErpActivityCode() + "_memberCode_" + memberCode;
                if (!this.redisTemplateService.setIfAbsent((Object)explainRedisKey, (Object)DateUtil.date().toDateStr())) {
                    log.info("unionPay\u63a5\u53e3\u5e76\u53d1\u5904\u7406,\u64cd\u4f5c\u7e41\u5fd9,\u4f1a\u5458memberCode:{}", (Object)memberCode);
                    responseData.setCode(203);
                    responseData.setMessage("\u64cd\u4f5c\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e!");
                    return responseData;
                }
                this.redisTemplateService.stringSetValueAndExpireTime((Object)explainRedisKey, (Object)"executing", 2000L);
                log.info("unionPay\u63a5\u53e3\u5e76\u53d1\u5904\u7406,\u8bbe\u7f6eredis\u8fc7\u671f\u65f6\u95f42s");
                HqtCheckRechargeTimesRequestVO hqtCheckRechargeTimesRequestVO = new HqtCheckRechargeTimesRequestVO();
                hqtCheckRechargeTimesRequestVO.setSysBrandId(sysBrandId);
                hqtCheckRechargeTimesRequestVO.setMemberCode(memberCode);
                hqtCheckRechargeTimesRequestVO.setStoreId(vo.getSysStoreId());
                hqtCheckRechargeTimesRequestVO.setMbrRechargeExplainId(mbrRechargeExplainPo.getMbrRechargeExplainId());
                hqtCheckRechargeTimesRequestVO.setErpActivityCode(mbrRechargeExplainPo.getErpActivityCode());
                hqtCheckRechargeTimesRequestVO.setOrganizationCode(mbrRechargeExplainPo.getOrganizationCode());
                ResponseData checkRechargeResp = this.mbrRechargeServiceRpc.checkHqtMemberRechargeTimes(hqtCheckRechargeTimesRequestVO);
                log.info("unionPay#checkRechargeResp:{}", (Object)JacksonUtil.bean2Json((Object)checkRechargeResp));
                if (null == checkRechargeResp || SysResponseEnum.SUCCESS.getCode() != checkRechargeResp.getCode() || BooleanUtils.isNotTrue((Boolean)((Boolean)checkRechargeResp.getData()))) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u4e0d\u6ee1\u8db3\u5c0f\u989d\u50a8\u503c\u6761\u4ef6");
                    return responseData;
                }
            }
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)Boolean.TRUE);
        return responseData;
    }
}

