/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.MktActivityPointsLootService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.centerstageservice.consts.SysConfigKeyEnum;
import com.bizvane.centerstageservice.models.po.SysConfigsPo;
import com.bizvane.centerstageservice.rpc.SysConfigsServiceRpc;
import com.bizvane.mktcenterservice.models.vo.MktActivityPointsLootRequestVo;
import com.bizvane.mktcenterservice.models.vo.MktActivityPointsLootVo;
import com.bizvane.mktcenterservice.models.vo.MktActivityPrizeRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktMbrPrizeRecordVo;
import com.bizvane.mktcenterservice.rpc.MktActivityPointsLootServiceRpc;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mktActivityPointsLoot"})
public class MktActivityPointsLootController {
    @Autowired
    private MktActivityPointsLootService mktActivityPointsLootService;
    @Autowired
    private MktActivityPointsLootServiceRpc mktActivityPointsLootServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private SysConfigsServiceRpc sysConfigsServiceRpc;

    @RequestMapping(value={"/participationActivity"}, method={RequestMethod.POST})
    public ResponseData<String> participationActivity(@RequestBody MktActivityPointsLootRequestVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.mktActivityPointsLootServiceRpc.participationActivity(vo);
        return responseData;
    }

    @RequestMapping(value={"/selectActivityDetail"}, method={RequestMethod.POST})
    public ResponseData<MktActivityPointsLootVo> selectActivityDetail(@RequestBody MktActivityPointsLootRequestVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.mktActivityPointsLootServiceRpc.selectActivityDetail(vo);
        return responseData;
    }

    @RequestMapping(value={"/selectDrawPrizeRecord"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<MktActivityPrizeRecordVO>> selectDrawPrizeRecord(@RequestBody MktActivityPointsLootRequestVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.mktActivityPointsLootService.selectDrawPrizeRecord(vo);
        return responseData;
    }

    @RequestMapping(value={"/selectParticipationActivityRecord"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<MktMbrPrizeRecordVo>> selectParticipationActivityRecord(@RequestBody MktActivityPointsLootRequestVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.mktActivityPointsLootServiceRpc.selectParticipationActivityRecord(vo);
        return responseData;
    }

    @RequestMapping(value={"/selectFitMbrActivityList"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<MktActivityPointsLootVo>> selectFitMbrActivityList(@RequestBody MktActivityPointsLootRequestVo vo, HttpServletRequest request) {
        ResponseData responseData = null;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData = new ResponseData(-100, "\u4f1a\u5458\u4e3a\u7a7a");
            return responseData;
        }
        vo.setMemberCode(memberCode);
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        vo.setSysBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        responseData = this.mktActivityPointsLootServiceRpc.selectFitMbrActivityList(vo);
        return responseData;
    }

    @RequestMapping(value={"/selectRule"}, method={RequestMethod.POST})
    public ResponseData<SysConfigsPo> selectRule() {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        String key = SysConfigKeyEnum.MJ_POINT_LOOT_RULE_KEY.getConfigKey();
        return this.sysConfigsServiceRpc.getConfigsByBrandAndKey2(memberResourceBO.getBrandId(), key);
    }
}

