/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.fitmentservice.models.Rpc.MbrCenterThemeRpc;
import com.bizvane.fitmentservice.models.po.AppletBrandThemePO;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.vo.ActivityInfoResponseVO;
import com.bizvane.mktcenterservice.models.vo.MktActivityRecordRequestVO;
import com.bizvane.mktcenterservice.models.vo.MktActivityRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktActivitySignInDayVO;
import com.bizvane.mktcenterservice.models.vo.MktActivitySignInRequestVO;
import com.bizvane.mktcenterservice.models.vo.MktActivitySignMemberVO;
import com.bizvane.mktcenterservice.models.vo.MktAppletActivitySignInPrizeInfoVO;
import com.bizvane.mktcenterservice.models.vo.MktAppletActivitySignInRecordVO;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/menberCenterRigister"})
public class MenberCenterRigisterController {
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MbrCenterThemeRpc mbrCenterThemeRpc;
    @Autowired
    private RedissonTemplate redissonTemplate;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @PostMapping(value={"getSignInDays"})
    public ResponseData<MktActivitySignInDayVO> getSignInDays(MktActivitySignInRequestVO requestVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        requestVO.setMemberCode(memberCode);
        if (requestVO.getMemberCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
            return responseData;
        }
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        requestVO.setSysBrandId(sysBrandId);
        return this.activityServiceRpc.getSignInDays(requestVO);
    }

    @PostMapping(value={"getActivityInfo"})
    public ResponseData<ActivityInfoResponseVO> getActivityInfo(MktActivitySignInRequestVO requestVO) {
        return this.activityServiceRpc.getActivityInfo(requestVO);
    }

    @RequestMapping(value={"/getActivityRecordPOList"}, method={RequestMethod.POST})
    public ResponseData getActivityRecordPoList(MktActivityRecordVO vo, HttpServletRequest request) {
        logger.info("MenberCenterRigisterController-getActivityRecordPOList-info,request:{}", (Object)JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        if (vo.getMemberCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(-100);
            responseData.setMessage("\u83b7\u53d6\u4f01\u4e1a\u54c1\u724c\u9519\u8bef");
            return responseData;
        }
        vo.setSysBrandId(Long.valueOf(sysBrandId));
        ResponseData response = this.activityServiceRpc.getActivityRecordPOList(vo);
        logger.info("MenberCenterRigisterController-getActivityRecordPOList-info,response:{}", (Object)JSON.toJSONString((Object)response));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/executeActivitySignin"}, method={RequestMethod.POST})
    public ResponseData<Integer> executeActivitySignin(MktActivitySignMemberVO memberInfoModel, HttpServletRequest request) {
        logger.info("MenberCenterRigisterController-executeActivitySignin-info,request:{}", (Object)JSON.toJSONString((Object)memberInfoModel));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        try {
            logger.info("MenberCenterRigisterController-executeActivitySignin-info,memberCode lock:{}", (Object)memberCode);
            this.redissonTemplate.getRLock(memberCode, 30L, TimeUnit.SECONDS);
            memberInfoModel.setMemberCode(memberCode);
            if (memberInfoModel.getMemberCode() == null) {
                responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
                ResponseData responseData2 = responseData;
                return responseData2;
            }
            if (memberInfoModel.getBrandId() == null) {
                responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724c\u7f16\u53f7");
                ResponseData responseData3 = responseData;
                return responseData3;
            }
            Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
            logger.info("serviceStoreId:{} , openCardStoreId:{}", (Object)serviceStoreId, (Object)openCardStoreId);
            memberInfoModel.setServiceStoreId(serviceStoreId);
            memberInfoModel.setOpenCardStoreId(openCardStoreId);
            logger.info("MenberCenterRigisterController-executeActivitySignin-info,sign request:{}", (Object)JSON.toJSONString((Object)memberInfoModel));
            ResponseData data = this.activityServiceRpc.executeActivitySignin(memberInfoModel);
            logger.info("MenberCenterRigisterController-executeActivitySignin-info,sign response:{}", (Object)JSON.toJSONString((Object)data));
            if (data.getCode() == 0) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setData(data.getData());
            } else {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(StringUtils.isNotBlank((CharSequence)data.getMessage()) ? data.getMessage() : "\u7b7e\u5230\u5931\u8d25\uff01");
            }
        }
        finally {
            this.redissonTemplate.getRUnLook(memberCode);
            logger.info("MenberCenterRigisterController-executeActivitySignin-info,memberCode unlock:{}", (Object)memberCode);
        }
        logger.info("MenberCenterRigisterController-executeActivitySignin-info,response:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    @RequestMapping(value={"/getThemeStyleByBrand"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<String> getThemeStyleByBrand(Long sysBrandId) {
        logger.info("MenberCenterRigisterController getThemeStyleByBrand sysBrandId:{}", (Object)sysBrandId);
        ResponseData responseData = new ResponseData();
        ResponseData themePoResponseData = this.mbrCenterThemeRpc.getThemeOrBranId(sysBrandId);
        if (themePoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            AppletBrandThemePO brandThemePo = (AppletBrandThemePO)themePoResponseData.getData();
            responseData.setData((Object)brandThemePo.getThemeStyle());
            logger.info("getThemeStyleByBrand ThemeStyle:{}", (Object)brandThemePo.getThemeStyle());
        }
        return responseData;
    }

    @RequestMapping(value={"/getIsSignAble"}, method={RequestMethod.POST})
    public ResponseData<Boolean> getIsSignAble(MktActivitySignMemberVO memberInfoModel, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String sysCompanyId = request.getHeader("sysCompanyId");
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysCompanyId) || StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(-100);
            responseData.setMessage("\u83b7\u53d6\u4f01\u4e1a\u54c1\u724c\u9519\u8bef");
            return responseData;
        }
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setServiceStoreId(serviceStoreId);
        memberInfoModel.setOpenCardStoreId(openCardStoreId);
        memberInfoModel.setSysCompanyId(Long.valueOf(sysCompanyId));
        memberInfoModel.setBrandId(Long.valueOf(sysBrandId));
        return this.activityServiceRpc.getIsSignAble(memberInfoModel);
    }

    @PostMapping(value={"getActivitySignInPrizeInfo"})
    public ResponseData<MktAppletActivitySignInPrizeInfoVO> getActivitySignInPrizeInfo(MktActivityRecordVO vo, HttpServletRequest request) {
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        vo.setSysBrandId(sysBrandId);
        return this.activityServiceRpc.getActivitySignInPrizeInfo(vo);
    }

    @PostMapping(value={"selectSignInRecordInfoPage"})
    public ResponseData<PageInfo<MktAppletActivitySignInRecordVO>> selectSignInRecordInfoPage(MktActivityRecordRequestVO requestVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(-100);
            responseData.setMessage("\u83b7\u53d6\u4f01\u4e1a\u54c1\u724c\u9519\u8bef");
            return responseData;
        }
        requestVO.setSysBrandId(Long.valueOf(sysBrandId));
        requestVO.setMemberCode(memberCode);
        return this.activityServiceRpc.selectSignInRecordInfoPage(requestVO);
    }
}

