/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.MemberInvitedService;
import com.bizvane.appletservice.interfaces.MemberLotteryService;
import com.bizvane.appletservice.models.bo.AppletBrandFunctionBo;
import com.bizvane.appletservice.models.bo.AppletTaskWXBO;
import com.bizvane.appletservice.models.vo.SubscribeMsgAuthResponseVO;
import com.bizvane.appletserviceimpl.impl.WeChatAppletSubscribeCommonServiceImpl;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.customized.facade.interfaces.EvaluationQuestionnaireFeign;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderDetailPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.vo.CusUrMbrQuestionnaireTemplateVO;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.CompanyMemberInfoBo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.messagefacade.enums.WeChatSubscribeMenuEnum;
import com.bizvane.mktcenterservice.models.bo.TaskQuestionnaireRewardBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXDetailBO;
import com.bizvane.mktcenterservice.models.vo.MktTaskMbrDefVO;
import com.bizvane.mktcenterservice.models.vo.TaskForWXVO;
import com.bizvane.mktcenterservice.models.vo.TaskVO;
import com.bizvane.mktcenterservice.rpc.MktTaskMbrDefRpc;
import com.bizvane.mktcenterservice.rpc.TaskQuestionnaireServiceRpc;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberTask"})
public class MemberTaskController {
    @Autowired
    private TaskServiceForWXRpc taskServiceForWxRpc;
    @Autowired
    private MktTaskMbrDefRpc mktTaskMbrDefRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInvitedService memberInvitedService;
    @Autowired
    private TaskQuestionnaireServiceRpc taskQuestionnaireServiceRpc;
    @Autowired
    private EvaluationQuestionnaireFeign evaluationQuestionnaireFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private WeChatAppletSubscribeCommonServiceImpl weChatAppletSubscribeCommonService;
    @Autowired
    private MemberLotteryService memberLotteryService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getMemberTask"}, method={RequestMethod.POST})
    public ResponseData getMemberTask(TaskForWXVO taskForWXvo, HttpServletRequest request) {
        logger.info("\u4f1a\u5458\u4efb\u52a1\u5217\u8868\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)taskForWXvo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String sysBrandId = request.getHeader("sysBrandId");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null || "".equals(memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        taskForWXvo.setMemberCode(memberCode);
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        ResponseData completeTask = this.taskServiceForWxRpc.getCompleteTask(taskForWXvo);
        ArrayList<AppletTaskWXBO> infos = new ArrayList<AppletTaskWXBO>();
        for (TaskWXBO taskWXbo : ((PageInfo)completeTask.getData()).getList()) {
            ResponseData card;
            AppletTaskWXBO appletTaskWXBo = new AppletTaskWXBO();
            BeanUtils.copyProperties((Object)taskWXbo, (Object)appletTaskWXBo);
            SubscribeMsgAuthResponseVO subscribeMsgAuthResponseVO = this.weChatAppletSubscribeCommonService.queryTaskDetailWeChatAppletSubscribeData(Long.valueOf(sysBrandId), openId, WeChatSubscribeMenuEnum.FIELD_8, taskWXbo.getTaskCode());
            appletTaskWXBo.setSubscribeMsgAuthResponseVO(subscribeMsgAuthResponseVO);
            if (taskWXbo.getTaskType() == 1) {
                appletTaskWXBo.setRemaks(Integer.valueOf(0));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 2) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 3) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 7) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 4) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 5) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                appletTaskWXBo.setTaskType(Integer.valueOf(4));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 6) {
                CusUrMbrQuestionnaireTemplatePO templatePo;
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                TaskVO taskVO = new TaskVO();
                taskVO.setMktTaskId(taskWXbo.getTaskId());
                ResponseData quesResponseData = this.taskQuestionnaireServiceRpc.getTempCodeByTaskId(taskVO);
                String templateCode = (String)quesResponseData.getData();
                CusUrMbrQuestionnaireTemplateVO templateVO = new CusUrMbrQuestionnaireTemplateVO();
                templateVO.setSysBrandId(taskForWXvo.getBrandId());
                templateVO.setTemplateCode(templateCode);
                appletTaskWXBo.setTemplateCode(templateCode);
                if (taskWXbo.getRewarded() == 1) {
                    templateVO.setMktTaskId(taskWXbo.getTaskId());
                    templateVO.setMemberCode(taskForWXvo.getMemberCode());
                    templatePo = (CusUrMbrQuestionnaireOrderPO)this.evaluationQuestionnaireFeign.queryAnswerOrderByTaskId(templateVO).getData();
                    appletTaskWXBo.setTemplateJson(templatePo == null ? "" : templatePo.getTemplateJsonOrder());
                } else {
                    templatePo = (CusUrMbrQuestionnaireTemplatePO)this.evaluationQuestionnaireFeign.queryQuestionTemplate(templateVO).getData();
                    appletTaskWXBo.setTemplateJson(templatePo == null ? "" : templatePo.getTemplateJson());
                }
                ResponseData card2 = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card2.getData());
            }
            infos.add(appletTaskWXBo);
        }
        if (infos != null) {
            Collections.sort(infos, new /* Unavailable Anonymous Inner Class!! */);
            ArrayList list = new ArrayList(infos);
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
            PageInfo wxboPageInfo = new PageInfo();
            this.copyPageInfo((PageInfo)completeTask.getData(), wxboPageInfo);
            wxboPageInfo.setList(list);
            logger.info("\u4f1a\u5458\u4efb\u52a1\u5217\u8868\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)wxboPageInfo));
            responseData.setData((Object)wxboPageInfo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        infos = null;
        PageInfo wxboPageInfo = new PageInfo(infos);
        logger.info("\u4f1a\u5458\u4efb\u52a1\u5217\u8868\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)wxboPageInfo));
        responseData.setData((Object)wxboPageInfo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    private void copyPageInfo(PageInfo<TaskWXBO> sourcePageInfo, PageInfo<AppletTaskWXBO> targePageInfo) {
        targePageInfo.setPageNum(sourcePageInfo.getPageNum());
        targePageInfo.setPageSize(sourcePageInfo.getPageSize());
        targePageInfo.setSize(sourcePageInfo.getSize());
        targePageInfo.setStartRow(sourcePageInfo.getStartRow());
        targePageInfo.setEndRow(sourcePageInfo.getEndRow());
        targePageInfo.setPages(sourcePageInfo.getPages());
        targePageInfo.setPrePage(sourcePageInfo.getPrePage());
        targePageInfo.setNextPage(sourcePageInfo.getNextPage());
        targePageInfo.setIsFirstPage(sourcePageInfo.isIsFirstPage());
        targePageInfo.setIsLastPage(sourcePageInfo.isIsLastPage());
        targePageInfo.setHasPreviousPage(sourcePageInfo.isHasPreviousPage());
        targePageInfo.setHasNextPage(sourcePageInfo.isHasNextPage());
        targePageInfo.setNavigatepageNums(sourcePageInfo.getNavigatepageNums());
        targePageInfo.setNavigateFirstPage(sourcePageInfo.getNavigateFirstPage());
        targePageInfo.setNavigateLastPage(sourcePageInfo.getNavigateLastPage());
        targePageInfo.setTotal(sourcePageInfo.getTotal());
    }

    @RequestMapping(value={"/taskId"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<TaskWXDetailBO> getTaskWXDetail(Long taskId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage());
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null || "".equals(memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        ResponseData detail = this.taskServiceForWxRpc.getMemberTaskWXDetail(taskId, memberCode, sysBrandId);
        if (detail != null && SysResponseEnum.SUCCESS.getCode() == detail.getCode() && null != detail.getData()) {
            TaskWXDetailBO data = (TaskWXDetailBO)detail.getData();
            if (null != data.getTaskType() && (3 == data.getTaskType() || 7 == data.getTaskType())) {
                ResponseData card = this.memberInvitedService.invitedOpenCard(data.getTaskType(), data.getMktTaskId(), memberCode, sysBrandId, bizvaneSessionId);
                data.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            } else if (null != data.getTaskType() && 6 == data.getTaskType()) {
                CusUrMbrQuestionnaireTemplatePO templatePo;
                TaskVO taskVO = new TaskVO();
                taskVO.setMktTaskId(data.getMktTaskId());
                ResponseData quesResponseData = this.taskQuestionnaireServiceRpc.getTempCodeByTaskId(taskVO);
                String templateCode = (String)quesResponseData.getData();
                CusUrMbrQuestionnaireTemplateVO templateVO = new CusUrMbrQuestionnaireTemplateVO();
                templateVO.setSysBrandId(sysBrandId);
                templateVO.setTemplateCode(templateCode);
                data.setTemplateCode(templateCode);
                if (data.getRewarded() == 1) {
                    templateVO.setMktTaskId(data.getMktTaskId());
                    templateVO.setMemberCode(memberCode);
                    templatePo = (CusUrMbrQuestionnaireOrderPO)this.evaluationQuestionnaireFeign.queryAnswerOrderByTaskId(templateVO).getData();
                    data.setTemplateJson(templatePo == null ? "" : templatePo.getTemplateJsonOrder());
                } else {
                    templatePo = (CusUrMbrQuestionnaireTemplatePO)this.evaluationQuestionnaireFeign.queryQuestionTemplate(templateVO).getData();
                    data.setTemplateJson(templatePo == null ? "" : templatePo.getTemplateJson());
                }
                ResponseData card = this.memberInvitedService.invitedOpenCard(data.getTaskType(), data.getMktTaskId(), memberCode, sysBrandId, bizvaneSessionId);
                data.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            } else if (null != data.getTaskType() && 2 == data.getTaskType()) {
                ResponseData card = this.memberInvitedService.invitedOpenCard(data.getTaskType(), data.getMktTaskId(), memberCode, sysBrandId, bizvaneSessionId);
                data.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            responseData.setData((Object)data);
        }
        return responseData;
    }

    @PostMapping(value={"/addMemberQuestionnaire"})
    public ResponseData addMemberQuestionnaire(EvaluationSaveTempRequestVO evo, HttpServletRequest request) {
        logger.info("MemberTaskController addMemberQuestionnaire params:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)evo));
        evo.setSysCompanyId(Long.valueOf(request.getHeader("sysCompanyId")));
        evo.setSysBrandId(Long.valueOf(request.getHeader("sysBrandId")));
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(evo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        logger.info("\u4fdd\u5b58\u95ee\u5377 \u67e5\u8be2\u4f1a\u5458\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)singleMemberModel));
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        evo.setMemberName(member.getName());
        evo.setMemberPhone(member.getPhone());
        ResponseData storeVoResponseData = this.storeServiceRpc.getSysStoreById(member.getOpenCardStoreId());
        if (storeVoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            SysStoreVo sysStoreVo = (SysStoreVo)storeVoResponseData.getData();
            evo.setStoreName(sysStoreVo != null ? sysStoreVo.getStoreName() : "");
        }
        String questionnaireList = evo.getTemplateJsonOrder();
        List questionList = JSONArray.parseArray((String)questionnaireList, CusUrMbrQuestionnaireOrderDetailPO.class);
        JSONObject questionJson = new JSONObject();
        questionJson.put("templateList", (Object)questionList);
        evo.setTemplateJsonOrder(JSON.toJSONString((Object)questionJson));
        logger.info("\u89e3\u6790\u7684questionList={}", (Object)JSON.toJSONString((Object)questionList));
        evo.setTemplateList(questionList);
        return this.evaluationQuestionnaireFeign.saveQuestionnaireTask(evo);
    }

    @PostMapping(value={"/getTaskRewardDetail"})
    public ResponseData<TaskQuestionnaireRewardBO> getTaskRewardDetail(Long mktTaskId) {
        logger.info("MemberTaskController getTaskRewardDetail param:{}", (Object)mktTaskId);
        return this.taskQuestionnaireServiceRpc.getTaskRewardDetail(mktTaskId);
    }

    @PostMapping(value={"/getTaskMbrDef"})
    public ResponseData getTaskMbrDef(HttpServletRequest request) {
        String sysCompanyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysCompanyId) || StringUtils.isBlank((CharSequence)brandId)) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u83b7\u53d6\u4f1a\u5458\u8bf7\u6c42\u53c2\u6570\u5931\u8d25");
        }
        MktTaskMbrDefVO mktTaskMbrDefVO = new MktTaskMbrDefVO();
        mktTaskMbrDefVO.setSysCompanyId(Long.valueOf(sysCompanyId));
        mktTaskMbrDefVO.setSysBrandId(Long.valueOf(brandId));
        return this.mktTaskMbrDefRpc.getEntityByVo(mktTaskMbrDefVO);
    }

    @PostMapping(value={"/selectInvitationRecord"})
    public ResponseData<PageInfo<CompanyMemberInfoBo>> selectInvitationRecord(@RequestParam(name="taskId") Long taskId, @RequestParam(name="taskType", required=false, defaultValue="3") Integer taskType, @RequestParam(name="pageNum") Integer pageNum, @RequestParam(name="pageSize") Integer pageSize, HttpServletRequest request) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null || "".equals(memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        TaskForWXVO taskVO = new TaskForWXVO();
        taskVO.setBrandId(sysBrandId);
        taskVO.setSysCompanyId(sysCompanyId);
        taskVO.setMemberCode(memberCode);
        taskVO.setMktTaskId(taskId);
        taskVO.setTaskType(taskType);
        taskVO.setPageNumber(pageNum);
        taskVO.setPageSize(pageSize);
        responseData = this.taskServiceForWxRpc.selectInvitationRecord(taskVO);
        return responseData;
    }

    @PostMapping(value={"/listInvitationRecord"})
    public ResponseData<PageInfo<CompanyMemberInfoBo>> listInvitationRecord(@RequestParam(name="taskId") Long taskId, @RequestParam(name="taskType", required=false, defaultValue="3") Integer taskType, HttpServletRequest request) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null || "".equals(memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        TaskForWXVO taskVO = new TaskForWXVO();
        taskVO.setBrandId(sysBrandId);
        taskVO.setSysCompanyId(sysCompanyId);
        taskVO.setMemberCode(memberCode);
        taskVO.setMktTaskId(taskId);
        taskVO.setTaskType(taskType);
        responseData = this.taskServiceForWxRpc.listInvitationRecord(taskVO);
        return responseData;
    }

    @RequestMapping(value={"/scanningLottery"}, method={RequestMethod.POST})
    public ResponseData scanningLottery(Long taskId, Integer taskType, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.taskScanningLottery(memberCode, taskId, taskType);
    }
}

