/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.MemberOpenCardStoreService;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.appletservice.models.vo.ShopStoreVo;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberOpenCardStore"}, method={RequestMethod.POST})
public class MemberOpenCardStoreController {
    @Autowired
    private MemberOpenCardStoreService memberOpenCardStoreService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private IntegrationShopService integrationShopService;

    @RequestMapping(value={"/searchStores"}, method={RequestMethod.POST})
    public ResponseData searchStores(@Valid MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        memberOpenCardStoreVo.setMemberCode(memberCode);
        if (!Integer.valueOf(2).equals(memberOpenCardStoreVo.getBizType())) {
            memberOpenCardStoreVo.setIsWholeStore(Integer.valueOf(1));
            logger.info("\u975e\u79ef\u5206\u5546\u57ce\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
            return this.memberOpenCardStoreService.searchStores(memberOpenCardStoreVo);
        }
        Integer isWholeStore = null;
        ShopStoreVo goodsDetail = null;
        if (memberOpenCardStoreVo.getIntegralGoodsId() != null) {
            goodsDetail = (ShopStoreVo)this.integrationShopService.commodityDetails(memberOpenCardStoreVo.getIntegralGoodsId().toString()).getData();
        }
        if (goodsDetail != null && Boolean.TRUE.equals(goodsDetail.getIsSetZitiStore())) {
            logger.info("\u72ec\u7acb\u81ea\u63d0\u5546\u54c1");
            if (Integer.valueOf(0).equals(goodsDetail.getZitiStoreType())) {
                isWholeStore = 1;
            } else if (Integer.valueOf(1).equals(goodsDetail.getZitiStoreType())) {
                isWholeStore = 2;
                memberOpenCardStoreVo.setStoreIdList(Arrays.stream(goodsDetail.getZitiStoreList().split(",")).map(i -> Long.valueOf(i)).collect(Collectors.toList()));
            } else if (Integer.valueOf(2).equals(goodsDetail.getZitiStoreType())) {
                isWholeStore = 0;
            }
        } else {
            ResponseData configData = this.integrationShopService.getConfig(Integer.valueOf(memberOpenCardStoreVo.getSysBrandId().intValue()));
            logger.info("\u975e\u72ec\u7acb\u81ea\u63d0\u6240\u83b7\u53d6\u7684\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)configData));
            Object data = configData.getData();
            JSONObject json = (JSONObject)JSON.toJSON((Object)data);
            isWholeStore = json.getInteger("isWholeStore");
            String storeList = json.getString("storeList");
            if (Integer.valueOf(2).equals(isWholeStore)) {
                memberOpenCardStoreVo.setStoreIdList(Arrays.stream(storeList.split(",")).map(i -> Long.valueOf(i)).collect(Collectors.toList()));
            }
        }
        memberOpenCardStoreVo.setIsWholeStore(isWholeStore);
        logger.info("\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        return this.memberOpenCardStoreService.searchStores(memberOpenCardStoreVo);
    }

    @RequestMapping(value={"/searchStoresByMemberCode"}, method={RequestMethod.POST})
    public ResponseData searchStoresByMemberCode(@RequestBody MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) {
        logger.info("\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        return this.memberOpenCardStoreService.searchStores(memberOpenCardStoreVo);
    }

    @RequestMapping(value={"/choosingStore"}, method={RequestMethod.POST})
    public ResponseData choosingStore(Long storeId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u66f4\u6539\u95e8\u5e97={}", (Object)JSON.toJSONString((Object)storeId));
        return this.memberOpenCardStoreService.choosingStore(storeId, memberCode);
    }

    @RequestMapping(value={"/searchStoresByRecordId"}, method={RequestMethod.POST})
    public ResponseData searchStoresByRecordId(MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) {
        logger.info("searchStoresByRecordId memberOpenCardStoreVo:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (null == memberOpenCardStoreVo.getMktActivityPrizeRecordId()) {
            responseData.setMessage("\u4e2d\u5956\u8bb0\u5f55ID\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        memberOpenCardStoreVo.setMemberCode(memberCode);
        return this.memberOpenCardStoreService.searchStoresByRecordId(memberOpenCardStoreVo);
    }
}

