/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.models.bo.IntegralNSActivityBO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletservice.models.vo.AllMerchandiseVo;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.IntegralOrderFeightVO;
import com.bizvane.appletservice.models.vo.IntegralQRCodeRequestVO;
import com.bizvane.appletservice.models.vo.IntegralShopGetHomePageHotCommodityRequestVO;
import com.bizvane.appletservice.models.vo.RefundLogisticsVo;
import com.bizvane.appletservice.models.vo.ReturnGoodsVo;
import com.bizvane.appletservice.models.vo.ShopClassifyMapVo;
import com.bizvane.appletservice.models.vo.ShopHomePageVo;
import com.bizvane.appletservice.models.vo.ShopStoreVo;
import com.bizvane.appletservice.models.vo.UserAddressPutVo;
import com.bizvane.appletservice.models.vo.classifiedGoodsVo;
import com.bizvane.appletserviceimpl.common.NoStoreActivityGoodsRangeEnum;
import com.bizvane.appletserviceimpl.impl.integeractivity.nsActivity.IntegrationShopNSActivityServiceImpl;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.appletserviceimpl.utils.IpUtil;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centercontrolservice.models.enums.FusionPayBusinessTypeEnum;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysAccountServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponAuthTmallServiceFeign;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.common.IntegralActivityTypeEnum;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.QRCodeServiceFeign;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integrationShop"}, method={RequestMethod.POST})
public class IntegrationShopController {
    @Autowired
    private IntegrationShopNSActivityServiceImpl integrationShopNSActivityService;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponAuthTmallServiceFeign couponAuthTmallServiceFeign;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private QRCodeServiceFeign qrCodeServiceFeign;
    @Autowired
    private SysAccountServiceRpc sysAccountServiceRpc;
    @Value(value="${c361.companyId}")
    private Long c361CompanyId;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/integrationShopResources"}, method={RequestMethod.POST})
    public ResponseData integrationShopResources(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
        appletResourcesPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M006").andSysBrandIdEqualTo(couponRecordVO.getBrandId()).andModularTypeEqualTo("2");
        List resourcesPOS = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
        for (AppletResourcesPO appletResourcesPO : resourcesPOS) {
            appletResourcesPO.setModularContent(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletResourcesPO.getModularContent()));
        }
        responseData.setCode(0);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)resourcesPOS);
        return responseData;
    }

    @RequestMapping(value={"/integrationShopGetall"})
    public ResponseData integrationShopGetall(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        Object data;
        logger.info("IntegrationShopController#integrationShopGetall#134# couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("integrationShopGetall memberCode:{}", (Object)memberCode);
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getCanConvertCoupon() == null) {
            responseData.setMessage("\u67e5\u8be2\u52fe\u9009\u6846\u4e3anull");
            responseData.setCode(100);
            return responseData;
        }
        couponRecordVO.setMemberCode(memberCode);
        Long serviceStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        try {
            ResponseData config = this.integrationShopService.getConfig(Integer.valueOf(couponRecordVO.getBrandId().intValue()));
            data = config.getData();
            JSONObject json = (JSONObject)JSON.toJSON((Object)data);
            logger.info("IntegrationShopController#integrationShopGetall#169# configMap:{}", (Object)json);
            if (!couponRecordVO.getCanConvertCoupon().booleanValue()) {
                logger.info("hiddenGoods:{}", (Object)json.getBoolean("hiddenGoods"));
                couponRecordVO.setHiddenGoods(json.getBoolean("hiddenGoods"));
            }
        }
        catch (Exception e) {
            logger.info("IntegrationShopController#integrationShopGetall#157 Exception :{},:{}", (Object)e.getMessage(), (Object)e);
        }
        couponRecordVO.setOpenCardStoreId(serviceStoreId);
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        data = (MemberCardLevelModel)modelResponseData.getData();
        Integer integral = data.getCountIntegral();
        logger.info("integrationShopGetall memberCode:{},memberResp:{}", (Object)memberCode, (Object)JSONObject.toJSONString((Object)modelResponseData));
        if (integral != null) {
            couponRecordVO.setCountIntegral(integral);
        }
        couponRecordVO.setMbrLevelId(data.getLevelId());
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO));
        ResponseData convernCouponLists = this.taskServiceForWXRpc.getConvernCouponLists(couponRecordVO);
        logger.info("integrationShopGetall convernCouponLists:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
        return convernCouponLists;
    }

    @GetMapping(value={"/getExchangeCoupon"})
    public ResponseData getExchangeCoupon(@RequestParam(value="pageNumber", required=false) Integer pageNumber, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="brandId") Long brandId, @RequestParam(value="canConvertCoupon", required=false) Boolean canConvertCoupon, @RequestParam(value="hotGoods", required=false) Boolean hotGoods, @RequestParam(value="exchangePriceType", required=false) Integer exchangePriceType, HttpServletRequest request) {
        Object data;
        Long serviceStoreId;
        CouponRecordVO couponRecordVO = new CouponRecordVO();
        couponRecordVO.setPageNumber(pageNumber);
        couponRecordVO.setPageSize(pageSize);
        couponRecordVO.setBrandId(brandId);
        couponRecordVO.setHotGoods(hotGoods);
        couponRecordVO.setExchangePriceType(exchangePriceType);
        logger.info("IntegrationShopController#getExchangeCoupon#couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
        ResponseData responseData = new ResponseData();
        String memberCode = "";
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId != null) {
            memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            logger.info("integrationShopGetall#getExchangeCoupon#memberCode:{}", (Object)memberCode);
            if (memberCode != null) {
                couponRecordVO.setMemberCode(memberCode);
            }
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        Long mbrLevelId = null;
        if (StringUtils.isEmpty((Object)memberCode)) {
            serviceStoreId = 0L;
        } else {
            serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            if (null == serviceStoreId) {
                ResponseData storeRes;
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                memberInfoModel.setMemberCode(memberCode);
                ResponseData memberRes = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (memberRes != null && memberRes.getCode() == SysResponseEnum.SUCCESS.getCode() && memberRes.getData() != null && ((MemberInfoModel)memberRes.getData()).getServiceStoreCode() != null && (storeRes = this.storeServiceRpc.getStoreByOfflineCode(((MemberInfoModel)memberRes.getData()).getServiceStoreCode(), ((MemberInfoModel)memberRes.getData()).getSysCompanyId())) != null && storeRes.getCode() == SysResponseEnum.SUCCESS.getCode() && storeRes.getData() != null) {
                    serviceStoreId = ((SysStorePo)storeRes.getData()).getSysStoreId();
                }
            }
            ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
            data = (MemberCardLevelModel)modelResponseData.getData();
            couponRecordVO.setOpenId(data.getWxOpenId());
            Integer integral = data.getCountIntegral();
            logger.info("integrationShopGetall memberCode:{},memberResp:{}", (Object)memberCode, (Object)JSONObject.toJSONString((Object)modelResponseData));
            if (integral != null) {
                couponRecordVO.setCountIntegral(integral);
            }
            mbrLevelId = data.getLevelId();
        }
        couponRecordVO.setOpenCardStoreId(serviceStoreId);
        couponRecordVO.setMbrLevelId(mbrLevelId);
        try {
            ResponseData config = this.integrationShopService.getConfig(Integer.valueOf(couponRecordVO.getBrandId().intValue()));
            data = config.getData();
            JSONObject json = (JSONObject)JSON.toJSON((Object)data);
            logger.info("IntegrationShopController#integrationShopGetall#169# configMap:{}", (Object)json);
            logger.info("hiddenGoods:{}", (Object)json.getBoolean("hiddenGoods"));
            couponRecordVO.setHiddenGoods(json.getBoolean("hiddenGoods"));
        }
        catch (Exception e) {
            logger.error("IntegrationShopController#integrationShopGetall#157 Exception :{},:{}", (Object)e.getMessage(), (Object)e);
        }
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO));
        ResponseData convernCouponLists = this.taskServiceForWXRpc.getConvernCouponLists(couponRecordVO);
        logger.info("integrationShopGetall convernCouponLists:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
        return convernCouponLists;
    }

    @PostMapping(value={"/updateIntegralConfig"})
    public void updateIntegralConfig(@RequestBody JSONObject json) {
        logger.info("IntegrationShopController#getExchangeCoupon#updateVO:{}", (Object)JSON.toJSONString((Object)json));
        HashMap<String, Object> map = new HashMap<String, Object>();
        Boolean customerService = (Boolean)json.get((Object)"customerService");
        Boolean refundSingle = (Boolean)json.get((Object)"refundSingle");
        if (refundSingle.booleanValue()) {
            map.put("refundSingleConditionList", json.get((Object)"refundSingleConditionList"));
        }
        map.put("awaitOrderCancel", json.get((Object)"awaitOrderCancel"));
        map.put("customerService", customerService);
        map.put("refundSingle", refundSingle);
        map.put("integralRule", json.getString("integralRule"));
        map.put("isDeliverCheck", json.getString("isDeliverCheck"));
        map.put("deliverAuditorMark", json.getString("deliverAuditorMark"));
        map.put("isWholeStore", json.getInteger("isWholeStore"));
        map.put("hiddenGoods", json.getBooleanValue("hiddenGoods"));
        map.put("showCoupon", json.getBooleanValue("showCoupon"));
        map.put("showCouponInGoods", json.getBooleanValue("showCouponInGoods"));
        map.put("isTimedCancelOrder", json.getIntValue("isTimedCancelOrder"));
        map.put("selfPickTimeJudge", json.getBooleanValue("selfPickTimeJudge"));
        map.put("storeList", json.getString("storeList"));
        this.integrationShopService.setIntegralConfig2Redis(map, json.getInteger("merchantId"));
    }

    @RequestMapping(value={"/integrationShopStallInfo"}, method={RequestMethod.POST})
    public ResponseData integrationShopStallInfo(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        logger.info("integrationShopStallInfo#couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        try {
            ResponseData storeById;
            SysStorePo memberStore;
            if (StringUtils.isEmpty((Object)memberCode)) {
                responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            logger.info("\u79ef\u5206\u5151\u6362\u5238\u7684redis\u83b7\u53d6memberCode:{}", (Object)memberCode);
            if (couponRecordVO.getBrandId() == null) {
                responseData.setMessage("\u54c1\u724c\u4e3a null");
                responseData.setCode(100);
                return responseData;
            }
            if (couponRecordVO.getExchangeId() == null) {
                responseData.setMessage("\u89c4\u5219 id \u4e3a\u7a7a");
                responseData.setCode(100);
                return responseData;
            }
            if (couponRecordVO.getExchangeNum() == null) {
                responseData.setMessage("\u5151\u6362\u6570 \u4e3a\u7a7a");
                responseData.setCode(100);
                return responseData;
            }
            Long serviceStoreId = this.wxAppletApiService.getServiceStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            logger.info("\u79ef\u5206\u5151\u6362\u5238\u83b7\u53d6crm\u7684memberCode:{},\u7528\u6237\u4fe1\u606f:{}", (Object)memberCode, JSON.toJSON((Object)singleMemberModel));
            MemberInfoModel data = (MemberInfoModel)singleMemberModel.getData();
            Integer integral = data.getCountIntegral();
            if (integral != null) {
                couponRecordVO.setCountIntegral(integral);
            }
            if (!ObjectUtils.isEmpty((Object)serviceStoreId) && (memberStore = (SysStorePo)(storeById = this.storeServiceRpc.getStoreById(serviceStoreId)).getData()) != null) {
                couponRecordVO.setMemberStoreCode(memberStore.getSysStoreOnlineCode());
                couponRecordVO.setMemberStoreId(serviceStoreId);
                couponRecordVO.setMemberStoreName(memberStore.getStoreName());
            }
            couponRecordVO.setMbrLevelId(data.getLevelId());
            couponRecordVO.setOpenCardStoreId(serviceStoreId);
            couponRecordVO.setMemberCode(memberCode);
            if (!ObjectUtils.isEmpty((Object)couponRecordVO.getActivityId())) {
                ResponseData nsActivityDetail = this.integrationShopNSActivityService.getNSActivityDetail(couponRecordVO.getActivityId(), couponRecordVO.getBrandId());
                if (ObjectUtils.isEmpty((Object)nsActivityDetail.getData())) {
                    responseData.setMessage("\u6d3b\u52a8\u4e0d\u5b58\u5728");
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                IntegralNSActivityBO activityBO = (IntegralNSActivityBO)((JSONObject)nsActivityDetail.getData()).toJavaObject(IntegralNSActivityBO.class);
                couponRecordVO.setActivityType(activityBO.getActivityType());
                if (!activityBO.getActivityStatus().booleanValue()) {
                    responseData.setMessage("\u6d3b\u52a8\u5173\u95ed\uff0c\u4e0d\u53ef\u67e5\u770b\u5546\u54c1");
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                if (NoStoreActivityGoodsRangeEnum.GOODS.getCode().equals(activityBO.getGoodsType())) {
                    responseData.setMessage("\u6d3b\u52a8\u662f\u7eaf\u5546\u54c1\u6d3b\u52a8");
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                if (!activityBO.getAllGoodsJudge().booleanValue() && !activityBO.getCouponList().contains(couponRecordVO.getExchangeCode())) {
                    responseData.setMessage("\u5546\u54c1\u4e0d\u5728\u89c4\u5b9a\u8303\u56f4\u4e2d");
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                if (activityBO.getActivityType().equals(IntegralActivityTypeEnum.NO_STORE.getCode())) {
                    couponRecordVO.setMbrLevelId(null);
                    couponRecordVO.setOpenCardStoreId(null);
                }
            }
            logger.info("\u79ef\u5206\u5151\u6362\u5238\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
            Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
            Integer cardUseStatus = ((MemberInfoModel)singleMemberModel.getData()).getCardUseStatus();
            Integer freezeCardUseStatus = 4;
            if (this.c361CompanyId.compareTo(sysCompanyId) == 0 && freezeCardUseStatus == cardUseStatus) {
                responseData.setMessage("361\u4f1a\u5458\u51bb\u7ed3\u72b6\u6001\u4e0d\u80fd\u5728\u79ef\u5206\u5546\u57ce\u4e0b\u5355");
                responseData.setCode(101);
                return responseData;
            }
            return this.taskServiceForWXRpc.doConvernCoupon(couponRecordVO);
        }
        catch (Exception e) {
            logger.error(memberCode + ":" + e.getMessage(), (Throwable)e);
            responseData.setMessage("\u64cd\u4f5c\u5f02\u5e38");
            responseData.setCode(1);
            return responseData;
        }
    }

    @RequestMapping(value={"/getTmallNick"}, method={RequestMethod.POST})
    ResponseData<String> getTmallNick(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        logger.info("enter IntegrationShopController getTmallNick method! ");
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getExchangeId() == null) {
            responseData.setMessage("\u89c4\u5219 id \u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getExchangeNum() == null) {
            responseData.setMessage("\u5151\u6362\u6570 \u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        Long openCardStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        Integer integral = data.getCountIntegral();
        if (integral != null) {
            couponRecordVO.setCountIntegral(integral);
        }
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenCardStoreId(openCardStoreId);
        couponRecordVO.setMemberCode(memberCode);
        logger.info("\u6821\u9a8c\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.couponAuthTmallServiceFeign.getTmallNick(couponRecordVO);
    }

    @RequestMapping(value={"/integrationShopGetOld"}, method={RequestMethod.POST})
    public ResponseData integrationShopGetOld(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setMemberCode(memberCode);
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.taskServiceForWXRpc.getConvernConpouByMember(couponRecordVO);
    }

    @RequestMapping(value={"/getCouponAndPrice"}, method={RequestMethod.POST})
    public ResponseData getCouponAndPrice(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMemberCode(memberCode);
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenId(data.getWxOpenId());
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.taskServiceForWXRpc.getCouponAndPrice(couponRecordVO);
    }

    @Deprecated
    @RequestMapping(value={"/shopHomePage"}, method={RequestMethod.POST})
    public ResponseData shopHomePage(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.shopHomePage(sysBrandId, memberCode);
    }

    @RequestMapping(value={"/shopHomePage/rotationChartAndClass"}, method={RequestMethod.GET})
    public ResponseData<ShopHomePageVo> getHomePageRotationChart(@RequestParam String sysBrandId, HttpServletRequest request) {
        logger.info("IntegrationShopController#getHomePageRotationChart#sysBrandId:{}", (Object)sysBrandId);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            return ResponseUtils.getFailedData((String)"\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
        }
        return this.integrationShopService.getHomePageRotationChart(sysBrandId);
    }

    @RequestMapping(value={"/shopHomePage/getHomePageHotCommodity"}, method={RequestMethod.GET})
    public ResponseData<JSONObject> getHomePageHotCommodity(@RequestParam(value="sysBrandId") Long sysBrandId, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageIndex") Integer pageIndex, HttpServletRequest request) {
        IntegralShopGetHomePageHotCommodityRequestVO requestVO = IntegralShopGetHomePageHotCommodityRequestVO.builder().sysBrandId(sysBrandId).pageIndex(pageIndex).pageSize(pageSize).build();
        logger.info("IntegrationShopController#getHomePageRotationChart#requestVO:{}", JSON.toJSON((Object)requestVO));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            return ResponseUtils.getFailedData((String)"\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            return ResponseUtils.getFailedData((String)"\u4f1a\u5458\u6570\u636e\u4e3a\u7a7a");
        }
        requestVO.setMemberCode(memberCode);
        return this.integrationShopService.getHomePageHotCommodity(requestVO);
    }

    @RequestMapping(value={"/shopHomePage/getHomePageMemberInfo"}, method={RequestMethod.GET})
    public ResponseData<ShopHomePageVo> getHomePageMemberInfo(HttpServletRequest request, @RequestParam Long sysBrandId) {
        logger.info("IntegrationShopController#getHomePageMemberInfo#sysBrandId:{} ", (Object)sysBrandId);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = "";
        if (bizvaneSessionId != null) {
            memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            logger.info("IntegrationShopController#getGoodsByParamsAndPage#memberCode:{}", (Object)memberCode);
        }
        return this.integrationShopService.getHomePageMemberInfo(memberCode, sysBrandId);
    }

    @RequestMapping(value={"/fullMerchandiseDisplay"}, method={RequestMethod.POST})
    public ResponseData fullMerchandiseDisplay(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        allMerchandiseVo.setMemberCode(memberCode);
        return this.integrationShopService.fullMerchandiseDisplay(allMerchandiseVo);
    }

    @RequestMapping(value={"/commodityDetails"}, method={RequestMethod.POST})
    public ResponseData<ShopStoreVo> commodityDetails(String hostId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.commodityDetails(hostId);
    }

    @RequestMapping(value={"/classifiedGoods"}, method={RequestMethod.POST})
    public ResponseData classifiedGoods(classifiedGoodsVo classifiedGoodsVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.classifiedGoods(classifiedGoodsVo2);
    }

    @RequestMapping(value={"/tailForClassifiedGoods"}, method={RequestMethod.POST})
    public ResponseData tailForClassifiedGoods(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        allMerchandiseVo.setMemberCode(memberCode);
        return this.integrationShopService.tailForClassifiedGoods(allMerchandiseVo);
    }

    @PostMapping(value={"/getFeight"})
    public ResponseData getFeight(@RequestBody IntegralOrderFeightVO integralOrderFeightVO) {
        ResponseData responseData = new ResponseData();
        logger.info("IntegrationShopController_getFeight:{}", (Object)JSON.toJSONString((Object)integralOrderFeightVO));
        responseData = this.integrationShopService.getFeight(integralOrderFeightVO);
        return responseData;
    }

    @RequestMapping(value={"/generateOrder"}, method={RequestMethod.POST})
    public ResponseData generateOrder(ConfirmGoodsVo confirmGoodsVo, HttpServletRequest request) {
        confirmGoodsVo.setIp(IpUtil.getClientIpAddress((HttpServletRequest)request));
        confirmGoodsVo.setDevice(request.getHeader("user-agent"));
        logger.info("IntegrationShopController#generateOrder#confirmGoodsVo :{}", JSONObject.toJSON((Object)confirmGoodsVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        try {
            logger.info("generateOrder\u7684redis\u83b7\u53d6memberCode:{}", (Object)memberCode);
            if (StringUtils.isEmpty((Object)memberCode)) {
                responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
                responseData.setCode(-100);
                return responseData;
            }
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            logger.info("\u79ef\u5206\u751f\u6210\u8ba2\u5355generateOrder\u7684memberCode:{},\u83b7\u53d6crm\u7528\u6237\u4fe1\u606f\u4e3a:{}", (Object)memberCode, JSON.toJSON((Object)singleMemberModel));
            Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
            Integer cardUseStatus = ((MemberInfoModel)singleMemberModel.getData()).getCardUseStatus();
            Integer freezeCardUseStatus = 4;
            if (this.c361CompanyId.compareTo(sysCompanyId) == 0 && freezeCardUseStatus == cardUseStatus) {
                responseData.setMessage("361\u4f1a\u5458\u51bb\u7ed3\u72b6\u6001\u4e0d\u80fd\u5728\u79ef\u5206\u5546\u57ce\u4e0b\u5355");
                responseData.setCode(101);
                return responseData;
            }
            Integer countIntegral = ((MemberInfoModel)singleMemberModel.getData()).getCountIntegral();
            if (Integer.valueOf(confirmGoodsVo.getSaleIntegral()) > countIntegral) {
                responseData.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
                responseData.setCode(100);
                return responseData;
            }
            confirmGoodsVo.setMemberCode(memberCode);
            logger.info("\u79ef\u5206\u751f\u6210\u8ba2\u5355generateOrder\u7684memberCode:{},\u8fdb\u5165\u79ef\u5206\u5546\u57ce\u5165\u53c2:{}", (Object)memberCode, JSON.toJSON((Object)confirmGoodsVo));
            return this.integrationShopService.generateOrder(confirmGoodsVo);
        }
        catch (Exception e) {
            logger.error(memberCode + ":" + e.getMessage(), (Throwable)e);
            responseData.setMessage("\u64cd\u4f5c\u5f02\u5e38");
            responseData.setCode(1);
            return responseData;
        }
    }

    @RequestMapping(value={"/inventoryStatus"}, method={RequestMethod.POST})
    public ResponseData inventoryStatus(ConfirmGoodsVo confirmGoodsVo, String hostId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.inventoryStatus(confirmGoodsVo);
    }

    @RequestMapping(value={"/increaseReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData increaseReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.increaseReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/editReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData editReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.editReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/eliminateReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData eliminateReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.eliminateReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/addressuery"}, method={RequestMethod.POST})
    ResponseData addressuery(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.addressuery(memberCode);
    }

    @RequestMapping(value={"/fullOrderDisplayNew"}, method={RequestMethod.POST})
    ResponseData fullOrderDisplay(String sysBrandId, String orderStatus, HttpServletRequest request, Integer pageNum, Integer pageSize) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.fullOrderDisplay(sysBrandId, orderStatus, memberCode, pageNum, pageSize);
    }

    @RequestMapping(value={"/fullOrderDisplay"}, method={RequestMethod.POST})
    ResponseData fullOrderDisplay(String sysBrandId, String orderStatus, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.fullOrderDisplay(sysBrandId, orderStatus, memberCode);
    }

    @RequestMapping(value={"/fullCouponDisplay"}, method={RequestMethod.POST})
    ResponseData fullCouponDisplay(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        couponRecordVO.setMemberCode(memberCode);
        return this.integrationShopService.fullCouponDisplay(couponRecordVO);
    }

    @RequestMapping(value={"/tailForFullCouponDisplay"}, method={RequestMethod.POST})
    ResponseData tailForFullCouponDisplay(Long convertCouponRecordId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.tailForFullCouponDisplay(convertCouponRecordId, memberCode);
    }

    @RequestMapping(value={"/viewOrder"}, method={RequestMethod.POST})
    ResponseData viewOrder(String orderId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.viewOrder(orderId);
    }

    @RequestMapping(value={"/integralAcquisition"}, method={RequestMethod.POST})
    ResponseData integralAcquisition(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.integralAcquisition(sysBrandId);
    }

    @RequestMapping(value={"/storeSelfMention"}, method={RequestMethod.POST})
    ResponseData storeSelfMention(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.storeSelfMention();
    }

    @RequestMapping(value={"/logisticsCompanyGroup"}, method={RequestMethod.POST})
    ResponseData logisticsCompanyGroup(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.logisticsCompanyGroup();
    }

    @RequestMapping(value={"/displayLogistics"}, method={RequestMethod.POST})
    ResponseData displayLogistics(String companyCode, String num, String phone, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.displayLogistics(companyCode, num, phone);
    }

    @RequestMapping(value={"/applyeturnSubmission"}, method={RequestMethod.POST})
    ResponseData applyeturnSubmission(ReturnGoodsVo returnGoodsVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        returnGoodsVo.setMemberCode(memberCode);
        return this.integrationShopService.applyeturnSubmission(returnGoodsVo);
    }

    @RequestMapping(value={"/applyeturnNotSubmitted"}, method={RequestMethod.POST})
    ResponseData applyeturnNotSubmitted(RefundLogisticsVo refundLogisticsVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.applyeturnNotSubmitted(refundLogisticsVo);
    }

    @RequestMapping(value={"/instructions"}, method={RequestMethod.POST})
    ResponseData instructions(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.instructions(sysBrandId);
    }

    @GetMapping(value={"/getConfig"})
    public ResponseData getConfig(Integer merchantId) throws IOException {
        return this.integrationShopService.getConfig(merchantId);
    }

    @GetMapping(value={"/getMemberLevelBySysBrandId"})
    public ResponseData getMemberLevelBySysBrandId(@RequestParam(value="brandid") Long brandId) {
        logger.info("getMemberLevelBySysBrandId\u5165\u53c2:[{}]", (Object)brandId);
        ResponseData listResponseData = this.memberLevelApiService.queryAllLevelList(brandId);
        return listResponseData;
    }

    @PostMapping(value={"getStoreListByBrandId"})
    public ResponseData getStoreListByBrandId(@RequestBody SysStoreVo vo) {
        logger.info("getStoreListByBrandId\u5165\u53c2:[{}]", JSON.toJSON((Object)vo));
        ResponseData sysStoreList = this.brandServiceRpc.getSysStoreList(vo);
        return sysStoreList;
    }

    @PostMapping(value={"integralOrdersByPage"})
    public ResponseData getIntegralOrdersByPage(int pageNum, int pageSize, Integer sysBrandId, HttpServletRequest request) {
        logger.info("integralOrdersByPage\u5165\u53c2:pageNum[{}],pageSize[{}],sysBrandId[{}]", new Object[]{pageNum, pageSize, sysBrandId});
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("\u83b7\u53d6\u5230\u7684memberCode --------------- = {}", (Object)bizvaneSessionId);
        logger.info("\u67e5\u8be2memberCode \u7684key\u503c --------------- = {}", (Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((Object)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.getAllOrdersPages(pageNum, pageSize, sysBrandId, memberCode);
    }

    @GetMapping(value={"payment"})
    public ResponseData payment(Integer ordersId, HttpServletRequest request) {
        logger.info("payment\u5165\u53c2:ordersId[{}]", (Object)ordersId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.payment(ordersId);
    }

    @GetMapping(value={"paymentWithCoupon"})
    public ResponseData paymentWithCoupon(Integer convertCouponRecordId, HttpServletRequest request) {
        logger.info("paymentWithCoupon\u5165\u53c2:convertCouponRecordId[{}]", (Object)convertCouponRecordId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.paymentWithCoupon(convertCouponRecordId, bizvaneSessionId, FusionPayBusinessTypeEnum.WXPAY);
    }

    @GetMapping(value={"aliPayment"})
    public ResponseData aliPayment(Integer ordersId, HttpServletRequest request) {
        logger.info("aliPayment\u5165\u53c2:ordersId[{}]", (Object)ordersId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.aliPayment(ordersId, bizvaneSessionId);
    }

    @GetMapping(value={"aliPaymentWithCoupon"})
    public ResponseData aliPaymentWithCoupon(Integer convertCouponRecordId, HttpServletRequest request) {
        logger.info("aliPaymentWithCoupon\u5165\u53c2:convertCouponRecordId[{}]", (Object)convertCouponRecordId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.paymentWithCoupon(convertCouponRecordId, bizvaneSessionId, FusionPayBusinessTypeEnum.ALIPAY);
    }

    @GetMapping(value={"payCouponSuccess"})
    public ResponseData payCouponSuccess(Integer convertCouponRecordId, String bizvaneTradeNo, HttpServletRequest request) {
        logger.info("payCouponSuccess\u5165\u53c2:convertCouponRecordId[{}]", (Object)convertCouponRecordId);
        String redisKey = "payCouponSuccess" + convertCouponRecordId;
        String doit = (String)this.redisTemplateService.stringGetStringByKey((Object)redisKey);
        if (doit != null) {
            ResponseData responseData = new ResponseData();
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u4e0d\u8981\u91cd\u590d\u8bf7\u6c42");
            return responseData;
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)redisKey, (Object)(convertCouponRecordId + ""), 3000L);
        ResponseData responseData = this.integrationShopService.payCouponSuccess(convertCouponRecordId, bizvaneTradeNo);
        this.redisTemplateService.deleteFromRedis((Object)redisKey);
        return responseData;
    }

    @PostMapping(value={"/getIntegralClassifyQRCordUrl"})
    public ResponseData getIntegralClassifyQRCordUrl(@RequestBody IntegralQRCodeRequestVO integralQRCodeRequestVO) {
        logger.info("IntegrationShopController_getIntegralClassifyQRCordUrl:{}", (Object)JSON.toJSONString((Object)integralQRCodeRequestVO));
        ResponseData responseData = this.integrationShopService.getIntegralClassifyQRCord(integralQRCodeRequestVO);
        return responseData;
    }

    @GetMapping(value={"getChargeGoodsList"})
    public ResponseData getChargeGoodsList(String sysBrandId, HttpServletRequest request) {
        logger.info("getChargeGoodsList\u5165\u53c2:getChargeGoodsList[{}]", (Object)sysBrandId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.getChargeGoodsList(sysBrandId, bizvaneSessionId);
    }

    @GetMapping(value={"getChargeGoodsListByMobile"})
    public ResponseData getChargeGoodsListByMobile(String sysBrandId, String mobile, HttpServletRequest request) {
        logger.info("getChargeGoodsListByMobile\u5165\u53c2:getChargeGoodsListByMobile[{}]", (Object)sysBrandId, (Object)mobile);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return this.integrationShopService.getChargeGoodsListByMobile(sysBrandId, mobile, bizvaneSessionId);
    }

    @GetMapping(value={"getHistoryChargeMobile"})
    public ResponseData getHistoryChargeMobile(String sysBrandId, HttpServletRequest request) {
        logger.info("getHistoryChargeMobile\u5165\u53c2:getHistoryChargeMobile[{}]", (Object)sysBrandId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("\u83b7\u53d6\u5230\u7684bizvaneSessionId --------------- = {}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u672a\u83b7\u53d6bizvaneSessionId");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.getHistoryChargeMobile(sysBrandId, memberCode);
    }

    @GetMapping(value={"autoShelfIntegralCoupon"})
    public ResponseData<String> autoShelfIntegralCoupon(@RequestParam Long exchangeId, @RequestParam Boolean shelfJudge) {
        return this.taskServiceForWXRpc.autoShelfIntegralCoupon(exchangeId, shelfJudge);
    }

    @GetMapping(value={"getStageUserMemberDataDesensitize"})
    public ResponseData<Boolean> getStageUserMemberDataDesensitize(@RequestParam(value="sysAccountId") Long sysAccountId) {
        ResponseData booleanResponseData = new ResponseData();
        booleanResponseData.setData((Object)Boolean.FALSE);
        try {
            ResponseData responseData = this.sysAccountServiceRpc.getByAccountId(sysAccountId);
            booleanResponseData.setData((Object)((SysAccountVo)responseData.getData()).getMemberDataDesensitize());
        }
        catch (Exception e) {
            logger.info("getStageUserMemberDataDesensitize:{}", (Throwable)e);
        }
        return booleanResponseData;
    }

    @RequestMapping(value={"getExchangeCouponOrGoodsIdByCode"}, method={RequestMethod.GET})
    public ResponseData<String> getExchangeCouponOrGoodsIdByCode(@RequestParam(value="sysBrandId", required=false) Long sysBrandId, @RequestParam(value="sysCompanyId", required=false) Long sysCompanyId, @RequestParam(value="code") String code, @RequestParam(value="type") Integer type, HttpServletRequest request) {
        sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        ResponseData responseData = this.integrationShopService.getExchangeCouponOrGoodsIdByCode(code, type, sysBrandId, sysCompanyId);
        return responseData;
    }

    @RequestMapping(value={"/shopHomePage/getClassifyMapByAttribute"}, method={RequestMethod.GET})
    public ResponseData<List<ShopClassifyMapVo>> getClassifyMapByAttribute(@RequestParam String sysBrandId, HttpServletRequest request) {
        logger.info("IntegrationShopController#getClassifyMapByAttribute#sysBrandId:{}", (Object)sysBrandId);
        return this.integrationShopService.getClassifyMapByAttribute(sysBrandId);
    }

    @RequestMapping(value={"/shopHomePage/getGoodsByParamsAndPage"}, method={RequestMethod.POST})
    public ResponseData<JSONObject> getGoodsByParamsAndPage(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        logger.info("IntegrationShopController#getGoodsByParamsAndPage#allMerchandiseVo:{}", JSON.toJSON((Object)allMerchandiseVo));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId != null) {
            String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            logger.info("IntegrationShopController#getGoodsByParamsAndPage#memberCode:{}", (Object)memberCode);
            if (memberCode != null) {
                allMerchandiseVo.setMemberCode(memberCode);
            }
        }
        return this.integrationShopService.getGoodsByParamsAndPage(allMerchandiseVo);
    }
}

