/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.IncreaseByTransferringService;
import com.bizvane.appletservice.models.bo.CouponDetailResponseBo;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.thymeleaf.util.StringUtils;

@RestController
@RequestMapping(value={"/increaseByTransferring"}, method={RequestMethod.POST})
public class IncreaseByTransferringController {
    @Autowired
    private IncreaseByTransferringService increaseByTransferringService;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/increaseInSecurities"}, method={RequestMethod.POST})
    public ResponseData increaseInSecurities(String couponCode, String transferDate, HttpServletRequest request) {
        logger.info("IncreaseByTransferringController increaseInSecurities couponCode:{},transferDate:{}", (Object)couponCode, (Object)transferDate);
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((String)couponCode)) {
            logger.info("increaseInSecurities couponCode is null");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((String)bizvaneSessionId) || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)brandId)) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId\u6216sysCompanyId\u6216sysBrandId");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((String)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.couponServiceFeign.couponGiving(couponCode, memberCode, Long.valueOf(Long.parseLong(companyId)), Long.valueOf(Long.parseLong(brandId)), transferDate);
    }

    @RequestMapping(value={"/transferCouponBack"}, method={RequestMethod.POST})
    public ResponseData transferCouponBack(String couponCode, HttpServletRequest request) {
        logger.info("IncreaseByTransferringController transferCouponBack couponCode:{}", (Object)couponCode);
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((String)couponCode)) {
            logger.info("increaseInSecurities couponCode is null");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((String)bizvaneSessionId) || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)brandId)) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId\u6216sysCompanyId\u6216sysBrandId");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((String)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.couponServiceFeign.transferCouponBack(couponCode, memberCode, Long.valueOf(Long.parseLong(companyId)), Long.valueOf(Long.parseLong(brandId)));
    }

    @RequestMapping(value={"/getIncreaseByTransferring"}, method={RequestMethod.POST})
    public ResponseData<CouponDetailResponseBo> increaseByTransferring(String couponCode, String transferMemberCode, String transferDate, HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        logger.info("IncreaseByTransferringController increaseByTransferring couponCode:{},transferMemberCode:{},transferDat:{},bizvaneSessionId:{},companyId:{},brandId:{}", new Object[]{couponCode, transferMemberCode, transferDate, bizvaneSessionId, companyId, brandId});
        return this.increaseByTransferringService.increaseByTransferring(couponCode, transferMemberCode, transferDate, bizvaneSessionId, Long.valueOf(Long.parseLong(companyId)), Long.valueOf(Long.parseLong(brandId)));
    }

    @RequestMapping(value={"/transfer"}, method={RequestMethod.POST})
    public ResponseData transfer(CouponEntityVO vo, HttpServletRequest request) {
        ResponseData coupon;
        int couponCode;
        ResponseData responseData = new ResponseData();
        logger.info("transfer\u5165\u53c2=====" + vo.getOldMemberCode());
        if (vo.getCouponCode() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u52b5\u7f16\u53f7");
            return responseData;
        }
        String key = "transfer_coupon" + vo.getCouponCode();
        Boolean isTransfer = this.redisTemplateService.hasKey((Object)key);
        if (isTransfer.booleanValue()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u975e\u5e38\u62b1\u6b49\u6b64\u5238\u5df2\u88ab\u4eba\u9886\u53d6");
            return responseData;
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)key, (Object)vo.getCouponCode(), 3000L);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((String)bizvaneSessionId) || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)brandId)) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId\u6216sysCompanyId\u6216sysBrandId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setNewMemberCode(memberCode);
        if (vo.getOldMemberCode() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u8001\u4f1a\u5458code");
            return responseData;
        }
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(companyId)));
        vo.setSysBrandId(Long.valueOf(Long.parseLong(brandId)));
        if (StringUtil.isNotEmpty((String)vo.getCreateDtStart())) {
            try {
                vo.setDtStart(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(vo.getCreateDtStart()));
            }
            catch (Exception e) {
                logger.info("\u8f6c\u8d60\u65f6\u95f4\u7c7b\u578b\u9519\u8bef\u3002dtStart:{}", (Object)vo.getCreateDtStart());
            }
        }
        if ((couponCode = (coupon = this.couponServiceFeign.givenCoupon(vo)).getCode()) == SysResponseEnum.SUCCESS.getCode()) {
            Date newTimes = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            this.redisTemplateService.stringSetString((Object)(memberCode + vo.getCouponCode()), (Object)df.format(newTimes));
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u9886\u53d6\u6210\u529f");
            responseData.setData((Object)memberCode);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u975e\u5e38\u62b1\u6b49\u6b64\u5238\u5df2\u88ab\u4eba\u9886\u53d6");
        return responseData;
    }
}

