/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.GraphicTemplateService;
import com.bizvane.appletservice.models.bo.ObtainGraphicBo;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/graphicTemplateServiceRpc"})
public class GraphicTemplateController {
    private static final Logger log = LoggerFactory.getLogger(GraphicTemplateController.class);
    @Autowired
    private GraphicTemplateService graphicTemplateService;
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;

    @RequestMapping(value={"/obtainGraphicTemplate"}, method={RequestMethod.POST})
    public ResponseData<ObtainGraphicBo> obtainGraphicTemplate(@RequestBody ObtainGraphicBo obtainGraphicBo) {
        return this.graphicTemplateService.obtainGraphicTemplate(obtainGraphicBo);
    }

    @PostMapping(value={"/groupSending"})
    public ResponseData groupSending(@RequestBody ObtainGraphicBo obtainGraphicBo) {
        log.info("graphicTemplateController#groupSending#obtainGraphicBo:{}", (Object)JSON.toJSONString((Object)obtainGraphicBo));
        return this.graphicTemplateService.groupSending(obtainGraphicBo);
    }

    @RequestMapping(value={"/groupSendingDoing"}, method={RequestMethod.GET})
    public ResponseData groupSendingDoing(@RequestParam(value="msgId") String msgId, @RequestParam(value="brandId") Long brandId) {
        return this.graphicTemplateService.groupSendingDoing(msgId, brandId);
    }

    @RequestMapping(value={"/groupSendDelete"}, method={RequestMethod.GET})
    public ResponseData groupSendDelete(@RequestParam(value="msgId") String msgId, @RequestParam(value="brandId") Long brandId) {
        return this.graphicTemplateService.groupSendDelete(msgId, brandId);
    }
}

