/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.FitmentService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.vo.NorthOuBiRecordVO;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.fitmentservice.models.vo.AppletCustomerConfigVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.MiniProgramPropertyVipCardShowBo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.unifiedreg.rpc.AppletServiceFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fitment"})
public class FitmentController {
    @Autowired
    private FitmentService fitmentService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private AppletServiceFeign appletServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    private DecimalFormat df = new DecimalFormat("###,###.00");
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/selectBrandIntroduce"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData selectBrandIntroduce(Long sysBrandId) {
        return this.fitmentService.selectBrandIntroduce(sysBrandId);
    }

    @RequestMapping(value={"/northOuBiRecord"})
    public ResponseData northOuBiRecord(NorthOuBiRecordVO northOuBiRecordVO, HttpServletRequest request) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(northOuBiRecordVO.getMemberCode());
        MemberInfoModel memberModel = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModel).getData();
        if (memberModel != null) {
            northOuBiRecordVO.setSysCompanyId(memberModel.getSysCompanyId());
        }
        return this.fitmentService.northOuBiRecord(northOuBiRecordVO);
    }

    @RequestMapping(value={"/getBaseAndExtendPropertyValueVipCardStyle"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData getBaseAndExtendPropertyValueVipCardStyle(Long brandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String memberCode = this.loginService.getMemberCode(request);
        ResponseData miniProgramPropertyVipCardShow = this.appletServiceFeign.getMiniProgramPropertyVipCardShow(brandId, memberCode);
        List cardShowData = (List)miniProgramPropertyVipCardShow.getData();
        if (cardShowData == null) {
            return responseData;
        }
        for (MiniProgramPropertyVipCardShowBo miniProgramPropertyVipCardShowBo : cardShowData) {
            String propertyValue;
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().contains("phone_")) {
                propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue();
                logger.info("phone_+propertyValueString={}", (Object)propertyValue);
                if (propertyValue.length() == 11) {
                    String securityPhone = propertyValue.replaceAll("(\\d{3})\\d*(\\d{2})", "$1******$2");
                    logger.info("phone_+securityPhone={}", (Object)securityPhone);
                    miniProgramPropertyVipCardShowBo.setPropertyValue(securityPhone);
                }
            }
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().contains("integral_")) {
                propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue();
                logger.info("integral_+propertyValueString={}", (Object)propertyValue);
                Integer integer = Integer.valueOf(propertyValue);
                logger.info("integral_+propertyValueInteger={}", (Object)integer);
            }
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().contains("extend_")) {
                propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue();
                String propertyType = miniProgramPropertyVipCardShowBo.getPropertyType();
                if ("4".equals(propertyType) && StringUtils.isBlank((CharSequence)propertyValue)) {
                    miniProgramPropertyVipCardShowBo.setPropertyValue("0");
                }
            }
            if (!miniProgramPropertyVipCardShowBo.getPropertyCode().contains("gender_") || !StringUtils.isNotBlank((CharSequence)(propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue())) || !"3".equals(propertyValue)) continue;
            miniProgramPropertyVipCardShowBo.setPropertyValue("");
        }
        responseData.setData((Object)cardShowData);
        return responseData;
    }

    @RequestMapping(value={"/getMiniProgramPropertyIntegralFromOffline"})
    public ResponseData getMiniProgramPropertyIntegralFromOffline(Long brandId, String memberCardNo, String memberCode) {
        logger.info("brandId={}", (Object)JSON.toJSONString((Object)brandId));
        logger.info("memberCode={}", (Object)JSON.toJSONString((Object)memberCode));
        logger.info("memberCardNo={}", (Object)JSON.toJSONString((Object)memberCardNo));
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("brandId \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)memberCardNo)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("memberCardNo \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        ResponseData integral = this.wxAppletApiService.getMiniProgramPropertyIntegral(brandId, memberCardNo, memberCode);
        return integral;
    }

    @RequestMapping(value={"/getCustomerConfig"}, method={RequestMethod.GET})
    public ResponseData<AppletCustomerConfigVo> getCustomerConfig(HttpServletRequest request) {
        ResponseData brandPoRes;
        String sysCompanyId = request.getHeader("sysCompanyId");
        String sysBrandId = request.getHeader("sysBrandId");
        logger.info("getCustomerConfig mthod sysCompanyId:{},sysBrandId:{}", (Object)sysCompanyId, (Object)sysBrandId);
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            throw LogicException.error((Integer)-100, (String)"\u672a\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        if (StringUtils.isBlank((CharSequence)sysCompanyId) && (brandPoRes = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId))) != null && brandPoRes.getData() != null) {
            sysCompanyId = ((SysBrandPo)brandPoRes.getData()).getSysCompanyId().toString();
        }
        return this.fitmentService.getCustomerConfig(Long.valueOf(sysCompanyId), Long.valueOf(sysBrandId));
    }
}

