/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bizvane.appletservice.models.vo.TraceRecordMiniVo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.models.vo.WxqyLoginResponseVO;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.members.facade.models.qywx.WxqyPendingParam;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.entity.po.MiniProgramLoginParam;
import com.bizvane.wechatenterprise.service.rpc.SystemServiceRpc;
import com.bizvane.wechatfacade.interfaces.QRCodeServiceFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/coreTrace"})
public class CoreTraceController {
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private SystemServiceRpc systemServiceRpc;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private QRCodeServiceFeign qrCodeServiceFeign;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Value(value="${yiWen.brandId}")
    private Long yiWenBrandId;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/saveTraceRecord"}, method={RequestMethod.POST})
    public ResponseData saveTraceRecord(@RequestBody TraceRecordVo vo) {
        logger.info("enter CoreTraceController saveTraceRecord method {}", (Object)JacksonUtil.bean2Json((Object)vo));
        TracePO tracePO = (TracePO)this.coreTraceFeign.selectByTraceId(vo.getTraceId()).getData();
        if (tracePO != null && StringUtils.isNotBlank((String)tracePO.getTraceValue())) {
            JSONObject json = JSON.parseObject((String)tracePO.getTraceValue());
            Long storeId = json.getLong("storeId");
            Long guideId = json.getLong("guideId");
            if (storeId != null || guideId != null) {
                WxqyPendingParam wxqyPendingParam = new WxqyPendingParam(vo.getSysCompanyId(), vo.getBrandId(), vo.getUnionId(), vo.getOpenId(), "2");
                SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("mbr_wxqy_pending_deal").tag("*").build(), (Object)wxqyPendingParam);
                logger.info("sendResult:{}", JSON.toJSON((Object)sendResult));
            }
        }
        return this.coreTraceFeign.saveTraceRecord(vo);
    }

    @Deprecated
    @RequestMapping(value={"/getTraceByParamId"}, method={RequestMethod.GET})
    public ResponseData getTraceByTraceId(@RequestParam(value="paramId") Long paramId) {
        logger.info("enter CoreTraceController getTraceByParamId method! ");
        ResponseData paramData = this.qrCodeServiceFeign.queryParam(paramId);
        if (paramData == null || SysResponseEnum.SUCCESS.getCode() != paramData.getCode() || StringUtils.isBlank((String)((String)paramData.getData()))) {
            return new ResponseData();
        }
        Long traceId = Long.parseLong((String)paramData.getData());
        ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(traceId);
        logger.info("coreTraceFeign#selectByTraceId,res:{}", (Object)JSONObject.toJSONString((Object)tracePOResponseData));
        return tracePOResponseData;
    }

    @RequestMapping(value={"/getParamByParamId"}, method={RequestMethod.GET})
    public ResponseData getParamByParamId(@RequestParam(value="paramId") String paramId) {
        Long id;
        ResponseData paramData;
        logger.info("enter CoreTraceController getParamByParamId method! ");
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        if (paramId.startsWith("pn:")) {
            paramId = paramId.replaceFirst("pn:", "");
        }
        if ((paramData = this.qrCodeServiceFeign.queryParam(id = Long.valueOf(Long.parseLong(paramId)))) != null && SysResponseEnum.SUCCESS.getCode() == paramData.getCode() && StringUtils.isNotBlank((String)((String)paramData.getData()))) {
            String data = (String)paramData.getData();
            boolean b = JSONUtil.isJson((String)data);
            if (b) {
                Map map = JacksonUtil.json2Map((String)data);
                responseData.setData((Object)map);
            } else {
                responseData.setData((Object)data);
            }
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/saveTraceRecordByMini"}, method={RequestMethod.POST})
    public ResponseData saveTraceRecordByMini(@RequestBody TraceRecordMiniVo vo) {
        ResponseData responseData = new ResponseData();
        logger.info("enter CoreTraceController saveTraceRecordByMini method: {}", (Object)JacksonUtil.bean2Json((Object)vo));
        if (vo.getSysCompanyId() == null) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)vo.getUnionId())) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage("unionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getParamId() == null) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage("\u5fae\u4fe1\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getParamId() != null) {
            ResponseData paramData = this.qrCodeServiceFeign.queryParam(vo.getParamId());
            if (paramData != null && StringUtils.isNotEmpty((String)((String)paramData.getData()))) {
                Long traceId = Long.parseLong((String)paramData.getData());
                vo.setTraceId(traceId);
                responseData = this.coreTraceFeign.saveTraceRecord((TraceRecordVo)vo);
            }
            WxqyPendingParam wxqyPendingParam = new WxqyPendingParam(vo.getSysCompanyId(), vo.getBrandId(), vo.getUnionId(), vo.getOpenId(), "2");
            SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("mbr_wxqy_pending_deal").tag("*").build(), (Object)wxqyPendingParam);
            logger.info("sendResult:{}", JSON.toJSON((Object)sendResult));
        }
        return responseData;
    }

    @RequestMapping(value={"/saveTraceByCode"}, method={RequestMethod.POST})
    public ResponseData saveTraceByCode(@RequestParam(value="code") String code, @RequestParam(value="appId") String appId, @RequestParam(value="sourceWay", required=false) String sourceWay) {
        logger.info("enter CoreTraceController saveTraceByCode method! ");
        ResponseData responseData = new ResponseData();
        ResponseData WxPublicPoResponseData = this.wxPublicServiceFeign.getWxPublicPOByAppId(appId);
        WxPublicPO wxPublicPo = (WxPublicPO)WxPublicPoResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != WxPublicPoResponseData.getCode() || WxPublicPoResponseData.getData() == null) {
            logger.info("\u6839\u636eappid \u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u54c1\u724c appid:{}", (Object)appId);
            responseData.setMessage("\u6839\u636eappid \u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u54c1\u724c");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        MiniProgramLoginParam param = new MiniProgramLoginParam();
        param.setCode(code);
        param.setType("member");
        param.setSysCompanyId(wxPublicPo.getSysCompanyId());
        param.setSysBrandId(wxPublicPo.getSysBrandId());
        ResponseData wxqyResponseData = this.miniProgramLogin(param);
        WxqyLoginResponseVO wxqyLoginResponseVO = (WxqyLoginResponseVO)wxqyResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != wxqyResponseData.getCode() || wxqyResponseData.getData() == null) {
            logger.info("\u8c03\u4f01\u5fae\u67e5\u8be2\u5bfc\u8d2d\u95e8\u5e97\u4fe1\u606f\u5931\u8d25\uff0ccode:{}", (Object)code);
            responseData.setMessage("\u8c03\u4f01\u5fae\u67e5\u8be2\u5bfc\u8d2d\u95e8\u5e97\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String traceValue = "";
        traceValue = StringUtils.isNotEmpty((String)sourceWay) ? "{\"source_way\":\"" + sourceWay + "\",\"channel\":\"1\",\"sub_channel\":\"2\",\"guideId\":\"" + wxqyLoginResponseVO.getSysStaffId() + "\",\"storeId\":\"" + wxqyLoginResponseVO.getSysStoreId() + "\"}" : "{\"source_way\":\"wxqyGuide2friend\",\"channel\":\"1\",\"sub_channel\":\"2\",\"guideId\":\"" + wxqyLoginResponseVO.getSysStaffId() + "\",\"storeId\":\"" + wxqyLoginResponseVO.getSysStoreId() + "\"}";
        JSONObject traceValueJSON = JSON.parseObject((String)traceValue);
        traceValueJSON.fluentPut("guideId", (Object)traceValueJSON.getLong("guideId")).fluentPut("storeId", (Object)traceValueJSON.getLong("storeId"));
        traceValue = JSON.toJSONString((Object)traceValueJSON, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        logger.info("traceValue:{}", (Object)traceValue);
        TracePO po = new TracePO();
        po.setTraceValue(traceValue);
        po.setCreateDate(new Date());
        po.setSysCompanyId(wxPublicPo.getSysCompanyId());
        po.setBrandId(wxPublicPo.getSysBrandId());
        return this.coreTraceFeign.insertTrace(po);
    }

    @RequestMapping(value={"/insertTrace"}, method={RequestMethod.POST})
    public ResponseData insertTrace(@RequestBody TracePO vo) {
        logger.info("enter CoreTraceController insertTrace method! vo:{}", (Object)JSONObject.toJSONString((Object)vo));
        return this.coreTraceFeign.insertTrace(vo);
    }

    @RequestMapping(value={"/getStoreGuideByCode"}, method={RequestMethod.POST})
    public ResponseData<WxqyLoginResponseVO> getStoreGuideByCode(@RequestParam(value="code") String code, @RequestParam(value="sysCompanyId") Long sysCompanyId, @RequestParam(value="sysBrandId") Long sysBrandId) {
        logger.info("CoreTraceController getStoreGuideByCode ");
        MiniProgramLoginParam param = new MiniProgramLoginParam();
        param.setCode(code);
        param.setType("member");
        param.setSysCompanyId(sysCompanyId);
        param.setSysBrandId(sysBrandId);
        return this.miniProgramLogin(param);
    }

    public static void main(String[] args) {
        WxqyLoginResponseVO wxqyLoginResponseVO = new WxqyLoginResponseVO();
        wxqyLoginResponseVO.setSysStaffId(Long.valueOf(1111L));
        wxqyLoginResponseVO.setSysStoreId(Long.valueOf(2222L));
        String sourceWay = "wxqyGuide2friend";
        String traceValue = "";
        traceValue = StringUtils.isNotEmpty((String)sourceWay) ? "{\"source_way\":\"" + sourceWay + "\",\"channel\":\"1\",\"sub_channel\":\"2\",\"guideId\":\"" + wxqyLoginResponseVO.getSysStaffId() + "\",\"storeId\":\"" + wxqyLoginResponseVO.getSysStoreId() + "\"}" : "{\"source_way\":\"wxqyGuide2friend\",\"channel\":\"1\",\"sub_channel\":\"2\",\"guideId\":\"" + wxqyLoginResponseVO.getSysStaffId() + "\",\"storeId\":\"" + wxqyLoginResponseVO.getSysStoreId() + "\"}";
    }

    private ResponseData<WxqyLoginResponseVO> miniProgramLogin(MiniProgramLoginParam param) {
        if (this.yiWenBrandId == null || !this.yiWenBrandId.equals(param.getSysBrandId())) {
            return this.systemServiceRpc.miniProgramLogin(param);
        }
        ResponseData userIdResponseData = this.systemServiceRpc.getUserIdByCodeMiniProgram(param);
        ResponseData responseData = new ResponseData();
        if (SysResponseEnum.SUCCESS.getCode() != userIdResponseData.getCode() || userIdResponseData.getData() == null) {
            logger.info("\u8c03\u4f01\u5fae\u67e5\u8be2\u5bfc\u8d2d\u95e8\u5e97\u4fe1\u606f\u5931\u8d25\uff0ccode:{}", (Object)param.getCode());
            responseData.setMessage("\u8c03\u4f01\u5fae\u67e5\u8be2userId\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String yiWenUserId = (String)userIdResponseData.getData();
        ResponseData staffPoResponseData = this.staffServiceRpc.getStaffInfoByCode(yiWenUserId, param.getSysCompanyId());
        SysStaffPo sysStaffPo = (SysStaffPo)staffPoResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != staffPoResponseData.getCode() || sysStaffPo == null) {
            logger.info("\u8c03\u4e2d\u53f0\u67e5\u8be2\u5bfc\u8d2d\u4fe1\u606f\u5931\u8d25\uff0cuserId:{}", (Object)yiWenUserId);
            responseData.setMessage("\u8c03\u4e2d\u53f0\u67e5\u8be2\u5bfc\u8d2d\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        ResponseData storeStaffInfoResponseData = this.staffServiceRpc.getStoreStaffInfo(sysStaffPo.getSysStaffId(), param.getSysCompanyId(), param.getSysBrandId());
        StaffVo staffVo = (StaffVo)storeStaffInfoResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != storeStaffInfoResponseData.getCode() || staffVo == null) {
            logger.info("\u8c03\u4e2d\u53f0\u67e5\u8be2\u5bfc\u8d2d\u95e8\u5e97\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff0cuserId:{}", (Object)yiWenUserId);
            responseData.setMessage("\u8c03\u4e2d\u53f0\u67e5\u8be2\u5bfc\u8d2d\u95e8\u5e97\u5173\u8054\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        WxqyLoginResponseVO wxqyLoginResponseVO = new WxqyLoginResponseVO();
        wxqyLoginResponseVO.setSysStaffId(sysStaffPo.getSysStaffId());
        wxqyLoginResponseVO.setSysStoreId(staffVo.getSysStoreId());
        wxqyLoginResponseVO.setSysBrandId(param.getSysBrandId());
        wxqyLoginResponseVO.setSysCompanyId(param.getSysCompanyId());
        wxqyLoginResponseVO.setStaffCode(sysStaffPo.getStaffCode());
        wxqyLoginResponseVO.setStaffName(sysStaffPo.getStaffName());
        responseData.setData((Object)wxqyLoginResponseVO);
        return responseData;
    }
}

