/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.ActivityRegistrationService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.ActivityRegistrationVO;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.qywxapi.CompanyMemberApiService;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.mktcenterservice.models.vo.SignupHistory;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.UserAuthorizationFeign;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberResponseVO;
import com.bizvane.wechatfacade.models.vo.WxCodeResolveVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ebf\u4e0b\u62a5\u540d\u6d3b\u52a8\u76f8\u5173"})
@RestController
@RequestMapping(value={"activity/registration"})
public class ActivityRegistrationController {
    private static final Logger log = LoggerFactory.getLogger(ActivityRegistrationController.class);
    @Autowired
    private ActivityRegistrationService activityRegistrationService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private UserAuthorizationFeign userAuthorizationFeign;
    @Autowired
    private LoginService loginService;
    @Autowired
    private CompanyMemberApiService companyMemberApiService;

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u5217\u8868")
    @PostMapping(value={"list"})
    public ResponseData<PageInfo<ActivityRegistrationVO>> getActivityList(PageForm pageForm) {
        return this.activityRegistrationService.getActivityRegistrationList(pageForm);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5 \u767b\u9646\u540e\u4f1a\u8fd4\u56de\u662f\u5426\u5df2\u7ecf\u62a5\u540d")
    @PostMapping(value={"detail"})
    public ResponseData<ActivityRegistrationVO> detail(String activityCode, HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        return this.activityRegistrationService.getActivityRegistrationDetail(activityCode, memberCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\uff0c\u5e26\u6269\u5c55\u5b57\u6bb5")
    @PostMapping(value={"memberInfo"})
    public ResponseData memberInfo(HttpServletRequest request) {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setBrandId(memberResourceBO.getBrandId());
        memberInfoModel.setMemberCode(memberResourceBO.getMemberCode());
        ResponseData responseData = this.companyMemberApiService.queryMemberCardInfo(memberInfoModel);
        return responseData;
    }

    @ApiOperation(value="\u81ea\u5df1\u62a5\u540d\u6216\u672a\u767b\u5f55\u70b9\u51fb\u5e2e\u522b\u4eba\u62a5\u540d\u65f6\uff0c\u8c03\u7528\u8fd9\u4e2a\u63a5\u53e3")
    @PostMapping(value={"signup"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="activityCode", value="\u6d3b\u52a8\u4ee3\u7801"), @ApiImplicitParam(name="customProperties", value="\u62a5\u540d\u8d44\u6599\u7684json,\u5305\u542b\uff0ckey\u4e3apropertyName\uff0cvalue\u4e3a\u586b\u5199\u7684\u503c \u5982{\"\u624b\u673a\u53f7\":\"123****1234\",\"\u59d3\u540d\":\"\u738b\u5c0f\u660e\"}"), @ApiImplicitParam(name="code", value="\u5fae\u4fe1code\uff0c\u5f53\u672a\u767b\u5f55\u65f6\u624d\u4f20"), @ApiImplicitParam(name="appid", value="\u5fae\u4fe1appid\uff0c\u5f53\u672a\u767b\u5f55\u65f6\u624d\u4f20")})
    public ResponseData<Object> signup(String activityCode, String customProperties, String code, String appid, HttpServletRequest request) {
        Map properties = JacksonUtil.json2Map1((String)customProperties);
        String memberCode = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{code, appid})) {
            try {
                ResponseData appletBrandMenberBoResponseData = this.loginService.getUserInfobyCode(code, appid);
                memberCode = ((AppletBrandMenberBo)appletBrandMenberBoResponseData.getData()).getMemberCode();
            }
            catch (Exception e) {
                log.error("\u975e\u4f1a\u5458\u626b\u7801", (Throwable)e);
            }
        } else {
            String bizvaneSessionId = request.getHeader("bizvaneSessionId");
            memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        }
        try {
            return this.activityRegistrationService.signup(activityCode, properties, memberCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getFailedData((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5f53\u5df2\u767b\u5f55\u4e14\u70b9\u51fb\u4e3a\u4ed6\u4eba\u62a5\u540d\u65f6\uff0c\u8c03\u7528\u8fd9\u4e2a\u63a5\u53e3")
    @PostMapping(value={"signup4others"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="activityCode", value="\u6d3b\u52a8\u4ee3\u7801"), @ApiImplicitParam(name="customProperties", value="\u62a5\u540d\u8d44\u6599\u7684json,\u5305\u542b\uff0ckey\u4e3apropertyName\uff0cvalue\u4e3a\u586b\u5199\u7684\u503c \u5982{\"\u624b\u673a\":\"123****1234\",\"\u59d3\u540d\":\"\u738b\u5c0f\u660e\"}"), @ApiImplicitParam(name="code", value="\u5fae\u4fe1code\uff0c\u5f53\u672a\u767b\u5f55\u65f6\u624d\u4f20"), @ApiImplicitParam(name="appid", value="\u5fae\u4fe1appid\uff0c\u5f53\u672a\u767b\u5f55\u65f6\u624d\u4f20")})
    public ResponseData<Object> signup4others(String activityCode, String customProperties, String code, String appid, HttpServletRequest request) {
        Map properties = JacksonUtil.json2Map1((String)customProperties);
        String memberCode = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{code, appid})) {
            try {
                ResponseData appletBrandMenberBoResponseData = this.loginService.getUserInfobyCode(code, appid);
                memberCode = ((AppletBrandMenberBo)appletBrandMenberBoResponseData.getData()).getMemberCode();
            }
            catch (Exception e) {
                log.error("\u975e\u4f1a\u5458\u626b\u7801", (Throwable)e);
            }
        } else {
            String bizvaneSessionId = request.getHeader("bizvaneSessionId");
            memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        }
        return this.activityRegistrationService.signup4others(activityCode, properties, memberCode);
    }

    @ApiOperation(value="\u6d3b\u52a8\u7b7e\u5230")
    @PostMapping(value={"signin"})
    public ResponseData<Object> signin(String activityCode, String phone) {
        return this.activityRegistrationService.signin(activityCode, phone);
    }

    @ApiOperation(value="\u62a5\u540d\u5386\u53f2")
    @PostMapping(value={"signupHistory"})
    public ResponseData<List<SignupHistory>> signupHistory(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(119);
            return responseData;
        }
        return this.activityRegistrationService.signupHistory(memberCode);
    }

    @ApiOperation(value="\u89e3\u5bc6\u624b\u673a\u53f7", response=UserAuthorizationGetPhoneNumberResponseVO.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="phoneNumberData", value="\u52a0\u5bc6\u5185\u5bb9", required=true, dataType="String"), @ApiImplicitParam(name="iv", value="\u504f\u79fb\u91cf", required=true, dataType="String"), @ApiImplicitParam(name="code", value="code", required=true, dataType="String")})
    @PostMapping(value={"/phone"})
    public ResponseData<UserAuthorizationGetPhoneNumberResponseVO> getPhone(String phoneNumberData, String code, String appid, HttpServletRequest request) {
        ResponseData codeResolve = this.userAuthorizationFeign.wxCodeResolve(code, appid);
        if (Objects.equals(codeResolve.getCode(), SysResponseEnum.FAILED.getCode())) {
            throw LogicException.error((Integer)-1, (String)codeResolve.getMessage());
        }
        if (codeResolve.getData() == null) {
            throw LogicException.error((Integer)-1, (String)"\u83b7\u53d6\u624b\u673a\u53f7\u5931\u8d25");
        }
        UserAuthorizationGetPhoneNumberRequestVO vo = new UserAuthorizationGetPhoneNumberRequestVO();
        vo.setBizvaneSessionId(((WxCodeResolveVo)codeResolve.getData()).getBizvaneSessionId());
        vo.setAppid(appid);
        vo.setPhoneNumberData(phoneNumberData);
        return this.userAuthorizationFeign.getPhoneNumber(vo);
    }
}

