/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletservice.utils;

import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ImageUrlValidator {
    private static final String[] IMAGE_CONTENT_TYPES = new String[]{"image/jpeg", "image/png", "image/gif", "image/bmp", "image/webp", "image/svg+xml", "image/tiff"};

    public static boolean isImageUrl(String urlString) {
        try {
            if (urlString.startsWith("https")) {
                ImageUrlValidator.disableSslVerification();
            }
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return false;
            }
            String contentType = connection.getContentType();
            if (contentType == null) {
                return false;
            }
            String mainType = contentType.split(";")[0].trim();
            for (String imageType : IMAGE_CONTENT_TYPES) {
                if (!mainType.equalsIgnoreCase(imageType)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("\u68c0\u67e5URL\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            return false;
        }
    }

    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String testUrl = "https://resource.uat.bizvane.cn/1755240108003";
        boolean isImage = ImageUrlValidator.isImageUrl(testUrl);
        if (isImage) {
            System.out.println("\u8be5URL\u6307\u5411\u56fe\u7247\u8d44\u6e90");
        } else {
            System.out.println("\u8be5URL\u4e0d\u6307\u5411\u56fe\u7247\u8d44\u6e90");
        }
    }
}

