package com.bizvane.appletservice.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分订单（券+实物订单）出参对象
 */
@Data
public class IntegralOrderResponseVo {

    /**
     * 订单主表
     */
    @ApiModelProperty(value = "订单号")
    private String orderNo;
    @ApiModelProperty(value = "会员卡号")
    private String cardNo;
    @ApiModelProperty(value = "会员手机号")
    private String phone;
    @ApiModelProperty(value = "订单创建时间")
    private Date orderTime;
    @ApiModelProperty(value = "提货门店code")
    private String selfPickStoreCode;
    @ApiModelProperty(value = "提货门店名称")
    private String selfPickStoreName;
    @ApiModelProperty("配送方式(实物订单才有)：0：寄货到家(快递)、1：寄货到店(自提)")
    private Integer shippingMode;
    @ApiModelProperty("订单类型：1：实物订单，2券订单")
    private Integer orderType;

    /**
     * 订单明细
     */
    @ApiModelProperty(value = "sku对应下单数量")
    private Integer saleQuantity;
    @ApiModelProperty(value = "订单实付积分")
    private Integer payedIntegral;
    @ApiModelProperty(value = "订单实付现金")
    private BigDecimal payedCash;

    /**
     * 商品
     */
    @ApiModelProperty(value = "商品编号")
    private String goodsNo;
    @ApiModelProperty(value = "商品名称")
    private String goodsName;
    @ApiModelProperty(value = "商品主图")
    private String goodsCoverImg;

    /**
     * sku
     */
    @ApiModelProperty(value = "sku编号")
    private String skuNo;
    @ApiModelProperty(value = "规格名称")
    private String specNames;
    @ApiModelProperty(value = "sku图片")
    private String skuImg;
}
