package com.bizvane.alipayfacade.interfaces.alipay;

import com.alipay.api.domain.AlipayMarketingRecruitEnrollCloseModel;
import com.alipay.api.domain.AlipayMarketingRecruitEnrollCreateModel;
import com.alipay.api.domain.AlipayMarketingRecruitPlanQueryModel;
import com.alipay.api.domain.AlipayMarketingRecruitPlanlistQueryModel;
import com.alipay.api.response.*;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayImageRequestVo;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value="${feign.client.alipay.name}",path="${feign.client.alipay.path}/alipayMarketingRecruitPlanList")
@Api(value = "支付宝商家券",tags = {"支付宝商家券"})
public interface AlipayMarketingRecruitPlanListFeign {

    /**
     * 查询可报名的方案列表
     * <a>https://opendocs.alipay.com/pre-open/02bijp</a>
     */
    @PostMapping("/recruitPlanListQuery")
    ResponseData<AlipayMarketingRecruitPlanlistQueryResponse> recruitPlanListQuery(@RequestBody @Valid AlipayRequestVo<AlipayMarketingRecruitPlanlistQueryModel> requestVo);

    /**
     * 招商方案详情查询
     * <a>https://opendocs.alipay.com/pre-open/02bhl7</a>
     */
    @PostMapping("/recruitPlanQuery")
    ResponseData<AlipayMarketingRecruitPlanQueryResponse> recruitPlanQuery(@RequestBody @Valid AlipayRequestVo<AlipayMarketingRecruitPlanQueryModel> requestVo);

    /**
     * 营销图片资源上传接口
     * <a>https://opendocs.alipay.com/pre-open/02bhlj</a>
     */
    @PostMapping("/materialImageUpload")
    ResponseData<AlipayMarketingMaterialImageUploadResponse> materialImageUpload(@RequestBody @Valid AlipayRequestVo<AlipayImageRequestVo> requestVo);

    /**
     * 招商报名提交
     * <a>https://opendocs.alipay.com/pre-open/02bhl8</a>
     */
    @PostMapping("/recruitEnrollCreate")
    ResponseData<AlipayMarketingRecruitEnrollCreateResponse> recruitEnrollCreate(@RequestBody @Valid AlipayRequestVo<AlipayMarketingRecruitEnrollCreateModel> requestVo);


    /**
     * 招商报名提交
     * <a>https://opendocs.alipay.com/pre-open/02bhl8</a>
     */
    @PostMapping("/recruitEnrollClose")
    ResponseData<AlipayMarketingRecruitEnrollCloseResponse> recruitEnrollClose(@RequestBody AlipayRequestVo<AlipayMarketingRecruitEnrollCloseModel> requestVo);

}
