package com.bizvane.alipayfacade.interfaces.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.domain.*;
import com.alipay.api.response.*;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value="${feign.client.alipay.name}",path="${feign.client.alipay.path}/alipayMarketingActivityOrderVoucher")
@Api(value = "支付宝商家券",tags = {"支付宝商家券"})
public interface AlipayMarketingActivityOrderVoucherFeign {

    /**
     * 创建商家券活动
     * <a>https://opendocs.alipay.com/pre-open/0290rn</a>
     */
    @PostMapping("/orderVoucherCreate")
    ResponseData<AlipayMarketingActivityOrdervoucherCreateResponse> orderVoucherCreate(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityOrdervoucherCreateModel> requestVo) ;

    /**
     * 商家券上传券码
     * <a>https://opendocs.alipay.com/pre-open/0290rp</a>
     */
    @PostMapping("/orderVoucherCodeDeposit")
    ResponseData<AlipayMarketingActivityOrdervoucherCodedepositResponse> orderVoucherCodeDeposit(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityOrdervoucherCodedepositModel> requestVo) ;

    /**
     * 追加商家券活动
     * <a>https://opendocs.alipay.com/pre-open/028xrf</a>
     */
    @PostMapping("/orderVoucherAppend")
    ResponseData<AlipayMarketingActivityOrdervoucherAppendResponse> orderVoucherAppend(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityOrdervoucherAppendModel> requestVo) ;

    /**
     * 停止商家券活动
     * <a>https://opendocs.alipay.com/pre-open/0290ru</a>
     */
    @PostMapping("/orderVoucherStop")
    ResponseData<AlipayMarketingActivityOrdervoucherStopResponse> orderVoucherStop(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityOrdervoucherStopModel> requestVo);

    /**
     * 同步券核销状态
     * <a>https://opendocs.alipay.com/pre-open/028xrg</a>
     */
    @PostMapping("/orderVoucherUse")
    ResponseData<AlipayMarketingActivityOrdervoucherUseResponse> orderVoucherUse(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityOrdervoucherUseModel> requestVo);
}
