package com.bizvane.alipayfacade.interfaces;

import com.bizvane.alipayfacade.models.vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.bizvane.utils.responseinfo.ResponseData;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value="${feign.client.alipay.name}", path="${feign.client.alipay.path}/alipayUserAuthorization")
@Api(value = "小程序授权相关接口",tags = {"小程序授权相关接口"})
public interface AlipayUserAuthorizationFeign {

    @ApiOperation(value = "授权code获取session_key")
    @PostMapping(value = "/byCode")
    ResponseData<AlipayCodeResolveVo> byCode(@RequestParam("code") String code, @RequestParam("appid") String appid);

    @ApiOperation(value = "获取手机号")
    @PostMapping(value = "/getPhoneNumber")
    ResponseData<UserAuthorizationGetPhoneNumberResponseVO> getPhoneNumber(@RequestBody UserAuthorizationGetPhoneNumberRequestVO vo);

}
