package com.bizvane.alipayfacade.interfaces;

import com.bizvane.alipayfacade.models.po.AlipayPublicPo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@FeignClient(value="${feign.client.alipay.name}", path="${feign.client.alipay.path}/alipayPublic")
@Api(value="支付宝生活号/小程序相关接口")
public interface AlipayPublicServiceFeign {
    /**
     * 根据appid获得公众号信息
     * @param appid
     * @return
     */
    @ApiOperation(value = "根据appid获得公众号信息")
    @PostMapping("/getAlipayPublicByAppid")
    ResponseData<AlipayPublicPo> getAlipayPublicByAppid(@RequestParam("appid") String appid);

    /**
     * 根据brandId+type获得公众号信息
     */
    @ApiOperation(value = "根据brandId+type获得公众号信息")
    @PostMapping("/getAlipayPublicByBrandIdAndType")
    ResponseData<AlipayPublicPo> getAlipayPublicByBrandIdAndType(@RequestParam("sysBrandId") Long sysBrandId,@RequestParam("alipayPublicType") String alipayPublicType,@RequestParam("miniProgramtype") String miniProgramtype);

}
