package com.bizvane.alipayfacade.interfaces;

import com.bizvane.alipayfacade.models.vo.AlipayChannelInfoVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(value="${feign.client.alipay.name}", path="${feign.client.alipay.path}/alipayChannelMembers")
@Api(value="支付宝渠道会员接口")
public interface AlipayChannelMembersFeign {

    @ApiOperation(value = "查询渠道下会员信息")
    @PostMapping("/getAlipayChannelMemberInfo")
    ResponseData<AlipayChannelInfoVo> getAlipayChannelMemberInfo(@RequestBody AlipayChannelInfoVo alipayChannelInfoVo);

    @ApiOperation(value = "渠道会员注册")
    @PostMapping("/addAlipayChannelMemberInfo")
    ResponseData<AlipayChannelInfoVo> addAlipayChannelMemberInfo(@RequestBody AlipayChannelInfoVo alipayChannelInfoVo);

    @ApiOperation(value = "查询渠道下会员信息")
    @PostMapping("/getAlipayChannelMemberInfoByMemberCode")
    ResponseData<AlipayChannelInfoVo> getAlipayChannelMemberInfoByMemberCode(@RequestBody AlipayChannelInfoVo alipayChannelInfoVo);
}
