package com.bizvane.alipayfacade.interfaces.alipay;

import com.alipay.api.domain.AlipayMarketingActivityDeliveryCreateModel;
import com.alipay.api.domain.AlipayMarketingActivityDeliveryStopModel;
import com.alipay.api.domain.AlipayMarketingActivityDeliverychannelQueryModel;
import com.alipay.api.response.AlipayMarketingActivityDeliveryCreateResponse;
import com.alipay.api.response.AlipayMarketingActivityDeliveryStopResponse;
import com.alipay.api.response.AlipayMarketingActivityDeliverychannelQueryResponse;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value="${feign.client.alipay.name}",path="${feign.client.alipay.path}/alipayMarketingActivityDeliveryChannel")
@Api(value = "支付宝商家券",tags = {"支付宝商家券"})
public interface AlipayMarketingActivityDeliveryChannelFeign {

    /**
     * 查询可投放渠道接口
     * <a>https://opendocs.alipay.com/pre-open/02c7hl</a>
     */
    @PostMapping("/deliveryChannelQuery")
    ResponseData<AlipayMarketingActivityDeliverychannelQueryResponse> deliveryChannelQuery(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityDeliverychannelQueryModel> requestVo);

    /**
     * 投放创建接口
     * <a>https://opendocs.alipay.com/pre-open/02c7hm</a>
     */
    @PostMapping("/deliveryCreate")
    ResponseData<AlipayMarketingActivityDeliveryCreateResponse> deliveryCreate(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityDeliveryCreateModel> requestVo);

    /**
     * 停止投放接口
     * <a>https://opendocs.alipay.com/pre-open/02c8k1</a>
     */
    @PostMapping("/deliveryStop")
    ResponseData<AlipayMarketingActivityDeliveryStopResponse> deliveryStop(@RequestBody @Valid AlipayRequestVo<AlipayMarketingActivityDeliveryStopModel> requestVo);

}
