package com.bizvane.alipayfacade.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.alipayfacade.models.po.AlipayMiniprgmTemplatePo;
import com.bizvane.alipayfacade.models.vo.AlipayMiniprgmReleaseLogVo;
import com.bizvane.alipayfacade.models.vo.AlipayMiniprgmReleaseVo;
import com.bizvane.alipayfacade.models.vo.AlipayMiniprgmTemplateVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(value="${feign.client.alipay.name}", path="${feign.client.alipay.path}/alipayMiniVersionManage")
@Api(value="小程序版本管理接口")
public interface AlipayMiniVersionManageFeign {

    @ApiOperation(value = "添加小程序模板")
    @PostMapping(value = "/addMiniTemplate")
    public ResponseData<String> addMiniTemplate(@RequestBody AlipayMiniprgmTemplatePo template);

    @ApiOperation(value = "更新小程序模板")
    @PostMapping(value = "/updateMiniTemplate")
    public ResponseData<String> updateMiniTemplate(@RequestBody AlipayMiniprgmTemplatePo template);

    @ApiOperation(value = "删除小程序模板")
    @PostMapping(value = "/deleteMiniTemplate")
    public ResponseData<String> deleteMiniTemplate(@RequestParam(value = "alipayMiniprgmTemplateId",required = false)Long alipayMiniprgmTemplateId);

    @ApiOperation(value = "查询小程序模板详情")
    @PostMapping(value = "/findMiniTemplate")
    public ResponseData<AlipayMiniprgmTemplateVo> findMiniTemplate(@RequestParam(value = "alipayMiniprgmTemplateId",required = false)Long alipayMiniprgmTemplateId);

    @ApiOperation(value = "获取小程序模板列表")
    @PostMapping(value = "/getMiniTemplateList")
    public ResponseData<List<AlipayMiniprgmTemplatePo>> getMiniTemplateList(@RequestParam(value = "conditions",required = false)String conditions,
                                                                            @RequestParam(value = "miniProgramType",required = false)String miniProgramType);

    @ApiOperation(value = "查询小程序发布列表")
    @PostMapping(value = "/getReleaseList")
    public ResponseData<PageInfo<AlipayMiniprgmReleaseVo>> getReleaseList(@RequestParam(value = "miniProgramType",required = false)String miniProgramType,
                                                                          @RequestParam(value = "conditions",required = false)String conditions,
                                                                          @RequestParam(value = "openLive",required = false)Boolean openLive,
                                                                          @RequestParam(value = "pageNumber",required = false)int pageNumber,
                                                                          @RequestParam(value = "pageSize",required = false)int pageSize);

    @ApiOperation(value = "批量提交代码")
    @PostMapping(value = "/submitCode")
    public ResponseData<String> submitCode(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                           @RequestParam(value = "releaseState",required = false)String releaseState,
                                           @RequestParam(value = "templateId",required = false)Integer templateId);

    @ApiOperation(value = "批量提交审核")
    @PostMapping(value = "/submitAudit")
    public ResponseData<String> submitAudit(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                            @RequestParam(value = "releaseState",required = false)String releaseState);

    @ApiOperation(value = "获取提交类目")
    @PostMapping(value = "/getCategory")
    public ResponseData<JSONObject> getCategory(String token);

    @ApiOperation(value = "发布小程序")
    @PostMapping(value = "/release")
    public ResponseData<String> release(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                        @RequestParam(value = "releaseState",required = false)String releaseState);

    @ApiOperation(value = "小程序版本回退")
    @PostMapping(value = "/revertVersionRelease")
    public ResponseData<String> revertVersionRelease(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                                     @RequestParam(value = "releaseState",required = false)String releaseState);

    @ApiOperation(value = "查询小程序历史发布列表")
    @PostMapping(value = "/getReleaseLogList")
    public ResponseData<PageInfo<AlipayMiniprgmReleaseLogVo>> getReleaseLogList(@RequestParam(value = "miniProgramType",required = false)String miniProgramType,
                                                                                @RequestParam(value = "conditions",required = false)String conditions,
                                                                                @RequestParam(value = "pageNumber",required = false)int pageNumber,
                                                                                @RequestParam(value = "pageSize",required = false)int pageSize);
  
    @ApiOperation(value = " 获取小程序体验码")
    @PostMapping(value = "/getTestQrCode")
    String getTestQrCode(@RequestParam("appid") String appid);

    @ApiOperation(value = "审核撤回")
    @PostMapping(value = "/auditWithdraw")
    public ResponseData<String> auditWithdraw(@RequestParam("alipayPublicId")Long alipayPublicId,
                                              @RequestParam("alipayMiniprgmReleaseId")Long alipayMiniprgmReleaseId);

    @ApiOperation(value = " 切换小程序直播组件状态")
    @PostMapping(value = "/switchLiveStatus")
    public ResponseData<String> switchLiveStatus(@RequestParam("appid") String appid);
}
