package com.bizvane.alipayfacade.interfaces;

import com.bizvane.alipayfacade.models.po.AlipayTracePo;
import com.bizvane.alipayfacade.models.po.AlipayTraceRecordPo;
import com.bizvane.alipayfacade.models.vo.AlipayTraceRecordVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(value="${feign.client.core.name}",path="${feign.client.core.path}/alipayCoreTrace")
@Api(value = "Trace接口",tags = {"Trace接口"})
public interface AlipayCoreTraceFeign {

	@ApiOperation(value = "新增trace")
	@PostMapping(value = "/insertTrace")
	ResponseData<Long> insertTrace(@RequestBody AlipayTracePo vo);


	@ApiOperation(value = "查询trace")
	@PostMapping(value = "/selectByTraceId")
	ResponseData<AlipayTracePo> selectByTraceId(@RequestParam Long traceId);


	@ApiOperation(value = "根据traceId插入一条trace记录")
	@PostMapping(value = "/saveTraceRecord")
	ResponseData saveTraceRecord(@RequestBody AlipayTraceRecordVo vo);


	@ApiOperation(value = "根据unionid查询最近一条trace记录")
	@PostMapping(value = "/selectTraceRecord")
	ResponseData<AlipayTraceRecordPo> selectTraceRecord(@RequestBody AlipayTraceRecordVo vo);

	@ApiOperation(value = "根据unionid查询最近一百条trace记录")
	@PostMapping(value = "/selectTraceRecordList")
	ResponseData<PageInfo<AlipayTraceRecordPo>> selectTraceRecordList(@RequestBody AlipayTraceRecordVo vo);

}
