package com.bizvane.ajhfacade.rpc;

import com.bizvane.ajhfacade.models.po.Orders;
import com.bizvane.ajhfacade.vo.StaffOrderVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.ajh.name}",path = "${feign.client.ajh.path}/wechatStaffRpc")
public interface WechatStaffRpcService {

    /**
     * 获取导购订单列表
     *
     * @return
     */
    @RequestMapping(value = "/getStaffOrderList", method = RequestMethod.POST)
    ResponseData<List<Orders>> getStaffOrderList(@RequestBody StaffOrderVO request);
}
