package com.bizvane.ajhfacade.rpc;
import com.bizvane.ajhfacade.models.po.Comments;
import com.bizvane.ajhfacade.models.po.Orders;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.List;
@FeignClient(value = "${feign.client.ajh.name}", path = "${feign.client.ajh.path}/ordersRpc")
public interface OdersRpcService {

    @RequestMapping(value = "purchasedProducts", method = RequestMethod.POST)
    ResponseData<List<Orders>> purchasedProducts(@RequestParam(value = "id", required = false) Integer id, @RequestParam(value = "userId") Long userId, Integer pageNum, Integer pageSize);

    @RequestMapping(value = "afterSalesOrder", method = RequestMethod.POST)
    ResponseData afterSalesOrder(@RequestParam(value = "ostatus", required = false) Integer ostatus, @RequestParam(value = "userId") Long userId);

    @RequestMapping(value = "distributionInstall", method = RequestMethod.POST)
    ResponseData distributionInstall(@RequestParam(value = "ostatus", required = false) Integer ostatus, @RequestParam(value = "userId") Long userId);

    @RequestMapping(value = "insert", method = RequestMethod.POST)
    ResponseData insert(@RequestBody(required = false) Comments comments);

    @RequestMapping(value = "userCancel", method = RequestMethod.POST)
    ResponseData userCancel(@RequestBody(required = false) Orders orders);

    @RequestMapping(value = "selectById", method = RequestMethod.POST)
    ResponseData selectById(@RequestParam("id") Integer id);

    @RequestMapping(value = "viewAudit", method = RequestMethod.POST)
    ResponseData viewAudit(@RequestParam(value="id") Integer id);

    @RequestMapping(value = "selectProject", method = RequestMethod.POST)
    ResponseData selectProject();

    @RequestMapping(value = "addRepairOrder", method = RequestMethod.POST)
    ResponseData addRepairOrder(@RequestBody Orders orders,@RequestParam(value = "projectID") int [] projectID,@RequestParam(value = "id") int id);

}